/* Exercise_4.asm
                                    Task Description
Task: Create a Pulse Modulated signal of 1KHz with a 25% duty cycle.  The CPU
frequency is not fixed, it is stored in a processor register named CPU_Frequency
with 1 Hz resolution.

The program will need to do some calculations in order to determine the divisor
values for the Timer and PM registers.
*/

;******************************** Memory Definitions ***************************
;	define the RAM values
#define  RAMSTART    0x40000              ; starting address of RAM
#define  RAMSIZE     0x40000              ;		and its size
#define  RAMEND      RAMSTART + RAMSIZE   ; calculate the end address of the RAM

;  define the stack size and  location
#define  STACKSIZE   0x1000               ; size of stack
#define  STACK_TOP   RAMEND - STACKSIZE   ; top of the stack

;  define the values for the Address Pointer
#address NEXT_ROM    0x400                ; starting address to put any constants
#address NEXT_PC     0x1000               ; starting address of the program
#address NEXT_RAM    RAMSTART             ; start of the RAM
;*******************************************************************************

#if NEXT_ROM >= NEXT_PC
   #error "NEXT_ROM incursion into NEXT_PC"
#endif

#address NEXT_PC           ; set the Address Pointer to the start of the program
#vector  VECTOR_START      ; set the start up vector to point to the first
                           ;        instruction

;******************************** begin program code ***************************

Main:
   copy.4      #RAMEND, SP       ; set stack pointer to top of RAM  bottom of the stack

/* Use Timer 0 as the time base for the PM signal and PP2.3 as the output pin.
Calculate the divisor needed to produce a 1ms period.  Set the appropriate
registers to generate a continuous pulse stream.  Due to the processor
configuration of the PM signals, it is necessary to use PM3  see Sample Port
Assignments.  Additional comments indicate the details of the hardware registers
being programmed.
*/

; calculate the T0 divisor  dividing the CPU frequency by the desired frequency
;     will yield the required divisor value
   copy.4      CPU_FREQUENCY, r0       ; get the CPU frequency
   div.4       #1000, r0               ; r0 = PM divisor

; set up the T0 registers
   iocopy.4    r0, T0DATA              ; set the T0 divisor
   clr.1       T0CLK                   ; T0 clock source = internal
   iocopy.1    #0xC0, T0CFG            ; start counting, max count = T0DATA,
                                       ;		pre-scale divisor = 1
                                       ; bit 7 = 1 = 0x80 = enable timer
                                       ; bit 6 = 1 = 0x40 = use T0DATA as max count
                                       ; bit 4 = 0 = free run
                                       ; bits 2,1,0 = 0 = pre-scale divisor = 1

   iocopy.1    #0x87, PP2.3CFG         ; PP2.3 = fast edge, 4ma, CMOS, PM3
                                       ; bit 7 = 1 = 0x80 = Fast edge
                                       ; bit 6 = 0 = CMOS
                                       ; bits 5,4 = 0 = 4ma drive
                                       ; bits 2,1,0 = 7 = PM3
; set up the PM registers
   iocopy.1    #0x80, PM3CFG           ; PWM, Timer 0, no interrupt
                                       ; bit 7 = 1 = 0x80 = Enable PWM
                                       ; bits 6,5,4 = 0 = use Timer 0
                                       ; bits 2,1,0 = 0 = no interrupt

; to get the on time, divide the period count by 4 
   div.4       #4, r0                  ; on time = period/4
   iocopy.4    r0, PM3WIDTH            ; set PWM on time

; there should now be pulses on PP2.3

Main_1:
   br          Main_1                  ; forever loop

#vector     VECTOR_RTC                 ; dummy ISR required by the assembler
   reti
