/* Exercise_3.asm
Task: Make an LED follow the state of a switch.

This example reads the state of an input and sets an output to the same state.
If the input is connected to a switch and the output drives an LED then the
on/off state of the LED is controlled by the state of the switch.  The switch
will be connected between the parallel port bit and ground; therefore, the bit
needs a pullup.  The LED will be connected between the port bit and +V through
an appropriate current limiting resistor; therefore, the bit needs to be able
to sink enough current to light the LED.  Here is a schematic:
*/

; insert the "preliminary code" required by the assembler

;   define the RAM values
#define   RAMSTART   0x40000              ; starting address of RAM
#define   RAMSIZE    0x40000              ;      and its size
#define   RAMEND     RAMSTART+ RAMSIZE    ; calculate the end address of the RAM

;   define the stack size and  location
#define   STACKSIZE   0x1000              ; size of stack
#define   STACK_TOP   RAMEND - STACKSIZE  ; top of the stack

;   define the values for the Address Pointer
#address  NEXT_ROM   0x0400               ; starting address to put any constants
#address  NEXT_PC    0x1000               ; starting address of the program
#address  NEXT_RAM   RAMSTART             ; start of the RAM

; Code
#address NEXT_PC                          ; set the Address Pointer
#vector  VECTOR_RTC                       ; dummy ISR required by the assembler
   reti

; defines for the states of the LED
#define  LED_ON      0x52              ; open drain, 8ma, output = 0 - turns LED on
#define  LED_OFF     0x52|BIT03        ; open drain, 8ma, output = 1 - turns LED off

#vector  VECTOR_START ; set the start up vector to point to the first instruction

;************************* begin program code **************************************

Main:
   copy.4   #RAMEND, SP	               ; set stack pointer to top of RAM

; set up the 2 I/O ports
   iocopy.1 #0x90, PP0.0CFG            ; PP0.0 = input, 20K load, pullup
   iocopy.1 #LED_OFF, PP0.1CFG         ; PP0.1 = LED off

Main_1:
   iocopy.1 PP0DATA, r0                ; read PP0
   rrc.1    r0                         ; bit 0 ==> C-bit
   bcc      Main_2                     ; br if the switch is closed - grounded

; here if the switch is open
   iocopy.1 #LED_OFF, PP0.1CFG         ; PP0.1 = LED off
   br       Main_1

; here if the switch is closed
Main_2:
   iocopy.1 #LED_ON, PP0.1CFG          ; PP0.1 = LED on
   br       Main_1                     ; start over

/* Just as in the previous examples, there is more than one set of statements
that will do the same thing.  The only way to make it more efficient would be to
put the addresses of PP0DATA and PP0.1CFG into registers.  This would save six
bytes of code memory and 3 clock cycles within the loop but would add six bytes
and eight clock cycles to the setup.
Another important criteria that may not be very obvious is the reason for
selecting the I/O bits as defined.  Bit 0 was selected for the switch input
simply because detecting the switch state requires only reading the register
and doing a single shift.  Another method is as follows:
   iocopy.1 PP0DATA, r0                ; read PP0
   and.1    #BIT00, r0                 ; leave only bit 0
   beq      SomeAddr                   ; br if bit is a 0  switch is closed
This set of instructions is more general purpose in that it will work for any
bit as long as the mask is defined correctly, but it does take an extra byte.

And yet another partial solution:
   bitest.1 #BIT00, PP0DATA            ; is switch closed?
   beq      SomeAddr                   ; br if yes
*/
