/* Exercise_2.asm
Task: Generate a very low frequency square wave out of one of the parallel
port bits using "bit banging."
Now lets make the program a little more complicated - insert a delay in both
the '1' and '0' times using the simplest possible method.  Since there is no
delay function, what is a simple way of generating a delay?  We implemented one
in the second solution above by adding a 'dummy' instruction.  We can extend
this method quite easily as shown below.
Note: this example does not show all of the initialization statements - it gets
right into the program code.
*/

; insert the "preliminary code" required by the assembler

;   define the RAM values
#define   RAMSTART   0x40000              ; starting address of RAM
#define   RAMSIZE    0x40000              ;      and its size
#define   RAMEND     RAMSTART+ RAMSIZE    ; calculate the end address of the RAM

;   define the stack size and  location
#define   STACKSIZE   0x1000              ; size of stack
#define   STACK_TOP   RAMEND - STACKSIZE  ; top of the stack

;   define the values for the Address Pointer
#address  NEXT_ROM   0x0400               ; starting address to put any constants
#address  NEXT_PC    0x1000               ; starting address of the program
#address  NEXT_RAM   RAMSTART             ; start of the RAM

; Code
#address NEXT_PC                          ; set the Address Pointer
#vector  VECTOR_RTC                       ; dummy ISR required by the assembler
   reti

#vector  VECTOR_START
Main:
   copy.4   #RAMEND, SP                ; set stack pointer to top of RAM  bottom of the stack
   iocopy.1 #1, PP2.4CFG               ; set PP2.3 as an output to use PP3DATA
   clr.2    r0                         ; set r0 = 0 for loop counter
Main_1:                                ; need a label for the loop
   dbne     r0, Main_1                 ; decrement r0 until it reaches 0 
   or.1     #BIT04, PP2DATA            ; bit 4 = 1
; note that R0 = 0
Main_2:
   dbne     r0, Main_2                 ; decrement r0 until it reaches 0 
   and.1    #~BIT04, PP2DATA           ; bit 4 = 0
   br       Main_1                     ; start the pulse over

/* Note that the delay precedes the change in the output state.  This will
generate a square wave with a very long period!  Each state will be several
clocks longer than (65535*3) clocks.  The 65535 is because the first value in r0
that the dbne instructions get is 0.  The test for 0 is done after the
decrement.  The reason it is not 65536 is that on the last iteration the branch
will not be taken, when r0 = 0.  The factor of 3 is because every branch
instruction takes 3 clock cycles if the branch is taken.  Note that the execution
time of the actual output statements is not included in the calculations  this
is because they are negligible relative to the dbne time.  The degree of
asymmetry will be about 3 parts in 6*66535 and is due to the last br
instruction.  If 100% symmetry is required, 3 clock cycles of dummy instructions
can be inserted immediately preceding Main_2.  If the processor has a 100MHz
clock each state will be real close to 1.966msec yielding a square wave of about
254 Hz.  It should be noted that a really easy way to generate an even lower
frequency square wave is to insert one or more dummy instructions between the
dbne instructions and their target br locations.
*/
