; Exercise 1
/******************************* Memory Definitions *********************************
These first values define the memory configuration and the memory definitions for the Address Pointer.
The memory definitions are completely dependent on the memory devices connected to the processor, how
they are connected and how the processor configures their control signals when it comes out of reset.
The assumption here is that the flash (program memory) starts at address 0.  For many processors this
is a valid assumption.  However, the starting address of RAM may have to be set up by the initialization
code.  Here we are assuming that this is not the case and that RAM starts at address 0x40000.
*/

;   define the RAM values
#define  RAMSTART   0x40000              ; starting address of RAM
#define  RAMSIZE    0x40000              ;      and its size
#define  RAMEND     RAMSTART + RAMSIZE    ; calculate the end address of the RAM

;   define the stack size and  location
#define  STACKSIZE   0x1000              ; size of stack
#define  STACK_TOP   RAMEND - STACKSIZE  ; top of the stack

;   define the values for the Address Pointer
#address NEXT_ROM   0x0400               ; starting address to put any constants
#address NEXT_PC    0x1000               ; starting address of the program
#address NEXT_RAM   RAMSTART             ; start of the RAM

;********************************************************************************
; Define any other values that may be needed for this task
; ***   Other values

;********************************************************************************
; Interrupt Vectors
; Any required interrupt vectors will be set using the alternative method
; placing the #vector directive immediately before the code for the interrupt itself.

;********************************************************************************
; Any required constants

#address NEXT_ROM
; there are none for this example

;********************************************************************************
; Any required RAM

#address NEXT_RAM                      ; set the Address Pointer to the next available RAM
; no RAM is required for this example

;********************************************************************************
; Code

/* Remember that the assembler will generate an error if NEXT_ROM attempts to use
memory beyond the initial value of NEXT_PC.  If this does happen, all that is
needed is to redefine the initial value of NEXT_PC.  If you want to automatically
set the value of NEXT_PC to be just past the constants, all you need to do is NOT
define NEXT_PC where the other NEXT_... values are and do the following instead:
   #address      NEXT_PC   NEXT_ROM
However, this method then disallows you from using NEXT_ROM from this point forward.
*/

#address    NEXT_PC           ; set the Address Pointer to the start of the program

#vector     VECTOR_RTC        ; dummy ISR required by the assembler
   reti

#vector     VECTOR_START      ; set the start up vector to point to the first instruction

;************************** begin program code *************************************

Main:                         ; a name is not really needed here
; Even though interrupts are not needed in this sample, nor are any
;  functions called, the Stack Pointer should still be initialized.
   copy.4      #RAMEND, SP    ; set stack pointer to top of RAM  bottom of the stack

; The first thing to do is enable a parallel port bit to be an output.
; Which one?  For this exercise we will use Port 2 bit 4. The selection of PP2.4
; is somewhat arbitrary - basically I just did not want to use PP0.0.

; Note: The assembler has a set of pre-defined values for each of the bits
; from 0 to 31:  BIT00, ... BIT31

   iocopy.1    #1, PP2.4CFG               ; set PP2.4 as an output to use PP2DATA
Main_1:                                   ; need a label for the loop
   ioor.1      #BIT04, PP2DATA            ; 7  bit 4= 1
   ioand.1     #~BIT04, PP2DATA           ; 7  bit 4 = 0
   br          Main_1                     ; 3
                                          ; total loop time = 17 clocks:
                                          ; duty cycle = 7/17 = 41%

/* That's all there is to it!  However, this will not be a 50% duty cycle due to
the execution time of thebr instruction.  The following set of instructions will
make it 50% using the same I/O registers.
*/
   iocopy.1    #1, PP2.4CFG               ; set PP2.4 as an output to use PP2DATA
Main_2:                                   ; need a label for the loop
   ioor.1      #BIT04, PP2DATA            ; 7  bit 4= 1
   br          Main_3                     ; 3  cause a 3 clock delay
Main_3:
   ioand.1     #~BIT04, PP2DATA           ; 7  bit 4 = 0
   br          Main_2                     ; 3
                                          ; total loop time = 20 clocks:
                                          ;     duty cycle = 10/20 = 50%

; Here is another solution - one that uses only PP2.4CFG by varying the state of bit 3
   iocopy.1    #2, PP2.4CFG               ; set PP2.4 to use bit 3 for its state
Main_4:                                   ; need a label for the loop
   iocopy.1    #2|BIT03, PP2.4CFG         ; 4  bit 4 = 1
   br          Main_5                     ; 3  cause a 3 clock delay
Main_5:
   iocopy.1    #2, PP2.4CFG               ; 4  bit 4 = 0
   br          Main_4                     ; 3
                                          ; total loop time = 14 clocks:
                                          ;     duty cycle = 7/14 = 50%

/* In the last 2 examples, the added br instruction could be replaced with
any dummy instruction that takes 3 clocks but using the br makes it a lot
more obvious that the 1 and 0 times will be the same.
Note that the above are not the only solutions.  Here is another possibility
 also the fastest:
*/
   copy.4      #PP2.4CFG, r0              ; r0 = address of the I/O register
Main_6:                                   ; need a label for the loop
   copy.1      #2|BIT03, (r0)             ; 3  bit 4 = 1
   copy.1      #2, (r0)                   ; 3  bit 4 = 0
   br          Main_6                     ; 3
                                          ; total loop time = 9 clocks:
                                          ;     duty cycle = 3/9 = 33%
                                          
/*Note that the loop contains normal copy instructions.  This is because the iocopy instruction requires
an I/O address as one of its arguments.  Using (r0) is not an I/O address.

 This will execute faster because the address of the I/O register does not have to be read from the
instructions.  Since this set of instructions does not have the extra br instruction it will also not be a
50% duty cycle.  With these instructions the imbalance in the 1 and 0 times will be more evident while
the frequency will be higher.  The reason for the more obvious imbalance is due to the 3 clocks of the br
instruction being a higher percentage of the total loop time.
What has been shown with these 4 examples that do essentially the same task is that there is usually
more than one solution to almost every programming task.  What they also attempt to show is that to be
most efficient in assembly language you have to know the hardware of the processor.  The better you know
the hardware, the better will be your solution.

Note that by using two more registers the loop time can be decreased to seven clocks.
*/