; Example_Multiplier.asm

#address       NEXT_RAM	   0x100000   ; set up to allocate the variables
Result:        #alloc.4
Multiplicand:  #alloc.4
Multiplier:    #alloc.2

#address       NEXT_PC  0x1000      ; set the PC for the code
#vector        VECTOR_START         ; to eliminate assembler error
#vector        VECTOR_RTC           ;     "     "     "        "

   clr.4    Result               ; initialize the result and the values to multiply
   copy.4   #0d56, Multiplicand		; make 4 bytes because the Multiplicand is added to the Result
   copy.2   #0d38, Multiplier
Mpy_Loop:
   bitest.1 #1, Multiplicand     ; check for bit 0 set
   beq      Do_not_add           ; branch if bit 0 not set
   add.4    Multiplicand, Result ; update the result
Do_not_add:
   sla.4    Multiplicand         ; update
   srl.2    Multiplier           ;		values
   bne      Mpy_Loop             ; branch if Multiplier not 0

; Result now contains the product of the two values
/*
Please notice a few things about this code:
It does not count the number of iterations - this is because the Multiplier will
become 0 within the iteration count due to the way the SRL instruction works.

Both the Result and Multiplicand are allocated double the size that is required
to contain the original values.  This is necessary because:
   Multiplying 16-bit values can easily yield a 32-bit result
   The Multiplicand is successively shifted left which can also generate a
         32-bit value.

There are no registers used - this is somewhat inefficient.  The following example
shows the same algorithm using registers.
*/
   clr.4    r0                ; initialize the result and the values to multiply
   copy.4   #0d56, r1         ; initialize Multiplicand
   copy.2   #0d38, r2         ; initialize Multiplier
Mpy_LoopA:
   srlc.2   r2                ; shift the Multiplier getting bit 0 into the C-bit
   bcc      Do_not_addA       ; branch if C-bit is clear
   add.4    r1, r0            ; update the result
Do_not_addA:
   sla.4    r1                ; update Multiplicand
   test.2   r2                ; check if done
   bne      Mpy_LoopA          ; branch if Multiplier not 0

; r0 now contains the product of the two values
