;Example_Divider.asm
#nprint PR_PROC_DEFS       ; do not print the processor definitions

#address    NEXT_RAM 0x100000       ; set up to allocate the variables
Dividend:   #alloc.2
Divisor:    #alloc.2
Quotient:   #alloc.2

#address    NEXT_PC  0x1000         ; set the PC for the code
#vector     VECTOR_START            ; to eliminate assembler error
#vector     VECTOR_RTC              ;     "     "     "        "

   copy.2   #1234, Dividend         ; initialize the
   copy.2   #27, Divisor            ;		two values 
   clr.2    Quotient                ; initialize the quotient
   comp.2   Divisor, Dividend       ; is Divisor > Dividend?
   bgt      DivideExit              ; branch if yes
   clr.2    R0                      ; set up
   ccs      cbit                    ;	mask for finding MSB of Dividend
Loop_1:
   rrc.2    R0                      ; put mask into next lower bit
   bitest.2 R0, Dividend            ; found MSB yet?
   beq      Loop_1	                  ; branch if no
; R0 now contains a single bit which is in the MSB position of the Dividend
   copy.2   #-1, R1                 ; initialize mask
   copy.2   #1, R2                  ; initialize shift counter
Loop_2:
   bitest.2 R0, Divisor             ; found MSB of Divisor?
   bne      Label_1                 ; branch if yes
   
   
   inc.2    R2                      ; update shift counter
   sla.2	    R1                     ; update mask
   sla.2    Divisor                 ; shift divisor
   br       Loop_2                  ; until done
; now MSB of divisor is in same bit position as MSB of Dividend
; R2 = shift counter		R1 = mask ( a '1' in each bit used by the Divisor )
Label_1:
   sla.2    Quotient                ; Quotient always gets shifted
   copy.2   Dividend, R0            ; get working copy of  Dividend
   and.2    R1, R0                  ; R0 = Dividend & Mask
   comp.2   R0, Divisor             ; is (Dividend & Mask) >= Divisor?
   blt      Label_2                 ; branch if no
   sub.2    Divisor, Dividend       ; Dividend =  Dividend -  Divisor
   or.2     #1, Quotient            ; insert 1 into quotient
Label_2:
   sra.2    Divisor                 ; update divisor
   sra.2    R1                      ; update mask
   dbne     R2, Label_1             ; update shift counter and branch if not done
DivideExit:

; Quotient now contains the correct value and Dividend contains the remainder.
