
/* this is DSC, the diameter scaling program */
/* the file I/O is a copy of read.c */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

main (int argc, char **argv)
/* Usage:
 * (prog) [infile] [outfile]
 */
{
FILE *infile,*outfile;
double *len,*dia,*dis;
double freq;
double cfactor;
int ele,x;
/* these are the "doing stuff" variables */
double reac,newlen,lambda,t1,t2,newdia;

if (argc<3) {
printf("Akk!  I need to know which files to read and write, thus:\n");
printf("%s: [infile] [outfile]\n   Seeya...\n",argv[0]);
exit(-1);
} 

/* ADD your own check to argc here: */

if (argc<4) {
printf("Akk!  I need to know what diameter to scale to...\n");
printf("%s: [infile] [outfile] [new_diameter]\n",argv[0]);
exit(-1);
}

newdia=atof(argv[3]);

/* ARGC checking done! */

/* open the input file */
infile=fopen(argv[1],"r");
printf("input file: %s\n",argv[1]);

/* read the input file */

fscanf(infile,"%lf",&freq); /* fscanf is bulletproof... right? */
fscanf(infile,"%lf",&cfactor);
fscanf(infile,"%d",&ele);

/* make the arrays... */
len=calloc(ele,sizeof(freq)); /* according to my C manual, that's right */
dis=calloc(ele,sizeof(freq));
dia=calloc(ele,sizeof(freq));

/* load the arrays... */
for (x=0;x<ele;x++)
  fscanf(infile,"%lf %lf %lf",&len[x],&dis[x],&dia[x]);

/* close the input file */
fclose(infile);

/******* This is where one should do something useful. *******/

/* we're trying... */
lambda=cfactor/freq; /* figure a wavelength */
printf("lambda = %f\n",lambda);

/* from www.cebik.com article on scaling and adjusting vhf/uhf yagis:
 * x=[(430.3 log10 ((2lam)/D))-320]*[((2L)/lam)-1]+40
 * that oughta turn your brain to tapioca in about three weeks... */ 

for (x=0;x<ele;x++)
{
/* t1=(430.3*log10(((2*lambda)/dia[x])))-320; */
t1=430.3*log10(2*lambda/dia[x])-320;
t2=((2*len[x])/lambda)-1;
reac=(t1*t2)+40; /* that's simple */
/* printf("reac %f\n",reac); */

/* L= (((x-40)/430.3*(log10(2lambda/d))-320)+1)*lambda/2 */
/* newlen=(((x-40)/430.3*(log10(2*lambda/newdia))-320)+1)*(lambda/2); */
/* newlen=(((reac-40)/430.3*(log10(2*lambda/newdia))-320)+1)*(lambda/2); */

newlen=((reac-40)/(430.3*log10(2*lambda/newdia)-320)+1)*lambda/2;

printf("o %f n %f\n",len[x],newlen);
len[x]=newlen;
dia[x]=newdia;

}

/******* ALL DONE WITH USEFULNESS! *****/

/* open the output file */
outfile=fopen(argv[2],"w");
printf("outfile: %s\n",argv[2]);

/* write the output file */
fprintf(outfile,"%10f\n",freq);
fprintf(outfile,"%10f\n",cfactor);
fprintf(outfile,"%d\n",ele);
for (x=0;x<ele;x++)
fprintf(outfile,"%10f %10f %10f\n",len[x],dis[x],dia[x]);

/* close the output file */
close(outfile);
return(0);
}
