/*
  SAME_MESSAGES.h
 
  Arduino program for receiving and displaying messages (in ASCII format) that are
  broadcast using the NOAA Weather Radio (NWR) Specific Area Message Encoding (SAME)
  format.  It is based on National Weather Service Instruction 10-1712, dated
  October 3, 2011.  Event Codes are taken from ANSI/CEA-2009-B, dated November, 2010.
 
  Copyright (C) 2012 by Ray H. Dees
  
  PLL receive routine adapted from VirtualWire, Copyright (C) 2008 by Mike McCauley.
  
  Compiled with Arduino 1.0 and using a 168/328 or 1280/2560 Arduino running on 5 vdc
  at 16 mHz.  Uses XR-2211 FSK Demodulators (or other circuitry that you design)
  to receive data.
 
  In this example program:
 
  Arduino Digital Pin 2 is Warning Alert Tone, Active Low.
  Arduino Digital Pin 3 is Carrier Detect, Active Low.
  Arduino Digital Pin 5 is Receive Data.
  Arduino Digital Pin 7 is SAME Activity, On during reception.
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/
//
#ifndef SAME_MESSAGES_h
#define SAME_MESSAGES_h
//
#include <inttypes.h>
#include <avr/pgmspace.h>
//
#define SAME_ORIGINATOR_DISPLAY_LENGTH 40  //  Maximum length of an Originator string.
#define SAME_EVENT_DISPLAY_LENGTH 40       //  Maximum length of an Event string.
#define SAME_WAT_ON_DISPLAY_LENGTH 4       //  Length of the WAT On string.
#define SAME_WAT_OFF_DISPLAY_LENGTH 4      //  Length of the WAT Off string.
//
//  SAME Originator Codes.
//
static const uint16_t __attribute__ ((progmem)) SAME_ORIGINATOR_CODES[] =  
{ 
  0x8AE6, 0x8E63, 0xA4A0, 0xB3D2, 0x822F
};
//
//  SAME Originator Strings.
//
static const char __attribute__ ((progmem)) SAME_ORIGINATOR_STRING_00[] = "Civil Authorities";
static const char __attribute__ ((progmem)) SAME_ORIGINATOR_STRING_01[] = "Emergency Alert System";
static const char __attribute__ ((progmem)) SAME_ORIGINATOR_STRING_02[] = "Primary Entry Point";
static const char __attribute__ ((progmem)) SAME_ORIGINATOR_STRING_03[] = "National Weather Service";
static const char __attribute__ ((progmem)) SAME_ORIGINATOR_STRING_04[] = "Unrecognized Originator";
//
//  SAME Originator String Index.
//
static const char __attribute__ ((progmem)) *SAME_ORIGINATOR_STRING_INDEX[] =  
{
  SAME_ORIGINATOR_STRING_00, SAME_ORIGINATOR_STRING_01, SAME_ORIGINATOR_STRING_02, SAME_ORIGINATOR_STRING_03,
  SAME_ORIGINATOR_STRING_04
};
//
//  SAME Event Codes.
//
static const uint16_t __attribute__ ((progmem)) SAME_EVENT_CODES[] =  
{ 
  0x8692, 0x87A1, 0x87B7, 0x88D7, 0x8987, 0x89C7, 0x89F7, 0x8A55, 0x8A97, 0x8A9D,
  0x8AA1, 0x8AB7, 0x8AD7, 0x8BC7, 0x8C61, 0x8C77, 0x8CA7, 0x8D1F, 0x8D87, 0X8E5E,
  0x8E64, 0x8F67, 0x8FA9, 0x8FA1, 0x9087, 0x90A1, 0x90B3, 0x90B7, 0x9101, 0x9113,
  0x9117, 0x9177, 0x9187, 0x91F7, 0x9513, 0x9527, 0x9591, 0x95A7, 0x95B1, 0x95C7,
  0x9677, 0x96B7, 0x9C55, 0x9CA7, 0x9D87, 0xA064, 0xA0D3, 0xA11E, 0xA154, 0xA184,
  0xA1A7, 0xA543, 0xA8D7, 0xA924, 0xA9C4, 0xAB27, 0xAB53, 0xAB57, 0xABA1, 0xABB2,
  0xABB3, 0xAD31, 0xAD35, 0xAD42, 0xAD61, 0xAD77, 0xAD71, 0xAD87, 0xADC2, 0xADC6,
  0xADCF, 0xADD0, 0xB147, 0xB2A1, 0xB2B7, 0xB371, 0xB387, 0x8231, 0x8235, 0x8243,
  0x8247, 0x822F  
};
//
//  SAME Event Strings.
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_00[] = "Administrative Message";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_01[] = "Avalanche Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_02[] = "Avalanche Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_03[] = "Biological Hazard Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_04[] = "Blowing Snow Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_05[] = "Boil Water Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_06[] = "Blizzard Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_07[] = "Child Abduction Emergency";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_08[] = "Civil Danger Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_09[] = "Civil Emergency Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_10[] = "Coastal Flood Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_11[] = "Coastal Flood Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_12[] = "Chemical Hazard Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_13[] = "Contaminated Water Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_14[] = "Dam Break Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_15[] = "Dam Break Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_16[] = "Contagious Disease Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_17[] = "Practice / Demo";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_18[] = "Dust Storm Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_19[] = "Emergency Action Notification";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_20[] = "Emergency Action Termination";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_21[] = "Earthquake Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_22[] = "Immediate Evacuation";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_23[] = "Evacuation Watch";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_24[] = "Food Contamination Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_25[] = "Flash Flood Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_26[] = "Flash Flood Statement";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_27[] = "Flash Flood Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_28[] = "Flood Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_29[] = "Flood Statement";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_30[] = "Flood Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_31[] = "Fire Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_32[] = "Flash Freeze Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_33[] = "Freeze Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_34[] = "Hurricane Statement";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_35[] = "Hazardous Material Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_36[] = "Hurricane Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_37[] = "Hurricane Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_38[] = "High Wind Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_39[] = "High Wind Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_40[] = "Iceberg Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_41[] = "Industrial Fire Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_42[] = "Local Area Emergency";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_43[] = "Law Enforcement Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_44[] = "Land Slide Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_45[] = "National Audible Test";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_46[] = "National Information Center";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_47[] = "Network Notification Message";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_48[] = "National Periodic Test";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_49[] = "National Silent Test";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_50[] = "Nuclear Power Plant Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_51[] = "Power Outage Statement";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_52[] = "Radiological Hazard Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_53[] = "Required Monthly Test";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_54[] = "Required Weekly Test";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_55[] = "Special Marine Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_56[] = "Special Weather Statement";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_57[] = "Shelter In-Place Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_58[] = "Severe Thunderstorm Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_59[] = "Severe Thunderstorm Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_60[] = "Severe Weather Statement";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_61[] = "Tornado Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_62[] = "911 Telephone Outage Emergency";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_63[] = "Tornado Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_64[] = "Tropical Storm Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_65[] = "Tropical Storm Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_66[] = "Tsunami Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_67[] = "Tsunami Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_68[] = "Transmitter Backup On";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_69[] = "Transmitter Carrier Off";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_70[] = "Transmitter Carrier On";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_71[] = "Transmitter Primary On";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_72[] = "Volcano Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_73[] = "Wild Fire Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_74[] = "Wild Fire Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_75[] = "Winter Storm Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_76[] = "Winter Storm Warning";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_77[] = "Unrecognized Watch";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_78[] = "Unrecognized Emergency";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_79[] = "Unrecognized Statement";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_80[] = "Unrecognized Warning";
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_81[] = "Unrecognized Event";
//
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_82[] = "WAT+";  //  Warning Alert Tone On.
static const char __attribute__ ((progmem)) SAME_EVENT_STRING_83[] = "WAT-";  //  Warning Alert Tone Off.
//
//  SAME Event String Index.
//
static const char __attribute__ ((progmem)) *SAME_EVENT_STRING_INDEX[] =  
{
  SAME_EVENT_STRING_00, SAME_EVENT_STRING_01, SAME_EVENT_STRING_02, SAME_EVENT_STRING_03, SAME_EVENT_STRING_04, SAME_EVENT_STRING_05,
  SAME_EVENT_STRING_06, SAME_EVENT_STRING_07, SAME_EVENT_STRING_08, SAME_EVENT_STRING_09, SAME_EVENT_STRING_10, SAME_EVENT_STRING_11,
  SAME_EVENT_STRING_12, SAME_EVENT_STRING_13, SAME_EVENT_STRING_14, SAME_EVENT_STRING_15, SAME_EVENT_STRING_16, SAME_EVENT_STRING_17,
  SAME_EVENT_STRING_18, SAME_EVENT_STRING_19, SAME_EVENT_STRING_20, SAME_EVENT_STRING_21, SAME_EVENT_STRING_22, SAME_EVENT_STRING_23,
  SAME_EVENT_STRING_24, SAME_EVENT_STRING_25, SAME_EVENT_STRING_26, SAME_EVENT_STRING_27, SAME_EVENT_STRING_28, SAME_EVENT_STRING_29,
  SAME_EVENT_STRING_30, SAME_EVENT_STRING_31, SAME_EVENT_STRING_32, SAME_EVENT_STRING_33, SAME_EVENT_STRING_34, SAME_EVENT_STRING_35,
  SAME_EVENT_STRING_36, SAME_EVENT_STRING_37, SAME_EVENT_STRING_38, SAME_EVENT_STRING_39, SAME_EVENT_STRING_40, SAME_EVENT_STRING_41,
  SAME_EVENT_STRING_42, SAME_EVENT_STRING_43, SAME_EVENT_STRING_44, SAME_EVENT_STRING_45, SAME_EVENT_STRING_46, SAME_EVENT_STRING_47,
  SAME_EVENT_STRING_48, SAME_EVENT_STRING_49, SAME_EVENT_STRING_50, SAME_EVENT_STRING_51, SAME_EVENT_STRING_52, SAME_EVENT_STRING_53,
  SAME_EVENT_STRING_54, SAME_EVENT_STRING_55, SAME_EVENT_STRING_56, SAME_EVENT_STRING_57, SAME_EVENT_STRING_58, SAME_EVENT_STRING_59,
  SAME_EVENT_STRING_60, SAME_EVENT_STRING_61, SAME_EVENT_STRING_62, SAME_EVENT_STRING_63, SAME_EVENT_STRING_64, SAME_EVENT_STRING_65,
  SAME_EVENT_STRING_66, SAME_EVENT_STRING_67, SAME_EVENT_STRING_68, SAME_EVENT_STRING_69, SAME_EVENT_STRING_70, SAME_EVENT_STRING_71,
  SAME_EVENT_STRING_72, SAME_EVENT_STRING_73, SAME_EVENT_STRING_74, SAME_EVENT_STRING_75, SAME_EVENT_STRING_76, SAME_EVENT_STRING_77,
  SAME_EVENT_STRING_78, SAME_EVENT_STRING_79, SAME_EVENT_STRING_80, SAME_EVENT_STRING_81, SAME_EVENT_STRING_82, SAME_EVENT_STRING_83
};
//
//
//
#endif

