#define __KERNEL__
#define MODULE
#include <linux/module.h>
#include <linux/version.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/fs.h>
#include <asm/io.h>

#define MYNAME "irlp-port"

static int base = 0x378;
static int major = 0;

int my_open(struct inode *in, struct file *f)
{
	MOD_INC_USE_COUNT;
	return(0);
}

void my_close(struct inode *i, struct file *f)
{
	MOD_DEC_USE_COUNT;
	return;
}

int my_read(struct inode *i, struct file *f, char *buff, int len)
{
	if( len <= 0 )
		return(0);
	put_user(inb(base + 1), buff);
	if( len == 1 )
		return(1);
	else
	{
		put_user(inb(base), buff + 1);
		return(2);
	}
}

int my_write(struct inode *i, struct file *f, const char *buff, int len)
{
	if( len <= 0 )
		return(0);
	outb(get_user(buff), base);
	return(1);
}

struct file_operations my_fops = {
	NULL,
	my_read,
	my_write,
	NULL, NULL, NULL, NULL,
	my_open,
	my_close,
	NULL, NULL, NULL, NULL
};


int init_module()
{
	int ret;
	
	if( check_region(base, 2) )
		return(-EBUSY);
	request_region(base, 2, MYNAME);
	if( (ret = register_chrdev(major, MYNAME, &my_fops)) < 0 )
		return(ret);
	if( !major )
		major = ret;
	outb(0, base);
	return(0);
}

void cleanup_module()
{
	outb(0, base);
	unregister_chrdev(major, MYNAME);
	release_region(base, 2);
}

