/* $Id: fm_cw.c,v 1.1 2004/01/04 23:40:26 adicvs Exp $
 *
 * Copyright (c) 2004, Adi Linden <adi@adis.on.ca>
 * All rights reserved.
 * 
 * This code is based on sccw_1.1a by:
 * 
 *     Soundcard CW for Linux   Steven J. Merrifield    
 *     VK3ESM  steve@labyrinth.net.au
 *     http://www.labyrinth.net.au/~steve
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of its contributors may 
 *    be used to endorse or promote products derived from this software 
 *    without specific prior written permission.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h> 
#include <sys/io.h>
#include <time.h>
#include "fm_adlib.h"

extern int AdLib_found();
extern int Play_sound();

int Ask_numeric(int min, int max);

/* Default values */

int Morse_speed=35;          /* Speed in WPM */
int Morse_gap=3;          /* Spacing between each letter */
int AdLib_tone = 700;      /* Frequency of tone */
int AdLib_vol = 64;          /* Soundcard volume */

char *Code[] = 
        {".-","-...","-.-.","-..",".","..-.","--.",
        "....","..",".---","-.-",".-..","--","-.","---",
        ".--.","--.-",".-.","...","-","..-","...-",
        ".--","-..-","-.--","--..",  /* A..Z */
        "-----",".----","..---","...--","....-",
        ".....","-....","--...","---..","----.", /* 0..9 */
        "..--..","-..-.",""}; /*  q-mark, slant, space */

/* 
 * Print usage information 
 */
void usage(void)
{
    fprintf(stdout, "Usage: sccw [options] [text ...]\n");
    fprintf(stdout, "Play morse code from command line.\n\n");
    fprintf(stdout, "  -s     character speed 3-50, default 35\n");
    fprintf(stdout, "  -g     character gap (spacing) 1-20, default 3\n");
    fprintf(stdout, "  -f     frequency 100-6000, default 700\n");
    fprintf(stdout, "  -l     volume level 0-64, default 64\n\n");
    fprintf(stdout, "Report bugs to <adi@adis.on.ca>.\n");
}

/*
 * Display the character on the screen after sending it in cw
 */
void Show_code(int a)
{
    if (a < 26) fprintf(stdout,"%c",a+65);
    if ((a >= 26) && (a < 36)) fprintf(stdout,"%c",a+22);
    if (a == 36) fprintf(stdout,"?");
    if (a == 37) fprintf(stdout,"/");
    if (a == 38) fprintf(stdout," "); /* when reading a file */
}

/*
 * Convert the string into sound
 */
void Code_2_snd(int a)
{
    int i;
    double dit,dah,wait;
    
    /* delay in us (PARIS method) */
    dit = (double)(60.0/(Morse_speed*50.0)) * 1000000.0;
    dah = 3 * dit;
    wait = Morse_gap * dit;
    
    for (i=0;i<strlen(Code[a]);i++)
    {
        if (Code[a][i] == '.') 
        {
            /* printf("."); */
            Play_sound(AdLib_tone,dit,AdLib_vol);
        }
        if (Code[a][i] == '-')
        {
            /* printf("-"); */
            Play_sound(AdLib_tone,dah,AdLib_vol);
        }
        usleep(dit);    /* delay between each dit or dah */
    }
    /* printf(" "); */
    usleep(wait);    /* delay between each each character */

    if (a == 38)     /* delay between each 5 char group */
    {
        usleep(wait);
        usleep(wait);
        usleep(wait);
    }
}

/*
 * Translate text into morse
 */
int Send_text(char *text)
{

    int ch, i;

    for( i=0 ; i<strlen(text) ; i++ )    /*while ((ch = getc(f)) != EOF)*/
    {
        ch = text[i];
        if (isalpha(ch)) ch = toupper(ch); 
        if (((ch >= 'A') && (ch <= 'Z')) ||
            ((ch >= '0' ) && (ch <= '9')) ||
            (ch == '?') || (ch == '/') || (ch == ' ') ||
            (ch == 0x0A))
        {
            if (ch == 0x0A)  printf("\n");
            else
            {
                if (ch == '?') ch = 36;
                if (ch == '/') ch = 37;
                if (ch == ' ') ch = 38;
                if ((ch >= 'A') && (ch <= 'Z')) ch = ch - 65;
                if ((ch >= '0') && (ch <= '9')) ch = ch - 22;
                Code_2_snd(ch);
                Show_code(ch);
            }
        }
    }
    printf("\n");
    return(0);
}

/*
 * Setup the IO ports, then reset the IO ports on exit. Note that this 
 * requires the setuid bit to be set, since we are playing with the 
 * hardware directly.
 */
int main(int argc, char *argv[])
{
    char *buffer = "";
    if (geteuid())
    {
        fprintf(stderr,"This program must run as root (make install)\n");
        exit(1);
    }
    ioperm(reg_port,17,1);
    ioperm(data_port,17,1);
    if (!(AdLib_found))
    {
        fprintf(stderr,"\nAdLib/SoundBlaster card not found.\n");
        exit(1);
    }

    /* Get command line arguments */
    if ((argc>1)) {
        while (argc > 1) {
            if (!strcmp(argv[1], "-s")) {
                sscanf(argv[2], "%d", &Morse_speed);
            } else if (!strcmp(argv[1], "-g")) {
                sscanf(argv[2], "%d", &Morse_gap);
            } else if (!strcmp(argv[1], "-f")) {
                sscanf(argv[2], "%d", &AdLib_tone);
            } else if (!strcmp(argv[1], "-l")) {
                sscanf(argv[2], "%d", &AdLib_vol);
            } else if (!strcmp(argv[1], "-h")) {
                usage();
                return(0);
            } else {
                buffer = argv[1];
            }
            argc -= 2;
            argv += 2;
        } 
    }
    if (strlen(buffer) > 0) {
        Send_text(buffer);
    } else {
        fprintf(stderr, "Error: missing text to send\n");
        fprintf(stderr, "Try `sccw -h' for more information.\n");
        return(0);
    }
    
    ioperm(reg_port,17,0);
    ioperm(data_port,17,0);
    return(0);
}


