/* $Id: fm_beep.c,v 1.1 2004/01/04 23:46:39 adicvs Exp $
 *
 * Copyright (c) 2004, Adi Linden <adi@adis.on.ca>
 * All rights reserved.
 *
 * This code is based on sccw_1.1a by Steven J. Merrifield.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of its contributors may 
 *    be used to endorse or promote products derived from this software 
 *    without specific prior written permission.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h> 
#include <sys/io.h>
#include <time.h>
#include "fm_adlib.h"

extern int AdLib_found();
extern int Play_sound();

/* Default values */
int AdLib_vol = 64;          /* Soundcard volume */

/* 
 * Print usage information 
 */
void usage(void)
{
    fprintf(stdout, "Usage: scbeep [option] [frequency duration space] ...\n");
    fprintf(stdout, "Play beep (tones) from command line. Multiple tones can be specified.\n\n");
    fprintf(stdout, "  -v     volume 0-64, default 64\n");
    fprintf(stdout, "  -h     display this help and exit\n\n");
    fprintf(stdout, "Frequency is the desired tone frequency in hertz. The duration of the tone\n");
    fprintf(stdout, "and the space after a tone are specified in milliseconds.\n\n");
    fprintf(stdout, "Report bugs to <adi@adis.on.ca>.\n");
}

/*
 * Setup the IO ports, then reset the IO ports on exit. Note that this 
 * requires the setuid bit to be set, since we are playing with the 
 * hardware directly.
 */
int main(int argc, char *argv[])
{
    int Frequency;
    double Duration;
    double Space;
    int tf = 0;

    if (geteuid())
    {
        fprintf(stderr,"This program must run as root (make install)\n");
        exit(1);
    }
    ioperm(reg_port,17,1);
    ioperm(data_port,17,1);
    if (!(AdLib_found))
    {
        fprintf(stderr,"\nAdLib/SoundBlaster card not found.\n");
        exit(1);
    }

    /* Get command line arguments */
    while (argc > 1) {
        if (!strcmp(argv[1], "-h")) {
            usage();
            return(0);
        }
        if (!strcmp(argv[1], "-v")) {
            sscanf(argv[2], "%d", &AdLib_vol);
            argc -= 2;
            argv += 2;
        }
        while (argc > 3) {
            Frequency = atoi(argv[1]);
            Duration  = atoi(argv[2]);
            Space     = atoi(argv[3]);
            argc -= 3;
            argv += 3;
            tf += 1;
            /* Send tone to the card */
            Play_sound(Frequency, Duration * 1000, AdLib_vol);
            usleep(Space * 1000);
        } 
        argc -= 1;
        argv += 1;
    }
    if (tf < 1) {
        fprintf(stderr, "Error: Insufficient arguments provided.\n");
        fprintf(stderr, "Try `scbeep -h' for more information.\n");
    }
    
    ioperm(reg_port,17,0);
    ioperm(data_port,17,0);
    return(0);
}

