// main.cpp

#include "Vector3.h"
#include <iostream>
using namespace std;

int main()
{
	float coords[3] = {1.0f, 2.0f, 3.0f};

	// Part 1: Construct three vectors.
	Vector3 u;
	Vector3 v(coords);
	Vector3 w(-5.0f, 2.0f, 0.0f);

	// Part 2: Print the three vectors.
	cout << "u = ";
 	u.print();
	cout << "v = ";
	v.print();
	cout << "w = ";
	w.print();
	cout << endl;

	// Part3: u = v + w
	u = v.add(w);
	cout << "v.add(w) = ";
	u.print();
	cout << endl;

	// Part 4: v = v / ||v||
	v.normalize();
	cout << "unit v = ";
	v.print();
	cout << "v.length() = " << v.length() << endl;
	cout << endl;

	// Part 5: dotP = u * w
	float dotP = u.dot(w);
	cout << "u.dot(w) = " << dotP;

	// Part 6: Convert to array representation.
	float* vArray = v.toFloatArray();

	// Print out each element and verify it matches the
	// components of v.
	cout << 
		"[0] = " << vArray[0] << ", "
		"[1] = " << vArray[1] << ", "
		"[2] = " << vArray[2] << endl;
	cout << endl;

	// Part 7: Create a new vector and have user specify its
	// components, then print the vector.
	cout << "Input vector..." << endl;
	Vector3 m;
	m.input();
	cout << "m = ";
	m.print();
}