// Vector3.cpp

#include "Vector3.h"
#include <iostream>
#include <cmath>
using namespace std;

Vector3::Vector3()
{
	mX = 0.0f;
	mY = 0.0f;
	mZ = 0.0f;
}

Vector3::Vector3(float coords[3])
{
	mX = coords[0];
	mY = coords[1];
	mZ = coords[2];
}

Vector3::Vector3(float x, float y, float z)
{
	mX = x;
	mY = y;
	mZ = z;
}

bool Vector3::equals(const Vector3& rhs)
{
	// Return true if the corresponding components are equal.
	return 
		mX == rhs.mX &&
		mY == rhs.mY &&
		mZ == rhs.mZ;
}

Vector3 Vector3::add(const Vector3& rhs)
{
	Vector3 sum;
	sum.mX = mX + rhs.mX;
	sum.mY = mY + rhs.mY;
	sum.mZ = mZ + rhs.mZ;

	return sum;
}

Vector3 Vector3::sub(const Vector3& rhs)
{
	Vector3 dif;
	dif.mX = mX - rhs.mX;
	dif.mY = mY - rhs.mY;
	dif.mZ = mZ - rhs.mZ;

	return dif;
}

Vector3 Vector3::mul(float scalar)
{
	Vector3 p;
	p.mX = mX * scalar;
	p.mY = mY * scalar;
	p.mZ = mZ * scalar;

	return p;
}

float Vector3::length()
{
	return sqrtf(mX*mX + mY*mY + mZ*mZ);
}

void Vector3::normalize()
{
	// Get 'this' vector's length.
	float len = length();

	// Divide each component by the length.
	mX /= len;
	mY /= len;
	mZ /= len;
}

float Vector3::dot(const Vector3& rhs)
{
	float dotP = mX*rhs.mX + mY*rhs.mY + mZ*rhs.mZ;

	return dotP;
}

float* Vector3::toFloatArray()
{
	return &mX;
}

void Vector3::print()
{
	cout << "<" << mX << ", " << mY << ", " << mZ << "> \n";
}

void Vector3::input()
{
	cout << "Enter x: ";
	cin >> mX;
	cout << "Enter y: ";
	cin >> mY;
	cout << "Enter z: ";
	cin >> mZ;
}