// binaryfile.cpp

struct Point3
{
	Point3();
	Point3(float x, float y, float z);
	float mX;
	float mY;
	float mZ;
};

Point3::Point3()
{
	mX = mY = mZ = 0.0f;
}

Point3::Point3(float x, float y, float z)
{
	mX = x;
	mY = y;
	mZ = z;
}

#include <fstream>
#include <iostream>
using namespace std;

int main()
{
	// Create 8 points to define a unit cube.
	Point3 cube[8];

	cube[0] = Point3(-1.0f, -1.0f, -1.0f);
	cube[1] = Point3(-1.0f,  1.0f, -1.0f);
	cube[2] = Point3( 1.0f,  1.0f, -1.0f);
	cube[3] = Point3( 1.0f, -1.0f, -1.0f);
	cube[4] = Point3(-1.0f, -1.0f,  1.0f);
	cube[5] = Point3(-1.0f,  1.0f,  1.0f);
	cube[6] = Point3( 1.0f,  1.0f,  1.0f);
	cube[7] = Point3( 1.0f, -1.0f,  1.0f);

	// Create a stream which will transfer the data from
	// our program to the specified file "pointdata.tex".
	// Observe how we add the binary flag modifier
	// ios_base::binary.
	ofstream outFile("pointdata.txt", ios_base::binary);

	// If the file opened correctly then save the data.
	if( outFile )
	{
		// Dump data into the stream in binary format.
		// That is, stream the bytes of the array.
		outFile.write((char*)cube, sizeof(Point3)*8); 
	
		// Done with stream--close it.
		outFile.close();
	}


	//********************************************************************
	// Replace the following for the above to reverse to loading the data.
	//********************************************************************
/*	
	Point3 cube[8];

	cout << "BEFORE LOADING..." << endl;
	for(int i = 0; i < 8; ++i)
	{
		cout << "cube[" << i << "] = ";
		cout << "(";
		cout << cube[i].mX << ", ";
		cout << cube[i].mY << ", ";
		cout << cube[i].mZ << ")" << endl;
	}

	// Create a stream which will transfer the data from
	// the specified file "pointdata.txt" to our program.
	// Observe how we add the binary flag modifier
	// ios_base::binary.
	ifstream inFile("pointdata.txt", ios_base::binary);


	// If the file opened correctly then call load methods.
	if( inFile )
	{
		// Stream the bytes in from the file into our
		// program variable.
		inFile.read((char*)cube, sizeof(Point3)*8);

		// Done with stream--close it.
		inFile.close();
	}

	// Output the points to show the data was loaded correctly.
	cout << "AFTER LOADING..." << endl;
	for(int i = 0; i < 8; ++i)
	{
		cout << "cube[" << i << "] = ";
		cout << "(";
		cout << cube[i].mX << ", ";
		cout << cube[i].mY << ", ";
		cout << cube[i].mZ << ")" << endl;
	}
	*/
}