/* ---------------------------------------------------------------------------
Simple viewer for compressed file. 
--> The program MUST be compiled in LARGE memory.
--> The program MUST be put into the tsthost PG directory
--> The program REQUIRE FV.COM under a PATH directory
--> The program work ONLY with tsthost 1.41 and upper version
--------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <dos.h>
#include <string.h>

#define REALDISK 3

struct info
	{		// THIS FIELDS ARE NOT CHANNEL DEPANDANT, AND ARE
			// ALWAYS VALID. 
			//====================================================

	unsigned char THVH;	// Version of the soft, high value
	unsigned char THVL;	// Version of the soft, low value
	int  MAXCHANNEL;	// Number of channel active in tsthost
	char DRVTYPE;		// type of driver, 1 host, 0 tfpc, 2 drsi
	char PORT;		// com port for host driver
	unsigned int BAUDRATE;	// baudrate for host driver
	int  INTNO;		// IRQ used if tfpcx or tfpcr
	char TstHostCall[10];	// callsign of the system
	char UListEnable;	// if not 0, unproto list is active in memory,
				// and you cannot touch the TSTHOST.ULS file
	char Wpath[81];		// tsthost WorkDir
	char Upath[101];	// tsthost UserDir. If multipath exist, path
				// are separated by a space.
	char HomeBbs[10];	// callsign of homebbs
	char HomeAlias[10];	// homebbs alias callsign, null if undefined

			// ALL OTHERS FIELD ARE REFERRED TO THE SPECIFIED
			// CHANNEL
			//====================================================
	
	int  chstatus;		// 0 channel is disconnected
				// 1 standard connect, i have connected a user
				// 2 PMS connect, a user have connected the pms
				// 3 PMS, home bbs have connect my pms for fwd
				// 4 PMS, i have connected home bbs for fwd
				// 5 UNPROTO, i have connected home bbs to
				//   get unproto mail.
	char SuppCall[10];	// if not NULL, extra-callsign of the channel,
				// (AX PORT COMMAND)
	char UserCall[10];	// callsign of the remote connection with ssid

			// NEXT FIELD ARE VALID ONLY FOR USER PMS CONNECTION,
			// chstatus=2 or 3
			//=====================================================

	char UIname[13];	// name of the pms user
	long UILastConnTime;	// in seconds from 1970, last conn date
	long UILastMsgList;	// in second, last message listed
	long UINbrConn;		// number of connection made by call
	long UIThisConnTime;	// in second, actual conn date
	unsigned int SysFlag;	// actual SYS flag for the user
	}; 

void errore(void);
void errore()
{
puts("\nPG program error.\n");
exit(0);
}

int y,z,sysop;		// global variables
struct info *p;
char temp[101],*kk;
FILE *pf;
int IrqVect;
struct REGPACK rp;
char upath[5][81];
int DrvAvailable=0;

main(int argc, char **argv)
{
if(argc<4)				// test users parameters
	{
USO:	puts("\nView v1.0 for TstHost 1.41\nUsage: View [path\\]archivename\n");
	return 0;
	}
if((pf=fopen("TSTHOST.IRQ","rt"))==NULL) 
	errore();			// Aquire IRQ vector
z=1;
while(fgets(temp,80,pf))
	{
	if(sscanf(temp,"TstHostInterruptVector=%d",&IrqVect)!=1) continue;
	if(IrqVect>255) errore();
	z=0;
	break;
	}
if(z) errore();
fclose(pf);

for(z=0;z<5;z++) *upath[z]=0;		// clear users path
sysop=0;				// default is not sysop
for(y=0;y<9;y++)
	{
	rp.r_ax=y;		// Read from exetended info the SYS user level
	intr(IrqVect,&rp);	// Aquire standard users path 
	z=rp.r_ax;
	p=MK_FP(rp.r_es,rp.r_bx);
	if(z>255) break;
	if(y==0){
		DrvAvailable=sscanf(p->Upath," %s %s %s %s %s",
			upath[0],upath[1],upath[2],upath[3],upath[4]);
		if(DrvAvailable<1) errore();
		}
	else	{
		if(stricmp(argv[1],p->UserCall)==0)
			{
			sysop=p->SysFlag&REALDISK;
			break;
			}
		}
	}
kk=strupr(argv[3]);
y=0;
if(sysop==0)		// if the users cannot access to the real disk
	{		// first see if exist a specified drive in the path
	if(*(kk+1)==':')
		{
		y=(*kk)-'C';
		if(y<0 || y>=DrvAvailable)
			{
			printf("\nInvalid drive lettar\Available drive from C to %c\n",'B'+DrvAvailable);
			return 0;
			}
		kk+=2;
		}
	if(*kk=='\\') kk++;	// erase starting slash if exist
	if(*kk==0) goto USO;
	sprintf(temp,"%s%s",upath[y],kk);
	kk=temp;		// kk point to the virtual disk
	}

		// and now call and execute FV.
spawnlp(P_WAIT,"FV","FV",kk,"/C",NULL);
return 0;
}
