/*----------------------------------------------------------------------------
This code run only under tsthost v1.41
The program must be compiled with a large memory model

This is a simple server, REQFIL, for tsthost. ReqFil is s server that return
to sender of the message, the requested ascii file. The server is started when
receive a personal mail like this:

 	SP REQFIL < IK1AAA
	[PATH\]PIPPO.TXT @ IK1MSL	<-- Title of the message
	Text is not necessary and is ignored
	/EX

and return a message like this:

	SP IK1AAA @ IK1MSL
	Req File : PIPPO.TXT		<-- Title of the message
	Contents of the file 		<-- text
	.....
	Contents of the file
	/EX 				<-- end of text

----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <dos.h>
#include <string.h>

struct info
	{		// THIS FIELDS ARE NOT CHANNEL DEPANDANT, AND ARE
			// ALWAYS VALID. 
			//====================================================

	unsigned char THVH;	// Version of the soft, high value
	unsigned char THVL;	// Version of the soft, low value
	int  MAXCHANNEL;	// Number of channel active in tsthost
	char DRVTYPE;		// type of driver, 1 host, 0 tfpc, 2 drsi
	char PORT;		// com port for host driver
	unsigned int BAUDRATE;	// baudrate for host driver
	int  INTNO;		// IRQ used if tfpcx or tfpcr
	char TstHostCall[10];	// callsign of the system
	char UListEnable;	// if not 0, unproto list is active in memory,
				// and you cannot touch the TSTHOST.ULS file
	char Wpath[81];		// tsthost WorkDir
	char Upath[101];	// tsthost UserDir. If multipath exist, path
				// are separated by a space.
	char HomeBbs[10];	// callsign of homebbs
	char HomeAlias[10];	// homebbs alias callsign, null if undefined

			// ALL OTHERS FIELD ARE REFERRED TO THE SPECIFIED
			// CHANNEL
			//====================================================
	
	int  chstatus;		// 0 channel is disconnected
				// 1 standard connect, i have connected a user
				// 2 PMS connect, a user have connected the pms
				// 3 PMS, home bbs have connect my pms for fwd
				// 4 PMS, i have connected home bbs for fwd
				// 5 UNPROTO, i have connected home bbs to
				//   get unproto mail.
	char SuppCall[10];	// if not NULL, extra-callsign of the channel,
				// (AX PORT COMMAND)
	char UserCall[10];	// callsign of the remote connection with ssid

			// NEXT FIELD ARE VALID ONLY FOR USER PMS CONNECTION,
			// chstatus=2 or 3
			//=====================================================

	char UIname[13];	// name of the pms user
	long UILastConnTime;	// in seconds from 1970, last conn date
	long UILastMsgList;	// in second, last message listed
	long UINbrConn;		// number of connection made by call
	long UIThisConnTime;	// in second, actual conn date
	unsigned int SysFlag;	// actual SYS flag for the user
	}; 

void answer(int mode);		// this function does not return

int y,z;		// global variables
struct info *p;
char temp[101],*kk;
FILE *pf;
int IrqVect;
struct REGPACK rp;
char upath[5][81];
int DrvAvailable=0;
char mycall[7],callreturn[7],bbsreturn[7],title[81];

main(int argc, char **argv)
{					// First read users path
if(argc<2) exit(1);
if((pf=fopen("TSTHOST.IRQ","rt"))==NULL) 
	exit(1);			// Aquire IRQ vector
z=1;
while(fgets(temp,80,pf))
	{
	if(sscanf(temp,"TstHostInterruptVector=%d",&IrqVect)!=1) continue;
	if(IrqVect>255)	exit(1);
	z=0;
	break;
	}
fclose(pf);
if(z) exit(1);

for(z=0;z<5;z++) *upath[z]=0;	// clear users path
rp.r_ax=y;			// Read from exetended info the SYS user level
intr(IrqVect,&rp);		// Aquire standard users path 
z=rp.r_ax;
p=MK_FP(rp.r_es,rp.r_bx);
if(z>255) exit(1);
DrvAvailable=sscanf(p->Upath," %s %s %s %s %s",
	upath[0],upath[1],upath[2],upath[3],upath[4]);
if(DrvAvailable<1) exit(1);
if(sscanf(p->TstHostCall," %6[a-zA-Z0-9]",mycall)!=1) exit(1);

		// now open the input message.
if((pf=fopen(argv[1],"rt"))==NULL) exit(1);
z=0;		// get sender of the message
y=0;
while(fgets(temp,81,pf))
	{
	kk=temp;
	while(*kk==' ') kk++; // discard init space if exist
	if(*kk==0 || *kk=='\n' || *kk=='#') continue;
	if(y==0){		// get sender
		if(sscanf(kk,"SP %*s < %6[a-zA-Z0-9]",callreturn)!=1) exit(1);
		y++;
		continue;
		}
	*title=*bbsreturn=0;
	if(sscanf(kk," %s @ %6[a-zA-Z0-9]",title,bbsreturn)<1) exit(0);
	y=1;
	break;
	}
fclose(pf);
if(y==0) exit(1);	// found any error
kk=strupr(title);	// detect if there are a specified path
y=0;
if(*(kk+1)==':')
	{
	y=(*kk)-'C';
	if(y<0 || y>=DrvAvailable) answer(1);
	kk+=2;
	}
if(*kk=='\\') kk++;	// erase slash if exist
if(*kk==0) exit(0);
sprintf(temp,"%s%s",upath[y],kk);	// make real path
answer(0);
return 0;
}

void answer(int mode)
{
FILE *pfi,*pfo;
if((pfo=fopen("TSTHOST.IN","at"))==NULL) exit(1);
fprintf(pfo,"\nSP %s",callreturn);
if(*bbsreturn) fprintf(pfo," @ %s",bbsreturn);
fprintf(pfo," < %s\nReq File: %s\n\n",mycall,title);
if(mode==1)
	{
NONO:	fprintf(pfo,"Request file not found.\n/EX\n");
	exit(0);
	}
if((pfi=fopen(temp,"rt"))==NULL) goto NONO;
while(fgets(temp,100,pfi)) fputs(temp,pfo);
fprintf(pfo,"\n/EX\n");
exit(0);
}
