
			/* TSTHOST's MES_FILT C EXAMPLE */
			/*------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* global variable and definitions */
struct dirmes {
	char type;                  /* type of message BPT */
	char status;                /* status of message NFKYHX */
	long number;                /* number of message */
	int  da_year;               /* creation date, year */
	char da_day;                /* day */
	char da_mon;                /* mounth */
	unsigned char ti_min;       /* creation time, minutes */
	unsigned char ti_hour;      /* hour */
	unsigned char ti_hund;      /* hundredths of seconds */
	unsigned char ti_sec;       /* seconds */
	char to[7];                 /* destination, TO field */
	char route[7];              /* destination BBS, @ field */
	char from[7];               /* sender, FROM field */
	char title[61];             /* message title */
	char frombbs;               /* bit field:
                            bit 0 =1 if received in forward, 0 if local
                            bit 6 =1 if the msg contain the string /ACK
                            bit 7 =1 if the msg contain 7plus code */
	char startbbs[7];           /* BBS where the message started*/
	char bid[13];               /* BID or MID of the message */
	char rcvbbs[7];             /* BBS that have fwd the msg */
	char free[4];               /* reserved */
	};                 /* total 128 bytes */

char buf[81];			/* global line buffer */
char messagepath[81];		/* path of the message corp */
long dmsrecord;			/* record number in tsthost.dms database */
int  deftype;			/* default exit code, accept message */
struct dirmes dm;		/* space for record data */
FILE *pf;			/* general file pointer */
int fld;			/* field to examine */

/* when mes_filt start, the tsthost.exe directory is the current path*/

main(int argc, char **argv)
{
int mode,nparm,found,def7p;
char call[10];

deftype=0;					/* default exit code */
def7p=0;					/* default action for 7+ */
fld=0;						/* field not defined */
if(argc<2) return 0;				/* invalid call */
if(sscanf(argv[1],"%ld",&dmsrecord)!=1)		/* retrieve the dms rec nbr */
	return 0;				/* error, so exit */

/* open tsthost.dms file, in binary mode, and read the header data */
if((pf=fopen("TSTHOST.DMS","rb"))==NULL) return 0;
fseek(pf,dmsrecord,SEEK_SET);
if(fread(&dm,1,sizeof(struct dirmes),pf)!=sizeof(struct dirmes))
	return 0;	/* just in case of error */
fclose(pf);		/* dms is not more needed */

/* retrieve the name of message's corp, just if needed */
sprintf(messagepath,"MAIL\\%08ld.MES",dm.number);

/* now open the mes_filt.sys cfg file */
if((pf=fopen("MES_FILT.SYS","rt"))==NULL)
	return 0;	/* not found? nothing to do! */

/* scan the file for call corrispondance */
while(fgets(buf,80,pf))
	{
	nparm=sscanf(buf," %7s %d",call,&mode);
	if(nparm<1) continue;		/* invalid line */
	if(*call=='#') continue;	/* ignore comment */
	if(stricmp(call,"[TO]")==0)	/* search for field group */
		{
		fld=1;
		continue;
		}
	if(stricmp(call,"[ROUTE]")==0)
		{
		fld=2;
		continue;
		}
	if(stricmp(call,"[FROM]")==0)
		{
		fld=3;
		continue;
		}
	if(stricmp(call,"[TITLE]")==0)
		{
		fld=4;
		continue;		/* any other line is assumed to be */
		}			/* a callsign - number */
	if(nparm<2) continue;		/* invalid line */
	if(mode<0 || mode>2) continue;	/* invalid line */
	if(stricmp(call,"7PLUS")==0)	/* default value for 7plus */
		{
		def7p=mode;
		continue;
		}
	if(stricmp(call,"DEFAULT")==0)
		{
		deftype=mode;		/* set the default exit code */
		continue;
		}
	found=1;
	switch(fld)			/* now examine call correspondance */
		{
		case 1:			/* TO */
			found=stricmp(call,dm.to);
			break;
		case 2:			/* ROUTE */
			found=stricmp(call,dm.route);
			break;
		case 3:			/* FROM */
			found=stricmp(call,dm.from);
			break;
		case 4:			/* TITLE */
			found=!strstr(strupr(dm.title),strupr(call));
			break;
		}
	if(found==0)
		{
		deftype=mode;		/* found call corrispondance */
		break;			/* return this code, stop loop */
		}
	if(def7p)			/* we have defined a 7plus exception */
		{
		if(dm.frombbs&128)	/* and the mail have 7+ inside */
			{
			deftype=def7p;
			break;
			}
		}
	}
fclose(pf);
return deftype;
}
