#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

extern int _wscroll=0;
struct UInfo	{
		char call[7];
		char name[13];
		long LastConnTime;
		long LastMsgList;
		long NbrConn;
		long ThisConnTime;
		char PrivDir[31];
		char reserved[61];
		} ui;				/* 128 byte */

//==========================================================================
char helpmsg[]=
"ͻ\r\n"
"Use   CURSOR KEY to move   \r\n"
"                           \r\n"
"ENTER  to change user data \r\n"
"ESCAPE to abort            \r\n"
"ALT-D  to toggle delete    \r\n"
"ALT-K  to delete day oldest\r\n"
"ALT-F  to find callsign    \r\n"
"ALT-N  find next           \r\n"
"F-10   exit and save       \r\n"
"ͼ";
long current,totalrecord;
int  ScreenSize,videosize;
char intest[]="MAINTUSR v1.22 by IK1GKJ@IK1MSL";
FILE *in,*out;
char buf[1000];
char myline[]="͸";
//==========================================================================
void Error(char *msg);
void TestErrorIn(void);
void TestErrorOut(void);
int  GetOneNext(int mode);
void Decode(void);
void OneLineDown(void);
void OneLineUp(void);
int  YesNo(char *msg);
void SaveDatabase(void);
void GetData(void);
int  EditString(char *str,int size,int onlynumber);
void Help(void);
void GetDataNum(void);
int  Find(int cont);
int  IsDeleted(char *call);
//==========================================================================
int IsDeleted(char *call)
{
char *z;
z=call;
while(*z)
	{
	if(isdigit(*z)) z++;
	else break;
	}
if(*z==0) z=call;
return islower(*z);
}
//==========================================================================
int Find(int cont)
{
static char findcall[7]="";
struct text_info ti;
char data[7]="",data1[7],kx[100];
int x,found=0;
long cur;
gettextinfo(&ti);
window(1,2,80,5);
gettext(1,2,80,5,buf);
clrscr();
gotoxy(1,4); cputs(myline);
if(cont==0)
	{
	*findcall=0;
	gotoxy(1,2);
	cprintf("Enter call to search for: %-8s","");
	window(29,3,35,3);
	clrscr();
	if(EditString(data,6,0)) 
		{
AHH:		puttext(1,2,80,5,buf);
		goto NOTHING;
		}		
	if(sscanf(data," %s",data1)!=1) goto AHH;
	strcpy(findcall,data1);
	window(1,2,80,5);
	gotoxy(1,3);
	cur=0;
	}
else	cur=current+1;
x=strlen(findcall);
if(x==0) goto NOTHING;
for(;cur<totalrecord;cur++)
	{
	cprintf("\rPlease wait... searching record %ld",cur+1);
	fseek(in,cur*sizeof(struct UInfo),SEEK_SET);
	GetOneNext(1);
	if(strnicmp(ui.call,findcall,x)) continue;
	found=1;
	break;
	}
puttext(1,2,80,5,buf);
if(cont==0 && found==0)
	{
	sprintf(kx,"%s not found, create new one?",findcall);
	if(YesNo(kx))
		{
		fseek(in,0,SEEK_END);
		memset(&ui,0,sizeof(struct UInfo));
		strcpy(ui.call,strupr(findcall));
		ui.NbrConn=1;
		ui.LastConnTime=ui.ThisConnTime=time(NULL);
		fwrite(&ui,sizeof(struct UInfo),1,in);
		TestErrorOut();
		cur=totalrecord++;
		found=1;
		puttext(1,2,80,5,buf);
		}
	}
NOTHING:;
window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
gotoxy(1,ti.cury);
if(found)
	{
	current=cur;
	return 1;
	}
return 0;
}
//==========================================================================
void GetDataNum()
{
struct text_info ti;
long dayold,cur;
char data[9]="";
gettextinfo(&ti);
window(1,2,80,5);
gettext(1,2,80,5,buf);
clrscr();
gotoxy(1,4); cputs(myline);
gotoxy(1,2);
cprintf("Enter day oldest to delete: %-10s","");
window(31,3,39,3);
NONO:;
clrscr();
if(EditString(data,8,1)) goto NOTHING;
if(sscanf(data," %ld",&dayold)!=1)
	{
AHH:;	putch(7);
	goto NONO;
	}
if(dayold<1) goto AHH;
rewind(in);
window(1,2,80,5);
gotoxy(1,3);
dayold=time(NULL)-dayold*86400L;
for(cur=0;cur<totalrecord;cur++)
	{
	cprintf("\rPlease wait... processing record %ld",cur+1);
	fseek(in,cur*sizeof(struct UInfo),SEEK_SET);
	GetOneNext(1);
	if(ui.LastConnTime<dayold)
		{
		strlwr(ui.call);
		fseek(in,cur*sizeof(struct UInfo),SEEK_SET);
		fwrite(&ui,sizeof(struct UInfo),1,in);
		TestErrorOut();
		}
	}
NOTHING:;
puttext(1,2,80,5,buf);
window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
gotoxy(1,ti.cury);
}
//==========================================================================
void Help()
{
struct text_info ti;
gettextinfo(&ti);
gettext(25,10,53,20,buf);
window(25,10,53,20);
cputs(helpmsg);
if(getch()==0) getch();
puttext(25,10,53,20,buf);
window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
gotoxy(ti.curx,ti.cury);
}
//==========================================================================
int EditString(char *str,int size, int onlynumber)
{
static char validchar[]="\\ _+-.:";
int h,z;
while(1){
	h=getch();
	if(h==27) return -1;
	if(h==13) return 0;
	if(h==0){
		getch();
		continue;
		}
	z=strlen(str);
	if(h==8){
		if(z==0) continue;
		*(str+z-1)=0;
		goto DISP;
		}
	if(z>=size) continue;
	if(onlynumber)
		{
		if(isdigit(h)==0) continue;
		}
	else	{
		if(isalnum(h)==0 && strchr(validchar,h)==0)
			if(h<128 || h>154) continue;
		}
	*(str+z)=h;
	*(str+z+1)=0;
DISP:	clrscr();
	cputs(str);
	}
}
//==========================================================================
void GetData()
{
struct text_info ti;
int x,quale=0,datasize[2]={12,30};
char tmp[31],data[2][35]={"",""};
strcpy(data[0],ui.name);
strcpy(data[1],ui.PrivDir);
gettextinfo(&ti);
window(1,2,80,5);
gettext(1,2,80,5,buf);
clrscr();
gotoxy(1,4); cputs(myline);
gotoxy(1,2);
cprintf("Name:  %-13s\r\nPriv:  %-31s",ui.name,ui.PrivDir);
window(9,3,9+datasize[0],3);
gotoxy(1+strlen(data[0]),1);
x=0;
while(1){
	if(EditString(data[quale],datasize[quale],0)) break;
	if(++quale==2)
		{
		sscanf(data[0]," %[^\r\n]",ui.name);
		*ui.PrivDir=0;
		if(sscanf(data[1]," %29s",tmp)==1)
			{
			if(*(tmp+strlen(tmp)-1)!='\\') strcat(tmp,"\\");
			strcpy(ui.PrivDir,tmp);
			}
		fseek(in,current*sizeof(struct UInfo),SEEK_SET);
		fwrite(&ui,sizeof(struct UInfo),1,in);
		TestErrorOut();
		x=1;
		break;
		}
	window(9,4,9+datasize[1],4);
	gotoxy(1+strlen(data[1]),1);
	}
puttext(1,2,80,5,buf);
window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
gotoxy(ti.curx,ti.cury);
if(x)	{
	gotoxy(1,wherey());
	Decode();
	cputs(buf);
	}
}
//==========================================================================
void SaveDatabase()
{
clrscr();
cputs("Saving database.....");
if((out=fopen("TEMPUSR.$$1","wb"))==NULL) Error("Cannot open temp file for write");
rewind(in);
for(current=0;current<totalrecord;current++)
	{
	GetOneNext(1);
	if(IsDeleted(ui.call)) continue;
	strupr(ui.PrivDir);
	fwrite(&ui,sizeof(struct UInfo),1,out);
	TestErrorOut();
	}
fclose(out);
unlink("TSTHOST.USR");
if(rename("TEMPUSR.$$1","TSTHOST.USR")) Error("Cannot rename TEMPUSR.$$1 to TSTHOST.USR");
Error("Done");
}
//==========================================================================
int YesNo(char *msg)
{
struct text_info ti;
int z;
gettext(1,2,80,5,buf);
gettextinfo(&ti);
window(1,2,80,5);
clrscr();
gotoxy(1,4); cputs(myline);
gotoxy(1,2);
cprintf("%s (Y/N)? ",msg);
while(1){
	z=getch();
	switch(z)
		{
		case 0:
			getch();
			continue;
		case 'Y':
		case 'y':
			return 1;
		case 'n':
		case 'N':
			puttext(1,2,80,5,buf);
			window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
			gotoxy(ti.curx,ti.cury);
			return 0;
		}
	}
}
//==========================================================================
void OneLineUp()
{
if(current==0) return;
gotoxy(1,wherey());
textattr(7);
fseek(in,current*sizeof(struct UInfo),SEEK_SET);
GetOneNext(1);
Decode();
cputs(buf);
current--;
fseek(in,current*sizeof(struct UInfo),SEEK_SET);
GetOneNext(1);
Decode();
if(wherey()>1) gotoxy(1,wherey()-1);
else insline();
textattr(0x70);
cputs(buf);
}
	
//==========================================================================
void OneLineDown()
{
if(current==(totalrecord-1)) return;
gotoxy(1,wherey());
textattr(7);
fseek(in,current*sizeof(struct UInfo),SEEK_SET);
GetOneNext(1);
Decode();
cputs(buf);
GetOneNext(1);
cputs("\r\n");
Decode();
textattr(0x70);
cputs(buf);
current++;
}
//==========================================================================
void Error(char *msg)
{
window(1,1,80,ScreenSize);
textattr(7);
clrscr();
printf("\n%s\n%s\n\n",intest,msg);
fcloseall();
unlink("TEMPUSR.$$$");
exit(1);
}
//===========================================================================
void TestErrorIn()
{
if(ferror(in)) Error("Error reading input file");
}
//===========================================================================
void TestErrorOut()
{
if(ferror(out))	Error("Error writing output file");
}
//===========================================================================
int GetOneNext(int mode)
{
int z;
z=fread(&ui,1,sizeof(struct UInfo),in);
TestErrorIn();
if(z!=sizeof(struct UInfo))
	{
	if(mode) Error("Error reading input file");
	return 0;
	}
return 1;
}
//=========================================================================
void Decode()
{
struct tm *tm;
char tmp[7];
tm=localtime(&ui.LastConnTime);
strcpy(tmp,ui.call);
sprintf(buf,"%c%-6s%-12s%8ld%02d-%02d-%04d %02d:%02d%-30s",
	IsDeleted(ui.call)?'D':' ',strupr(tmp),ui.name,ui.NbrConn,
	tm->tm_mday,tm->tm_mon+1,tm->tm_year+1900,tm->tm_hour,tm->tm_min,
	ui.PrivDir);
}
//============================================================================
main()
{
int i;
struct text_info ti;
gettextinfo(&ti);
ScreenSize=ti.screenheight;
videosize=ScreenSize-5;
textattr(7);
clrscr();
totalrecord=0;
in=fopen("TSTHOST.USR","rb");
if((out=fopen("TEMPUSR.$$$","wb+"))==NULL) Error("Cannot open temporary file for write");
if(in)	{
	printf("\n%s\nPlease wait, making tmp copy of TSTHOST.USR....\n\n",intest);
	while(!feof(in))
		{
		if(GetOneNext(0))
			{
			fwrite(&ui,1,sizeof(struct UInfo),out);
			TestErrorOut();
			totalrecord++;
			}
		}
	fclose(in);
	}
if(totalrecord==0)
	{
	printf("\n\nDatabase is empty, enter callsign to create new record or ESCAPE to exit"
	       "\n\nCall %-8s","");
	window(wherex()-8,wherey(),wherex()-2,wherey());
	*buf=0;
	if(EditString(buf,6,0))
		{
AB:		Error("Aborted");
		}
	if(strlen(buf)==0) goto AB;
	memset(&ui,0,sizeof(struct UInfo));
	strcpy(ui.call,strupr(buf));
	ui.NbrConn=1;
	ui.ThisConnTime=ui.LastConnTime=time(NULL);
	fwrite(&ui,sizeof(struct UInfo),1,out);
	TestErrorOut();
	totalrecord++;
	}
in=out;
window(1,1,80,5);
textattr(0x70);
clrscr();
cprintf("%-69sF1 for Help\r\n\r\n%s\r\n"
      "DCall  Name        Nbr connLast connection Private directory             \r\n"
      "Ĵ",
      intest,myline);

current=0;

RESTART:;
window(1,6,80,ScreenSize);
textattr(7);
clrscr();
fseek(in,current*sizeof(struct UInfo),SEEK_SET);
for(i=0;i<videosize && (current+i)<totalrecord;i++)
	{
	GetOneNext(1);
	Decode();
	gotoxy(1,i+1);
	cputs(buf);
	}
gotoxy(1,1);
fseek(in,current*sizeof(struct UInfo),SEEK_SET);
GetOneNext(1);
textattr(0x70);
Decode();
cputs(buf);
while(1){
	i=getch();
	if(!i)	i=getch()*256;
	switch(i)
		{
		case 27: 
			if(YesNo("Abort edit")) Error("Aborted.");
			break;
		case 0x4400:	// F10
			if(YesNo("Save database")) SaveDatabase();
			break;
		case 0x5000:	// cur down
			OneLineDown();
			break;
		case 0x4800:	// cur up
			OneLineUp();
			break;
		case 0x4900:	// pg up
			i=wherey()-1;
			current=current-i-videosize;
			if(current>=0) goto RESTART;
		case 0x4700:	// home
			current=0;
			goto RESTART;
		case 0x5100:	// pg dwn
			i=wherey()-1;
			current=current-i+videosize;
			if(current<totalrecord)
				{
				if((current+videosize)<totalrecord) goto RESTART;
				}
		case 0x4f00:	// end
			current=totalrecord-videosize;
			if(current<0) current=0;
			goto RESTART;
		case 0x2000:	// alt-d
			if(IsDeleted(ui.call)) strupr(ui.call);
			else strlwr(ui.call);
			fseek(in,current*sizeof(struct UInfo),SEEK_SET);
			fwrite(&ui,sizeof(struct UInfo),1,in);
			TestErrorOut();
			gotoxy(1,wherey());
			Decode();
			cputs(buf);
			break;
		case 13:
			GetData();
			break;
		case 0x3b00:	// help
			Help();
			break;
		case 0x2500:	// alt k
			GetDataNum();
			current=0;
			goto RESTART;
		case 0x2100:	// alt f
			if(Find(0)) goto RESTART;
			break;
		case 0x3100:	// alt n
			if(Find(1)) goto RESTART;
			break;
		}
	}

}
