#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

FILE *in,*out;
char OUTFILE[]="LIST2UNP.OUT";
char buf[256],tmp[256],typestr[10],type,to[10],route[10],from[10],
     date[20],time[10];
long number,size;
int line,n;

main(int argc, char **argv)
{
puts("\nLIST2UNP v1.10, (c) IK1GKJ\nBbs list to unproto list converter\n");
if(argc<2)
	{
	puts("Usage: list2unp inputfile\n");
	exit(1);
	}

if((in=fopen(argv[1],"rt"))==NULL)
	{
	puts("Cannot open input file.");
	exit(1);
	}
if((out=fopen(OUTFILE,"wt"))==NULL)
	{
	puts("Cannot open output file.");
	exit(1);
	}
line=0;
while(fgets(buf,255,in))
	{
	printf("Converting, please wait.... line: %d\r",++line);
	if(sscanf(buf," %ld %9[^0-9] %ld %[^\r\n]",
		&number,typestr,&size,tmp)!=4) continue;
	strupr(typestr);
	if(strchr(typestr,'P'))	type='P';
	else if(strchr(typestr,'B')) type='B';
	else if(strchr(typestr,'T')) type='T';
	else if(strchr(typestr,'A')) type='A';
	else continue;
	if(sscanf(tmp,"%9[^@ ] %[^\r\n]",to,buf)!=2) continue;
	if(strlen(to)>6) continue;
	if(*buf=='@')
		{
		if(sscanf(buf+1,"%9s %[^\r\n]",route+1,tmp)!=2) continue;
		strcpy(buf,tmp);
		if(strlen(route+1)>6) continue;
		*route='@';
		}
	else	*route=0;
	if(sscanf(buf,"%9s %[^\r\n]",from,tmp)!=2) continue;
	if(strlen(from)>6) continue;
	*buf=0;
	n=sscanf(tmp,"%19s %9s %[^\r\n]",date,time,buf);
	if(n>1)		// se esiste sia la data che il tempo e forse il titolo
		{	// elimina il tempo
		if(strlen(time)==5)
			{
			if(isdigit(*time) && isdigit(time[1]) &&
			   isdigit(time[3]) && isdigit(time[4]) &&
			   isdigit(time[2])==0) sprintf(tmp,"%s %s",date,buf);
			}
		}
	fprintf(out,"%7ld %c %6ld %-6s%-7s %-6s %-40s\n",number,type,size,to,route,from,tmp);
	}
fclose(in);
fclose(out);
return 0;
}
