;
;           ___  MONOSCOPIC_COLO  ___
;
;
;
;              ***************
;              *  T E X T    *   testo scorrevole max 51 caratteri
;              *             *  
;              * barre grigi *
;              *             *  
;              *   12:00     *    (scritta fissa 9 Caratteri o orologio)
;              ***************
;
;************************************************************************
; Lo spunto  stato preso dal programma PICDREAM realizzato da
; Alain FORT e da Peter KNIGHT, mantenendo la struttura di base 
; del programma ho elaborato le seguenti modifiche
;
; Le varianti al programma originale sono:
;       A) la scritta scorrevole e fissa in alternativa all'orologio,
;          resa programmabile da pulsanti senza dover riprogrammare
;          la PIC
;       B) scorrimento della scritta a carattere o pixel con velocit
;          variabile impostata dai pulsanti
;       C) caratteri pi piccoli (met) con aumento dei caratteri 
;          sullo schermo possibile solo con PIC a 10 Mhz
;
; REQUISITI HW rispetto originale
;       A) PIC 16C84 o 16F84 a 10 Mhz  ( 16F84 preferibile per new release)
;       B) Quarzo 8 Mhz come clock alla PIC
;       C) Aggiunta di un interruttore al pin 11 verso massa
;
;NOTA: attenzine alla pregrammazzione della PIC in funzione del tipo 
;      di oscillatore utilizzato.
;
;       7351_  IW2KGH
;              Salvatore Pagnoncelli
;               Via Chiusa 18
;               24040 Bottanuco (BERGAMO)
;
;************************************************************************
;       
; Release SW:
;   V_01 ___ date  01/02/98
;
;         _beta release
;                
;   V_02 ___ date  01/04/98
;
;         _Corretto errore, non si riusciva a modificare la 
;           scritta scorrevole nelle prime e ultime posizioni
;         _Variato numero caratteri memorizzabili da 45 a 51
;         _Togle e mette sfondo sotto le scritte con pulsanti
;
;   V_03 ____ date 22/04/98
;
;        _Corretto errore, non si attendeva il tempo sufficente per la
;          scrittura in EEPROM, e quindi non memorizzava i dati di utente
;          Il difetto non si presenta su tutti i PIC. ( BUG di programma )
;        _Aumentato il tempo sincronismo di riga da 2,5 a 4,5 micro sec 
;                
;
;***********************************************************************
;

	TITLE   "MONOPIC_COLO"  ;PICDREAM modificato da IW2KGH Salvatore

	list p=16c84,  f=inhx32 ;Enter device name 
	__config 0x3FF2         ;configurazione (fuse_off )

#Define W       0
#Define F       1
#define Sync    PortA,0         ; Sincronismo video uscita RA0  (PIN 17)


LUNCAR  EQU     D'9'            ;
ULTICAR EQU     D'62'-LUNCAR    ;Ultimo carattere del circolare
FINCIR  EQU     ULTICAR-LUNCAR  ;
VELOCI  EQU     D'2'            ;

VELOFOS EQU     B'11110101'     ;SCRITTA Scorrevole
;                 ||||||||
;                 |||||||======= lasciare 1
;                 ||||========== Colore di fondo scritta
;                 |============= Sempre a 1
;                 ============== 1=Scritta scorrevole
			

VELOFOF EQU     B'01111001'     ;SCRITTA fissa
;                 ||||||||
;                 |||||||======= lasciare 1
;                 ||||========== Colore di fondo scritta
;                 |============= Sempre a 1
;                 ============== 0=Scritta fissa
;
;

	cblock  0x00
		INDF,RTCC,PCL,Status,FSR,PortA,PortB
	endc
	cblock  0x08
		EEData,EEAdr,PClath,IntCon
	endc
	cblock  0x08
		EECON1,EECON2,PClath,IntCon
	endc
	cblock  0x00
		C,DC,Z,PD,TO,RP0,RP1,IRP
	endc

	cblock  0x00
		RD,WR,WREN,WRERR,EEI
	endc

; Page 1 registers
TRISA   EQU     05H
PORTA   EQU     05H
Roption EQU     01H
TrisA   EQU     05H
TrisB   EQU     06H
RAMbase EQU     0CH


; DNOP - doppia NOP. Delay di 2 cycles, 

DNOP    MACRO
	LOCAL   Label
Label   GOTO    Label+1
	ENDM

SKIPNC  MACRO
	BTFSC   Status,C

	ENDM
SKIPSC  MACRO
	BTFSS   Status,C
	ENDM

SKIPNZ  MACRO
	BTFSC   Status,Z
	ENDM

SKIPSZ  MACRO
	BTFSS   Status,Z
	ENDM
	LIST

	CBLOCK  RAMbase                                         ;36 celle 
		TIME,CNT_0                                      ;2      2
		Count2,Count3,SubSec                            ;3      5   
		HrT,HrU,MiT,MiU,SeU                             ;5      10
		CA0,CA1,CA2,CA3,CA4,CA5,CA6,CA7,CA8             ;9      19
		Ta0,Ta1,Ta2,Ta3,Ta4,Ta5,Ta6,Ta7,Ta8             ;9      28
		Ptrtxt,CNT_1,CNT_R                              ;3      31
		CNTCA,TABCA,STATO,DISPE,PUNCA                   ;5      36
	ENDC                                                    ;
;
;TIME     cella utilizzata dal delay (nel ciclo)
;CNT_0    utilizzato chiamate per sapere quante righe video fare e altro 
;Count2   Contatore di quadri per azione con pulsanti (riservata )
;Count3   Contatore per velocit di scorrimento
;SubSec   utilizzata per semiquadri a/b e orologio 1sec
;
;Ptrtxt  punt. al primo carattere per display scritta scorrevole e no
;CNT_1   numero di linee che definiscono il punto carattere (DISPLAY)  
;CNT_R   numero di riga del carattere in dislay (DISPLAY)
;CNTCA   puntatore carattere circolare durante memorizzazione (stato0 e 1)
;TABCA   carattere da memorizzate convertito asci_tab
;STATO   stato per sapere quale comando devo eseguire
;DISPE   tipo di display a salti o punti e velocit da sommare
;PUNCA   punt. carattere scritta fissa durante memorizzazione frase 
;               
;*********************************************************************
;  EEPROM 
;*********************************************************************  
	ORG     2100
;scritta scorrevole (il primo CarSP va lasciato )
;
;frase: "QTH: NIEUWEGEIN FREQ. 10.180 GHZ"
;
	DT      CarSP,CarQ,CarT,CarH,CarDP,CarSP,CarN,CarI      ;8
	DT      CarE,CarU,CarW,CarE,CarG,CarE,CarI,CarN         ;8 16
	DT      CarSP,CarSP,CarSP,CarSP,CarSP,CarSP,CarSP,CarSP ;8 24
	DT      CarF,CarR,CarE,CarQ,CarPU,CarSP,Car1,Car0       ;8 32
	DT      CarPU,Car1,Car8,Car0,CarSP,CarG,CarH,CarZ       ;8 40                                   ;2 8
	DT      CarSP,CarSP,CarSP,CarSP,CarSP,CarSP,CarSP,CarSP ;8 48   
	DT      CarSP,CarSP,CarSP,CarSP,CarSP                   ;5 53

;scritta fissa
;"PE1PWB"
	DT      CarSP,CarSP,CarP,CarE,Car1,CarP,CarW,CarB,CarSP ;9 62

;Dati di gestione per il programma non modificare
;
	DE      00,0A                                           ;2 64
;******************************************************************
;
;MODI: cella 62 EEPROM 'XXXX XXXX' 
;                              ||___ Scritta orologio o fissa
;                              |____ Sfondo colore si /no
;
;VELO: cella 63 EEPROM 'XXXX XXXX'
;                            ||||___ Valore di somma per velocit
;                            |______ Scorrimento Pixel/caratteri
;       
;
;*********************************************************************
;       START  del programma 
;*********************************************************************  

	ORG     0
	GOTO    INIZIO

	ORG     4
	RETURN
;*********************************************************************
;       TABELLA definizione matrice dei caratteri
;*********************************************************************  
;
; Table of caracters
Table   ADDWF   CNT_R,W         ;
	ADDWF   PCL,F           ;
Tbase   equ     $
Car0    equ     $-Tbase
CarO    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car1    equ     $-Tbase
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001110'     ; ....***.
Car2    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00011111'     ; ...*****
Car3    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ;....*...*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000110'     ; .....**.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car4    equ     $-Tbase
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000110'     ; .....**.
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
Car5    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car6    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car7    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
Car8    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car9    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001111'     ; ....****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.      
CarSP   equ     $-Tbase
	RETLW   B'00000000'     ; ........
CarFI   equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
CarDP   equ     $-Tbase 
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
CarPU   equ     $-Tbase 
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
CarA    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011111'     ; ...*****
CarH    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011111'     ; ...*****
CarU    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ;.....***.
CarD    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarB    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarP    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
CarL    equ     $-Tbase
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarE    equ     $-Tbase
	RETLW   B'00011111'     ; ...***** 
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00011100'     ; ...***..
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarF    equ     $-Tbase
	RETLW   B'00011111'     ; ...***** 
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00011100'     ; ...***..
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarJ    equ     $-Tbase
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
CarG    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010011'     ; ...*..**
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarQ    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010011'     ; ...*..**
CarS    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
CarC    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010001'     ; ...*...*
CarI    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001110'     ; ....***.
CarK    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00011000'     ; ...**...
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00010010'     ; ...*..*.
CarM    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011011'     ; ...**.**
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarN    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010011'     ; ...*..**
CarY    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
CarR    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00010001'     ; ...*...*
CarV    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarX    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001010'     ; ....*.*.
CarW    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00011011'     ; ...**.**
	RETLW   B'00010001'     ; ...*...*
CarZ    equ     $-Tbase
	RETLW   B'00011111'     ; ...***** 
	RETLW   B'00000001'     ; ...... *
	RETLW   B'00000010'     ; ..... *.
	RETLW   B'00000100'     ; .... *..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00010000'     ; ...*....
CarT    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
CarBL   equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****

;*********************************************************************
;    inizio del programma e settaggio del PIC          
;*********************************************************************

INIZIO
	BSF     Status,RP0      ; select bank 1
	MOVLW   B'11110'        ; Port_A  0=outputs  1=inputs
	MOVWF   TrisA           ;
;       MOVLW   B'00000000'     ; serve per testare con MPLAB
	MOVLW   B'11100000'     ; Port_B  0=outputs  1=inputs
	MOVWF   TrisB           ; 
	BCF     Roption,7       ; resistenze pull-up on su port_B
	BCF     Status,RP0      ; select bank 0 

	CLRF    SeU             ; azzero clock a 00.00
	CLRF    MiU
	CLRF    MiT
	CLRF    HrU
	CLRF    HrT
	CLRF    Ptrtxt          ; puntatore inizio frase scorrevole
	CLRF    Count3          ;
	CLRF    DISPE           ;

;*********************************************************************
;   Programma principale o loop main          
;*********************************************************************

FRAME                           ;
	CALL    EQUALIZ         ;totale 7,5 linee

;*****  BLACK LINES   ************ line 0 (+15)=15

	MOVLW   D'15'           ; 1
	MOVWF   CNT_0           ; 2
	CALL    BLKLINE         ;128

;***** GREY BARS **************** line 15 (+208)=223

	MOVLW   D'208'          ;1
	MOVWF   CNT_0           ;2
	CALL BARRE              ;128

;**** BLACK LINES   ************* line 223 (+1)=224

	MOVLW   D'1'           ; 1
	MOVWF   CNT_0           ; 2
	CALL    BLKLINE         ;128

;***** PREPARE CLOCK ************ line 224 (+2)=226

	CALL    PREPH           ;2

;**** DISPLAY CLOCK 57 line  **** line 227 (+36)= 263
;
;        MOVLW   VELOFOF         ;
;        MOVWF   DISPE           ;
;        CALL    DISPLAY         ;1      128
;
;***** INCREMENT TIME *********** line 226 (+1)=227

	INCTIM  CALL    INCTIME         ;2      128

;**** INIT TEXTE     ************ line 227(+2)=229

	Call    PREREAD         ;2

;****  PULSANTI    ************** line 229(+1)=230

	Call    PULSANTI        ;2

;**** DISPLAY TEXTE ************* line 230 (+36)=266

	MOVLW   VELOFOS         ;1
	MOVWF   DISPE           ;2
	CALL    DISPLAY         ;4      128

	
; ***** BLACK LINES ************* line 266 (+5)=271
		   
	MOVLW   D'5'           ; 1
	MOVWF   CNT_0           ; 2
	CALL    BLKLINE         ;128

;***** GREY BARS **************** line 271 (+24)=295

	MOVLW   D'24'          ;1
	MOVWF   CNT_0           ;2
	CALL BARRE              ;128

; ***** BLACK LINES ************* line 295 (+10)=305

	MOVLW   D'10'           ; 1
	MOVWF   CNT_0           ; 2
	CALL    BLKLINE         ;128

	GOTO    FRAME           ;RITORNO A CAPO

;************************************************************
;************************************************************
;     Equalizzazione 7,5 + 305 visible Lines =312,5 *2 =625
;   inserisce linee per l'interlacciamento
;   e ritorno a capo del video secondo norme CCIR/PAL
;************************************************************
;
EQUALIZ
	CALL    SINCK           ;14     18
	MOVLW   4               ;1              
	BTFSS   SubSec,0        ;1-2    
	MOVLW   5               ;1      
	MOVWF   CNT_0           ;1      22

Loop1   CALL    RIT_46          ;46     68  (64  4)
	CALL    SINCK           ;14     18
	NOP                     ;1               
	DECFSZ  CNT_0,1         ;1-2        
	GOTO    Loop1           ;2              22  

	CALL    RIT_48          ;48     69   (64 5 )
	NOP                     ;1       6

; 5 mezze righe per Equalizzazione

	BCF     Sync            ;1      7   ;30us Sync
	CALL    RIT_8           ;       11  
	MOVLW   4               ;       12      
	MOVWF   CNT_0           ;       13
   
Loop2   CALL    RIT_48          ;52     65   
	BSF     Sync            ;1      66  ;2us Black
	CALL    RIT_8           ;4      70  (64 6)
	BCF     Sync            ;1      7   ;30us Sync
	DNOP                    ;2      9  
	NOP                     ;1      10
	DECFSZ CNT_0,1          ;       -       
	GOTO    Loop2           ;       13

	CALL    RIT_48          ;52     64  
	NOP                     ;       1  
	BSF     Sync            ;       2   ;2us Black

; 5 o 4 mezze righe di equalizzazione per interlacciare

	CALL    DSINCK          ;16     20  
	MOVLW   4               ;1      
	BTFSC   SubSec,0        ;1-2    
	MOVLW   3               ;1      
	MOVWF   CNT_0           ;1      22

Loop3   CALL    RIT_46          ;46     68  (64  4 )
	CALL    SINCK           ;14     18
	NOP                     ;1      
	DECFSZ  CNT_0,1         ;1-2    
	GOTO    Loop3           ;2      22
			
	MOVLW   D'12'           ;ritardo
	CALL    RIT_P0          ;41     62

	RETURN                  ;2      64

;************************************************************
;    routines di ritardo ( delay )
; es: RIT_51 = ritardo di 51 Time inclusi chiamata e ritorno
;************************************************************
;
RIT_48  NOP                     ;
RIT_47  NOP                     ;
RIT_46  MOVLW   D'13'           ;
	GOTO    RIT_P0          ;

RIT_15  NOP                     ;
RIT_14  MOVLW   D'2'            ;
	GOTO    RIT_P1          ;

RIT_P2  NOP                     ;
RIT_P1  NOP                     ;
RIT_P0  MOVWF   TIME            ; ritardo  2  + 3*W + 2
RITAY   DECFSZ  TIME,1          ;         call      return
	GOTO    RITAY           ;
	RETURN                  ;

RIT_8   NOP                     ;
RIT_7   NOP                     ;
RIT_6   NOP                     ;
RIT_5   NOP                     ;
RIT_4   RETURN                  ;

DSINCK  DNOP                    ;2
SINCK   BCF     Sync            ;1   Genera inpulso di sincronismo
	CALL    RIT_8           ;4   per 9 time= 4,5 micro_secondi
	BSF     Sync            ;1   toglie sinc
	RETURN                  ;2  (8) -(10)

;***************************************************************
;       Righe nere sul televisore
;  il numero di righe  definito in  CNT_0 prima della chiamata
;***************************************************************
;
BLKLI_0
	CALL    RIT_5           ;5   1 4
BLKLINE CALL    SINCK           ;14    18   impulso di sincronismo

	MOVLW   D'33'           ;           ritardo 
	CALL    RIT_P2          ;106  124

	DECFSZ  CNT_0           ;1-2  125  126
	GOTO    BLKLI_0         ;2    127   -

	RETURN                  ;2    128

;*****************************************************************
;       BARRE:  dei grigi in verticale sul video
;  il numero di righe utilizzato per le barre e definito in CNT_0
;*****************************************************************

;BARRE_0 CALL    RIT_5           ;5  1-4
BARRE_0 NOP

BARRE   CALL    SINCK           ;14  18 
	
;        MOVLW   D'2'            ;         ritardo
;        CALL    RIT_P1          ;9  27

	MOVLW   D'7'            ;1      numero di barre
	MOVWF   CNT_1           ;1      in CNT_1
	MOVLW   D'15'           ;1      pongo in uscita il valore 15
	MOVWF   PORTA           ;1  
	MOVLW   B'10000'        ;1      Port_A definisco gli
	NOP;!!
	NOP;!!
	NOP;!!
	TRIS    PORTA           ;1      output per i grigi
	DNOP                    ;2   35

BARRE_1 CALL    RIT_6           ;6      genero le barre partendo dal
	NOP  ;!!!!
	NOP;!!!
	MOVLW   -D'2'           ;1      bianco (parto 15 e sommo -2 ) 
	ADDWF   PORTA,1         ;1      
	DECFSZ  CNT_1           ;1-2
	GOTO    BARRE_1         ;2
	CALL    RIT_7           ;
	MOVLW   B'11110'        ;1  123  
	TRIS    PORTA           ;1  124
;!!        NOP                     ;
	DECFSZ  CNT_0           ;1-2 125
	GOTO    BARRE_0         ;2   127
	RETURN                  ;  2 128        

;*****************************************************************
;       DISPLAY: mette sul video i caratteri prendendoli 
;                dalla EEPROM
;*****************************************************************  
DISPLAY CALL    SINCK           ;14  18
	MOVLW   D'7'            ;        Numero di punti per carattere
	MOVWF   CNT_0           ;        metto in CNT_0 
	MOVLW   H'0FF'          ;        numero di linea del carattere
	MOVWF   CNT_R           ;    22  in display

	MOVLW   D'63'           ;1  
	CALL    EEREADW         ;9   32    leggo la parola di controllo da 

	RLF     Count3,W        ;1
	IORLW   B'10001111'     ;1
	ANDWF   DISPE,1         ;1
	MOVLW   B'11110000'     ;1
	BTFSS   EEData,3        ;1
	IORWF   DISPE,1         ;1
	BTFSS   DISPE,7         ;1
	IORWF   DISPE,1         ;1  40

	MOVLW   D'62'           ;1
	CALL    EEREADW         ;9  50

	MOVLW   D'24'           ;       ritardo 
	CALL    RIT_P0          ;77 127

INCLIN
	MOVLW   D'4'            ;       128
	MOVWF   CNT_1           ;       1       linee per punto
	INCF    CNT_R,1         ;1      2       inc riga per prossimo giro
	CALL    DSINCK          ;16     18

	MOVF    CA0,W           ;1      Prendo Il carattere lo sommo alla 
	CALL    Table           ;7      riga e vado a prendere il segmento
	MOVWF   Ta0             ;1  27  equivalente lo metto in ram

	MOVF    CA1,W           ;1
	CALL    Table           ;7
	MOVWF   Ta1             ;1  36

	MOVF    CA2,W           ;1
	CALL    Table           ;7
	MOVWF   Ta2             ;1  45

	MOVF    CA3,W           ;1
	CALL    Table           ;7
	MOVWF   Ta3             ;1  54

	MOVF    CA4,W           ;1
	CALL    Table           ;7
	MOVWF   Ta4             ;1  63
 
	MOVF    CA5,W           ;1 
	CALL    Table           ;7 
	MOVWF   Ta5             ;1  72

	MOVF    CA6,W           ;1
	CALL    Table           ;7
	MOVWF   Ta6             ;1  81

	MOVF    CA7,W           ;1
	CALL    Table           ;7
	MOVWF   Ta7             ;1  90

	MOVF    CA8,W           ;1
	CALL    Table           ;7
	MOVWF   Ta8             ;1  99

	MOVLW   D'7'            ;       ritardo 
	CALL    RIT_P0          ;26 125

SLINE
	CALL    RIT_7           ;7  128 4
	CALL    SINCK           ;14  18 

	CALL    RIT_8           ;8  26
	CALL    RIT_4           ;4  30

	MOVF    DISPE,W         ;1      in funzione bit 1 di EEData
	MOVWF   PORTA           ;1      definisco i bit di port_A
	MOVLW   B'11110'        ;1      delle barre di grigio output            
	BTFSS   EEData,1        ;1      o li lascio come input
	MOVLW   B'10000'        ;1      pongo il valore colore su port_A
	TRIS    PORTA           ;1(6) 36

	BTFSS   DISPE,6         ;  |
	CALL    RIT_5           ;   |
	BTFSC   DISPE,5         ;    |    in testa e in coda 
	GOTO    RITCAR1         ;     |  per lo scorrimento a pixel
	DNOP                    ;      ) due volte vale 17
	NOP                     ;     |
RITCAR1 BTFSS   DISPE,4         ;    |
	DNOP                    ;   |  ES ( 10+7 )
				;46

	MOVF    Ta0,W           ;1      Carac 1
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 7

	MOVF    Ta1,W           ;1      Carac 2
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 7

	MOVF    Ta2,W           ;1      Carac 3
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 7

	MOVF    Ta3,W           ;1      Carac 4
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 7

	MOVF    Ta4,W           ;1      Carac 5
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 7

	MOVF    Ta5,W           ;1      Carac 6
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 7

	MOVF    Ta6,W           ;1      Carac 7
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 7

	MOVF    Ta7,W           ;1      Carac 8
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 7

	MOVF    Ta8,W           ;1      Carac 9
	MOVWF   PortB           ;1  
	RLF     PortB,1         ;1
	RLF     PortB,1         ;1  
	RLF     PortB,1         ;1 
	RLF     PortB,1         ;1
	CLRF    PortB           ;1 109

	BTFSC   DISPE,6         ;  |
	CALL    RIT_5           ;   |
	BTFSS   DISPE,5         ;    |    in testa e in coda 
	GOTO    RITCAR2         ;     |  per lo scorrimento a pixel
	DNOP                    ;      ) due volte vale 21
	NOP                     ;     |
RITCAR2 BTFSC   DISPE,4         ;    |
	DNOP                    ; 11 |  ES ( 10+11 )
				;120

	MOVLW   B'11110'        ;1  121 pongo i bit di port_A come input
	TRIS    PORTA           ;1  122 quelli barra dei grigi

	DECFSZ  CNT_1,1         ;1-2  123  124
	GOTO    SLINE           ;2    125       
	DECFSZ  CNT_0,1         ;1-2  125  126
	GOTO    INCLIN          ;2    127               
	RETURN                  ;2         128

;*********************************************************************
;       PULSANTI: lettura dei comandi eseguiti tramite pulsanti
;         STATO    set orologio e set scritta / orologio
;         STATO_0  modifica della scritta scorrevole
;         STATO_1  modifica della scritta fissa 
;         STATO_2  cambio velocita di scorrimento scritta
;         
;*********************************************************************
;
PULSANTI
	CALL    DSINCK          ;  18
	BTFSS   PortB,5         ;1      porta B vedo scrittura on
	GOTO    CAMBIOC         ;2 21   se si salto a...cambio testo

	MOVF    PortB,w         ;1 21  
	XORLW   B'11111111'     ;1      vedo se  premuto un tasto
	ANDLW   B'11000000'     ;1 23   dei due o entrambi per set ora
	SKIPNZ                  ;1      se premuti faccio skip
	CLRF    Count2          ;1      non premuti faccio azzero Count2 
	INCF    Count2,1        ;1 26   contatore di quadri e lo increm 

	MOVF    Count2,W        ;1 27    verifico se count2  uguale
	XORLW   D'50'           ;1       a xx 
	SKIPSZ                  ;1 29    
	GOTO    RTS2            ;  31   se no salto il set ora

	MOVF    PortB,W         ;1 31   verifico se pulsanti entrambi
	XORLW   B'00111111'     ;1       premuti se si vado in STATME
	ANDLW   B'11000000'     ;1
	SKIPNZ                  ;1
	GOTO    STATME          ;  36

	BTFSC   PortB,7         ;  36   set minuti se premuto
	INCF    MiU,1           ;
	BTFSC   PortB,6         ;       set ore se premuto
	INCF    HrU,1           ;
	CLRF    SeU             ;  

	MOVLW   D'25'           ;  41   tempo di attesa per 
	MOVWF   Count2          ;       prossimo incremento
PULSA30 CLRF    STATO           ;  43
	CLRF    CNTCA           ;
	CLRF    PUNCA           ;

	MOVLW   D'6'            ;
	CALL    RIT_P2          ;25 70   ritardo per sincronizzare

PULSA58 DNOP                    ;   72
PULSA60 NOP                     ;   73
PULSA61 NOP                     ;   74

PULSA62 MOVLW   D'15'           ;         ritardo
	CALL    RIT_P2          ;47  126

	RETURN                  ;   128

RTS2    MOVLW   D'1'            ;        ritardo
	CALL    RIT_P1          ;9  40
	GOTO    PULSA30         ;2  42

STATME  MOVLW   D'62'           ;  37
	MOVWF   EEAdr           ;  38
	CALL    EEREADW         ;9 47
	MOVWF   TIME            ;1      scelta se visualizzare testo 
	INCF    TIME,1          ;       o orologio con sfonfo o senza
	MOVF    TIME,W          ;
	MOVWF   EEData          ;   51
	CALL    MEMEEP          ;12 63        MEMORIZZA 
	CALL    RIT_7           ;7  70
	GOTO    ATTES72         ;   72
;---------------------------------------------------------------------

CAMBIOC MOVF    STATO,W         ;  22  verifico in che stato sono
	XORLW   D'0'            ;  
	SKIPNZ                  ;  24  se stato_0
	GOTO    STATO0          ;  26  vado cambio scritta scorrevole

	MOVF    STATO,W         ;  26
	XORLW   D'1'            ;  27
	SKIPNZ                  ;  28  se stato_1
	GOTO    STATO1          ;  30  vado cambio scritta fissa

;---------------------------------------------------------------------
;   STATO 2  cambio velocit di scorrimento scritta
;---------------------------------------------------------------------

STATO2  MOVLW   D'63'           ;  30   
	CALL    EEREADW         ;9 39
	MOVWF   CNTCA           ;
	MOVF    PortB,W         ;       
	XORLW   B'11111111'     ;  42   vedo se  premuto un tasto
	ANDLW   B'11000000'     ;       dei due o entrambi
	SKIPNZ                  ;       se premuti faccio skip
	CLRF    Count2          ;       non premuti faccio clear 
	INCF    Count2,1        ;       contatore di quadri e incr

	MOVF    Count2,W        ;  47   verifico se count2  uguale
	XORLW   D'2'            ;  48      a xx
	SKIPNZ                  ;       
	GOTO    RST2            ;  51   

	MOVLW   D'23'           ;        ritardo
	CALL RIT_P2             ;25  76
	RETURN

RST2    INCF    Count2,1        ;  52   
	CLRF    Count3          ;  53

	BTFSS   CNTCA,2         ;54     
	GOTO    STATO21         ;       
	COMF    CNTCA,W         ;1      56
	ANDLW   B'00001000'     ;1
	MOVWF   CNTCA           ;1
	BSF     CNTCA,0         ;1
	GOTO    STATO22         ;2      61

STATO21 BCF     Status,C        ;1      57
	RLF     CNTCA,1         ;1      
	BSF     CNTCA,3         ;1
	BTFSS   CNTCA,4         ;1
	BCF     CNTCA,3         ;1      61
STATO22 MOVF    CNTCA,W         ;1      62

	BCF     CNTCA,4         ;1
	MOVLW   D'63'           ;1  64   
	MOVWF   EEAdr           ;1       
	MOVF    CNTCA,W         ;1   66
	MOVWF   EEData          ;1   
	CALL    MEMEEP          ;12 79        MEMORIZZA 

	MOVLW   D'14'           ;
	CALL    RIT_P0          ;47
	GOTO    FINATT          ;                       ;128



;---------------------------------------------------------------------
;STATO 0  cambio scritta scorrevole 
;---------------------------------------------------------------------

STATO0  CLRF    Count3          ;  27
	COMF    PortB,w         ;       
	ANDLW   B'11000000'     ;       vedo se  premuto un dei due 
	SKIPNZ                  ;       o entrambi i tasti se si skip
	CLRF    Count2          ;       non premuti faccio clear 
	INCF    Count2,1        ;  32   contatore di quadri e increm 

	MOVF    Count2,W        ;       verifico se count e arrivato
	XORLW   D'30'           ;       al numero 
	SKIPSZ                  ;     
	GOTO    RST0            ;   37

	MOVF    PortB,w         ;37
	ANDLW   B'11000000'     ;       pulsanti entrambi pigiati   
	SKIPNZ                  ;
	GOTO    MEMCAR          ; 41    se si salto a memorizzazione

	BTFSC   PortB,7         ;41
	INCF    CNTCA           ;       incremento carattere
	BTFSC   PortB,6         ;
	DECF    CNTCA           ;       decremento carattere3

	MOVF    CNTCA,W         ;
	XORLW   D'255'          ;       verifico se fondo scala 
	SKIPSZ                  ;47     o inizio
	GOTO    CAMBI01         ; 49
	MOVLW   D'39'           ;49     per effettuare il 
	MOVWF   CNTCA           ;       sistema circolare a salire
	NOP                     ;
	GOTO    CAMBI02         ;53

CAMBI01 MOVF    CNTCA,W         ;50     
	XORLW   D'40'           ;       sistema circolare a scendere
	SKIPNZ                  ;
	CLRF    CNTCA           ;53

CAMBI02 MOVLW   D'13'           ;54     velocita di cambio carattere
	MOVWF   Count2          ;55
	CALL CONVER             ;15 70
	MOVF    TABCA,W         ;
	MOVWF   CA8             ;
	GOTO    PULSA62         ;   74

CONVER  MOVLW   HIGH Texte      ;1      conversione del numero CNTCA 
	MOVWF   PClath          ;2      al puntatore del carattere
	MOVF    CNTCA,W         ;3
	CALL    Texte           ;(6) 9
	MOVWF   TABCA           ;10
	CLRF    PClath          ;11
	RETURN                  ;  13


RST0    CALL    CONVER          ;15 52
	MOVF    TABCA,W         ;
	MOVWF   CA8             ;

	MOVLW   D'1'            ;ritardo
	CALL    RIT_P1          ;11  65

	MOVF    Ptrtxt,W        ;
	ADDLW   D'211'          ;

	movlw   -D'7'           ;
	btfsc   Ptrtxt,7        ;
	bcf     Status,0        ;

	SKIPNC                  ;
	movwf   Ptrtxt          ;

	GOTO    PULSA60         ;72

;---------------------------------------------------------------------
;STATO 1  cambio scritta fissa di fondo 
;---------------------------------------------------------------------

STATO1  CLRF    Count3          ;31
	COMF    PortB,w         ;       
	ANDLW   B'11000000'     ;       vedo se  premuto un tasto  
	SKIPNZ                  ;       dei due o entrambi se si skip
	CLRF    Count2          ;       non premuti faccio clear 
	INCF    Count2,1        ;36     contatore di quadri e increm 

	MOVF    Count2,W        ;       verifico se count e arrivato
	XORLW   D'30'           ;       al numero 
	SKIPSZ                  ;39     
	GOTO    RST1            ;   41

	MOVF    PortB,w         ;41
	ANDLW   B'11000000'     ;     pulsanti entrambi pigiati
	SKIPNZ                  ;
	GOTO    MEMCAR1         ; 45    se si salto a memorizzazione

	BTFSC   PortB,7         ;45
	INCF    CNTCA           ;       incremento carattere
	BTFSC   PortB,6         ;
	DECF    CNTCA           ;       decremento carattere3

	MOVF    CNTCA,W         ;
	XORLW   D'255'          ;50     verifico se fondo scala 
	SKIPSZ                  ;       o inizio
	GOTO    CAMBI11         ; 53
	MOVLW   D'39'           ;53     per effettuare il 
	MOVWF   CNTCA           ;       sistema circolare a salire
	NOP                     ;
	GOTO    CAMBI12         ; 57

CAMBI11 MOVF    CNTCA,W         ;54     
	XORLW   D'40'           ;       sistema circolare a scendere
	SKIPNZ                  ;
	CLRF    CNTCA           ;
CAMBI12 MOVLW   D'13'           ;58     velocita di cambio carattere
	MOVWF   Count2          ;59
CAMBI47 CALL CONVER             ;15 74
 
	MOVF    PUNCA,W         ;75
	ADDLW   H'16'           ;
	MOVWF   FSR             ;
	MOVF    TABCA,W         ;
	MOVWF   INDF            ;

	CALL    RIT_47          ;126
	RETURN                  ;128     

RST1    MOVLW   D'3'            ;ritardo
	CALL    RIT_P2          ;16  53

	GOTO    CAMBI47         ;55
;---------------------------------------------------------------------

MEMCAR  MOVLW   LUNCAR-1        ; 42
	ADDWF   Ptrtxt,W        ;       memorizzazione del puntatore
	MOVWF   EEAdr           ;       tabella caratteri in eeprom
	MOVF    TABCA,W         ;
	MOVWF   EEData          ;
	XORLW   CarBL           ; 47
	SKIPNZ                  ; 48
	GOTO    NEWSTA          ; 50
	CALL    MEMEEP          ;12  61        MEMORIZZA 

	MOVF    Ptrtxt,W        ;
	XORLW   FINCIR          ;
	SKIPSZ                  ;
	INCF    Ptrtxt          ;       incremento il puntatore al
		
	CLRF    CNTCA           ;66     
	CALL    RIT_4           ;70
	GOTO    ATTES72         ;72     vado a ritardo per wr EEPROM

;---------------------------------------------------------------------
MEMCAR1 MOVF    PUNCA,W         ; 46
	ADDWF   Ptrtxt,W        ;       memorizzazione del puntatore
	MOVWF   EEAdr           ;       tabella caratteri in eeprom
	MOVF    TABCA,W         ;
	MOVWF   EEData          ;
	XORLW   CarBL           ;
	SKIPNZ                  ;52
	GOTO    NEWSTA1         ;   54
	CALL    MEMEEP          ;12 65    MEMORIZZA 
	
	MOVF    PUNCA,W         ;
	XORLW   LUNCAR-1        ;       lunghezza del nome
	SKIPSZ                  ;68
	INCF    PUNCA           ;       incremento il puntatore al
			
	CLRF    CNTCA           ;70

ATTES70 DNOP                    ;72         in caso di memorizzazione EEPROM

ATTES72 MOVLW   D'17'           ;  17       ritardo sincronizzazione riga
	CALL    RIT_P0          ;56  128

FINATT  MOVLW   D'224'          ;224        Ritardo per poter scrivere
	MOVWF   CNT_0           ;           la EEPROM a bordo del PIC
	CALL    BLKLINE         ;           nessuna operazione su EEPROM
	GOTO    INCTIM          ;           per almeno 14 milli secondi
 
;---------------------------------------------------------------------
MEMEEP  BSF     Status,RP0      ;1
	BSF     EECON1,WREN     ;2
	MOVLW   055             ;3
	MOVWF   EECON2          ;4       MEMORIZZAZIONE EEPROM
	MOVLW   0AA             ;5 
	MOVWF   EECON2          ;6      
	BSF     EECON1,WR       ;7
	BCF     Status,RP0      ;8
	RETURN                  ;10
;---------------------------------------------------------------------

NEWSTA  CALL    RIT_4           ;54
NEWSTA1 INCF    STATO           ;55
	MOVLW   ULTICAR         ;       Ultimo carattere del circolare
	MOVWF   Ptrtxt          ;

	MOVLW   D'2'            ;       ritardo
	CALL    RIT_P2          ;13  70 

	GOTO    PULSA60         ;   72
;*******************************************************
;    Incremento orologio 
;*******************************************************
INCTIME CALL    DSINCK          ;16  18
	INCF    SubSec,1        ;1      Incremento 1/50 sec
	MOVLW   -D'50'          ;1
	ADDWF   SubSec,W        ;1      
	SKIPNC                  ;1      
	CLRF    SubSec          ;1
	SKIPNC                  ;1
	INCF    SeU,1           ;1       And increment Second Units
	SKIPNC                  ;1
	NOP                     ;1       seconds counter modulo 256
	MOVLW   -D'60'          ;1
	ADDWF   SeU,W           ;1       Carry if needed Second Units->Tens
	SKIPNC                  ;1
	CLRF    SeU             ;1
	SKIPNC                  ;1
	INCF    MiU,1           ;1             unit di minuti
	MOVLW   -D'10'          ;1      34
	ADDWF   MiU,W           ;1      
	SKIPNC                  ;1
	CLRF    MiU             ;1
	SKIPNC                  ;1
	INCF    MiT,1           ;1      39     decine di minuti
	MOVLW   -D'6'           ;1
	ADDWF   MiT,W           ;1
	SKIPNC                  ;1
	CLRF    MiT             ;1
	SKIPNC                  ;1
	INCF    HrU,1           ;1      45
	MOVLW   -D'10'          ;1
	ADDWF   HrU,W           ;1 
	SKIPNC                  ;1
	CLRF    HrU             ;1
	SKIPNC                  ;1
	INCF    HrT,1           ;1
	MOVF    HrU,W           ;1              Now check for Hours=24
	BTFSC   HrT,0           ;1
	ADDLW   D'10'           ;1      54
	BTFSC   HrT,1           ;1      
	ADDLW   -D'4'           ;1
	SKIPNC                  ;1
	CLRF    HrU             ;1      58      clear unita di ore
	SKIPNC                  ;1
	CLRF    HrT             ;1      60      clear decine di ore

	MOVLW   D'20'           ;               ritardo
	CALL    RIT_P1          ;66  126

	RETURN                  ;2      128

;*******************************************************
;       prepara le celle da displeiare
;*******************************************************
PREREAD CALL    DSINCK          ;   18
	MOVLW   D'63'           ;1
	CALL    EEREADW         ;9  28   estraggo da EEPROM la cella
				;        per la velocit o no ????
	MOVWF   DISPE           ;1       la metto in DISPE
	ANDLW   B'00000111'     ;1       
				
	ADDWF   Count3,1        ;1       e la sommo a Count3
	MOVF    Count3,W        ;1

	ADDLW   -D'56'          ;1  33  numero di quadri (20mS quadro)
	SKIPSC                  ;1-2    per velocita scorrimento 
	GOTO    GRIT2           ;       scritta al primo ingresso
	CLRF    Count3          ;       partenza per arrivare a ...
	INCF    Ptrtxt          ;1  37

	MOVF    Ptrtxt,W        ;1       puntatore all'ultimo carattere
	XORLW   ULTICAR+1       ;1      se si azzero puntatore
	SKIPNZ                  ;1
	CLRF    Ptrtxt          ;1      
	
PREREA1 CALL    RIT_4           ;11     45
	MOVF    Ptrtxt,W        ;1  47
PRERET  MOVWF   CNT_0           ;1      metto puntatore carattere in CNT_0
	MOVLW   D'22'           ;1      puntatore al segmento
	MOVWF   FSR             ;1      inizio tabella CA
	NOP                     ;1  50  

	CALL    EEREAD          ;18 68  leggo 1 carattere
	MOVF    EEData,W        ;1
	XORLW   CarFI           ;1      verifico se  ultimo carattere
	MOVLW   -D'7'           ;1      del messaggio
	SKIPNZ                  ;1      se no salto .. altrimenti 
	MOVWF   Ptrtxt          ;1  73  pongo puntatore a -7

	CALL    EEREAD          ;18 91  Leggo 2 carattere 
	CALL    EEREAD          ;18 109 leggo 3 carattere
	CALL    EEREAD          ;18 127 leggo 4 carattere
	CALL    RIT_5           ;5  132
;---------------------------------------------------- NUOVA LINEA
	CALL    SINCK           ;   18
	CALL    EEREAD          ;18 36  leggo 5 carattere
	CALL    EEREAD          ;18 54  leggo 6 carattere
	CALL    EEREAD          ;18 72  leggo 7 carattere
	CALL    EEREAD          ;18 90  leggo 8 carattere
	CALL    EEREAD          ;18 108 leggo 9 carattere
	CALL    EEREAD          ;18 126 leggo 10 carattere
	RETURN                  ; 128

;--------------------------------------------           
GRIT2   DNOP                    ;38
	NOP                     ;39
	GOTO    PREREA1         ;41
;--------------------------------------------
;**************************************************************
;       Prepara riga per display ore o scritta
;**************************************************************
PREPH   CALL    DSINCK          ;  18

	MOVLW   D'63'           ;1    
	CALL    EEREADW         ;9  28
	MOVWF   DISPE           ;1  29

	MOVLW   D'62'           ;1  30
	CALL    EEREADW         ;9  39    verifico se display ore
	ANDLW   B'00000001'     ;1        o scritta fissa 
	SKIPNZ                  ;1  41    se ore salto
	GOTO    PRETEST         ;  43     se scritta vado a...

	MOVLW   CarSP           ;1  43  Metto lo space in tutte
	MOVWF   CA0             ;1      le celle da  displeiare                         
	MOVWF   CA1             ;1
	MOVWF   CA2             ;1
	MOVWF   CA3             ;1
	MOVWF   CA4             ;1
	MOVWF   CA5             ;1
	MOVWF   CA6             ;1
	MOVWF   CA7             ;1
	MOVWF   CA8             ;1  52  

	BCF     Status,C        ;   53

	MOVF    HrT,W           ;1        Decine di ore 
	CALL    MULT7           ;10
	MOVWF   CA3             ;1  65  

	MOVF    HrU,W           ;1        unit di ore 
	CALL    MULT7           ;10
	MOVWF   CA4             ;1  77 

	MOVLW   CarDP           ;1
	BTFSC   SeU,0           ;1      visualizzo i due punti o
	MOVLW   CarSP           ;1      lo space ogni secondo
	MOVWF   CA5             ;1  81  

	MOVF    MiT,W           ;1          Decine di minuti 
	CALL    MULT7           ;10
	MOVWF   CA6             ;1  93

	MOVF    MiU,W           ;1          Decine di ore 
	CALL    MULT7           ;10
	MOVWF   CA7             ;1   105

	MOVLW   D'7'            ;            ritardo
	CALL    RIT_P1          ;27  128 4

	CALL    SINCK           ;    18
	MOVLW   D'34'           ;           ritardo
	CALL    RIT_P1          ;108  126

	RETURN                  ;   128

PRETEST MOVLW   ULTICAR         ;44     punto al carattere della
	GOTO    PRERET          ;46      scritta fissa e vado ...

;*******************************************************
;  routines di moltiplicazione per sette
;*******************************************************
MULT7   MOVWF   TIME            ;1     
	RLF     TIME,1          ;1      moltiplico x sette
	RLF     TIME,1          ;1      il valore in W e lo
	ADDWF   TIME,1          ;1      ritorno in W
	ADDWF   TIME,1          ;1
	ADDWF   TIME,W          ;1 
	RETURN                  ;2 (8)

;*******************************************************
;       lettura dato in eeprom
;*******************************************************

EEREAD  MOVLW   D'0'            ;
	BTFSS   CNT_0,7         ;       verifico se leggere la cella 0
	MOVF    CNT_0,W         ;      
	MOVWF   EEAdr           ;       lettura della eeprom
	BSF     Status,RP0      ;       alla cella puntata
	BSF     EEData,RD       ;       da Count
	BCF     Status,RP0      ;
	MOVF    EEData,W        ;       
	MOVWF   INDF            ;       metto dato a indirizzo
	INCF    FSR             ;       puntato da FSR
	XORLW   CarFI           ;       verifico se fine caratteri
	SKIPNZ                  ;       se si 
	BSF     CNT_0,7         ;       setto di leggere sempre cella 0
	INCF    CNT_0           ;
	RETURN                  ;16

EEREADW MOVWF   EEAdr           ;1      lettura della eeprom
	BSF     Status,RP0      ;2      alla cella puntata
	BSF     EEData,RD       ;3      dal W prima della chiamata
	BCF     Status,RP0      ;4
	MOVF    EEData,W        ;5      ritorno dato in accumulatore
	RETURN                  ;7

;*******************************************************
;       tabella di riferimento caratteri asci
;*******************************************************

Texte   ADDWF   PCL,F
DTexte  equ     $
	RETLW   CarBL   ; - 
	RETLW   CarA    ; 0 
	RETLW   CarB    ; 1
	RETLW   CarC    ; 2
	RETLW   CarD    ; 3
	RETLW   CarE    ; 4
	RETLW   CarF    ; 5
	RETLW   CarG    ; 6
	RETLW   CarH    ; 7
	RETLW   CarI    ; 8
	RETLW   CarJ    ; 9
	RETLW   CarK    ; 10
	RETLW   CarL    ; 11
	RETLW   CarM    ; 12
	RETLW   CarN    ; 13
	RETLW   CarO    ; 14
	RETLW   CarP    ; 15
	RETLW   CarQ    ; 16
	RETLW   CarR    ; 17
	RETLW   CarS    ; 18
	RETLW   CarT    ; 19
	RETLW   CarU    ; 20
	RETLW   CarV    ; 21
	RETLW   CarW    ; 22
	RETLW   CarX    ; 23
	RETLW   CarY    ; 24
	RETLW   CarZ    ; 25
	RETLW   CarSP   ; 26
	RETLW   Car0    ; 27  
	RETLW   Car1    ; 28
	RETLW   Car2    ; 29
	RETLW   Car3    ; 30
	RETLW   Car4    ; 31 
	RETLW   Car5    ; 32
	RETLW   Car6    ; 33
	RETLW   Car7    ; 34
	RETLW   Car8    ; 35
	RETLW   Car9    ; 36
	RETLW   CarDP   ; 37
	RETLW   CarFI   ; 38
	RETLW   CarSP   ; 39
	END


