; LE 13/02/1999
; Edit avec PFE and assembl avec MPASM
; Indicatif F1CJN
; Email:     Tristan@Club-Internet.fr
; Copyright: Alain FORT et Association Nationale de Tlevision Amateur (ANTA)

	TITLE	"PICOSD"  ; PIC On Screen Display

	LIST	P=16C84


#Define	W	0
#Define	F	1

; PIC16C84 defines
	cblock	0x00
		INDF,RTCC,PCL,STATUS,FSR,PORTA,PORTB
	endc
	cblock	0x08
		EEData,EEAdr,PClath,INTCON
	endc

; Status bits
	cblock	0x00
		C,DC,Z,PD,TO,RP0,RP1,IRP
	endc

; Page 1 registers
Roption	EQU	01H
TrisA	EQU	05H
TrisB	EQU	06H
RAMbase	EQU	0CH

#define INTER1	PORTB,5  ; Entre RB5  (PIN 11)	Scrolling  message 60 Sec
#define INTER2	PORTB,6  ; Entree RB6  (PIN 12) Text1
#define INTER3	PORTB,7  ; Entre RB7  (PIN 13) Text2
#define SLIGNE	PORTA,3  ; Sortie RA3  (PIN 2)
#define ETRAME	PORTA,2  ; Entre ETrame sur RA2  (PIN 1)


; DNOP - Double NOP. Delai de 2 cycles, mais ne prend qu'une instruction

DNOP	MACRO
	LOCAL	Label
Label	GOTO	Label+1
	ENDM  

; Delay3W - Delay 3 * W cycles, trois instructions

Delay3W	MACRO
	LOCAL	Label
	MOVWF	Delay		; 1 \
Label	DECFSZ	Delay		; n+1 } 3n
	GOTO	Label		; 2n-2/
	ENDM

;STATUS macro instruction

SKIPCC	MACRO
	BTFSC	STATUS,C
	ENDM

	LIST

	CBLOCK	RAMbase
		Delay,LIGNE,Trames,TNB,TNB1,TEMP		; 6	 
		CA0,CA1,CA2,CA3,CA4,CA5,CA6,CA7,CA8,CA9,CA10	; 11 Pointeurs de caracteres
		Ta0,Ta1,Ta2,Ta3,Ta4,Ta5,Ta6,Ta7,Ta8,Ta9,Ta10	; 11 Pointeurs de la ligne du caractere
		PTRTXT,Scroll,COUNTER,ADRESULT			; 4
			
	ENDC

	ORG	0
	GOTO	INIT 

	ORG	4
	RETFIE

Table	ADDWF	PCL,F
Tbase	equ	$
Car0	equ	$-Tbase
CarO	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00001110'	; ....***.
Car1	equ	$-Tbase
	RETLW	B'00000100'	; .....*..
	RETLW	B'00001100'	; ....**..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00001110'	; ....***.
Car2	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00000001'	; .......*
	RETLW	B'00000010'	; ......*.
	RETLW	B'00000100'	; .....*..
	RETLW	B'00001000'	; ....*...
	RETLW	B'00011111'	; ...*****
Car3	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001' 	;....*...*
	RETLW	B'00000001'	; .......*
	RETLW	B'00000110'	; .....**.
	RETLW	B'00000001'	; .......*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00001110'	; ....***.
Car4	equ	$-Tbase
	RETLW	B'00000010'	; ......*.
	RETLW	B'00000110'	; .....**.
	RETLW	B'00001010'	; ....*.*.
	RETLW	B'00010010'	; ...*..*.
	RETLW	B'00011111'	; ...*****
	RETLW	B'00000010'	; ......*.
	RETLW	B'00000010'	; ......*.
Car5	equ	$-Tbase
	RETLW	B'00011111'	; ...*****
	RETLW	B'00010000'	; ...*....
	RETLW	B'00011110'	; ...****.
	RETLW	B'00000001'	; .......*
	RETLW	B'00000001'	; .......*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00001110'	; ....***.
Car6	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010000'	; ...*....
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00001110'	; ....***.
Car7	equ	$-Tbase
	RETLW	B'00011111'	; ...*****
	RETLW	B'00000001'	; .......*
	RETLW	B'00000001'	; .......*
	RETLW	B'00000010'	; ......*.
	RETLW	B'00000010'	; ......*.
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
Car8	equ	$-Tbase
 	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
 	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
 	RETLW	B'00001110'	; ....***.
Car9	equ	$-Tbase
 	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
 	RETLW	B'00001111'	; ....****
	RETLW	B'00000001'	; .......*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00001110'	; ....***.	
Car. 	equ	$-Tbase
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000100'	; .....*..
SP	equ	$-Tbase
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
	RETLW	B'00000000'	; ........
CarA	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00011111'	; ...*****
CarH	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00011111'	; ...*****
CarU	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00001110'	;.....***.
CarD	equ	$-Tbase
	RETLW	B'00011110'	; ...****.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
CarB	equ	$-Tbase
	RETLW	B'00011110'	; ...****.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
CarP	equ	$-Tbase
	RETLW	B'00011110'	; ...****.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00011110'	; ...****.
CarL	equ	$-Tbase
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
CarE	equ	$-Tbase
	RETLW	B'00011111'	; ...***** 
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00011100'	; ...***..
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
CarF	equ	$-Tbase
	RETLW	B'00011111'	; ...***** 
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00011100'	; ...***..
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
CarJ	equ	$-Tbase
	RETLW	B'00000001'	; .......*
	RETLW	B'00000001'	; .......*
	RETLW	B'00000001'	; .......*
	RETLW	B'00000001'	; .......*
	RETLW	B'00000001'	; .......*
	RETLW	B'00010001'	; ...*...*
CarG	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010011'	; ...*..**
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
CarQ	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010101'	; ...*.*.*
	RETLW	B'00010011'	; ...*..**
CarS	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010000'	; ...*....
	RETLW	B'00001110'	; ....***.
	RETLW	B'00000001'	; .......*
	RETLW	B'00010001'	; ...*...*
CarC	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010000'	; ...*....
	RETLW	B'00010001'	; ...*...*
CarI	equ	$-Tbase
	RETLW	B'00001110'	; ....***.
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00001110'	; ....***.
CarK	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010010'	; ...*..*.
	RETLW	B'00010100'	; ...*.*..
	RETLW	B'00011000'	; ...**...
	RETLW	B'00010100'	; ...*.*..
	RETLW	B'00010010'	; ...*..*.
CarM	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00011011'	; ...**.**
	RETLW	B'00010101'	; ...*.*.*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
CarN	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00011001'	; ...**..*
	RETLW	B'00010101'	; ...*.*.*
	RETLW	B'00010011'	; ...*..**
CarY	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00001010'	; ....*.*.
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
CarR	equ	$-Tbase
	RETLW	B'00011110'	; ...****.
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00011110'	; ...****.
CarV	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
CarX	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00001010'	; ....*.*.
	RETLW	B'00000100'	; .....*..
	RETLW	B'00001010'	; ....*.*.
CarW	equ	$-Tbase
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010001'	; ...*...*
	RETLW	B'00010101'	; ...*.*.*
	RETLW	B'00011011'	; ...**.**
	RETLW	B'00010001'	; ...*...*
CarZ	equ	$-Tbase
	RETLW	B'00011111'	; ...***** 
	RETLW	B'00000001'	; ...... *
	RETLW	B'00000010'	; ..... *.
	RETLW	B'00000100'	; .... *..
	RETLW	B'00001000'	; ....*...
	RETLW	B'00010000'	; ...*....
CarT	equ	$-Tbase
	RETLW	B'00011111'	; ...*****
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	RETLW	B'00000100'	; .....*..
	

INIT	CLRW
	MOVWF	LIGNE
	BSF	STATUS,RP0	; on adresse le bank 1 des registres
	MOVLW	B'10111'
	MOVWF	TrisA		; RA3 =S RA2=E RA1=E RA0=E
	MOVLW   B'11100000'	; RB7 et RB6 en entre, les autres en sortie
	MOVWF	TrisB
	BCF	Roption,7	; les entres avec pull-up
	BCF	STATUS,RP0	; on adresse le bank 0 pour la suite du programme
	CLRF	PTRTXT

;*****************************************************************************************
;*				PROGRAMME PRINCIPAL					 *
;*****************************************************************************************

MAIN	NOP
M2	BTFSC	ETRAME		; ETRAME  0 ?	
	GOTO 	M2		; non on boucle 	
M3	BTFSS	ETRAME		; ETRAME  1 ?
	GOTO	M3		; non on boucle
	BSF	SLIGNE		; arret Horloge
	BCF	SLIGNE		; marche horloge
	MOVLW	D'9'		; delai=30 microsecondes environ
	Delay3W			;
	INCF	Trames		; increment du compteur de trames
	BSF 	SLIGNE		; arret horloge
	
	BCF	 SLIGNE		; on met SLIGNE  0 en debut horloge point
	CALL	 PRETXT1
	BSF	 SLIGNE		;arret de l'horloge

	BCF	 SLIGNE		;on met SLIGNE  0 en debut horloge point
	CALL	 PRETXT2
	BSF	 SLIGNE

	BCF	 SLIGNE		;start
	CALL	 DLIGNE1	; LIGNES NOIRES1
	BSF	 SLIGNE		;stop

	BCF	 SLIGNE
	CALL	 DISTXT		; AFFICHAGE TEXTE
	BSF	 SLIGNE

;	BCF	 SLIGNE
;	CALL	 DLIGNE		; LIGNES NOIRES
;	BSF	 SLIGNE

	GOTO M2			; retour au debut (detection trame)

;*****************************************************************************************
;*		SOUS PROGRAMME DE COMPTAGE DES LIGNES NON AFFICHEES			 *
;*****************************************************************************************

DLIGNE1	BSF	SLIGNE		; stop
	DNOP
	BCF	SLIGNE		;on met SLIGNE  0 en debut horloge point
	INCF 	LIGNE
	DNOP
	DNOP
	MOVF	LIGNE,W
	ADDLW	-D'220'		; nombre de lignes avant l'affichage du texte
	SKIPCC			; rduire le "220" pour avoir le texte plus haut
	GOTO	DFIN
	GOTO    DLIGNE1		; non on retourne attente ligne
DFIN	CLRF	LIGNE		; raz du compteur de lignes
	RETURN

;*****************************************************************************************
;*			SOUS PROGRAMME D'AFFICHAGE DU TEXTE				 *
;*****************************************************************************************

DISTXT	BCF	SLIGNE		; 7 debut h	1
	CALL 	INCLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 7 debut h	1
	CALL 	INCLINE2
	BSF	SLIGNE		; stop	
	BCF	SLIGNE		; 1 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 2 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 3 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 4 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop

	BCF	SLIGNE		; 7 debut h	2
	CALL 	INCLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 7 debut h	2
	CALL 	INCLINE2
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 1 debut h	
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 2 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 3 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 4 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop

	BCF	SLIGNE		; 7 debut h	3
	CALL 	INCLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 7 debut h	3
	CALL 	INCLINE2
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 1 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 2 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 3 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 4 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop

	BCF	SLIGNE		; 7 debut h	4
	CALL 	INCLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 7 debut h	4
	CALL 	INCLINE2
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 1 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 2 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 3 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 4 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop

	BCF	SLIGNE		; 7 debut h	5
	CALL 	INCLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 7 debut h	5
	CALL 	INCLINE2
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 1 debut h	
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 2 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 3 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 4 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop

	BCF	SLIGNE		; 7 debut h	6
	CALL 	INCLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 7 debut h	6
	CALL 	INCLINE2
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 1 debut h	
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 2 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 3 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 4 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop


	BCF	SLIGNE		; 7 debut h	7
	CALL 	INCLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 7 debut h	7
	CALL 	INCLINE2
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 1 debut h	
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 2 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 3 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	BCF	SLIGNE		; 4 debut h
	CALL 	SHOWLINE
	BSF	SLIGNE		; stop
	RETURN			; 

;*****************************************************************************************
;*			SOUS PROGRAMME D'AFFICHAGE D'UNE LIGNE				 *
;*****************************************************************************************

SHOWLINE
 	MOVF	TNB1,W		; 1  ancien TNB (without plus one)
	ADDWF	CA0,W		; 2  Incline (suite)
	CALL 	Table		; 8  Calcul de Ta0, resultat dans W
	DNOP
	DNOP
	DNOP
	DNOP
	MOVWF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta1,W		;Carac 2
	MOVWF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta2,W		;Carac 3
	MOVWF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta3,W		;Carac 4
	MOVWF	PORTB 
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta4,W		;Carac 5
	MOVWF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta5,W		;Carac 6
	MOVWF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta6,W		;Carac 7
	MOVWF	PORTB  
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta7,W		;Carac 8
	MOVWF	PORTB  
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta8,W		;Carac 9
	MOVWF	PORTB  
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta9,W		;Carac 10
	MOVWF	PORTB  
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	MOVF	Ta10,W		;Carac 11
	MOVWF	PORTB  
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	RLF	PORTB
	CLRF	PORTB
	RETURN

INCLINE MOVF 	TNB,W		;
	MOVWF	TNB1	
	ADDWF	CA6,W		;  Addition de TNB au resultat
	CALL 	Table		;  Appel dela ligne line nombre NB
	MOVWF	Ta6		;  Table  TA0

	MOVF 	TNB,W	
	ADDWF	CA1,W
	CALL 	Table
	MOVWF	Ta1

	MOVF 	TNB,W	
	ADDWF	CA2,W
	CALL 	Table
	MOVWF	Ta2

	MOVF 	TNB,W	
	ADDWF	CA3,W
	CALL 	Table
	MOVWF	Ta3

	MOVF 	TNB,W	
	ADDWF	CA4,W	
	CALL 	Table
	MOVWF	Ta4

	RETURN


INCLINE2	MOVF 	TNB,W
	ADDWF	CA5,W
	CALL 	Table
	MOVWF	Ta5

	MOVF	TNB,W
	ADDWF	CA7,W 
	CALL 	Table
	MOVWF	Ta7

	MOVF	TNB,W
	ADDWF	CA8,W 
	CALL 	Table
	MOVWF	Ta8

	MOVF	TNB,W
	ADDWF	CA9,W 
	CALL 	Table
	MOVWF	Ta9

	MOVF	TNB,W
	ADDWF	CA10,W 
	CALL 	Table
	MOVWF	Ta10

	INCF	TNB		; On incremente le pointeur vertical
	RETURN			;

;*****************************************************************************************
;*		SOUS PROGRAMME DE PREPARATION D'AFFICHAGE	 			 *
;*****************************************************************************************

PRETXT1	BTFSC	INTER1		; test interrupteur RB5 si = 0  pas de scroll
	GOTO	PRS		; RB5=1 Scroll Texte1
	BTFSC	INTER2		; test interrupteur RB6 si = 0
	GOTO	PR3		; RB6=1
	BTFSC	INTER3		; test interrupteur RB7 si = 0  pas de scroll 
	GOTO	PR1		; RB7=1 Texte1 fixe
	GOTO	PR0		; RB7=0 Texte fixe (espaces sur l'ecran)

PRS	BTFSS	Trames,4	; Scrolling sur test de compteur trames
	GOTO	GT5		; on attend 
	INCF	PTRTXT		; scrolling on se deplace d'un cran	
	CLRF	Trames		; RAZ compteur de temps
	GOTO 	GT5
PR3	BTFSC	INTER3		; test interrupteur RB7 si = 0 Texte 2
	GOTO	PR2		; Texte2 fixe
	MOVLW	D'95'		; on pointe sur Texte3-1 fixe
	MOVWF	PTRTXT
	GOTO	GT5
PR2	MOVLW	D'79'		; on pointe sur Texte2-1 fixe
	MOVWF	PTRTXT
	GOTO	GT5
PR1	MOVLW 	D'63'		; on pointe sur Texte1-1 fixe		
	MOVWF	PTRTXT
	GOTO 	GT5
PR0	MOVLW	D'00'		; Texte fixe (rien sur l'ecran) on pointe sur texte
	MOVWF	PTRTXT	
GT5 	MOVLW   HIGH Texte	; 17	prepare to read the text page at 300
	MOVWF	PClath		; 18 	
	MOVF	PTRTXT,W	; 19	first caracter
	CALL	Texte		; 25
	MOVWF	CA0		; 26
	INCF	PTRTXT		; 27
	MOVF	PTRTXT,W	; 28	Second caracter
	CALL	Texte		; 34
	MOVWF	CA1		; 35
	INCF	PTRTXT		; 36
	MOVF	PTRTXT,W	; 37	3e caractre
	CALL	Texte		; 43
	MOVWF	CA2		; 44
	INCF	PTRTXT		; 45	
	MOVF	PTRTXT,W	; 46	4e caractre
	CALL	Texte		; 52
	MOVWF	CA3		; 53
	INCF	PTRTXT		; 54
	RETURN			; 55

PRETXT2 MOVF	PTRTXT,W	; 7	5e caractre
	CALL	Texte		;13
	MOVWF	CA4		;14

	INCF	PTRTXT		;15	
	MOVF	PTRTXT,W	;16	6e caractre
	CALL	Texte		;22
	MOVWF	CA5		;23 

	INCF	PTRTXT		;24	
	MOVF	PTRTXT,W	;25	7e caractre
	CALL	Texte		;31
	MOVWF	CA6		;32

	INCF	PTRTXT		;24	
	MOVF	PTRTXT,W	;25	8e caractre
	CALL	Texte		;31
	MOVWF	CA7		;32

	INCF	PTRTXT		;24	
	MOVF	PTRTXT,W	;25	9e caratre
	CALL	Texte		;31
	MOVWF	CA8		;32

	INCF	PTRTXT		;24	
	MOVF	PTRTXT,W	;25	10e caratre
	CALL	Texte		;31
	MOVWF	CA9		;32

	INCF	PTRTXT		;24	
	MOVF	PTRTXT,W	;25	11e caractre
	CALL	Texte		;31
	MOVWF	CA10		;32

	MOVLW	-D'10'		; 55   10 pour un dcalage de 11 caracteres
	ADDWF	PTRTXT		; 56   voila 
	MOVF	PTRTXT,W	; 57   
	ADDLW	-(FTexte-DTexte); 58  comparaison  la longueur du texte
	SKIPCC			; 59
	CLRF	PTRTXT		; 60 RAZ pointeur  la fin du scrolling
	CLRF 	PClath		; 61 RAZ PClath pour pouvoir lire table caracteres en page 0	
	CLRF	TNB		; 62 TNB initialisation
	RETURN			; 64

;*****************************************************************************************
;*				DONNEES DES TEXTES					 *
;*****************************************************************************************


	Org	300
Texte	ADDWF	PCL,F
DTexte	equ	$
	RETLW	SP	; 1  TEXTE LONGUEUR MAXIMALE= 55 (caracteres et espaces)
	RETLW	SP	; 2
	RETLW	SP	; 3
	RETLW	SP	; 4
	RETLW	SP
	RETLW	SP
	RETLW	SP
	RETLW	SP
	RETLW	SP
	RETLW	SP
	RETLW	SP	; 
	RETLW	SP	;  ** ne pas modifier les 11 premiers caracteres SP**
	RETLW	Car7	;   premier caractre du texte
	RETLW	Car3	; 
	RETLW	SP	; 
	RETLW	CarA	;
	RETLW	CarU	;
	RETLW	CarX	; 
	RETLW	SP	; 
	RETLW	CarL	;  
	RETLW	CarE	;
	RETLW	CarC	;    
	RETLW	CarT	;  
	RETLW	CarE	;
	RETLW	CarU	;
	RETLW	CarR	;
	RETLW	CarS	;
	RETLW	SP	;
	RETLW	CarD	;
	RETLW	CarE	;
	RETLW	SP	;
	RETLW	CarB	;
	RETLW	Car5	;
	RETLW	SP	;
	RETLW	CarP	;  
	RETLW	CarL	;
	RETLW	CarU	;
	RETLW	CarS	;
	RETLW	SP	; espaces necessaires  la fin du scrolling
	RETLW	SP	; pour reboucler correctement
	RETLW	SP	;
	RETLW	SP	;
	RETLW	SP	;
	RETLW	SP
	RETLW   SP
	RETLW	SP
	RETLW	SP
FTexte	equ	$-9	; necessaire au scroll car 11 caracteres sur l'ecran
	RETLW	SP

	ORG 	340	; TEXTE1 FIXE 63
	RETLW	SP	; 11 caracteres
	RETLW	CarA	 
	RETLW	CarN 
	RETLW	CarT 
	RETLW	CarA
	RETLW	SP
	RETLW	Car1
	RETLW	Car9  
	RETLW	Car9  
	RETLW	Car9
	RETLW	SP 

	ORG 	350	; TEXTE2 FIXE 79
	RETLW	SP
	RETLW	Car1	; 11 caracteres
	RETLW	Car2
	RETLW	Car5
	RETLW	Car5
	RETLW	SP	 
	RETLW	CarM 
	RETLW	CarH
	RETLW	CarZ 
	RETLW	SP
	RETLW	SP

	ORG 	360	; TEXTE3 FIXE 95
	RETLW	CarS	; 11 caracteres
	RETLW	Car0	 
	RETLW	CarN
	RETLW	SP
	RETLW	Car1
	RETLW	Car4
	RETLW	Car4
	RETLW	Car.  
	RETLW	Car1  
	RETLW	Car9
	RETLW	Car0 

	END
