<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<!-- saved from url=(0038)http://www.von-info.ch/PIC/mir_v05.asm -->
<HTML><HEAD>
<META http-equiv=Content-Type content="text/html; charset=windows-1252">
<META content="MSHTML 5.50.4134.600" name=GENERATOR></HEAD>
<BODY><XMP>_NextPart_000_005B_01BE4A00.C87440F0
Content-Type: application/octet-stream;
	name="mono_v05.asm"
Content-Transfer-Encoding: quoted-printable
Content-Disposition: attachment;
	filename="mono_v05.asm"

;
;           ___  MONOSCOPIC_COLO  ___
;
;
;
;              ***************
;              *  T E X T    	  *   Testo scorrevole max 51 caratteri
;              *             	  *
;              *   barre     	  *   Barre dei grigi/colore
;              *             	  *
;              *   12:00     	  *   (scritta fissa 9 Caratteri o orologio)
;              ***************
;
; Lo spunto  stato preso dal programma PICDREAM realizzato da
; Alain FORT e da Peter KNIGHT, mantenendo la struttura di base
; del programma ho elaborato le seguenti modifiche
;
;
; Le varianti al programma originale sono:
;	A) la scritta scorrevole e fissa in alternativa all'orologio,
;          	     resa programmabile da pulsanti senza dover riprogrammare
;          	     la PIC
;       	B) scorrimento della scritta a carattere o pixel con velocit
;          	     variabile impostata dai pulsanti
;	C) caratteri pi piccoli (met) con aumento dei caratteri
;	     sullo schermo possibile solo con Quarzo a 8Mhz e PIC a 10Mhz
;	D) scritte con sfondo o colore scelto e impostato tramite
;          	     i pulsanti
;       	E) Tono in uscita Pin 3 del PIC a 244 Hz o bitonale 244 / 488
;          	     scelto con i pulsanti
;
; REQUISITI HW rispetto originale
;
;       	A) PIC 16C84 o 16F84 a 10 Mhz
;       	B) Quarzo 8 Mhz come clock alla PIC
;       	C) Aggiunta di un interruttore al pin 11 verso massa
;	E) modifica al circuito di reset per non alterare il contenuto
;          	     nella eeprom durante accensione e spegnimento.
;
;	X) Per ottenere il colore e stato utilizzato un encoder RGB
;	     della SONY CXA1645P oltre ad un oscillatore realizzato con
;	     una 74A04 o 74HC04 e un quarzo f=4.433619 MHz.
;
;  NOTA: Lo stesso programma funziona per la versione bianco/nero,
;        	   o a colori
;
;
;  	  7351
;
;	 IW2KGH
;              Salvatore Pagnoncelli
;             Via Chiusa 18
;             24040 Bottanuco BERGAMO
;                         (ITALY)
;
;	Email:  salvatore.pagnoncelli@tlt.alcatel.it
;
;************************************************************************
;
; Release SW:
;   V_01 ___ date  01/02/98
;
;         _beta release
;               
;   V_02 ___ date  01/04/98
;
;            _Corretto errore, non si riusciva a modificare la
;        	  scritta scorrevole nelle prime e ultime posizioni
;        **_Variato numero caratteri memorizzabili da 45 a 51
;        **_Toglie e mette sfondo sotto le scritte con pulsanti
;
;   V_03 ____ date 22/04/98
;
;           _Corretto errore, non si attendeva il tempo sufficiente per la
; 	scrittura in EEPROM, e quindi non memorizzava i dati di utente
;          	Il difetto non si presenta su tutti i PIC. ( BUG di programma )
;          _Aumentato il tempo sincronismo di riga da 2,5 a 4,5 micro sec
;
;   V_04 ____ date 15/6/98
;
;          	_Modificato programma per partenza con interruttore scrittura
;          	  chiuso a massa, ora parte con scritta piegata quindi ci si
;          	  accorge il sistema prima non partiva, buio sul video          
;          	_Corretto errore del punto in prima posizione della scritta fissa
;          	  il sistema si blocca e occorre riprogrammare il PIC
;      **	_Programmazione sfondo delle scritte tramite pulsanti indipendente
;         	  per scritta scorrevole e fissa
;      **	_Sull'uscita pin 3 del PIC =E8 presente una nota a 240 Hz circa onda
;         	  quadra a 4,5 Volt, attenuata si pu usare come audio per il TX
;
;   V_05 ____ date 18/10/98
;
;	_Modificato il programma per inizializzare la EEPROM in caso di...
;	 
;
;*****************************************************************************
;*****************************************************************************

	TITLE   "MONOPIC_COLO"  ;PICDREAM modificato da IW2KGH Salvatore

	list p=16C84,  f=inhx32			;Enter device name
	__config 0x3FF2  			;configurazione (fuse_off )

#Define W      0
#Define F       1
#define Sync    PortA,0         			; Sincronismo video uscita RA0  (PIN 17)
#define Audio   PortA,4         			; Sincronismo video uscita RA4  (PIN 3)


LUNCAR	EQU	D'9'			;
ULTICAR	EQU	D'62'-LUNCAR		;Ultimo carattere del circolare

PRIMCIR	EQU	D'0'			; Primo carattere della scritta circolare
ULTICIR	EQU	D'52'			; Ultimo carattere della scritta circolare
PRIMFIS	EQU	D'53'			; Primo carattere della scritta fissa
ULTIFIS	EQU	D'61'			; Ultimo carattere della scritta fissa

CELLSP	EQU	D'0'			;cella da sporcare in caso di :::::
;

	cblock  0x00
		INDF,RTCC,PCL,Status,FSR,PortA,PortB
	endc
	cblock  0x08
		EEData,EEAdr,PClath,IntCon
	endc
	cblock  0x08
		EECON1,EECON2,PClath,IntCon
	endc
	cblock  0x00
		C,DC,Z,PD,TO,RP0,RP1,IRP
	endc

	cblock  0x00
		RD,WR,WREN,WRERR,EEI
	endc

; Page 1 registers
TRISA	EQU	05H
PORTA	EQU	05H
Roption EQU  	01H
Timer0	EQU	01H
Intcon	EQU	0BH
TrisA   	EQU      05H
TrisB   	EQU      06H
RAMbase EQU   0CH


; DNOP - doppia NOP. Delay di 2 cycles,

DNOP    MACRO
	LOCAL   Label
Label   GOTO    Label+1
	ENDM

SKIPNC  MACRO
	BTFSC   Status,C

	ENDM
SKIPSC  MACRO
	BTFSS   Status,C
	ENDM

SKIPNZ  MACRO
	BTFSC   Status,Z
	ENDM

SKIPSZ  MACRO
	BTFSS   Status,Z
	ENDM
	LIST

	CBLOCK  RAMbase                                 			;36 celle
		TIME,CNT_0					;2	2
		Count2,Count3,SubSec       			;3	5  
	        	HrT,HrU,MiT,MiU,SeU				;5	10
		CA0,CA1,CA2,CA3,CA4,CA5,CA6,CA7,CA8	;9	19
		Ta0,Ta1,Ta2,Ta3,Ta4,Ta5,Ta6,Ta7,Ta8		;9	28
		Ptrtxt,CNT_1,CNT_R                              		;3	31
		CNTCA,TABCA,STATO,DISPE,PUNCA		;5	36
;
;celle ram aggiuntive per micro 16F84
;ora non necessarie

	ENDC                                          		;
;
;TIME     	cella utilizzata dal delay (nel ciclo)
;CNT_0    	utilizzato chiamate per sapere quante righe video fare e altro 
;Count2   	Contatore di quadri per azione con pulsanti (riservata )
;Count3   	Contatore per velocit di scorrimento
;SubSec   	utilizzata per semiquadri a/b e orologio 1sec
;
;Ptrtxt  punt. 	al primo carattere per display scritta scorrevole e no
;CNT_1   	numero di linee che definiscono il punto carattere (DISPLAY) 
;CNT_R   	numero di riga del carattere in display (DISPLAY)
;CNTCA   	puntatore carattere circolare durante memorizzazione (stato0 e 1)
;TABCA   	carattere da memorizzate convertito ascii_tab
;STATO   	stato per sapere quale comando devo eseguire
;DISPE     	tipo di display a salti o punti e velocit da sommare
;PUNCA   	punt. carattere scritta fissa durante memorizzazione frase
;
;*********************************************************************
;  EEPROM
;********************************************************************* 
	ORG     2100
;scritta scorrevole (il primo CarSP va lasciato )
;
;frase: " SORRY FOR BUGS IN VXX : GOOD LUCK WITH THIS V05  BY"
;
	DT      CarDP,CarS,CarO,CarR,CarR,CarY,CarSP,CarF		;8
	DT      CarO,CarR,CarSP,CarB,CarU,CarG,CarS,CarSP		;8 16
	DT      CarI,CarN,CarSP,CarV,CarX,CarX,CarSP,CarDP      	;8 24
	DT      CarSP,CarG,CarO,CarO,CarD,CarSP,CarL,CarU       	;8 32
	DT      CarC,CarK,CarSP,CarW,CarI,CarT,CarH,CarSP		;8 40
	DT      CarT,CarH,CarI,CarS,CarSP,CarV,Car0,Car5		;8 48 
	DT      CarSP,CarSP,CarB,CarY,CarFI		        		;5 53

;scritta fissa
;
	DT      CarSP,CarSP,CarI,CarW,Car2,CarK,CarG,CarH,CarSP	;9 62

;Dati di gestione per il programma non modificare
;
	DE      42,0EC                                           				;2 64
;******************************************************************
;
;
;COLORE:cella 62 EEPROM 'XXXX XXXX'
;                             ||||___ 		Colore di sfondo sopra
;                        ||||________	Colore di fondo sotto
;
;MODI: 	cella 63 EEPROM 'XXXX XXXX'
;                        |||| ||||___ 		Velocit di scorrimento
;                        ||||________
;                        |||_________ 	Tono:  1=singolo    0=bitonale
;                        ||__________ 	Fondo: 1=alternanza 0=fissa 
;                        |___________	Fondo: 1=orologio   0=fissa
;*********************************************************************
;       START  del programma
;*********************************************************************

	ORG     0
	GOTO    INIZIO

	ORG     4
	RETURN
;*********************************************************************
;       TABELLA definizione matrice dei caratteri
;********************************************************************* 
;
; Table of caracters
Table	ADDWF	CNT_R,W	;
	ADDWF	PCL,F		;
Tbase   equ     $
Car0    equ     $-Tbase
CarO    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car1    equ     $-Tbase
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001110'     ; ....***.
Car2    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00011111'     ; ...*****
Car3    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ;....*...*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000110'     ; .....**.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car4    equ     $-Tbase
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000110'     ; .....**.
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
Car5    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car6    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car7    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
Car8    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car9    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001111'     ; ....****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
CarSP   equ     $-Tbase
	RETLW   B'00000000'     ; ........
CarFI   equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
CarDP   equ     $-Tbase=20
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
CarA    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011111'     ; ...*****
CarH    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011111'     ; ...*****
CarU    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ;.....***.
CarD    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarB    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarP    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
CarL    equ     $-Tbase
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarE    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00011100'     ; ...***..
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarF    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00011100'     ; ...***..
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarJ    equ     $-Tbase
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
CarG    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010011'     ; ...*..**
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarQ    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010011'     ; ...*..**
CarS    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
CarC    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010001'     ; ...*...*
CarI    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001110'     ; ....***.
CarK    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00011000'     ; ...**...
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00010010'     ; ...*..*.
CarM    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011011'     ; ...**.**
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarN    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010011'     ; ...*..**
CarY    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
CarR    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00010001'     ; ...*...*
CarV    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarX    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001010'     ; ....*.*.
CarW    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00011011'     ; ...**.**
	RETLW   B'00010001'     ; ...*...*
CarZ    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000001'     ; ...... *
	RETLW   B'00000010'     ; ..... *.
	RETLW   B'00000100'     ; .... *..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00010000'     ; ...*....
CarT    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
CarBL   equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****

;*********************************************************************
;    inizio del programma e settaggio del PIC e EEPROM         
;*********************************************************************

WEEINI	CALL	MEMEEP	;*
	MOVLW	D'254'		;*254     Ritardo per poter scrivere
	MOVWF	CNT_0		;*          la EEPROM a bordo del PIC
	CALL	BLKLINE		;*          	nessuna operazione su EEPROM
	RETURN		 	;*           per almeno 14 millisecondi

INIZIO
	BSF     Status,RP0      		; 	select bank 1

	MOVLW	B'00000000'	; 	Protezione per scrittura in
	MOVWF	EECON1	; 	EEPROM all'accensione
	BCF     EECON1,WREN     	; 	 ( spero & spero )
	MOVWF	EECON2	;

	MOVLW   B'01110'		; 	Port_A  0=outputs  1=inputs
	MOVWF   TrisA			;
;	MOVLW	B'00000000'	; 	serve per testare con MPLAB
	MOVLW   B'11100000'		;	 Port_B  0=outputs  1=inputs
	MOVWF   TrisB           		;
	MOVLW   B'00000011'		;	pull up on, interup \_
					;	internal clok, inc rb4  _/
	MOVWF 	Roption		;	prescaler TMR0 / 2
	BCF     Status,RP0      		; 	select bank 0

;?????????????????????????????????????????????????????????????????
;
INSEPROVE	

;????????????????????????????????????????????????????????????????

	MOVLW   D'255'          		;*
	MOVWF	CNT_0		;*	solo ritardo iniziale
	CALL    BLKLINE		;*

	MOVF    PortB,W         		;* 
	ANDLW   B'11000000'     	;*    	pulsanti entrambi pigiati 
	SKIPSZ                  		;*
	GOTO    INIZ1           		;*   	se si inizzializzo la EEPROM

	BTFSS   PortB,5         		;   	in funzione dell'interruttore WR
	GOTO	RESET2

	MOVLW	CarX		;*
	MOVWF   EEData          		;*
	CLRF    EEAdr           		;*   	scrivo delle X in tutta la EEPROM 
INIEE	CALL	WEEINI		;*
	INCF	EEAdr,1		;*
	BTFSS	EEAdr,6		;*
	GOTO	INIEE			;*

	MOVLW	D'4'		;
	MOVWF	EEAdr		;
	MOVLW	CarSP		;
	MOVWF	EEData		;
	CALL	WEEINI		;
	INCF	EEAdr,1		;*
	MOVLW	CarV		;
	MOVWF	EEData		;
	CALL	WEEINI		;
	INCF	EEAdr,1		;*
	MOVLW	Car0		;
	MOVWF	EEData		;
	CALL	WEEINI		;
	INCF	EEAdr,1		;*
	MOVLW	Car5		;  	Versione 5
	MOVWF	EEData		;
	CALL	WEEINI		;
	INCF	EEAdr,1		;*
	MOVLW	CarFI		;*	metto punto di ripetizione
	MOVWF	EEData		;*	circolare alla scritta
	CALL	WEEINI		;*

RESET2
	MOVLW	D'62'		;
	MOVWF	EEAdr		;*   	sistemo cella di servizio
	MOVLW	042		;*
	MOVWF	EEData		;*
	CALL	WEEINI		;*

	INCF	EEAdr,1		;*
	MOVLW	0EC		;*	sistemo cella di servizio
	MOVWF	EEData		;*
	CALL	WEEINI		;*

	INCF	EEAdr,1		;*
	MOVLW	CarDP		;*	sistemo 1 cella della scorrevole
	MOVWF	EEData		;*
	CALL	WEEINI		;*

INIZ1	CLRF    SeU	 		; 	azzero clock a 00.00
	CLRF    MiU			;
	CLRF    MiT			;
	CLRF    HrU			;
	CLRF    HrT			;
	CLRF	Ptrtxt			; 	puntatore frase scorrevole
	CLRF    Count3			;
	CLRF    DISPE			;
	CLRF	STATO			;
	BSF	STATO,4		;
	MOVLW	CELLSP	;
	MOVWF	EEAdr		;
;*********************************************************************
;   Programma principale o loop main        
;*********************************************************************

FRAME					;
	CALL	EQUALIZ		;	totale 7,5 linee

;*****  BLACK LINES   ************ 	line 0 (+35)=35

	MOVLW   D'35'           		; 1
	MOVWF	CNT_0		; 2
	CALL    BLKLINE		;128

;**** INIT TEXTE     *************** 	line 35(+3)=38

	Call    PREREAD		;3

;****  PULSANTI    **************** 	line 38(+1)=39

	Call    PULSANTI		;1

;**** DISPLAY TEXTE ************ 	line 39 (+35)=75

	MOVLW	B'00000000' 	;1  0xxxxxx1= scorrevole e sopra
	MOVWF	DISPE		;2
	CALL    DISPLAY         		;4	128

;**** BLACK LINES ***************	 line 75 (+15)= 90

	MOVLW   D'15'           		; 1
	MOVWF	CNT_0		; 2
	CALL    BLKLINE		; 128

;***** GREY BARS **************** 	line 90 (+120)=210

	MOVLW   D'120'          		;1
	MOVWF   CNT_0		;2
	CALL BARRE              		;128

;**** BLACK LINES   **************	 line 210 (+14)=224

	MOVLW   D'14'           		; 1
	MOVWF	CNT_0		; 2
	CALL    BLKLINE		;128

;***** PREPARE CLOCK ***********	 line 224 (+3)=227

	CALL    PREPH           		;3

;**** DISPLAY CLOCK 57 line  **** *	line 227 (+36)=263

	MOVLW	B'11000001'	;1   1xxxxxx1=fissa  fondo
	MOVWF	DISPE		;
	CALL    DISPLAY		;1	128

;***** INCREMENT TIME **********	 line 263 (+1)=264

INCTIM	CALL    INCTIME         	;2	128

; ***** BLACK LINES ************* 	line 264 (+41)=305

	MOVLW   D'41'           		; 1
	MOVWF	CNT_0		; 2
	CALL    BLKLINE		;128

	GOTO	FRAME			;RITORNO A CAPO

;************************************************************
;************************************************************
;     Equalizzazione 7,5 + 305 visible Lines =312,5 *2 =625
;   inserisce linee per l'interlacciamento
;   e ritorno a capo del video secondo norme CCIR/PAL
;************************************************************
;
EQUALIZ
	CALL	SINCK			;14     18
	MOVLW   4               		;1
	BTFSS   SubSec,0        		;1-2
	MOVLW   5               		;1
	MOVWF   CNT_0           		;1     22

Loop1   CALL	RIT_46			;46   68  (64  4)
	CALL	SINCK			;14   18
	NOP				;1
	DECFSZ  CNT_0,1         		;1-2
	GOTO    Loop1           		;2     22


	CALL	RIT_48			;48   69   (64 5 )
	NOP				;1     6

; 5 mezze righe per Equalizzazione

	BCF     Sync            		;1   7   ;30us Sync
	CALL	AUDIO			;8

	MOVLW   4               		;16    
	MOVWF   CNT_0           		;17
 
Loop2
	CALL	RIT_48			;48  65  
	BSF     Sync            		;1    66  ;2us Nero
	CALL	AUDIO			;8
	BCF     Sync            		;1    7   	;30us Sync
	DNOP		        		;2    9 
	NOP				;1    10
	DECFSZ CNT_0,1          		;  -  
	GOTO    Loop2           		;13

	CALL	RIT_48			;52   64
	NOP                     		;1
	BSF     Sync            		;2          ;2us Nero

; 5 o 4 mezze righe di equalizzazione per interlacciare

	CALL	DSINCK		;16   20
	MOVLW   4               		;1
	BTFSC   SubSec,0        		;1-2
	MOVLW   3               		;1
	MOVWF   CNT_0           		;1     22

Loop3   CALL	RIT_46			;46   68  (64  4 )
	CALL	SINCK			;14   18
	NOP				;1
	DECFSZ  CNT_0,1         		;1-2
	GOTO    Loop3           		;2    22
		
	MOVLW	D'12'		;	ritardo
	CALL	RIT_P0			;41  62

	RETURN			;2    64

;************************************************************
;    routines di ritardo ( delay )
; es: RIT_51 = ritardo di 51 Time inclusi chiamata e ritorno
;************************************************************
;
RIT_48	DNOP				;
RIT_46	MOVLW	D'13'		;
	GOTO	RIT_P0			;

RIT_P2	NOP				;
RIT_P1	NOP				;
RIT_P0	MOVWF	TIME		; 	ritardo  2  + 3*W + 2
RITAY	DECFSZ	TIME,1		;         	call      return
	GOTO	RITAY			;
	RETURN			;

RIT_8	NOP
RIT_7	NOP				;
RIT_6	NOP				;
RIT_5   NOP				;
RIT_4   RETURN			;

DSINCK	DNOP			;2
SINCK	BCF	Sync			;1   	Genera inpulso di sincronismo
	CALL	AUDIO			;6 
	BSF	Sync			;1   	toglie sinc
	RETURN			;2  (12) -(14)

AUDIO
	BTFSC	Timer0,7		;
	BSF	PORTA,4		;
	BTFSS	Timer0,7		;	per 9 time= 4,5 micro_secondi
	BCF	PORTA,4		;
	RETURN			;

;***************************************************************
; 	Righe nere sul televisore
;  il numero di righe  definito in  CNT_0 prima della chiamata
;***************************************************************
;
BLKLI_0
	CALL	RIT_5			;5   1 4
BLKLINE	CALL	SINCK		;14  18   impulso di sincronismo

	MOVLW	D'33'		;           	ritardo
	CALL	RIT_P2			;106  124

	DECFSZ	CNT_0,1	;1-2  125  126
	GOTO	BLKLI_0		;2     127   -

	RETURN			;2     128

;*****************************************************************
;       BARRE:  dei grigi in verticale sul video
;  il numero di righe utilizzato per le barre e definito in CNT_0
;*****************************************************************

BARRE_0	CALL	RIT_5		;5  1-4
BARRE	CALL	SINCK			;14  18

	MOVLW	D'2'		;         	ritardo
	CALL	RIT_P1			;9  27

	MOVLW	D'7'		;1      	numero di barre
	MOVWF	CNT_1		;1      	in CNT_1
	MOVLW	D'15'		;1      	pongo in uscita il valore 15
	IORWF	PORTA,1		;1
	MOVLW	B'00000'	;1      	Port_A definisco gli
	TRIS	PORTA			;1      	output per i grigi
	DNOP				;2   35

BARRE_1	CALL	RIT_6		;6      	genero le barre partendo dal
	MOVLW	-D'2'		;1      	bianco (parto 15 e sommo -2 )
	ADDWF	PORTA,1	;1
	DECFSZ	CNT_1,1	;1-2
	GOTO	BARRE_1		;2
	CALL	RIT_7			;
	MOVLW	B'01110'	;1   123
	TRIS	PORTA			;1   124
	NOP				;
	DECFSZ	CNT_0,1	;1-2 125
	GOTO	BARRE_0		;2   127
	RETURN			;2   128

;*****************************************************************
;	DISPLAY: mette sul video i caratteri prendendoli
;                dalla EEPROM
;*****************************************************************
DISPLAY	CALL	SINCK 		;14  18
	MOVLW	D'7'		;        	Numero di punti per carattere
	MOVWF	CNT_0		;        	metto in CNT_0
	MOVLW	H'0FF'		;        	numero di linea del carattere
	MOVWF	CNT_R		;22  	in display

	MOVLW   D'63'           		;1 
	CALL    EEREADW         	;9   32 	leggo parola di controllo da
	BTFSS	EEData,3		;1      	se devo scorrere a salti o
	BSF	DISPE,7		;1   34 	a pixel

	MOVLW   D'62'           		;1   35
	CALL    EEREADW         	;9   44 	leggo la parola di controllo da

	BTFSS	DISPE,0		;1      	testo se scritta sopra o sotto
	SWAPF	EEData,1		;1      	per eseguire swap
	RLF	EEData,W		;1      	i bit di colore e li pongo
	ANDLW	B'00001111'	;1      	in dispe
	IORWF	DISPE,1		;1   49

	RLF	Count3,W		;1
	ANDLW	B'11110000'	;1
	BTFSS	DISPE,7		;1
	IORWF	DISPE,1		;1   53

	MOVLW	CELLSP	; zzz
	MOVWF	EEAdr		;

	MOVLW	D'22'		;       	ritardo
	CALL	RIT_P1			;72 127
			
INCLIN
	MOVLW	D'4'		;      128
	MOVWF	CNT_1		;1		linee per punto
	INCF    CNT_R,1         		;1    2		inc riga per prossimo giro
	CALL	DSINCK		;16  18

	MOVF    CA0,W           		;1  		Prendo Il carattere lo sommo alla
	CALL    Table           		;7 		riga e vado a prendere il segmento
	MOVWF   Ta0             		;1    27		equivalente lo metto in ram

	MOVF    CA1,W           		;1
	CALL    Table           		;7
	MOVWF   Ta1             		;1   36

	MOVF    CA2,W           		;1
	CALL    Table           		;7
	MOVWF   Ta2             		;1   45

	MOVF    CA3,W           		;1
	CALL    Table           		;7
	MOVWF   Ta3             		;1  54

	MOVF    CA4,W           		;1
	CALL    Table           		;7
	MOVWF   Ta4             		;1  63

	MOVF    CA5,W           		;1
	CALL    Table           		;7
	MOVWF   Ta5             		;1  72

	MOVF    CA6,W           		;1
	CALL	Table			;7
	MOVWF   Ta6             		;1  81

	MOVF    CA7,W           		;1
	CALL	Table			;7
	MOVWF   Ta7             		;1  90

	MOVF    CA8,W           		;1
	CALL	Table			;7
	MOVWF   Ta8             		;1  99

	MOVLW	D'7'		;       	ritardo
	CALL	RIT_P0			;26 125

SLINE
	CALL	RIT_7			;7  128 4
	CALL	SINCK			;14  18

	CALL	RIT_7			;7  25
	CALL	RIT_5			;5  30

	MOVF	DISPE,W		;1
	ANDLW	B'00001110'	;1
	IORWF	PORTA,1		;1

	MOVLW	B'00000'	;1        	in funzione bit x di EEData
	BTFSS	EEData,3		;1        	i bit di port_A output
	TRIS	PORTA			;1  36    o li lascio come input

	BTFSS	DISPE,6		;  |
	CALL	RIT_5			;   |
	BTFSC	DISPE,5		;    |   	in testa e in coda
	GOTO	RITCAR1		;     | 	per lo scorrimento a pixel
	DNOP				;      )	due volte vale 17
	NOP				;     |
RITCAR1	BTFSS	DISPE,4	;    |
	DNOP				;   |  ES ( 10+7 )
					;46

 	MOVF    Ta0,W           		;1	Carac 1
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1 7

	MOVF    Ta1,W           		;1	Carac 2
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1  7

	MOVF    Ta2,W           		;1	Carac 3
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1  7

	MOVF    Ta3,W           		;1	Carac 4
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1  7

	MOVF    Ta4,W           		;1	Carac 5
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1  7

	MOVF    Ta5,W           		;1	Carac 6
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1  7

	MOVF    Ta6,W           		;1	Carac 7
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1  7

	MOVF    Ta7,W           		;1	Carac 8
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1  7

	MOVF    Ta8,W           		;1	Carac 9
	MOVWF   PortB           		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	RLF     PortB,1         		;1
	CLRF    PortB           		;1 109

	BTFSC	DISPE,6		;     |
	CALL	RIT_5			;      |
	BTFSS	DISPE,5		;       |   	 in testa e in coda
	GOTO	RITCAR2		;        |  	per lo scorrimento a pixel
	DNOP				;         ) 	due volte vale 21
	NOP				;        |
RITCAR2	BTFSC	DISPE,4	;       |
	DNOP				;11  |  	ES ( 10+11 )
					;120
	MOVLW	B'01110'	;1  121	pongo i bit di port_A come input
	TRIS	PORTA			;1  122	quelli barra dei grigi

	DECFSZ  CNT_1,1		;1-2  123  124
	GOTO    SLINE			;2     125     
	DECFSZ  CNT_0,1		;1-2  125  126
	GOTO    INCLIN		;2     127
 	RETURN                  		;2     128

;*********************************************************************
;       PULSANTI: lettura dei comandi eseguiti tramite pulsanti
;         STATO_0  set orologio e set scritta / orologio
;         STATO_1  modifica della scritta scorrevole
;         STATO_2  modifica della scritta fissa
;         STATO_3  cambio velocit di scorrimento scritta
;         STATO_4 
;*********************************************************************
;
PULSANTI
	CALL	DSINCK		;18

	BTFSC   PortB,5         		;1       	in funzione dell'interruttore WR
	CLRF	STATO			;1       	Impongo lo stato da eseguire
	BTFSS   PortB,5         		;1
	BSF	STATO,1		;1
	BSF	STATO,0		;1  23

	MOVLW	D'63'		;1      	leggo cella per determinare
	CALL	EEREADW		;9  33  	se orologio o scritta
		
	DNOP				;35
	DNOP				;37

	BTFSC	STATO,4		;1  	partenza con interruttore
	GOTO	STATO_4		;2  40	di WR inserito

	BTFSC   STATO,3         		;1       	verifico in che stato sono
	GOTO    STATO_3         		;2  42   	vado velocit E tono

	BTFSC   STATO,2         		;1       	verifico in che stato sono
	GOTO    STATO_2         		;2  44   	cambio scritta fissa

	BTFSC   STATO,1         		;1       	verifico in che stato sono
	GOTO    STATO_1         		;2  46   	cambio scritta scorrevole

	NOP				;1
	GOTO	STATO_0		;2  48

;*********************************************************************
;	STATO 0    scelta X display    ora/scritta/alternanza
;*********************************************************************
;
STATO_4				;40	partenza con scritta
	CALL	RIT_6			;6  46	inclinata causa WR

STATO_0				;48
	CALL	TASTO_P		;14     	 tasto premuto
	SKIPSZ                  		;1     
	GOTO    PULFIN          		;65  	se no salto il set ora

	MOVF    PortB,W         		;1      	verifico se pulsanti entrambi
	ANDLW   B'11000000'     	;1      	premuti se si vado in STATME
	SKIPNZ                  		;1
	GOTO    STATO_9         		;2  69  	se si salto a memorizzazione

	BTFSC	EEData,6		;1  69    	se  alternanza ora/scritta
	BCF	EEData,7		;1        	pongo scritta
	BTFSC	EEData,7		;1        	cambio colore di fondo
	GOTO	STATO_7		;2  73    	in STATO8
	GOTO	STATO_8		;2  74

;*********************************************************************
;
PULFIN					;65
	CLRF    STATO           		;
	CLRF    CNTCA           		;
	CLRF    PUNCA           		;68

	MOVLW	D'17'		;
	CALL	RIT_P2			;58 126	ritardo per sincronizzare
	RETURN			;2  128

;*********************************************************************
;
STATO_7				;73
	BTFSC   PortB,6         		;       	set minuti se premuto
	INCF    MiU,1           		;
	BTFSC   PortB,7         		;       	set ore se premuto
	INCF    HrU,1           		;
	CLRF    SeU             		;79

	MOVLW   D'82'           		;       	tempo di attesa per
	BTFSC	Count2,6		;
	MOVWF   Count2          		;82  	prossimo incremento

	MOVLW	D'13'		;        	ritardo
	CALL	RIT_P0			;44 126
	RETURN			;2  128

;*********************************************************************
;
STATO_8				;74
	MOVLW	D'62'		;1      	leggo cella per determinare
	CALL	EEREADW		;9  84  	il colore di fondo
	BTFSC   PortB,7         		;1
	SWAPF	EEData,1		;1
	BCF	EEData,3		;1
	INCF	EEData,1		;1
	BTFSC	PortB,7			;1
	SWAPF	EEData,1		;1   90
	CALL	MEMEEP		;12  102

	MOVLW	D'6'		;
	CALL	RIT_P1			;24 126
	GOTO    FINATT          		;2  128

;*********************************************************************
;
STATO_9  				;69 
	MOVLW   B'10000000'     	;1       	scelta se visualizzare
	BCF	EEData,6		;1       	testo o orologio e azzero  
	XORWF	EEData,1	;1       	alternanza

	BTFSC	Count2,6		;1  73     verifico se e giro di OLD
	BSF	EEData,6		;1 

	CALL    MEMEEP          		;12 86	MEMORIZZA

	MOVLW	D'11'		;
	CALL	RIT_P2			;40 126
	GOTO    FINATT          		;2  128

;*********************************************************************
;STATO_X   ( per stato 1-2 ) cambio scritta scorrevole e fissa
;*********************************************************************
;
STATO_2				;44
	MOVLW   PRIMFIS		;1 	carattere scritta fissa
	MOVWF   Ptrtxt          		;

STATO_1				;46
	CLRF    Count3          		;1      	blocco la scritta scorrevole

	MOVLW	D'8'		;1
	BTFSS	STATO,2		;1	stato diverso da 2 PUNCA = 0
	MOVWF	PUNCA		;1  50

	CALL	TASTO_P		;14 64  	 tasto premuto
	SKIPSZ                  		;1    
	GOTO    STAT1_A1        	;67  	se no salto

	MOVF    PortB,W         		; 
	ANDLW   B'11000000'     	;      	 pulsanti entrambi pigiati  
	SKIPNZ                  		;
	GOTO    STORCAR         	;71  	se si salto a memorizzazione

	CALL	SCELTA_CA		;20 90  	rit con carattere in TABCA

STAT1_A2
	CALL CONVER             		;15 105

	MOVLW	H'16'		;1	preparo il puntatore alla
	ADDWF	PUNCA,W	;1  107	cella per display

	MOVWF   FSR             		;1	punto alla tabella display
	MOVF    TABCA,W         	;1	e metto il nuovo carattere
	MOVWF   INDF            		;1  110

	MOVLW	D'3'		;
	CALL	RIT_P2			;16	ritardo
	RETURN			;2  128

STAT1_A1				;
	MOVLW	D'5'		;
	CALL	RIT_P1			;21
	GOTO	STAT1_A2		;2  90

;*********************************************************************
;         Memorizzazione e cambio stato
;*********************************************************************
;
STORCAR				;71
	MOVF    Ptrtxt,W        		;1  72
	ADDWF   PUNCA,W         	;1      	memorizzazione del puntatore
	MOVWF   EEAdr           		;1      	tabella caratteri in eeprom

	XORLW	D'61'		;1  75	ultima cella di scrittura

	SKIPSZ                  		;1  76  	se non  ultima cella
	INCF    Ptrtxt,1        		;1        	incremento il puntatore Ptrtxt
	SKIPSZ				;1        	e il PUNCA
	INCF	PUNCA,1		;1
	CLRF    CNTCA           		;1  80  	azzero carattere

	MOVF    TABCA,W         	;1
	MOVWF   EEData          		;1
	XORLW   CarBL           		;1  83  

	SKIPNZ				;1	verifico se  il BLOC se si
	CLRF	PUNCA			;1	azzero PUNCA
	SKIPNZ                  		;1  
	RLF	STATO,1         		;1   	cambio stato e non memorizzo
	SKIPSZ				;1   88
	CALL    MEMEEP          		;12 100  

	MOVLW	D'7'		;       	ritardo sincronizzazione riga
	CALL	RIT_P2			;28 128

FINATT
	MOVLW	D'224'		;224	Ritardo per poter scrivere
	MOVWF	CNT_0		;           	la EEPROM a bordo del PIC
	CALL	BLKLINE		;           	nessuna operazione su EEPROM
	GOTO	INCTIM		;           	per almeno 14 milli secondi

;*********************************************************************
;   STATO_3   cambio velocit di scorrimento scritta
;*********************************************************************
;
STATO_3				;42
	MOVF	EEData,W        		;1
	MOVWF   CNTCA           	;1  44

	CALL	TASTO_P		;14 58   tasto premuto
	SKIPNZ                  		;1
	GOTO	STAT3_61		;61

	MOVLW	D'20'		; 	ritardo
	CALL RIT_P1	        		;66 126
	RETURN			;2   128
;-------------------------------------------------------------

STAT3_61				;    61
	BTFSS	PortB,6			;   	verifico se devo variare velocit
	GOTO	SPECIALE		;    64	o se devo cambiare il tono

 	CLRF	Count3          		;1  58 	azzero il count3 per sommare
	RLF	CNTCA,1		;1	correttamente
	BCF	CNTCA,0		;1	vario la velocit di scorrimento
	BTFSC	CNTCA,3		;1	e la pongo a pixel o a caratteri
	BSF	CNTCA,0		;1

	MOVLW	D'16'		;1   69
	BTFSC	CNTCA,3		;1
	ADDWF	CNTCA,1	;1

	BCF	CNTCA,3		;1   72
	BTFSC	CNTCA,4		;1
	BSF	CNTCA,3		;1

	MOVLW	B'11110000'	;1   75
	ANDWF	EEData,1	;1
	MOVF    CNTCA,W         	;1
	ANDLW	B'00001111'	;1

	IORWF   EEData,1        		;1   79
	CALL    MEMEEP          		;12  91    MEMORIZZA

	MOVLW	D'10'		;
	CALL	RIT_P0			;35 126
	GOTO	FINATT 		;2   128

;-------------------------------------------------------------

SPECIALE				;64
	MOVLW  	B'00100000'	;1        	scelta tono singolo/bitonale
	XORWF	EEData,1	;1 
	CALL    MEMEEP          		;12 78	MEMORIZZA

	MOVLW	D'14'		;
	CALL	RIT_P1			;48 126
	GOTO    FINATT          		;2   128


;---------------------------------------------------------------------
MEMEEP  BSF     Status,RP0      		;1
	BSF     EECON1,WREN     	;2
	MOVLW   055             		;3
	MOVWF   EECON2          	;4       	MEMORIZZAZIONE EEPROM
	MOVLW   0AA             		;5
	MOVWF   EECON2          	;6
	BSF     EECON1,WR       	;7
	BCF     EECON1,WREN     	;2

	BCF     Status,RP0      		;8
	RETURN                  		;10

;*********************************************************************
;	Scelta del carattere in modo circolare e ....
;        ....
;*********************************************************************
;
SCELTA_CA
	BTFSC   PortB,7         		;1
	INCF	CNTCA,1		;1	incremento carattere
	BTFSC   PortB,6         		;1
	DECF	CNTCA,1		;1  4   	decremento carattere

	MOVF    CNTCA,W         	;1    
	XORLW   D'255'          		;1 
	MOVLW	D'39'		;1
	SKIPNZ				;1
	MOVWF	CNTCA		;1  9

	MOVF    CNTCA,W         	;1   
	XORLW   D'40'           		;1      	verifico se fondo scala
	SKIPNZ                  		;1      	o inizio
	CLRF	CNTCA			;1  13

	MOVLW   D'83'           		;1  14  	velocit di cambio carattere
	BTFSC	Count2,6		;1
	MOVWF   Count2          		;1  16
	RETURN			;2  18

;*********************************************************************
;   CONVER  converto il numero nel puntatore alla tabella
;*********************************************************************
;
CONVER  MOVLW   HIGH Texte      	;1      	conversione del numero CNTCA
	MOVWF   PClath          		;2      	al puntatore del carattere
	MOVF    CNTCA,W         	;3
	CALL    Texte           		;(6) 9
	MOVWF   TABCA           	;10
	CLRF    PClath          		;11
	RETURN                  		;13

;*********************************************************************
;	Sistema la flag se il tasto  premuto e ha superato la
;       soglia di attivazione normale e old  ( incremento ogni 20mS )
;*********************************************************************
;
TASTO_P
	COMF    PortB,w         		;1      
	ANDLW   B'11000000'     	;1      	vedo se  premuto un dei due
	MOVLW	D'42'		;1
	SKIPNZ                  		;1      	o entrambi i tasti se si skip
	MOVWF   Count2          		;1      	non premuti faccio clear
	INCF    Count2,1        		;1  6   	contatore di quadri e increm

	MOVLW	D'50'		;1	tempo prima di servire la pigiata
	BTFSC	Count2,6		;1	testo se 1 vota o seconda
	MOVLW	D'90'		;1	tempo per considerare old la pigiata
	XORWF   Count2,W        	;1      	verifico se count e arrivato
	RETURN                  		;2  12 

;*******************************************************
;    Incremento orologio
;*******************************************************
INCTIME CALL	DSINCK		;16  18
	INCF    SubSec,1        		;1	Incremento 1/50 sec
	MOVLW   -D'50'          		;1   20
	ADDWF   SubSec,W        	;1     
	SKIPNC                  		;1    
	CLRF    SubSec          		;1
	SKIPNC                  		;1
	INCF    SeU,1           		;1	 And increment Second Units
	SKIPNC                  		;1
	NOP                     		;1	 seconds counter modulo 256
	MOVLW   -D'60'          		;1
	ADDWF   SeU,W           		;1	 Carry if needed Second Units->Tens
	SKIPNC                  		;1  30
	CLRF    SeU             		;1
	SKIPNC                  		;1
	INCF    MiU,1           		;1	unit di minuti
	MOVLW   -D'10'          		;1
	ADDWF   MiU,W           		;1  35
	SKIPNC                  		;1
	CLRF    MiU             		;1
	SKIPNC                  		;1
	INCF    MiT,1           		;1  39     decine di minuti
	MOVLW   -D'6'           		;1  40
	ADDWF   MiT,W           		;1
	SKIPNC                  		;1
	CLRF    MiT             		;1
	SKIPNC                  		;1
	INCF    HrU,1           		;1  45
	MOVLW   -D'10'          		;1
	ADDWF   HrU,W           		;1
	SKIPNC                  		;1
	CLRF    HrU             		;1
	SKIPNC                  		;1  50
	INCF    HrT,1           		;1
	MOVF    HrU,W           		;1	Now check for Hours=3D24
	BTFSC   HrT,0           		;1
	ADDLW   D'10'           		;1  54
	BTFSC   HrT,1           		;1
	ADDLW   -D'4'           		;1
	SKIPNC                  		;1
	CLRF    HrU             		;1  58	clear unita di ore
	SKIPNC                  		;1
	CLRF    HrT             		;1  60	clear decine di ore

	MOVLW	D'63'		;1
	CALL	EEREADW		;9  70
 
	MOVLW	CELLSP	;
	MOVWF	EEAdr		;

	MOVLW	B'00000011'	;1
	BTFSC	SeU,0			;1
	BTFSC	EEData,5		;1
	MOVLW	B'00000100'	;1 76

	BSF     Status,RP0      		;1	select bank 1
	MOVWF 	Roption		;1	prescaler TMR0 / 2
	BCF     Status,RP0      		;1  79	select bank 0

	MOVLW	D'14'		;	ritardo
	CALL	RIT_P0			;47  126

	RETURN                  		;2    128

;*******************************************************
;	prepara le celle da displeiare
;*******************************************************
PREREAD CALL	DSINCK	;18
	MOVLW   D'63'           		;1
	CALL    EEREADW         	;9  28   	estraggo da EEPROM la cella
					;        	per la velocit o no ????
	MOVWF	DISPE		;1      	la metto in DISPE
	ANDLW	B'00000111'	;1      
			
	ADDWF	Count3,1	;1       	e la sommo a Count3
	MOVF	Count3,W		;1

	ADDLW   -D'56'          		;*1  33	numero di quadri (20mS quadro)
	SKIPNC                  		;*1-2	per velocit scorrimento
	CLRF	Count3          		;*    36	scritta al primo ingresso
 	SKIPNC                  		;*	partenza per arrivare a ...
	INCF    Ptrtxt,1        		;*1  37
	DNOP				;*    39

PREREA_39
	MOVF	Ptrtxt,W			;1	 puntatore all'ultimo carattere
	ADDLW	-D'54'		;1	se si azzero puntatore
	MOVLW	-D'8'		;1
	SKIPNZ				;1
	MOVWF	Ptrtxt		;1  44
	MOVF    Ptrtxt,W        		;1  45
	CALL	EEREADW		;9  54
	XORLW   CarFI           		;1	verifico se  ultimo carattere
	MOVLW	-D'8'		;1      	del messaggio
	SKIPNZ                  		;1	se no salto .. altrimenti
	MOVWF   Ptrtxt          		;1  58	pongo puntatore a -7
	MOVF    Ptrtxt,W        		;1  59

PREREA_59
	MOVWF   EEAdr           		;1      	metto puntatore carattere in
	MOVLW   D'22'           		;1	puntatore al segmento
	MOVWF   FSR             		;1  62	inizio tabella CA
PREREA_62
	MOVLW	D'20'		;
	CALL	RIT_P1			;66 128

;---------------------------------------------------- NUOVA LINEA
	CALL	LETT_5			;
;---------------------------------------------------- NUOVA LINEA
	GOTO	LETT_5 		;
;--------------------------------------------          
;--------------------------------------------
PREH_34
	MOVLW	D'5'		;
	CALL	RIT_P2			;22 56
	MOVLW	ULTICAR	;1
	GOTO	PREREA_59		;2  59
;**************************************************************
;	Prepara riga per display ore o scritta
;**************************************************************
PREPH   CALL	DSINCK		;18

	MOVLW   D'63'           		;1 
	CALL    EEREADW         	;9  28 	verifico se display ore
	BTFSC	EEData,6		;1	0=fissa/ora  1=alterna fissa/ora
	GOTO    PREH_TIME       	;31      	se 1 vado a ...

	BTFSC	EEData,7		;1  31	0=scritta fissa se 1= ore salto
	GOTO    PREH_ORA        	;   33   	se scritta vado a...
	GOTO	PREH_34		;   34

PREH_TIME				;
	BTFSC	SeU,2			;  32
	GOTO	PREH_34		;  34

PREH_ORA				;
	MOVLW   CarSP           		;1  34	Metto lo space in tutte
	MOVWF   CA0             		;1	le celle da  displeiare
	MOVWF	CA1		;1
	MOVWF	CA2		;1
	MOVWF	CA8		;1  38 

	BCF     Status,C        		;1  

	MOVF    HrT,W           		;1	Decine di ore
	CALL	MULT7			;10
	MOVWF	CA3		;1  51 

	MOVF    HrU,W           		;1	unit di ore
	CALL	MULT7			;10
	MOVWF	CA4		;1  63

	MOVLW   CarDP           		;1
	BTFSC   SeU,0           		;1	visualizzo i due punti o
	MOVLW   CarSP           		;1 	lo space ogni secondo
	MOVWF   CA5             		;1  67

	MOVF    MiT,W           		;1          Decine di minuti
	CALL	MULT7			;10
	MOVWF	CA6		;1  89

	MOVF    MiU,W           		;1	Decine di ore
	CALL	MULT7			;10
	MOVWF	CA7		;1   91

	MOVLW	D'10'		;            ritardo
	CALL	RIT_P2			;37  128

	MOVLW	D'2'		;	chiamo due righe nere
	MOVWF	CNT_0		;	e ritorner
	GOTO	BLKLINE		;

;*******************************************************
;  routines di moltiplicazione per sette
;*******************************************************
MULT7	MOVWF   TIME            		;1    
	RLF     TIME,1          		;1 	moltiplico x sette
	RLF     TIME,1          		;1    	il valore in W e lo
	ADDWF   TIME,1          		;1      	ritorno in W
	ADDWF   TIME,1          		;1
	ADDWF   TIME,W          	;1
	RETURN			;2 (8)

;*******************************************************
;	lettura dato in eeprom
;*******************************************************
LETT_5
	CALL	DSINCK		;16 18
	CALL    EEREAD          		;20 38	leggo  carattere
	CALL    EEREAD          		;20 58	leggo  carattere
	CALL    EEREAD          		;20 78	leggo  carattere
	CALL    EEREAD          		;20 98	leggo  carattere
	CALL    EEREAD          		;20 118	leggo  carattere
	CALL    RIT_8           		;8  126	leggo  carattere
	RETURN                  		; 128
;----------------------------------------------------
EEREAD
	CALL	LETTU			;8	lettura della eeprom

	BTFSC	EEAdr,6		;	ALTERNATIVO A PUNTARE ALLA CELLA
	MOVLW   CarSP		;	ZERO DELLA EEPROM CON SPACE

	MOVWF   INDF            		;       	metto dato a indirizzo
	INCF    FSR,1           		;       	puntato da FSR
	XORLW   CarFI           		;       	verifico se fine caratteri
	SKIPNZ                  		;       	se si
	BSF	EEAdr,6         		;       	setto di leggere sempre cella 0
	INCF    EEAdr,1         		;
	RETURN                  		;18

EEREADW
	MOVWF   EEAdr           		;1      	lettura della eeprom
LETTU
	BSF     Status,RP0      		;2      	alla cella puntata
	BSF     EEData,RD       		;3      	dal W prima della chiamata
	BCF     Status,RP0      		;4
	MOVF    EEData,W        		;5      	ritorno dato in accumulatore
	RETURN                  		;7

;*******************************************************
;	tabella di riferimento caratteri asci
;*******************************************************

Texte   ADDWF   PCL,F
DTexte  equ     $
	RETLW   CarBL   		; -
	RETLW   CarA    		; 0
	RETLW   CarB    		; 1
	RETLW   CarC    		; 2
	RETLW   CarD    		; 3
	RETLW   CarE    		; 4
	RETLW   CarF    		; 5
	RETLW   CarG    		; 6
	RETLW   CarH    		; 7
	RETLW   CarI    		; 8
	RETLW   CarJ    		; 9
	RETLW   CarK    		; 10
	RETLW   CarL    		; 11
	RETLW   CarM    		; 12
	RETLW   CarN    		; 13
	RETLW   CarO    		; 14
	RETLW   CarP    		; 15
	RETLW   CarQ    		; 16
	RETLW   CarR    		; 17
	RETLW   CarS    		; 18
	RETLW   CarT    		; 19
	RETLW   CarU    		; 20
	RETLW   CarV    		; 21
	RETLW   CarW    		; 22
	RETLW   CarX    		; 23
	RETLW   CarY    		; 24
	RETLW   CarZ    		; 25
	RETLW   CarSP   		; 26
	RETLW   Car0    		; 27
	RETLW   Car1    		; 28
	RETLW   Car2    		; 29
	RETLW   Car3    		; 30
	RETLW   Car4    		; 31
	RETLW   Car5    		; 32
	RETLW   Car6    		; 33
	RETLW   Car7    		; 34
	RETLW   Car8    		; 35
	RETLW   Car9    		; 36
	RETLW   CarDP   		; 37
	RETLW   CarFI   		; 38
	END



_NextPart_000_005B_01BE4A00.C87440F0--
</XMP></BODY></HTML>
