;***********************************************************************
;

	TITLE   "BARRE_COLOR"  ; de IW2KGH Salvatore

		LIST        P=16F628, F=INHX8M
		include     "P16F628.inc"

		__CONFIG	0x3F6A
		__IDLOCS	0xFFFF

;===============================================================
;	Definizioni dell'utente  
;===============================================================
#Define F       1
#define Sync    PORTA,0         ; Sincronismo video uscita RA0  (PIN 17)
#define Audio   PORTA,4         ; Sincronismo video uscita RA4  (PIN 3)


;=======================================================




;=======================================================
;		MACRO D'UTENTE
;=======================================================

DNOP    MACRO		; DNOP - doppia NOP. Delay di 2 cycles, 
	LOCAL   Label
Label   GOTO    Label+1
	ENDM

SKIPNC  MACRO
	BTFSC   STATUS,C

	ENDM
SKIPSC  MACRO
	BTFSS   STATUS,C
	ENDM

SKIPNZ  MACRO
	BTFSC   STATUS,Z
	ENDM

SKIPSZ  MACRO
	BTFSS   STATUS,Z
	ENDM
	LIST

;===============================================================
;	Definizioni celle di RAM
;===============================================================
	ORG	20

TIME	RES	1	;cella utilizzata dal delay (nel ciclo)
CNT_0	RES	1	;utilizzato per quante righe video 
Count2	RES	1	;
Count3	RES	1	;Contatore per velocit di scorrimento
AUTO	RES	1	; MIO

SubSec	RES	1	;

PCF0	RES	1	;
CF0	RES	1	;
PCF1	RES	1	;
CF1	RES	1	;
PCF2	RES	1	;
CF2	RES	1	;
PCF3	RES	1	;
CF3	RES	1	;
PCF4	RES	1	;
CF4	RES	1	;
PCF5	RES	1	;
CF5	RES	1	;
PCF6	RES	1	;
CF6	RES	1	;
PCF7	RES	1	;
CF7	RES	1	;
PCF8	RES	1	;
CF8	RES	1	;
PCF9	RES	1	;
CF9	RES	1	;

PCA0	RES	1	;
CA0	RES	1	;
PCA1	RES	1	;
CA1	RES	1	;
PCA2	RES	1	;
CA2	RES	1	;
PCA3	RES	1	;
CA3	RES	1	;
PCA4	RES	1	;
CA4	RES	1	;
PCA5	RES	1	;
CA5	RES	1	;
PCA6	RES	1	;
CA6	RES	1	;
PCA7	RES	1	;
CA7	RES	1	;
PCA8	RES	1	;
CA8	RES	1	;
PCA9	RES	1	;
CA9	RES	1	;

Ta0	RES	1	;
Ta1	RES	1	;
Ta2	RES	1	;
Ta3	RES	1	;
Ta4	RES	1	;
Ta5	RES	1	;
Ta6	RES	1	;
Ta7	RES	1	;
Ta8	RES	1	;

Ptrtxt	RES	1	;
CNT_1	RES	1	;
CNT_R	RES	1	;
CNT_X	RES	1	;

CNTCA	RES	1	;
TABCA	RES	1	;
STATO	RES	1	;
DISPE	RES	1	;
PUNCA	RES	1	;
CELLAX	RES	1	;
CEL_X1	RES	1	;
CEL_X2	RES	1	;
CEL_T1	RES	1	;
CEL_T2	RES	1	;
COLORE	RES	1	;
FLAG	RES	1	;

S_LINEE	  res	1	;linee per punto scritta scorrevole
S_BLINEE  res	1	;linee mancanti al punto
F_LINEE	  res	1	;linee per punto scritta fissa
F_BLINEE  res	1	;linee mancanti al punto

F_FRAME	  res	1	; tipo di quadro da fare
F_PORTA	  res	1	; cosa stabilire su uscite portA

CEEDATA		RES	1	;Cella copia di EEDATA
CEEADR		RES	1	;Cella copia di EEADR
	


;
;TIME     cella utilizzata dal delay (nel ciclo)
;CNT_0    utilizzato chiamate per sapere quante righe video fare e altro 
;Count2   Contatore di quadri per azione con pulsanti (riservata )
;Count3   Contatore per velocit di scorrimento
;SubSec   utilizzata per semiquadri a/b e orologio 1sec
;
;Ptrtxt  punt. al primo carattere per display scritta scorrevole e no
;CNT_1   numero di linee che definiscono il punto carattere (DISPLAY)  
;CNT_R   numero di riga del carattere in dislay (DISPLAY)
;CNTCA   puntatore carattere circolare durante memorizzazione (stato0 e 1)
;TABCA   carattere da memorizzate convertito asci_tab
;STATO   stato per sapere quale comando devo eseguire
;DISPE   tipo di display a salti o punti e velocit da sommare
;PUNCA   punt. carattere scritta fissa durante memorizzazione frase
; 
;*********************************************************************
;  EEPROM 
;*********************************************************************  
	ORG     2100
;
;frase: " SORRY FOR BUGS GOOD LUCK WITH V10 BY IW2KGH SALVATORE "
;frase: "EMAIL: SALPAGNO@TIN.IT"

	DT	" !"
	DE	22
	DT	"#$%&'()*+,-./"	;10  
	DT      "0123456789:;<>=?"	;10  20
	DT      "@ABCDEFGHIJKLMNO"	;10  
	DT      "PQRSTUVWXYZ["
	DE	5C
	DT	"]^_"	;10  40
	DE	60
	DT      "abcdefghijklmno"	;10  
	DT	"pqrstuvwxyz{|}"	;10  60
	DE	7E,7F
	DT      "  By_Salvatore"
	DE	80,80  

;scritta fissa
;
	DT      "IW2KGH  "		;8 78

;dati di sistema
;
	DE      80,80,80,80,00,11,88,04	;7F
;-----------------------------------------------------

NUFRAME	EQU	H'7C'	; valore default H'04'
SIZLINE	EQU	H'7D'	; valore default H'11'
ECOLORE	EQU	H'7E'	; valore default H'88'
EDISPE	EQU	H'7F'	; valore default H'04
;
;NUFRAME:cella H7C EEPROM 'XXXX XXXX'
;                                |||___ N quadro configurazione
;                             
;
;SIZLINE:cella H7D EEPROM 'XXXX XXXX'
;                            ||   ||___ Dimensione scritta scorrevole
;                            ||________ Dimensione scritta Fissa
;                         
;	
;ECOLORE:cella H7E EEPROM 'XXXX XXXX'
;                          |||| ||||___ Colore per scorrevole
;                          ||||________ Colore per fissa
;	
;MODI:  cella H7B EEPROM 'XXXX XXXX' 
;                           || ||||___ Velocit di scorrimento
;                           ||
;                           ||________ scritta 1=orologio  0= NOMINATIVO
;                           |_________ Tono:   1=singolo   0=bitonale
;                          
;*********************************************************************
;       DEFINE per scritte 
;*********************************************************************  
;
ULTICIR	EQU	H'72'	; Ultimo carattere -9 della scritta circolare
PRIMFIS	EQU	H'70'	; Primo carattere della scritta fissa

C_BLOCK	EQU	H'61'	;
NUM_CAR	EQU	H'61'	; numero caratteri gestiti

CarFINE	EQU	H'80'	; | carattere di fine frase

;*********************************************************************
;       START  del programma 
;*********************************************************************  

	ORG     0
	GOTO    INIZIO
D_Table:
	GOTO	Table
	ORG     4
	RETURN

;*********************************************************************
;    inizio del programma e settaggio del PIC e EEPROM          
;*********************************************************************

RITA_WR
	MOVLW   D'255'          ;*
	MOVWF	CNT_0		;*	solo ritardo iniziale 
	CALL    BLKLINE		;*
	return
INIZIO
	movlw	0x07	
	movwf	CMCON		; PORTA come INPUT / OUTPUT
;------------------------------------
	MOVLW	SIZLINE		;      leggo cella per determinare 
	CALL	EEREADWN	;      la dimensione del carattere
	ANDLW	B'00000011'
	MOVWF	F_LINEE		; linee per fare un punto in verticale
		
	SWAPF	CEEDATA,W	
	ANDLW	B'00000011'
	MOVWF	S_LINEE		; linee per fare un punto in verticale
;---------------------------------------------------
	MOVLW	NUFRAME		;      leggo cella per determinare
	CALL	EEREADWN	;      il quadro di configurazione
	ANDLW	B'00001111'
	MOVWF	F_FRAME		;     tipo di quadro da fare

	SWAPF	CEEDATA,W	
	ANDLW	B'00000111'
	MOVWF	AUTO		;     tipo di quadro da Fare

;-------------------------------------
	BSF     STATUS,RP0      ; select bank 1

	MOVLW	B'00000000'	; Protezione per scrittura in
	MOVWF	EECON1		; EEPROM all'accenzione
	BCF     EECON1,WREN     ;  ( spero & spero )
	MOVWF	EECON2		;	

	movlw	B'00000'	;1      Port_A definisco gli
	MOVWF   TRISA		;

	MOVLW   B'11100000'	; Port_B  0=outputs  1=inputs
	MOVWF   TRISB           ; 

	MOVLW   B'00000011'	;pull up on, interup \_
				;internal clok, inc rb4  _/
	MOVWF 	OPTION_REG		;prescaler TMR0 / 2
	BCF     STATUS,RP0      ; select bank 0

;????????????????????????????????????????????????????????????????

	CALL	RITA_WR		;
INIZ1:
	CLRF	Ptrtxt		; puntatore frase scorrevole
	CLRF    Count3		;
	CLRF    DISPE		;
	CLRF	STATO		;

;*********************************************************************
;   F_BGFS   BARRE GRANDI CON SCRITTA FISSA E SCORREVOLE     
;*********************************************************************

F_BGFS:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;* GREY BARS ------------------------line 25  (+xx)=45
	MOVLW   D'20'           ; 
	MOVWF	CNT_0		; 
	CALL    S_BARRE		;

;* DISPLAY TEXTE --------------------line   (+38)=83
	movlw	-D'2'		;
	movwf	F_PORTA		;
	CALL	F_DISPLAY	;

;* GREY SPECIAL LINES ---------------line     (1)=84
	MOVFW	S_BLINEE        ;1 - 22       
	MOVWF	CNT_0		;             
	CALL    S_BARRE		;  

;* GREY SPECIAL LINES ---------------line     (1)=85
	MOVFW	F_BLINEE        ; 1-22    
	MOVWF	CNT_0		;        
	CALL    S_BARRE		;

;* GREY BARS ------------------------line   (+xx)=239
	MOVLW   D'154'          ;                 
	MOVWF   CNT_0		;
	CALL 	S_BARRE         ;

; BLACK LINES ----------------------line      (x)=244
	MOVLW   D'5'           ;
	MOVWF	CNT_0		;
	CALL    BLKLINE		;

;* DISPLAY SCORREVOLE  -------------line    (+38)= 282
	MOVLW	B'00000000' 	;38
	MOVWF	DISPE		;
	CALL    DISPLAY         ;
	
; BLACK LINES ----------------------line      (x)=304
	MOVLW   D'22'           ;
	MOVWF	CNT_0		;
	CALL    BLKLINE		;

;* INCREMENT TIME -------------------Line     (+1)=305
INCTIM:
	CALL    INCTIME         ;2	128

;*********************************************************************
;   F_BGF   BARRE GRANDI CON SCRITTA FISSA    
;*********************************************************************

F_BGF:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;* GREY BARS ------------------------line   (+xx)=45
	MOVLW   D'20'           ; 
	MOVWF	CNT_0		; 
	CALL    S_BARRE		;

;* DISPLAY TEXTE --------------------line   (+38)=83
	movlw	-D'2'		;
	movwf	F_PORTA		;
	CALL	F_DISPLAY	;

;* GREY SPECIAL LINES ---------------line     (1)=84
	MOVFW	F_BLINEE        ; 1-22    
	MOVWF	CNT_0		;        
	CALL    S_BARRE		;

;* GREY BARS ------------------------line   (+xx)=304
	MOVLW   D'220'          ;                 
	MOVWF   CNT_0		;
	CALL S_BARRE            ;

;* INCREMENT TIME -------------------Line     (+1)=305
	CALL    INCTIME         ;2	128


;*********************************************************************
;   F_BGS   BARRE GRANDI CON SCRITTA SCORREVOLE     
;*********************************************************************

F_BGS:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;* GREY SPECIAL LINES ---------------line     (1)=26
	MOVFW	S_BLINEE        ;1 - 22       
	MOVWF	CNT_0		;             
	CALL    S_BARRE		;  

;* GREY BARS ------------------------line   (+xx)=244
	MOVLW   D'218'           ; 
	MOVWF	CNT_0		; 
	CALL    S_BARRE		;

;* DISPLAY SCORREVOLE  -------------line    (+38)= 282
	MOVLW	B'00000000' 	;38
	MOVWF	DISPE		;
	CALL    DISPLAY         ;
	
; BLACK LINES ----------------------line      (x)=304
	MOVLW   D'22'           ;
	MOVWF	CNT_0		;
	CALL    BLKLINE		;

;* INCREMENT TIME -------------------Line     (+1)=305
	CALL    INCTIME         ;2	128


;*********************************************************************
;   F_BG  BARRE GRANDI    
;*********************************************************************

F_BG:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;* GREY BARS ------------------------line   (+)=100
	MOVLW   D'75'           ;                 
	MOVWF   CNT_0		;
	CALL S_BARRE            ;

;* GREY BARS ------------------------line   (+)=304
	MOVLW   D'204'          ;                 
	MOVWF   CNT_0		;
	CALL S_BARRE            ;

;* INCREMENT TIME -------------------Line   (+1)=305
	CALL    INCTIME         ;2	128

;*********************************************************************
;   F_BMSF   BARRE MEDIE CON SCRITTA SCORREVOLE E FISSA
;*********************************************************************

F_BMSF:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   25 (+xx)=45
	MOVLW   B'00000000'     ; 8-Barre
	MOVWF	FLAG		; 
	GOTO    SP_BLK		;


;*********************************************************************
;   F_BMFS   BARRE MEDIE CON SCRITTA FISSA E SCORREVOLE 
;*********************************************************************

F_BMFS:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00001100'     ; 8-Barre inverte scritta
	MOVWF	FLAG		; 
	GOTO    SP_BLK		;

;*********************************************************************
;   F_SMSF   SCACCHIERA MEDIE CON SCRITTA SCORREVOLE E FISSA
;*********************************************************************

F_SMSF:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00000001'     ; 8-scacciera
	MOVWF	FLAG		; 
	GOTO    SP_BLK		;

;*********************************************************************
;   F_SMFS   BARRE MEDIE CON SCRITTA FISSA E SCORREVOLE
;*********************************************************************

F_SMFS:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00001101'     ; 8-scacciera inverte scritta
	MOVWF	FLAG		; 
	GOTO    SP_BLK		;

;*********************************************************************
;   F_BDSF   BARRE DOPPIE CON SCRITTA SCORREVOLE E FISSA
;*********************************************************************

F_BDSF:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00000010'     ; 16-barre
	MOVWF	FLAG		; 
	GOTO    SP_BLK		;

;*********************************************************************
;   F_BDFS   BARRE DOPPIE CON SCRITTA FISSA E SCORREVOLE
;*********************************************************************

F_BDFS:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00001110'     ; 16-barre inverte scritta
	MOVWF	FLAG		; 
	GOTO    SP_BLK		;

;*********************************************************************
;   F_SDSF   SCACCHIERA DOPPIE CON SCRITTA SCORREVOLE E FISSA
;*********************************************************************

F_SDSF:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00000011'     ; 16-scacchiera
	MOVWF	FLAG		; 
	GOTO    SP_BLK		;

;*********************************************************************
;   F_SDFS   SCACCHIERA DOPPIE CON SCRITTA FISSA E SCORREVOLE
;*********************************************************************

F_SDFS:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00001111'     ; 16-scacchiera inverte scritta
	MOVWF	FLAG		; 
	GOTO    SP_BLK		;

;*********************************************************************
;   F_BMS   BARRE MEDIE CON SCRITTA SCORREVOLE 
;*********************************************************************

F_BMS:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00001000'     ; 8-barre scorrevole
	MOVWF	FLAG		; 
	GOTO    SP1_BLK		;

;*********************************************************************
;   F_BMF   BARRE MEDIE CON SCRITTA FISSA
;*********************************************************************

F_BMF:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   13 (+xx)=45
	MOVLW   B'00000000'     ; 8-barre fissa
	MOVWF	FLAG		; 
	GOTO    SP1_BLK		;

	
;*********************************************************************
;   F_BDS   BARRE DOPPIE CON SCRITTA SCORREVOLE 
;*********************************************************************
F_BDS:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   25 (+xx)=45
	MOVLW   B'00001010'     ; 16-Barre scorrevole
	MOVWF	FLAG		; 
	GOTO    SP1_BLK		;


;*********************************************************************
;   F_BDF   BARRE DOPPIE CON SCRITTA FISSA 
;*********************************************************************
F_BDF:				;
	CALL	EQUALIZ		;totale 7,5 linee  25

;*****  BLACK LINES   ************ line   25 (+xx)=45
	MOVLW   B'00000010'     ; 16-barre fissa
	MOVWF	FLAG		; 
	GOTO    SP1_BLK		;

;*********************************************************************
;   fRAME-- COMUNE_1   8/16 barre - scacciera - inversione  fisso scorrevole
;   per i quadri- Frame  F 4-5 8-9
;*********************************************************************
FRAME_C1:

;*****  BLACK LINES   ************ line   26 (+xx)=45
	MOVLW   D'19'           ; 
	MOVWF	CNT_0		; 
	CALL    BLKLINE		;

;* DISPLAY SCORREVOLE  -------------line    (+38)=83 
	MOVLW	B'00000000' 	;38
	MOVWF	DISPE		;
	CALL    DISPLAY         ;
	
; BLACK LINES ----------------------line      (x)=100
	MOVLW   D'17'           ;
	MOVWF	CNT_0		;
	CALL    BLKLINE		;

;* GREY SPECIAL LINES ---------------line     (1)=101
	MOVFW	S_BLINEE        ;1 - 22       
	MOVWF	CNT_0		;             
	CALL    BARRE	;  

;* GREY SPECIAL LINES ---------------line     (1)=102
	MOVFW	F_BLINEE        ; 1-22    
	MOVWF	CNT_0		;        
	CALL    BARRE		;

;* GREY BARS ------------------------line   (+xx)=227
	MOVLW   D'125'          ;                 
	MOVWF   CNT_0		;
	CALL 	BARRE        ;

; BLACK LINES ----------------------line      (x)=244
	MOVLW   D'17'           ;
	MOVWF	CNT_0		;
	CALL    BLKLINE		;

;* DISPLAY TEXTE --------------------line   (38)=282
	movlw	D'0'		;
	movwf	F_PORTA		;
	CALL	F_DISPLAY	;

;* BLACK BARS ------------------------line   (+xx)=304
	MOVLW   D'22'           ;                 
	MOVWF   CNT_0		;
	CALL    BLKLINE		;

;* INCREMENT TIME -------------------Line     (+1)=305
	CALL    INCTIME         ;2	128


;*********************************************************************
;   fRAME-- C2   barre piccole solo scritta sotto      
;*********************************************************************

FRAME_C2				;

;*****  BLACK LINES   ************ line   26 (+xx)=45
	MOVLW   D'19'           ; 
	MOVWF	CNT_0		; 
	CALL    BLKLINE		;

;* GREY SPECIAL LINES ---------------line     (1)=46
	MOVFW	F_BLINEE        ; 1-22    
	MOVWF	CNT_0		;        
	CALL    BARRE_X		;

;* GREY BARS ------------------------line   (+xx)=227
	MOVLW   D'181'          ;                 
	MOVWF   CNT_0		;
	CALL 	BARRE	        ;

; BLACK LINES ----------------------line      (x)=244
	MOVLW   D'17'           ;
	MOVWF	CNT_0		;
	CALL    BLKLINE		;

;* DISPLAY TEXTE --------------------line   (38)=282
	movlw	D'0'	;
	movwf	F_PORTA		;
	CALL	F_DISPLAY	;

;* BLACK BARS ------------------------line   (+xx)=304
	MOVLW   D'22'           ;                 
	MOVWF   CNT_0		;
	CALL    BLKLINE		;

;* INCREMENT TIME -------------------Line     (1)=305
	CALL    INCTIME         ;2

;************************************************************
;     Equalizzazione 7,5 + 305 visible Lines =312,5 *2 =625
;   inserisce linee per l'interlacciamento
;   e ritorno a capo del video secondo norme CCIR/PAL
;************************************************************
;
EQUALIZ
	CALL	SINCK		;14     18
	MOVLW   4               ;1		
	BTFSS   SubSec,0        ;1-2	
	MOVLW   5               ;1	
	MOVWF   CNT_0           ;1	22

Loop1   CALL	RIT_46		;46	68  (64  4)
	CALL	SINCK		;14     18
	NOP			;1		 
	DECFSZ  CNT_0,1         ;1-2	    
	GOTO    Loop1           ;2		22  


	CALL	RIT_49		;49	70   (64 5 )

; 5 mezze righe per Equalizzazione

	BCF     Sync            ;1   	7   ;30us Sync
	CALL	RIT_8		;8 

	MOVLW   4               ;   	16      
	MOVWF   CNT_0           ;   	17
   
Loop2
	CALL	RIT_48		;48	65   
	BSF	Sync		;1  	66  ;2us Nero
	CALL	RIT_8		;8 
	BCF     Sync            ;1    	7   ;30us Sync
	DNOP		        ;2    	9  
	NOP			;1    	10
	DECFSZ CNT_0,1          ;     	-  	
	GOTO    Loop2           ;     	13

	CALL	RIT_49		;53	65  
	BSF     Sync            ;	2   ;2us Nero

; 5 o 4 mezze righe di equalizzazione per interlacciare

	CALL	DSINCK		;16     20  
	MOVLW   4               ;1	
	BTFSC   SubSec,0        ;1-2	
	MOVLW   3               ;1	
	MOVWF   CNT_0           ;1	22

Loop3   CALL	RIT_46		;46	68  (64  4 )
	CALL	SINCK		;14     18
	NOP			;1	
	DECFSZ  CNT_0,1         ;1-2	
	GOTO    Loop3           ;2	22
			
	MOVLW	D'11'		;ritardo
	CALL	RIT_P2		;40	61

	INCF    SubSec,1        ;1	Incremento 1/50 sec

	MOVLW	D'15'		;
	MOVWF	CEL_X1		;
	CLRF	FLAG		;
	CLRF	CEL_X2		;


;------------------------------------------
;*****  BLACK LINES   ************ line  
	MOVLW   D'12'           ; 12
	MOVWF	CNT_0		;
	CALL    BLKLINE		;

	CALL    PREPH           ;6
	CALL	PREREAD		;6
	GOTO	PULSANTI	;1
;-----------------------------------------

;************************************************************
;    routines di ritardo ( delay )
; es: RIT_51 = ritardo di 51 Time inclusi chiamata e ritorno
;************************************************************
;
RIT_49	NOP			;
RIT_48	DNOP			;
RIT_46	MOVLW	D'13'		;
	GOTO	RIT_P0		;

RIT_P2	NOP			;
RIT_P1	NOP			;
RIT_P0	MOVWF	TIME		;     ritardo  2  + 3*W + 2
RITAY	DECFSZ	TIME,1		;         call      return
	GOTO	RITAY		;
	RETURN			;

RIT_9	NOP			;
RIT_8	NOP			;
RIT_7	NOP			;
RIT_6	NOP			;
RIT_5   NOP			;
RIT_4   RETURN			;


DSINCK:
	DNOP			;2
SINCK:
	movlw	B'00010000'	;1  mette il sinc azzero PORTA
	andwf	PORTA,1		;1  

	DNOP			;2
	DNOP			;2
	DNOP			;2
	NOP			;1
	BSF	Sync		;1   toglie sinc
	RETURN			;2  (14) -(16)

;***************************************************************
; 	Righe nere sul televisore
;  il numero di righe  definito in  CNT_0 prima della chiamata
;***************************************************************
;
BLKLI_0
	CALL	RIT_5		;5   1 4
BLKLINE	CALL	SINCK		;14  18   impulso di sincronismo

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1 20     output per i grigi

	MOVLW	D'33'		;           ritardo 
	CALL	RIT_P0		;104  124

	DECFSZ	CNT_0,1		;1-2  125  126
	GOTO	BLKLI_0		;2    127   -

	RETURN			;2    128

;=====================================================

SP_BLK
	CALL	SINCK		;14  18   impulso di sincronismo

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1 20     output per i grigi


;	B'0000 0000' CONTROLLO
;         |||| ||||__ 0= somma zero barre  1=somma -2 scacchi
;         |||| |||___ 0= 8 barre   1= 16 barre
;         |||| ||____ 0= SCORREVOLE SOPRA  1=SCORREVOLE SOTTO
;         |||| ||____


	MOVLW	D'0'		;1
	BTFSC	FLAG,0		;1
	MOVLW	-D'2'		;1

	MOVWF	CEL_T1		;1  24

	MOVLW	D'32'		;           ritardo 
	CALL	RIT_P2		;103  126
	
	GOTO	FRAME_C1	;2    128
;========================================================

SP1_BLK
	CALL	SINCK		;14  18   impulso di sincronismo

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1 20     output per i grigi


;	B'0000 0000' CONTROLLO
;         |||| ||||__ 0= somma zero barre  1=somma -2 scacchi
;         |||| |||___ 0= 8 barre   1= 16 barre
;         |||| ||____ 0= SCORREVOLE ok  1=SCORREVOLE sostituita con fissa
;         |||| ||____ 0= fissa ok     1= fissa sostituire con scorrevole


	MOVLW	D'0'		;1
	BTFSC	FLAG,0		;1
	MOVLW	-D'2'		;1

	MOVWF	CEL_T1		;1  24

	MOVLW	D'32'		;           ritardo 
	CALL	RIT_P2		;103  126
	
	GOTO	FRAME_C2	;2    128

;;
;*****************************************************************
; LINea: fondo display nominativo in funzione del quadro 2 tipi 
;        bit F_PORTA7=1  una nera fondo colore nero
;        bit F_PORTA7=0  una bare fondo colore barre
;                  
;*****************************************************************  
FONDO_DSY:			;2
	CALL	DSINCK 		;16  18

	movlw	D'1'		;1      pongo in uscita il valore 15
	btfsc	F_PORTA,7	;1
	movlw	D'15'		;1      pongo in uscita il valore 15
	IORWF	PORTA,1		;1  22

	CALL	RIT_8		;8
	MOVLW	B'00000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  32    output per i grigi

	MOVLW	D'1'		;       ritardo	
	CALL	RIT_P2		;10    

	movfw	F_PORTA		;1      bianco (parto 15 e sommo -2 ) 
	addwf	PORTA,1		;1  44	

	MOVLW	D'1'		;       ritardo	
	CALL	RIT_P2		;10    

	MOVF	DISPE,W		;1
	MOVWF	PORTA		;1  56

	MOVLW	D'13'		;       ritardo	
	CALL	RIT_P0		;44    

	movlw	D'1'		;1      pongo in uscita il valore 1
	btfsc	F_PORTA,7	;1
	movlw	D'3'		;1      pongo in uscita il valore 3 blu
	movwf	PORTA		;1  104 output per i grigi

	CALL	RIT_5		;5
	CALL	RIT_5		;5   

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1  116     output per i grigi

	MOVLW	D'1'		;         ritardo	
	CALL	RIT_P2		;10  126  

	RETURN			;2   128

;*****************************************************************
;       SS_BARRE:  dei grigi in verticale sul video larghe
;  il numero di righe utilizzato per le barre e definito in CNT_0
;*****************************************************************
S_BARRE_0:
	Call	RIT_5		;5  1-4
S_BARRE:			;4
	Call	SINCK		;14  18	

	movlw	D'7'		;1      numero di barre
	movwf	CNT_1		;1      in CNT_1
	movlw	D'15'		;1      pongo in uscita il valore 15
	IORWF	PORTA,		;1  22
	
	CALL	RIT_8		;  30

	MOVLW	B'00000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  32    output per i grigi
	DNOP			;
	NOP			;

S_BARRE_1:
	Call	RIT_7		;7      genero le barre partendo dal
	movlw	-D'2'		;1      bianco (parto 15 e sommo -2 ) 
	addwf	PORTA,1		;1	
	decfsz	CNT_1,1		;1-2
	GoTo	S_BARRE_1	;2 

	MOVLW	B'01110'	;1  123    Port_A definisco gli
	TRIS	PORTA		;1      output per i grigi
	CALL	RIT_4
	decfsz	CNT_0,1		;1  125
	GoTo	S_BARRE_0	;2  127
	Return			;  2 128	

;*****************************************************************
;       BARRE:  dei grigi in verticale sul video
;  il numero di righe utilizzato per le barre e definito in CNT_0
;*****************************************************************
BARRE_X:
	CALL	SINCK		;16  18

	MOVFW	CNT_0		;1	

	BTFSC	FLAG,2		;1
	MOVFW	F_BLINEE        ;1       

	BTFSC	FLAG,3		;1
	MOVFW	S_BLINEE        ;1   

	MOVWF	CNT_0		;1   24     
	NOP			;1
	GOTO	BARRE_X1	;2  27

BARRE_0
	CALL	RIT_5		;5  1-4
BARRE:
	CALL	SINCK		;16  18	
	CALL	RIT_9		;9 

BARRE_X1:                       ;   27
	BTFSC	FLAG,1		;1
	GOTO	SC_BARRE	;1  (30)

	MOVLW	D'7'		;1 30   numero di barre
	MOVWF	CNT_1		;1      in CNT_1

	BSF	CEL_X1,0	;1
	MOVFW	CEL_X1		;1      pongo in uscita il valore 15

	IORWF	PORTA,1		;1  
	MOVLW	B'00000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  36  output per i grigi

	DNOP			;2   
	NOP			;1   

BARRE_1
	CALL	RIT_6		;6      genero le barre partendo dal
	MOVLW	-D'2'		;1      bianco (parto 15 e sommo -2 ) 
	ADDWF	PORTA,1		;1	
	DECFSZ	CNT_1,1		;1-2
	GOTO	BARRE_1	;2

	MOVFW	CEL_T1		;
	INCF	CEL_X2,1	;
	BTFSC	CEL_X2,5	;
	ADDWF	CEL_X1,1	;
	BTFSC	CEL_X2,5	;
	CLRF	CEL_X2		;

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1      output per i grigi
	NOP			;

	DECFSZ	CNT_0,1		;1-2 125
	GOTO	BARRE_0		;2   127

	RETURN			;  2 128	
;*****************************************************************
;       BARRE:  dei grigi in verticale sul video
;  il numero di righe utilizzato per le barre e definito in CNT_0
;*****************************************************************
SC_BARRE_0
	CALL	RIT_5		;5  1-4
	CALL	SINCK		;16  18	
	CALL	RIT_8		;8   
	CALL	RIT_4		;4

SC_BARRE:			;   30
	NOP			;1
	MOVLW	D'15'		;1 32     numero di barre
	MOVWF	CNT_1		;1      in CNT_1

	BSF	CEL_X1,0	;1
	MOVFW	CEL_X1		;1      pongo in uscita il valore 15

	IORWF	PORTA,1		;1  
	MOVLW	B'00000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  38    output per i grigi

	DNOP			;2   
	NOP			;1   

SC_BARRE_1			;1      genero le barre partendo dal
	MOVLW	-D'2'		;1      bianco (parto 15 e sommo -2 ) 
	ADDWF	PORTA,1		;1	
	DECFSZ	CNT_1,1		;1-2 
	GOTO	SC_BARRE_1	;2

	MOVLW	B'01110'	;1  116    Port_A definisco gli
	TRIS	PORTA		;1      output per i grigi

	MOVFW	CEL_T1		;   118
	INCF	CEL_X2,1	;
	BTFSC	CEL_X2,4	;
	ADDWF	CEL_X1,1	;
	BTFSC	CEL_X2,4	;
	CLRF	CEL_X2		;
	NOP			;    124

	DECFSZ	CNT_0,1		;1-2 125
	GOTO	SC_BARRE_0		;2   127
	RETURN			;  2 128	
;*****************************************************************
;	DISPLAY: mette sul video i caratteri prendendoli 
;                dalla EEPROM
;*****************************************************************  
F_DISPLAY
	CALL	SINCK		;14  18
	BTFSC	FLAG,3		;
	GOTO	IS_DSY		; (21)
	NOP	
IF_DSY				; 21
	movlw	D'1'		;1      pongo in uscita il valore 15
	btfsc	F_PORTA,7	;1
	movlw	D'15'		;1      pongo in uscita il valore 15
	iorwf	PORTA,1		;1  25


	CALL	RIT_5		;5


	MOVLW	B'000000'	;1  31     Port_A definisco gli
	TRIS	PORTA		;1  32    output per i grigi

	CALL	RIT_6		;

	MOVFW	COLORE		;1
	ANDLW	B'00001110'	;1      in dispe
	movwf	DISPE		;1  
	BSF	DISPE,0		;1

	movfw	F_PORTA		;1      bianco (parto 15 e sommo -2 ) 
	addwf	PORTA,1		;1  44	

	MOVLW	D'1'		;       ritardo	
	CALL	RIT_P2		;10    

	MOVF	DISPE,W		;1
	MOVWF	PORTA		;1  56

	MOVLW	D'7'		;1        Numero di punti per carattere
	MOVWF	CNT_0		;1        metto in CNT_0 
	MOVLW	H'0FF'		;1        numero di linea del carattere
	MOVWF	CNT_R		;1  60   in display

	MOVLW	D'11'		;       ritardo	
	CALL	RIT_P2		;40 100   


	movlw	D'1'		;1      pongo in uscita il valore 1
	btfsc	F_PORTA,7	;1
	movlw	D'3'		;1      pongo in uscita il valore 3 blu
	movwf	PORTA		;1  104 output per i grigi

	CALL	RIT_5		;5
	CALL	RIT_5		;5    

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1 116  output per i grigi

	MOVLW	D'2'		;       ritardo	
	CALL	RIT_P0		;11    127
				
F_INCLIN
	MOVFW	F_LINEE		;	128           #########
	MOVWF	CNT_1		;	1	linee per punto
	INCF    CNT_1,1         ;1  	2

	CALL	DSINCK		;16	18
	INCF    CNT_R,1         ;1  		inc riga per prossimo giro

	movlw	D'1'		;1      pongo in uscita il valore 1
	btfsc	F_PORTA,7	;1
	movlw	D'15'		;1      pongo in uscita il valore 15
	iorwf	PORTA,1		;1 23

	CALL	RIT_5		;5
	MOVF    PCF0,W          ;1  	
	MOVWF	PCLATH		;1


	MOVLW	B'00000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  32    output per i grigi

	MOVF    CF0,W           ;1  	Prendo Il carattere lo sommo alla 
	CALL    Table	        ;7 	riga e vado a prendere il segmento
	MOVWF   Ta0             ;1  	equivalente lo metto in ram

	NOP			;

	movfw	F_PORTA		;1      bianco (parto 15 e sommo -2 ) 
	addwf	PORTA,1		;1  44	

	MOVLW	D'1'		;       ritardo	
	CALL	RIT_P2		;10    

	MOVF	DISPE,W		;1
	MOVWF	PORTA		;1  56


	MOVF    PCF1,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CF1,W           ;1  	Prendo Il carattere lo sommo alla 
	CALL    Table           ;7 	riga e vado a prendere il segmento
	MOVWF   Ta1             ;1  	equivalente lo metto in ram


	MOVF    PCF2,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CF2,W           ;1  	Prendo Il carattere lo sommo alla 
	CALL    Table           ;7 	riga e vado a prendere il segmento
	MOVWF   Ta2             ;1  	equivalente lo metto in ram

	MOVF    PCF3,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CF3,W           ;1
	CALL    Table           ;7
	MOVWF   Ta3             ;1  

	MOVF    PCF4,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CF4,W           ;1
	CALL    Table           ;7
	MOVWF   Ta4             ;1  100

	movlw	D'1'		;1      pongo in uscita il valore 1
	btfsc	F_PORTA,7	;1
	movlw	D'3'		;1      pongo in uscita il valore 3 blu
	movwf	PORTA		;1  104 output per i grigi

	MOVF    PCF5,W          ;1  	
	MOVWF	PCLATH		;1

	CALL	RIT_8		;8

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1  116    output per i grigi

	MOVF    CF5,W           ;1
	CALL    Table           ;7
	MOVWF   Ta5             ;1  125

F_SLINE
	CALL	RIT_7		;7  128 4
	CALL	SINCK		;14 18 

	movlw	D'1'		;1      pongo in uscita il valore 1
	btfsc	F_PORTA,7	;1
	movlw	D'15'		;1      pongo in uscita il valore 15
	iorwf	PORTA,1		;1  22

	CALL	RIT_8		;8

	MOVLW	B'00000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  32   output per i grigi

	MOVLW	D'1'		;       ritardo	
	CALL	RIT_P2		;10    

	movfw	F_PORTA		;1      bianco (parto 15 e sommo -2 ) 
	addwf	PORTA,1		;1  44	

	MOVLW	D'1'		;       ritardo	
	CALL	RIT_P2		;10    

	MOVF	DISPE,W		;1
	MOVWF	PORTA		;1  56
	
	DNOP			;   58

 	MOVF    Ta0,W           ;1	Carac 1
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7 

	MOVF    Ta1,W           ;1	Carac 2
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta2,W           ;1	Carac 3
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta3,W           ;1	Carac 4
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta4,W           ;1	Carac 5
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta5,W           ;1	Carac 6
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7  100


	movlw	D'1'		;1      pongo in uscita il valore 1
	btfsc	F_PORTA,7	;1
	movlw	D'3'		;1      pongo in uscita il valore 3 blu
	movwf	PORTA		;1  104 output per i grigi

	CALL	RIT_5		;5
	CALL	RIT_5		;5    

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1  116    output per i grigi

	CALL	RIT_6		;10    

	DECFSZ  CNT_1,1		;1-2  123  124
	GOTO    F_SLINE		;2    125       
	DECFSZ  CNT_0,1		;1-2  125  126
	GOTO    F_INCLIN		;2    127		

; 	RETURN                  ;2         128

	DNOP			;
	CALL	FONDO_DSY	;
	GOTO	FONDO_DSY	;

;*****************************************************************
;	DISPLAY: mette sul video i caratteri prendendoli 
;                dalla EEPROM
;*****************************************************************  
;
DISPLAY
	CALL	SINCK		;14  18

	BTFSC	FLAG,2		;
	GOTO	IF_DSY		; (21)
	NOP	
IS_DSY:				;21
	MOVLW	D'7'		;1        Numero di punti per carattere
	MOVWF	CNT_0		;1        metto in CNT_0 
	MOVLW	H'0FF'		;1        numero di linea del carattere
	MOVWF	CNT_R		;1  25  in display

	DNOP			;2
	NOP			;1

	SWAPF	COLORE,W	;1      per eseguire swap
	ANDLW	B'00001110'	;1      in dispe
	MOVWF	DISPE		;1  
	BSF	DISPE,0		;1

	MOVF	DISPE,W		;1
	IORWF	PORTA,1		;1  34
	MOVLW	B'000000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  36  output per i grigi

	MOVLW	D'27'		;       ritardo	
	CALL	RIT_P0		;86  122

	NOP			;1
	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1   125   output per i grigi
	DNOP			;1   127
	NOP			;1   128			
INCLIN
	NOP			;1	1
	MOVFW	S_LINEE		;	2	           #########
	MOVWF	CNT_1		;	3	linee per punto
	INCF    CNT_R,1         ;1  	4	inc riga per prossimo giro

	CALL	SINCK		;14	18
	INCF    CNT_1,1         ;1  	

	MOVF    PCA0,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CA0,W           ;1  	Prendo Il carattere lo sommo alla 
	CALL    Table         	;7 	riga e vado a prendere il segmento
	MOVWF   Ta0             ;1  	equivalente lo metto in ram

	MOVF    PCA1,W          ;1  	
	MOVWF	PCLATH		;1

	MOVF	DISPE,W		;1
	IORWF	PORTA,1		;1  34

	MOVLW	B'000000'	;1      Port_A definisco gli
	TRIS	PORTA		;1      output per i grigi

	MOVF    CA1,W           ;1
	CALL    Table           ;7
	MOVWF   Ta1             ;1  

	MOVF    PCA2,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CA2,W           ;1
	CALL    Table           ;7
	MOVWF   Ta2             ;1  

	MOVF    PCA3,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CA3,W           ;1
	CALL    Table           ;7
	MOVWF   Ta3             ;1  

	MOVF    PCA4,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CA4,W           ;1
	CALL    Table           ;7
	MOVWF   Ta4             ;1  
 
	MOVF    PCA5,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CA5,W           ;1 
	CALL    Table           ;7 
	MOVWF   Ta5             ;1  

	MOVF    PCA6,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CA6,W           ;1
	CALL	Table		;7
	MOVWF   Ta6             ;1  

	MOVF    PCA7,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CA7,W           ;1
	CALL	Table		;7
	MOVWF   Ta7             ;1  

	MOVF    PCA8,W          ;1  	
	MOVWF	PCLATH		;1
	MOVF    CA8,W           ;1
	CALL	Table		;7
	MOVWF   Ta8             ;1 (86) 122
	NOP			;1  123

SLINE
	MOVLW	B'01110'	;1  124    Port_A definisco gli
	TRIS	PORTA		;1  125    output per i grigi

	CALL	RIT_7		;7  128 4
	CALL	SINCK		;14  18 

	MOVLW	D'3'		;       ritardo	
	CALL	RIT_P0		;14 

	MOVF	DISPE,W		;1
	IORWF	PORTA,1		;1  34
	MOVLW	B'000000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  36    output per i grigi

	BTFSS	Count3,5		;  |
	CALL	RIT_5		;   |
	BTFSC	Count3,4		;    |    in testa e in coda 
	GOTO	RITCAR1		;     |  per lo scorrimento a pixel
	DNOP			;      ) due volte vale 17
	NOP			;     |
RITCAR1	BTFSS	Count3,3		;    |
	DNOP			;   |  ES ( 10+7 )
				;46

 	MOVF    Ta0,W           ;1	Carac 1
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta1,W           ;1	Carac 2
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta2,W           ;1	Carac 3
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta3,W           ;1	Carac 4
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta4,W           ;1	Carac 5
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta5,W           ;1	Carac 6
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta6,W           ;1	Carac 7
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta7,W           ;1	Carac 8
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 7

	MOVF    Ta8,W           ;1	Carac 9
	MOVWF   PORTB           ;1  
	RLF     PORTB,1         ;1
	RLF     PORTB,1         ;1  
	RLF     PORTB,1         ;1 
	RLF     PORTB,1         ;1
	CLRF    PORTB           ;1 109

	BTFSC	Count3,5		;  |
	CALL	RIT_5		;   |
	BTFSS	Count3,4		;    |    in testa e in coda 
	GOTO	RITCAR2		;     |  per lo scorrimento a pixel
	DNOP			;      ) due volte vale 21
	NOP			;     |
RITCAR2	BTFSC	Count3,3		;    |
	DNOP			; 11 |  ES ( 10+11 )
				;   120

	DECFSZ  CNT_1,1		;1-2  12
	GOTO    SLINE		;2    123       

	NOP			;1
	MOVLW	B'01110'	;1  124    Port_A definisco gli
	TRIS	PORTA		;1  125    output per i grigi

	DECFSZ  CNT_0,1		;1-2  
	GOTO    INCLIN		;2    128		
	
	NOP
	CALL	DIS_LINE	;  130  2  

	DNOP			;2   2
DIS_LINE
	CALL	DSINCK 	;16  18

	MOVLW	D'3'		;       ritardo	
	CALL	RIT_P0		;14 32

	MOVF	DISPE,W		;1
	IORWF	PORTA,1		;1  34
	MOVLW	B'000000'	;1      Port_A definisco gli
	TRIS	PORTA		;1  36  output per i grigi

	MOVLW	D'27'		;       ritardo	
	CALL	RIT_P1		;87  123

	MOVLW	B'01110'	;1      Port_A definisco gli
	TRIS	PORTA		;1      output per i grigi
	NOP			;1
 	RETURN                  ;2  128


;*********************************************************************
;       PULSANTI: lettura dei comandi eseguiti tramite pulsanti
;         STATO_0  set colori dimensioni e quadro
;         STATO_1  modifica della scritta scorrevole
;         STATO_2  modifica della scritta fissa 
;         STATO_3  cambio velocita di scorrimento scritta
;*********************************************************************
;
PULSANTI
	CALL	DSINCK		;   18

	BTFSC   PORTB,5         ;1       in funzione dell'interrutore WR
	CLRF	STATO		;1       Impongo lo stato da eseguire
	BTFSS   PORTB,5         ;1 	
	BSF	STATO,1		;1
	BSF	STATO,0		;1  23

	BTFSC   STATO,3         ;1       verifico in che stato sono
	GOTO    STATO_3         ;2  26   vado velocit E tono

	BTFSC   STATO,2         ;1       verifico in che stato sono
	GOTO    STATO_2         ;2  28   cambio scritta fissa

	BTFSC   STATO,1         ;1       verifico in che stato sono
	GOTO    STATO_1         ;2  30   cambio scritta scorrevole

;*********************************************************************
;	STATO 0    scelta X display    ora/scritta/alternanza
;*********************************************************************
;
STATO_0				;   29
	CALL	TASTO_P		;14       tasto premuto
	SKIPSZ                  ;1       no esco 
	GOTO    PULFIN          ;   46   

	MOVF    PORTB,W         ;1  46 65   verifico se pulsanti entrambi
	ANDLW   B'11000000'     ;1       premuti se si vado in STATME
	SKIPNZ                  ;1
	GOTO    STATO_9         ;2  50 69  se si salto a memorizzazione
	GOTO	STATO_8		;2  51 70

;*********************************************************************
;
PULFIN				;  46
	CLRF    STATO           ;
	MOVLW	C_BLOCK		; carBL
	MOVWF   CNTCA           ;
	CLRF    PUNCA           ;  50

	MOVLW	D'23'		;
	CALL	RIT_P2		;76 126   ritardo per sincronizzare
	RETURN			;2  128


;*********************************************************************
;
STATO_8				;   51
	BTFSC	Count2,6	;1         verifico se e giro di OLD
	GOTO	STATO_8B	;1-2

	MOVLW	ECOLORE		;1        leggo cella per determinare 
	CALL	EEREADWN	;12 66    il colore di fondo
	BTFSC   PORTB,7         ;1
	SWAPF	CEEDATA,1	;1
	BCF	CEEDATA,3	;1
	INCF	CEEDATA,1	;1
	BTFSC	PORTB,7		;1
	SWAPF	CEEDATA,1	;1 72  

	MOVLW	D'9'		;
	CALL	RIT_P1		;33 105
	GOTO    STATO_XX        ;2  107	

STATO_8B			;   54
	BTFSC   PORTB,7         ;1  
	INCF	S_LINEE,1	;1   
	BTFSS	PORTB,7		;1
	INCF	F_LINEE,1	;1  58

	MOVFW	S_LINEE		;1
	SUBLW	D'3'		;1
	MOVLW	D'0'		;1
	BTFSS	STATUS,C	;1
	MOVWF	S_LINEE		;1  

	MOVFW	F_LINEE		;1
	SUBLW	D'3'		;1
	MOVLW	D'0'		;1
	BTFSS	STATUS,C	;1
	MOVWF	F_LINEE		;1  68

	SWAPF	S_LINEE,W	;1

	IORWF	F_LINEE,W	;1
	MOVWF	CEEDATA		;1
	MOVLW	SIZLINE		;1
	MOVWF	CEEADR		;1  73

	MOVLW	D'9'		;
	CALL	RIT_P0		;32  105
	
	GOTO	STATO_XX	;2  107



;*********************************************************************
;
STATO_9  			;    50  
	MOVLW	D'14'		;
	CALL	RIT_P1		;48  98

	incf	F_FRAME		;1   99
	movlw	B'00001111'	;1
	andwf	F_FRAME,1	;1
	movfw	F_FRAME		;1
	MOVWF	CEEDATA		;1

	BTFSC	AUTO,0		;
	BSF	CEEDATA,4	;

	MOVLW	NUFRAME		;1
	MOVWF	CEEADR		;1  107

STATO_XX
	CALL	MEM_EEP		;19 126
	GOTO    FINATT          ;2  128



;*********************************************************************
;STATO_X   ( per stato 1-2 ) cambio scritta scorrevole e fissa
;*********************************************************************
;
STATO_2				;   28
	MOVLW   PRIMFIS		;       1 carattere scritta fissa
	MOVWF   Ptrtxt          ;

STATO_1				;   30
	CLRF    Count3          ;1      blocco la scritta scorrevole  

	MOVLW	D'8'		;1
	BTFSS	STATO,2		;1	stato diverso da 2 PUNCA = 0
	MOVWF	PUNCA		;1  34	

	CALL	TASTO_P		;14 48   tasto premuto
	SKIPSZ                  ;1      
	GOTO    STAT1_A1        ;   51  se no salto 

	MOVF    PORTB,W         ;   
	ANDLW   B'11000000'     ;       pulsanti entrambi pigiati   
	SKIPNZ                  ;
	GOTO    STORCAR         ;   55  se si salto a memorizzazione

	CALL	NEW_SCELTA_CA	;20 84  rit con carattere in TABCA

STAT1_A2			;74

	CALL NEW_CONVER         ;24 98


	BCF	STATUS,0	;1
	RLF	PUNCA,W		;1
	MOVWF	TIME		;1

	MOVLW	PCA0		;1	preparo il puntatore alla
	ADDWF	TIME,W		;1  	cella per dislplay

	MOVWF   FSR             ;1	punto alla tabella display
	MOVF    CELLAX,W        ;1	e metto il nuovo carattere
	MOVWF   INDF            ;1  

	INCF	FSR,1		;1
	MOVFW   TABCA		;1
	MOVWF   INDF            ;1  

	MOVLW	D'4'		;
	CALL	RIT_P0		;17 126		ritardo 
	RETURN			;2  128

STAT1_A1			; 51
	MOVLW	D'5'		;
	CALL	RIT_P1		;21 
	GOTO	STAT1_A2	;2  74

;*********************************************************************
;         Memorizzazione e cambio stato
;*********************************************************************
;
STORCAR				;   55
	MOVF    Ptrtxt,W        ;1  
	ADDWF   PUNCA,W         ;1      memorizzazione del puntatore
	MOVWF   CEEADR          ;1      tabella caratteri in eeprom

	XORLW	H'77'		;1  	 ultima cella di scrittura
	SKIPSZ                  ;1      se non  ultima cella 
	INCF    Ptrtxt,1        ;1      incremento il puntatore Ptrtxt
	SKIPSZ			;1      e il PUNCA
	INCF	PUNCA,1		;1  63


	MOVFW	CNTCA		;1     sommo 20h per rendere in ascii 
	ADDLW	H'20'		;1     il valore da memorizzare
	MOVWF	CEEDATA		;1

	XORLW   C_BLOCK+20      ;1     verifico se  ascii 81 block 
				;      se si non memorizzo e ...
	SKIPNZ			;1	verifico se  il BLOC se si
	CLRF	PUNCA		;1	azzero PUNCA

	SKIPNZ                  ;1   
	RLF	STATO,1         ;1   	cambio stato e non memorizzo
	SKIPSZ			;1  72	
	CALL    MEM_EEP         ;19 91   

	MOVLW	C_BLOCK		;1
	MOVWF	CNTCA		;1	azzero PUNCA

	MOVLW	D'10'		;       ritardo sincronizzazione riga
	CALL	RIT_P0		;35 128
;----------------------------------------------
FINATT				;     25 riga
	MOVLW	D'100'		;100 125       Ritardo per poter scrivere
	MOVWF	CNT_0		;           la EEPROM a bordo del PIC
	CALL	BLKLINE		;           nessuna operazione su EEPROM
	MOVLW	D'179'		;179 304        Ritardo per poter scrivere
	MOVWF	CNT_0		;           la EEPROM a bordo del PIC
	CALL	BLKLINE		;           nessuna operazione su EEPROM

	GOTO	INCTIM		;1   305        per almeno 14 milli secondi

;*********************************************************************
;   STATO_3   cambio velocit di scorrimento scritta
;*********************************************************************
;
STATO_3				;   26
	MOVLW	EDISPE		;1      leggo cella per determinare 
	CALL	EEREADWN	;12 39   e variare la velocit 

	CALL	TASTO_P		;14 53    tasto premuto
	SKIPSZ                  ;1       se  premuto salto   
	GOTO	STATO_31	;1   (56)  altrimenti esco

	MOVF	CEEDATA,W       ;1  
	ADDWF	CEEDATA,1	;1      se premuto raddoppio il valore

	MOVLW	B'00000111'	;1      verifico che il valore 
	ANDWF	CEEDATA,W	;1      dopo AND non sia zero

	MOVLW	D'1'		;1      se il valore era zero
	SKIPNZ                  ;1      carico 1 altrimenti skip
	MOVWF	CEEDATA		;1  62
	
	MOVLW	D'13'		;        
	CALL	RIT_P1		;45  107

	CALL    MEM_EEP         ;19  126        MEMORIZZA
	GOTO	FINATT 		;2   128	ritardo per memorizzare
	
STATO_31			; (56)
	MOVLW	D'21'		;        
	CALL	RIT_P2		;70  126

	RETURN			;2   128	
;---------------------------------------------------------------------
MEM_EEP  
	MOVF	CEEDATA,W	; 1
	BSF     STATUS,RP0      ; 2
	MOVWF	EEDATA		; 3

	BCF     STATUS,RP0      ; 4

	MOVF	CEEADR,W	; 5
	BSF     STATUS,RP0      ; 6
	MOVWF	EEADR		; 7

	BSF     EECON1,WREN     ; 8
	MOVLW   055             ; 9
	MOVWF   EECON2          ; 10      MEMORIZZAZIONE EEPROM
	MOVLW   0AA             ; 11
	MOVWF   EECON2          ; 12    
	BSF     EECON1,WR       ; 13
	BCF     EECON1,WREN     ; 14

	BCF     STATUS,RP0      ; 15

	RETURN                  ; 17

;*********************************************************************
;	Scelta del carattere in modo circolare e .... 
;        ....
;*********************************************************************
;
NEW_SCELTA_CA
	BTFSC   PORTB,7         ;1
	INCF	CNTCA,1		;1	incremento carattere
	BTFSC   PORTB,6         ;1
	DECF	CNTCA,1		;1  4   decremento carattere
 
	MOVF    CNTCA,W         ;1     
	XORLW   H'FF'          ;1  
	MOVLW	NUM_CAR		;1
	SKIPNZ			;1
	MOVWF	CNTCA		;1  9

	MOVF    CNTCA,W         ;1     
	XORLW   NUM_CAR +1	;1      verifico se fondo scala 
	SKIPNZ                  ;1      o inizio
	CLRF	CNTCA		;1  13

	MOVLW   D'83'           ;1  14  velocita di cambio carattere
	BTFSC	Count2,6	;1
	MOVWF   Count2          ;1  16
	RETURN			;2  18


;*********************************************************************
;   CONVER  converto il numero nel puntatore alla tabella
;*********************************************************************
NEW_CONVER:
	MOVLW	D'5'		;1
	MOVWF	CELLAX		;1 

	MOVFW	CNTCA		;1
	ADDLW	H'D5'		;1
	SKIPNC			;1
	INCF	CELLAX,1	;1

	MOVFW	CNTCA		;1
	ADDLW	H'AE'		;1
	SKIPNC			;1
	INCF	CELLAX,1	;1 10

	MOVLW   HIGH Tasci_Tspe ;1      
	MOVWF   PCLATH          ;1      
	MOVF    CNTCA,W         ;3
	CALL    Tasci_Tspe      ;6     converto da ascii in speciale
	MOVWF   TABCA           ;1
	RETURN                  ;2 24


;*********************************************************************
;	Sistema la flag se il tasto  premuto e ha superato la 
;       soglia di attivazione normale e old  ( incremento ogni 20mS )
;*********************************************************************
;
TASTO_P
	COMF    PORTB,w         ;1       
	ANDLW   B'11000000'     ;1      vedo se  premuto un dei due 
	MOVLW	D'42'		;1
	SKIPNZ                  ;1      o entrambi i tasti se si skip
	MOVWF   Count2          ;1      non premuti faccio clear 
	INCF    Count2,1        ;1  6   contatore di quadri e increm 

	MOVLW	D'50'		;1      tempo prima di servire la pigiata
	BTFSC	Count2,6	;1	testo se 1 vota o seconda
	MOVLW	D'90'		;1	tempo per considerare old la pigiata
	XORWF   Count2,W        ;1      verifico se count e arrivato
	RETURN                  ;2  12  

;*******************************************************
;    Incremento orologio 
;*******************************************************
INCTIME:
	CALL	DSINCK		;16  18

	MOVLW	D'27'		;
	CALL	RIT_P0		; 86  104

	MOVLW   HIGH T_LINEE    ;1       Linee di giustificazione
	MOVWF   PCLATH          ;1       per dimensione scritta

	MOVFW	S_LINEE		;1  
	CALL	T_LINEE		;6
	MOVWF	S_BLINEE	;1  114
	  
	MOVFW	F_LINEE		;1  
	CALL	T_LINEE		;6
	MOVWF	F_BLINEE	;1  122

	MOVFW	F_FRAME		;1
	ANDLW	B'00001111'	;1  
	GOTO	T_GOTO		;6  128  2

;*******************************************************
;	prepara le celle da displeiare
;*******************************************************
PREREAD CALL	DSINCK		;   18
	MOVLW   EDISPE		;1
	CALL    EEREADWN        ;12 31   estraggo da EEPROM la cella
				;        per la velocit o no ????
	MOVWF	DISPE		;1       la metto in DISPE
	ANDLW	B'00000111'	;1       
				
	ADDWF	Count3,1	;1       e la sommo a Count3
	MOVF	Count3,W	;1

	ADDLW   -D'56'          ;*1  36	numero di quadri (20mS quadro)
	SKIPNC                  ;*1-2    per velocita scorrimento 
	CLRF	Count3          ;*  39	scritta al primo ingresso
 	SKIPNC                  ;*	partenza per arrivare a ...
	INCF    Ptrtxt,1        ;*1  40

	MOVF	Ptrtxt,W	;1  41   puntatore all'ultimo carattere +8
	ADDLW	-ULTICIR	;1      se si azzero puntatore
	MOVLW	-D'8'		;1
	SKIPNZ			;1
	MOVWF	Ptrtxt		;1  	
	MOVF    Ptrtxt,W        ;1  46
	CALL	EEREADWN	;12 58

	MOVLW	-D'8'		;1      del messaggio
	BTFSC	CEEDATA,7	;1      se no salto .. altrimenti
	MOVWF   Ptrtxt          ;1  61	pongo puntatore a -8

	BTFSC	CEEDATA,7	;1   ROTAZIONE AUTOMATICA DEI QUADRI
	BSF	AUTO,1		;1   O FRAME AD OGNI FINE SCRITTA
	MOVFW	AUTO		;1   SE AUTO=1
	ADDLW	H'FD'		;1
	SKIPNZ			;1
	INCF	F_FRAME,1	;1
	BCF	AUTO,1		;1

	MOVLW	D'17'		;
	CALL	RIT_P0		;56

	MOVF    Ptrtxt,W        ;1  125
				;   125
	MOVWF   CEEADR          ;1      metto puntatore carattere in 
	MOVLW   PCA0		;1	puntatore al segmento
	MOVWF   FSR             ;1  128	inizio tabella CA
PREREA:
;---------------------------------------------------- NUOVA LINEA
	CALL	LETT_2		;
;---------------------------------------------------- NUOVA LINEA
	CALL	LETT_2 		;
;---------------------------------------------------- NUOVA LINEA
	CALL	LETT_2 		;
;---------------------------------------------------- NUOVA LINEA
	CALL	LETT_2 		;
;---------------------------------------------------- NUOVA LINEA
	GOTO	LETT_2 		;

;**************************************************************
;	Prepara riga per display ore o scritta
;**************************************************************
PREPH   CALL	DSINCK		;  18

	MOVLW	D'28'		;
	CALL	RIT_P1		;90 108

	MOVLW   ECOLORE         ;1   
	CALL    EEREADWN        ;12 	leggo la parola di controllo da
	RLF	CEEDATA,W	;1      i bit di colore e li pongo
	MOVWF	COLORE		;

	MOVLW	PRIMFIS		;1     puntatore a scritta fissa
	MOVWF   CEEADR          ;1      metto puntatore carattere in 

	MOVLW   PCF0		;1	puntatore al segmento
	MOVWF   FSR             ;1  	inizio tabella CA
	GOTO	PREREA		;2 128

;*******************************************************
;	lettura dato in eeprom
;*******************************************************
LETT_2
	CALL	DSINCK		;16 18

	MOVLW   HIGH Tasci_Tspe      ;1      Punto alla tabella 
	MOVWF   PCLATH          ;1      

	CALL    EEREAD          ;53 73	leggo  carattere
	CALL    EEREAD          ;53 126	leggo  carattere

	RETURN                  ; 128
;---------------------------------------------------- 
EEREAD
	CALL	LETTU		;11	lettura della eeprom

	NOP			;1
	BTFSC	CEEDATA,7	;1       verifico se fine caratteri
	BSF	CEEADR,7        ;1       setto sempre carattere 20h
	MOVFW	CEEDATA		;1

	BTFSC	CEEADR,7	;1	se sono fine frase impongo 20h	
	MOVLW	H'20'		;1	corriosponde allo space
	ADDLW	H'E0'		;1

	MOVWF	CEEDATA		;1     verifico se il codice  fuori range
	ADDLW	-NUM_CAR+1		;1
	SKIPNC			;1
	CLRF	CEEDATA		;1

	MOVLW	D'5'		;1
	MOVWF	CELLAX		;1  24

	MOVFW	CEEDATA		;1
	ADDLW	H'D5'		;1
	SKIPNC			;1
	INCF	CELLAX,1	;1

	MOVFW	CEEDATA		;1
	ADDLW	H'AE'		;1
	SKIPNC			;1
	INCF	CELLAX,1	;1

	MOVFW	CELLAX		;1
	MOVWF   INDF            ;1       metto dato a indirizzo
	INCF    FSR,1           ;1  35     puntato da FSR

	MOVFW	CEEDATA		;1
	CALL    Tasci_Tspe      ;6  42   converto da ascii in speciale

	MOVWF   INDF            ;1       metto dato a indirizzo
	INCF    FSR,1           ;1       puntato da FSR
	INCF    CEEADR,1        ;1

	CALL	RIT_4		;4
	RETURN                  ;2 51

EEREADWN
	MOVWF   CEEADR		;1      lettura della eeprom
LETTU
	MOVF	CEEADR,W	;2
	BSF     STATUS,RP0      ;3      alla cella puntata

	MOVWF	EEADR		;4
	BSF	EECON1,RD	;5      dal W prima della chiamata
	MOVF    EEDATA,W        ;6      ritorno dato in accumulatore

	BCF     STATUS,RP0      ;7
	MOVWF	CEEDATA		;8
	RETURN                  ;9

;=======================================================
;===================================================
	org 4E0
T_GOTO:
	ADDWF   PCL,F

	GOTO	F_BGFS		;eseguo quadro 0 
	GOTO	F_BGF		;eseguo quadro 1 
	GOTO	F_BGS		;eseguo quadro 2 
	GOTO	F_BG		;eseguo quadro 3 

	GOTO	F_BMSF		;eseguo quadro 4 
	GOTO	F_BMFS		;eseguo quadro 5 
	GOTO	F_BMS		;eseguo quadro 12
	GOTO	F_BMF		;eseguo quadro 13

	GOTO	F_SMSF		;eseguo quadro 6 
	GOTO	F_SMFS		;eseguo quadro 7 
	GOTO	F_BDSF		;eseguo quadro 8 
	GOTO	F_BDFS		;eseguo quadro 9 

	GOTO	F_SDSF		;eseguo quadro 10 
	GOTO	F_SDFS		;eseguo quadro 11 

	GOTO	F_BDS		;eseguo quadro 14
	GOTO	F_BDF		;eseguo quadro 15


T_LINEE:
	ADDWF   PCL,F
	RETLW   H'16'	;  22linee differenza per dimensione carattere
	RETLW   H'0F'	;  15linee differenza per dimensione carattere
	RETLW   H'08'	;  08linee differenza per dimensione carattere
	RETLW   H'01'	;  01linee differenza per dimensione carattere

;*********************************************************************
;       TABELLA definizione matrice dei caratteri
;*********************************************************************  
;-- !"#$%&'()*+,-./ 0123456789:;<=>?ABCDEFGHIJ
	org 500
;
; Table of caracters
Table	ADDWF	CNT_R,W		;
	ADDWF	PCL,F		;
Tbase   equ     $
Car21	equ     $-Tbase
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
Car2B	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
Car2A	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00000100'     ; .....*..
Car2D	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00011111'     ; ...*****
Car2C	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
Car27	equ     $-Tbase
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
CarSP	equ     $-Tbase
Car20	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
CarPU	equ     $-Tbase
Car2E	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
CarDP	equ     $-Tbase
Car3A	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00001100'     ; ....**..
CarPV	equ     $-Tbase
Car3B	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00000000'     ; ........
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
Car23	equ     $-Tbase
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00011111'     ; ...*****
Car22	equ     $-Tbase
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
Car25	equ     $-Tbase 
	RETLW   B'00011000'     ; ...**...
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00010011'     ; ...*..**
	RETLW   B'00000011'     ; ......**
CarSL	equ     $-Tbase
Car2F	equ     $-Tbase
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
Car24	equ     $-Tbase
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001111'     ; ....****
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000101'     ; .....*.*
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00000100'     ; .....*..
Car26	equ     $-Tbase
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00001101'     ; ....**.*

Car28	equ     $-Tbase
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...
Car29	equ     $-Tbase
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
Car3C	equ     $-Tbase
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
Car3E	equ     $-Tbase
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
Car3F	equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
Car3D	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000000'     ; ........
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
Car4    equ     $-Tbase
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000110'     ; .....**.
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
Car7    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
Car1    equ     $-Tbase
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
Car0    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010011'     ; ...*..**
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00010001'     ; ...*...*
Car2    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
Car5    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
Car3    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ;....*...*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000110'     ; .....**.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
Car6    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
Car8    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
Car9    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001111'     ; ....****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*

;================================================

CarCH	equ     $-Tbase
	RETLW   B'00001110'     ; ....***.  @
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00001101'     ; ....**.*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010101'     ; ...*.*.*
CarA    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011111'     ; ...*****
CarH    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarD    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarB    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
CarE    equ     $-Tbase
	RETLW   B'00011111'     ; ...***** 
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00011100'     ; ...***..
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarF    equ     $-Tbase
	RETLW   B'000011111'     ; ...***** 
	RETLW   B'000010000'     ; ...*....
	RETLW   B'000010000'     ; ...*....
	RETLW   B'000011100'     ; ...***..
	RETLW   B'000010000'     ; ...*....
	RETLW   B'000010000'     ; ...*....
	RETLW   B'000010000'     ; ...*....
CarJ    equ     $-Tbase
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
CarC    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010001'     ; ...*...*
CarI    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
CarG    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010011'     ; ...*..**
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.

;-- !"#$%&'()*+,-./ 0123456789:;<=>?ABCDEFGHIJ
;================================================
;--KLMNOPQRSTUVWXYZ[\]^abcdefghijklmnopq

	ORG 600
CarU    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarO    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarQ    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010011'     ; ...*..**
CarS    equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
CarP    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarK    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00011000'     ; ...**...
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00010010'     ; ...*..*.
CarM    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011011'     ; ...**.**
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarN    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010011'     ; ...*..**
CarY    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
CarR    equ     $-Tbase
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00010001'     ; ...*...*
CarV    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
CarX    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001010'     ; ....*.*.
CarW    equ     $-Tbase
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00011011'     ; ...**.**
	RETLW   B'00010001'     ; ...*...*
CarL    equ     $-Tbase
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
CarZ    equ     $-Tbase
	RETLW   B'00011111'     ; ...***** 
	RETLW   B'00000001'     ; ...... *
	RETLW   B'00000010'     ; ..... *.
	RETLW   B'00000100'     ; .... *..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00010000'     ; ...*....
CarT    equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
Car5C	equ     $-Tbase
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
Car5B	equ     $-Tbase
	RETLW   B'00001110'     ; ....***.  
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...

Car5D	equ     $-Tbase
	RETLW   B'00001110'     ; ....***.  
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00001110'     ; ....***.
Car5E	equ     $-Tbase
	RETLW   B'00000100'     ; .....*..  
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00010001'     ; ...*...*
Car5F	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00011111'     ; ...*****

;=============================================================

Car60	equ     $-Tbase
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
Car61	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00001111'     ; ....****
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001111'     ; ....****
Car62	equ     $-Tbase
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010110'     ; ...*.**.
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
Car63	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car64	equ     $-Tbase
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*
	RETLW   B'00001101'     ; ....*..*
	RETLW   B'00010011'     ; ...*..**
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001111'     ; ....****
Car65	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001110'     ; ....***.
Car66	equ     $-Tbase
	RETLW   B'00000110'     ; .....**.
	RETLW   B'00001001'     ; ....*..*
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00011100'     ; ...***..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...
Car67	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00001111'     ; ....****
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001111'     ; ....****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00001110'     ; ....***.
Car68	equ     $-Tbase
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010110'     ; ...*.**.
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
Car69	equ     $-Tbase
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000000'     ; ........
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001110'     ; ....***.
Car6A	equ     $-Tbase
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000000'     ; ........
	RETLW   B'00000110'     ; .....**.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00010010'     ; ...*..*.
Car6C	equ     $-Tbase
	RETLW   B'00001100'     ; ....**..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001110'     ; ....***.
Car6B	equ     $-Tbase
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010010'     ; ...*..*.
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00011000'     ; ...**...
	RETLW   B'00010100'     ; ...*.*..
	RETLW   B'00010010'     ; ...*..*.
Car6D	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00011010'     ; ...**.*.
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
Car6E	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00010110'     ; ...*.**.
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
Car6F	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001110'     ; ....***.
Car70	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00011110'     ; ...****.
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
Car71	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00001101'     ; ....**.*
	RETLW   B'00010011'     ; ...*..**
	RETLW   B'00001111'     ; ....****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00000001'     ; .......*

;--KLMNOPQRSTUVWXYZ[\]^abcdefghijklmnopq
;================================================
;--rstuvwxyz
	ORG 700

Car72	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00010110'     ; ...*.**.
	RETLW   B'00011001'     ; ...**..*
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00010000'     ; ...*....
Car73	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010000'     ; ...*....
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00000001'     ; .......*
	RETLW   B'00011110'     ; ...****.
Car74	equ     $-Tbase
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00011100'     ; ...***..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00001001'     ; ....*..*
	RETLW   B'00000110'     ; .....**.
Car75	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010011'     ; ...*..**
	RETLW   B'00001101'     ; ....**.*
Car76	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000100'     ; .....*..
Car77	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00010101'     ; ...*.*.*
	RETLW   B'00001010'     ; ....*.*.
Car78	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00010001'     ; ...*...*
Car79	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001111'     ; ....****
	RETLW   B'00000001'     ; .......*
	RETLW   B'00001110'     ; ....***.
Car7A	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000000'     ; ........
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00011111'     ; ...*****
Car7B	equ     $-Tbase
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000010'     ; ......*.
Car7C	equ     $-Tbase
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
Car7D	equ     $-Tbase
	RETLW   B'00001000'     ; ....*...
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000010'     ; ......*.
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*...
Car7E	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000010'     ; ....*..
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00000010'     ; ....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000000'     ; ........
Car7F	equ     $-Tbase
	RETLW   B'00000000'     ; ........
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00001000'     ; ....*..
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00001000'     ; ....*..
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000000'     ; ........
CarBL	equ     $-Tbase
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
	RETLW   B'00011111'     ; ...*****
CarFI	equ     $-Tbase
Car80	equ     $-Tbase
	RETLW   B'00001110'     ; ....***.
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00010001'     ; ...*...*
	RETLW   B'00001010'     ; ....*.*.
	RETLW   B'00011011'     ; ...**.**
	RETLW   B'00000100'     ; .....*..
	RETLW   B'00000100'     ; .....*..


;==============================================
;*******************************************************
;	tabella di riferimento caratteri asci
;*******************************************************
	ORG 780
;
Tasci_Tspe:
	ADDWF   PCL,F	; TOGLIERE 20H
	RETLW   CarSP   ; 0 
	RETLW   Car21   ; 1 
	RETLW   Car22   ; 2 
	RETLW   Car23   ; 3 
	RETLW   Car24   ; 4 
	RETLW   Car25   ; 5 
	RETLW   Car26   ; 6 
	RETLW   Car27   ; 7 
	RETLW   Car28   ; 8 
	RETLW   Car29   ; 9 
	RETLW   Car2A   ; A 
	RETLW   Car2B   ; B 
	RETLW   Car2C   ; C 
	RETLW   Car2D   ; D 
	RETLW   CarPU   ; E 
	RETLW   CarSL   ; F
 
	RETLW   Car0    ; 10  
	RETLW   Car1    ; 11
	RETLW   Car2    ; 12
	RETLW   Car3    ; 13
	RETLW   Car4    ; 14 
	RETLW   Car5    ; 15
	RETLW   Car6    ; 16
	RETLW   Car7    ; 17
	RETLW   Car8    ; 18
	RETLW   Car9    ; 19
	RETLW   CarDP   ; 1A
	RETLW   CarPV   ; 1B 
	RETLW   Car3C   ; 1C 
	RETLW   Car3D   ; 1D 
	RETLW   Car3E   ; 1E 
	RETLW   Car3F   ; 1F 

	RETLW   CarCH   ; 20
	RETLW   CarA    ; 21 
	RETLW   CarB    ; 22
	RETLW   CarC    ; 23
	RETLW   CarD    ; 24
	RETLW   CarE    ; 25
	RETLW   CarF    ; 26
	RETLW   CarG    ; 27
	RETLW   CarH    ; 28
	RETLW   CarI    ; 29
	RETLW   CarJ    ; 2A
	RETLW   CarK    ; 2B
	RETLW   CarL    ; 2C
	RETLW   CarM    ; 2D
	RETLW   CarN    ; 2E
	RETLW   CarO    ; 2F

	RETLW   CarP    ; 30
	RETLW   CarQ    ; 31
	RETLW   CarR    ; 32
	RETLW   CarS    ; 33
	RETLW   CarT    ; 34
	RETLW   CarU    ; 35
	RETLW   CarV    ; 36
	RETLW   CarW    ; 37
	RETLW   CarX    ; 38
	RETLW   CarY    ; 39
	RETLW   CarZ    ; 3A
	RETLW   Car5B   ; 3B 
	RETLW   Car5C   ; 3C 
	RETLW   Car5D   ; 3D
	RETLW   Car5E   ; 3E
	RETLW   Car5F   ; 3F

	RETLW   Car60   ; 40
	RETLW   Car61   ; 41
	RETLW   Car62   ; 42
	RETLW   Car63   ; 43
	RETLW   Car64   ; 44
	RETLW   Car65   ; 45
	RETLW   Car66   ; 46
	RETLW   Car67   ; 47
	RETLW   Car68   ; 48
	RETLW   Car69   ; 49
	RETLW   Car6A   ; 4A
	RETLW   Car6B   ; 4B
	RETLW   Car6C   ; 4C
	RETLW   Car6D   ; 4D
	RETLW   Car6E   ; 4E
	RETLW   Car6F   ; 4F

	RETLW   Car70   ; 50
	RETLW   Car71   ; 51
	RETLW   Car72   ; 52
	RETLW   Car73   ; 53
	RETLW   Car74   ; 54
	RETLW   Car75   ; 55
	RETLW   Car76   ; 56
	RETLW   Car77   ; 57
	RETLW   Car78   ; 58
	RETLW   Car79   ; 59
	RETLW   Car7A   ; 5A
	RETLW   Car7B   ; 5B
	RETLW   Car7C   ; 5C

	RETLW   Car7D   ; 5D
	RETLW   Car7E   ; 5E
	RETLW   Car7F   ; 5F
	RETLW   CarFI   ; 60
	RETLW   CarBL   ; 61

;====================================================================
;   label di versione
;====================================================================
	ORG 7F8
	
	DT	"Barre_20"

;====================================================================
	END


