
;.device AT90S1200

.include "1200def.inc"

; externer quarz, 4 mhz


;***** Common Registers

.def	soll1pos	=r01	;soll motorposition 1	
.def	soll2pos	=r02	;soll motorposition 2	
.def	soll3pos	=r03	;soll motorposition 3	
.def	soll4pos	=r04	;soll motorposition 4	
.def	soll5pos	=r05	;soll motorposition 5	
.def	soll6pos	=r06	;soll motorposition 6	
.def	soll7pos	=r07	;soll motorposition 7	
.def	soll8pos	=r08	;soll motorposition 8	
.def	servnum 	=r09	;servo number	

;***** UART Global Registers

.def	u_buffer	=r14	;Serial buffer
.def	u_sr		=r15	;Status-register storage
.def	u_tmp		=r16	;Scratchregister
.def	u_bit_cnt	=r17	;Bit counter
.def	u_status	=r18	;Status buffer
.def	u_reload	=r19	;Reload-register (internal - do not use)

;***** Common Global Registers

.def	charct		=r20	;character counter	
.def	temp  		=r21	;erste allgemeine variable
.def	wait_ct  	=r22	;verzoegerungs counter variable
.def	delay_ct  	=r23	;verzoegerungs counter
.def	temp2		=r24	;zweite allgemeine variable	

;***** Bit positions in the Status-register

.equ	RDR=0			;Receive data ready bit
.equ	TD=6			;Transmitting data (internal - read-only)
.equ	BUSY=7			;Busy-flag (internal - read-only)

;***** Pin Definitions

;PD0 = down taste mot1
;PD1 = up taste mot1
;PD2 = serial input rs232
;PD3 = serial output rs232
;PD4 = down taste mot2
;PD5 = up taste mot2
;PB0 = servo motor 1
;PB1 = servo motor 2
;PB2 = servo motor 3
;PB3 = servo motor 4
;PB4 = servo motor 5
;PB5 = servo motor 6
;PB6 = servo motor 7
;PB7 = servo motor 8

;***** Constants

.equ	N=52				;9600
.equ	C=8
.equ	R=2				;R=1 when C=1 (1,1; 2,8; 3,64)


;***** Reset and Interrupt Vectors

.CSEG
.org	$00
	rjmp	reset			;reset handle

.org INT0addr
	rjmp	ext_int0		;External interrupt handler

.org OVF0addr
	rjmp	tim0_ovf		;Timer0 overflow handler
	
.org ACIaddr
	reti				;Analog comparator handler
	 
;----------------------------------------------
.MACRO waitservo              		; macro definition 
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop		
.ENDMACRO 
;------------------------------

	
reset:
	ldi 	delay_ct,0x10		;step delay
	ldi	temp,0x80
	mov	soll1pos,temp
	mov	soll2pos,temp
	mov	soll3pos,temp
	mov	soll4pos,temp
	mov	soll5pos,temp
	mov	soll6pos,temp
	mov	soll7pos,temp
	mov	soll8pos,temp
	
	ldi	u_tmp,0xff
	out	DDRB,u_tmp		;pb as output	
	ldi	u_tmp,0x00
	out	PORTB,u_tmp		;set all outputs = l
	ldi	u_tmp,0x48
	out	DDRD,u_tmp		;pd3 as output
	ldi	u_tmp,0xff
	out	PORTD,u_tmp		;set all outputs = h
	ldi	u_tmp,R
	out	TCCR0,u_tmp		;Start timer and set clock source
	ldi	u_tmp,0x40
	out	GIMSK,u_tmp		;Enable external interrupt 0
	;ldi	u_tmp,0x02		;inv rs232 (using max232)
	ldi	u_tmp,0x03		;not inv. rs232
	out	MCUCR,u_tmp		;On falling edges
	clr	u_status		;Erase status-byte

	sei				;Enable interrupts

loop:	
	sbis	PIND,0			;is increase switch pressed?
	inc	soll1pos		;yes
	sbis	PIND,1			;is decrease switch pressed?
	dec	soll1pos		;yes
	sbis	PIND,4			;is increase switch pressed?
	inc	soll2pos		;yes
	sbis	PIND,5			;is decrease switch pressed?
	dec	soll2pos		;yes
	
	
	rcall	waitstep		;wait a time
	
	sbi	PORTB,0
	rcall	wdefin
	mov	temp,soll1pos
	rcall	wmot
	cbi	PORTB,0

	sbi	PORTB,1
	rcall	wdefin
	mov	temp,soll2pos
	rcall	wmot
	cbi	PORTB,1
	
	sbi	PORTB,2
	rcall	wdefin
	mov	temp,soll3pos
	rcall	wmot
	cbi	PORTB,2
	
	sbi	PORTB,3
	rcall	wdefin
	mov	temp,soll4pos
	rcall	wmot
	cbi	PORTB,3
	
	sbi	PORTB,4
	rcall	wdefin
	mov	temp,soll5pos
	rcall	wmot
	cbi	PORTB,4

	sbi	PORTB,5
	rcall	wdefin
	mov	temp,soll6pos
	rcall	wmot
	cbi	PORTB,5

	sbi	PORTB,6
	rcall	wdefin
	mov	temp,soll7pos
	rcall	wmot
	cbi	PORTB,6

	sbi	PORTB,7
	rcall	wdefin
	mov	temp,soll8pos
	rcall	wmot
	cbi	PORTB,7

	rjmp	loop			;again
	
;------------------------------

wmot:
	waitservo	
	dec	temp
	cpi	temp,0x00
	brne	wmot
	ret
			
;------------------------------

wdefin:
	ldi	temp,0
w_def:				
	nop
	nop
	nop
	nop
	nop		
	nop
	nop
	dec	temp
	cpi	temp,0x00
	brne	w_def	
	
	ret
		
;------------------------------
.MACRO waitpwm               		; macro definition 
	nop
	nop
	nop
	nop
.ENDMACRO 
;------------------------------
	
waitstep:
	mov	wait_ct,delay_ct
w_loop:					;das ist die warteschleife
	ldi	temp,0xff
wi_loop:				;das ist innere die warteschleife
	waitpwm
	dec	temp
	cpi	temp,0x00
	brne	wi_loop			;ende der inneren warteschleife
	dec	wait_ct	
	cpi	wait_ct,0x00
	brne	w_loop			;ende der warteschleife
	ret

	
;----------------------------------------------

	
ext_int0:				;action on the rs232 line
	in	u_sr,SREG		;Store Status Register
	
	;sbic	PIND,2			;using max232 
	sbis	PIND,2			;get start bit
	rjmp	endextir		;no startbit found, abort
	
	ldi	u_status,1<<BUSY	;Set busy-flag (clear all others)

	ldi	u_tmp,(256-(N+N/2)+(29/C));Set timer reload-value (to 1.5
	out	TCNT0,u_tmp		;  bit len). 29 = time delay that
					;  have already been used in this
					;  interrupt plus the time
					;  that will be used by the time
					;  delay between timer interrupt request
					;  and the actual sampling of the first
					;  data bit.

	ldi	u_tmp,2			;Set bit 1 in u_tmp
	out	TIFR,u_tmp		;   to clear T/C0 overflow flag
	out	TIMSK,u_tmp		;   and enable T/C0 overflow interrupt

	clr	u_bit_cnt		;Clear bit counter
	out	GIMSK,u_bit_cnt		;Disable external interrupt

	ldi	u_reload,(256-N+(8/C))	;Set reload-value (constant).
	

endextir:
	out	SREG,u_sr		;Restore SREG
	reti

;----------------------------------------------
	
tim0_ovf:				;next bit is ready
	in	u_sr,SREG		;Store statusregister

	out	TCNT0,u_reload		;Reload timer

	inc	u_bit_cnt		;Increment bit_counter
	sec				;Set carry
	;sbis	PIND,2			;if PD1=LOW (using max232)
	sbic	PIND,2			;if PD1=HIGH <=== SAMPLE HERE
	clc				;    clear carry
	ror	u_buffer		;Shift carry into data
	in	u_tmp,SREG		;Store SREG

	cpi	u_bit_cnt,9		;if u_bit_cnt!=9 (must sample stop-bit)
	brne	tim0_ret		;   exit interrupt

	out	SREG,u_tmp		;Get old SREG
	rol	u_buffer		;Rotate back data (to get rid of the stop-bit)

	sbr	u_status,1<<RDR		;Clear busy-flag
	
	ldi	u_tmp,0x40		;(u_bit_cnt==9):
	out	GIMSK,u_tmp		;Enable external interrupt
	clr	u_tmp 
	out	TIMSK,u_tmp		;Disable timer interrupt
					;we have 8 bits. now lets see what they are

	mov	u_tmp,u_buffer
	cpi	u_tmp,0xff		;is it the sync char?
	breq	syncchar		;yes
	cpi	charct,1		;is it the first char?
	breq	firchar			;yes
	cpi	charct,2		;is it the second char?
	breq	secchar			;yes
	ldi	charct,0		;seems some error
	out	SREG,u_sr		;Restore status register
	reti
	
syncchar:
	ldi	charct,1		;next is first
	out	SREG,u_sr		;Restore status register
	reti
firchar:
	mov	servnum,u_tmp		;this is for motor 1
	ldi	charct,2		;next is second
	out	SREG,u_sr		;Restore status register
	reti
secchar:
	ldi	charct,1
	cp	servnum,charct
	brne	not1
	mov	soll1pos,u_tmp		;this is for motor 1
not1:
	ldi	charct,2
	cp	servnum,charct
	brne	not2
	mov	soll2pos,u_tmp		;this is for motor 2
not2:
	ldi	charct,3
	cp	servnum,charct
	brne	not3
	mov	soll3pos,u_tmp		;this is for motor 3
not3:
	ldi	charct,4
	cp	servnum,charct
	brne	not4
	mov	soll4pos,u_tmp		;this is for motor 4
not4:
	ldi	charct,5
	cp	servnum,charct
	brne	not5
	mov	soll5pos,u_tmp		;this is for motor 5
not5:
	ldi	charct,6
	cp	servnum,charct
	brne	not6
	mov	soll6pos,u_tmp		;this is for motor 6
not6:
	ldi	charct,7
	cp	servnum,charct
	brne	not7
	mov	soll7pos,u_tmp		;this is for motor 7
not7:
	ldi	charct,8
	cp	servnum,charct
	brne	not8
	mov	soll8pos,u_tmp		;this is for motor 8
not8:

	ldi	charct,0		;next is sync
	out	SREG,u_sr		;Restore status register
	reti
	
tim0_ret:
	out	SREG,u_sr		;Restore status register
	reti

;----------------------------------------------

