/*
 * Grid Locator - calculator for distance/bearing for PalmOS devices.
 *
 * file: gps.h
 * Copyright (C) 2002, Rex Allers
 *
 * Definition for utilities to communicate from a Palm handheld  
 * to read position from an NMEA GPS receiver  
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef gps_h
#define gps_h


// defines

#define BAUD 4800
#define BUFMAX 512
#define NOTFOUND 90

// prototype definitions for GPS functions

//Boolean 
//GetField(char *sen, UInt n, char *result);

void 
SplitDegMin(char *inp);

Err
VerifyChecksum(char *sen);

Err
GetGPSLatLon(char *sen, char *LatStr, char *LonStr, char *Name);

Err
GetGPSTime(char *sen, char *Hrs, char *Mins, char *Secs);

Err
StartSerial(void);

void
StopSerial(void);

Err 
Get_Sentance(char *dest, char *tag);

void
FlushSerial();

void
InitForGPS(void);

#endif    // gps_h
