/*
 * Grid Locator - calculator for distance/bearing for PalmOS devices.
 *
 * file: gl_db.h
 * Copyright (C) 2001, Rex Allers
 *
 *   Some program structure based on: 
 *   Astro Info (Astro.c) Copyright (C) 2000, Michael Heinz
 *
 *   Dist/bear modules based on code from PROJ.4 1995 by 
 *   	Gerald I. Evenden
 *	USGS, Woods Hole, MA 02543
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef gldb_h
#define gldb_h

#define SAVEMEMO "GL- <Save>"

/* Max length of all text fields */
#define FIELDLENGTH     17

#define WMH 10
#define WLT 20
#define WLN 20

#define MAXLST 32
#define MAXLOC 40
#define MAXRNM 18

typedef struct _GLLstRec 
{
    UInt16     RecIdx;
    UInt32     RecSz;
    char       name[MAXNME+1];
} GLLstRec;

typedef struct _GLLocRec 
{
    UInt16     RecIdx;
    char       name[MAXNME+1];
} GLLocRec;


// DB function defs
Err  WriteMemoRecord(Char * data);

UInt16  FindGLRecord(void);

UInt16 FindGLLocs(void);

UInt16 StrBySlash(char *dest, char *src, Int16 strSz);

void GetLocData(UInt16 LocIdx);

void ListDraw(Int16 itemNumber, RectanglePtr bounds, char **text);

void LocDraw(Int16 itemNumber, RectanglePtr bounds, char **text);

UInt16 SaveToGL(char *recStr);

#endif
