/*
 * Grid Locator - calculator for distance/bearing for PalmOS devices.
 *
 * file: gl.h
 * Copyright (C) 2001, Rex Allers
 *
 *   Some program structure based on: 
 *   Astro Info (Astro.c) Copyright (C) 2000, Michael Heinz
 *
 *	  Dist/bear modules based on code from PROJ.4 1995 by 
 *		Gerald I. Evenden
 *		USGS, Woods Hole, MA 02543
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef gl_h
#define gl_h

// The GLVERSION constant needs to be incremented everytime something changes
// in the program. This constant is written to the saved preferences,
// allowing us to verify that they are not obsolete when we start.
// When this changes a new install is assumed on start up.
// (saved in glPrefs)
// Use this convention:
//   low order decimal digit for beta versions; 0 = not beta
//   2nd & 3rd digits = minor version
//   4th & 5th digits = major version (max of 65)
//   ex:   2010 = 2.01 released ; 1012 = 1.01b beta version
#define GLVERSION   1202

/* Max length of all text fields */
#define FIELDLENGTH     17

#define MAXNME 15
#define LSTEMPTY 999

/* Application Preferences */
typedef struct {
    UInt16              version;       // validates the prefs structure
    char                bnam[MAXNME+1], tnam[MAXNME+1];
    double              blat, blng, tlat, tlng;
//    int                 dmode;
    Int8		forceWest, forceSouth;
    Int8		datum;
    Int8		degfmt;
    Int8		brgfmt;
    UInt16              activeFormId;  // The page we were on last time
    UInt16		lstIdx;
    UInt32		memoDbSize;
//    UInt16		locIdx;
    UInt8		ToLoc;  // last work dest - 0=base, 1=tgt, 2=do time
    Int16		GPSOffst;
} GlPrefsType;


/*
 * Needed by other code sections
 */
extern GlPrefsType glPrefs;
extern UInt16 saveFormId;
extern char datestr[];
extern char timestr[];
extern UInt16 mainMenu;

Boolean DoMenu(UInt16 itemID);
void UpdateTextField(FieldPtr fld, char *t);
void UpdateTimeField(FieldPtr fld, double num, int st);

#endif
