/*
 * Grid Locator - calculator for distance/bearing for PalmOS devices.
 *
 * file: constants.h
 * Copyright (C) 2001, Rex Allers
 *
 *   Some program structure based on: 
 *   Dist/bear modules based on code from PROJ.4 1995 by 
 *   	Gerald I. Evenden
 *   	USGS, Woods Hole, MA 02543
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#ifndef constants_h
#define constants_h

/*
 * Constants
 */
#define PI      3.14159265358979323846264338327950288
#define PI_2    (PI * 2)
#define TWOPI	(PI * 2)
#define PIh     1.57079632679489661923132169163975144
#define D2R     0.0174532925199432958
#define R2D	57.29577951308232

// note: SPI = PI adjusted high value
// approx. true val:	3.1415926535897932384
#define SPI		3.14159265359

// ellipsoid constants
// Clark 1866
#define EL_A  6378206.4
#define EL_B  6356583.8

// WGS84
//#define EL_A  6378137.0
//#define EL_B  6356752.3

/*
 * EPOCH is 1990.
 */
#define EPOCH   2447891.5
#define YEAR    365.242191


#endif // constants_h

