/*
 * Grid Locator - calculator for distance/bearing for PalmOS devices.
 *
 * file: PalmUtil.h
 * Copyright (C) 2001, Rex Allers
 *
 *   Some program structure based on: 
 *   Astro Info (Astro.c) Copyright (C) 2000, Michael Heinz
 *
 *	  Dist/bear modules based on code from PROJ.4 1995 by 
 *		Gerald I. Evenden
 *		USGS, Woods Hole, MA 02543
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef PalmUtil_h
#define PalmUtil_h


#include <PalmOS.h>

// Some basic ROM versions
#define sysVersion10	sysMakeROMVersion(1,0,0,sysROMStageRelease,0)
#define sysVersion20	sysMakeROMVersion(2,0,0,sysROMStageRelease,0)
#define sysVersion30	sysMakeROMVersion(3,0,0,sysROMStageRelease,0)
#define sysVersion31	sysMakeROMVersion(3,1,0,sysROMStageRelease,0)
#define sysVersion35	sysMakeROMVersion(3,5,0,sysROMStageRelease,0)

// For writing to databases.
#define offsetof(type, member) (UInt32)&(((type *)0)->member)

/*
 * Returns true if the ROM version is at least
 * minVersion.
 */
Boolean CheckMinRomVersion(UInt32 minVersion);

// return ID of current focused object
//   returns noFocus if none focused
UInt16 GetFocusID( void );

// return pointer to an object in a form
void *Id2Ptr( UInt16 wID );

/*
 * Update a text field and redraw it.
 */
void
UpdateTextField(FieldPtr fld, char *t);

/*
 * Update a numeric Int16 field and redraw it.
 */
void
UpdateNumField(FieldPtr fld, Int16 num);

/*
 * Update an editable integer field and redraw it.
 */
void
UpdateEditField(FieldPtr fld, long num);

// my string N copy 
// -- Palm version	doesn't append NULL
//
void strNcopy(char *dst, char *src, UInt16 n);

/*
 * Retrieve the current integer value of a field.
 * formPtr = the form containing the field.
 * id = the resource # of the field.
 * Returns the integer value of the field.
 */
int GetNumField(FormPtr formPtr, UInt16 id);

/*
 * Retrieve the current text value of a field.
 * formPtr = the form containing the field.
 * id = the resource # of the field.
 * Returns a string ptr to the field.
 */
char *GetTextField(FormPtr formPtr, UInt16 id);

typedef struct _DBRecord 
{
    char       name[33];
    UInt16     cardNo;
    LocalID    dbID;
} DBRecord;

DBRecord **GetDBList(UInt32 type, UInt32 creator, int *count);
void FreeDBList(DBRecord **recordList, int count);

void GotoApplication(UInt32 ApplId);

#endif    // PalmUtil_h

