/*
 * Grid Locator - calculator for distance/bearing for PalmOS devices.
 *
 * file: PalmMath.h
 * Copyright (C) 2001, Rex Allers
 *
 *   Some program structure based on: 
 *   Astro Info (Astro.c) Copyright (C) 2000, Michael Heinz
 *
 *	  Dist/bear modules based on code from PROJ.4 1995 by 
 *		Gerald I. Evenden
 *		USGS, Woods Hole, MA 02543
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef PalmMath_h
#define PalmMath_h


#include <PalmOS.h>

/*
 * Update a numeric double field and redraw it.
 * p = # of digits to the right of the decimal.
 */
void
UpdateDblField(FieldPtr fld, double num, UInt16 p);

/*
 * Retrieve the current double value of a field.
 * formPtr = the form containing the field.
 * id = the resource # of the field.
 * Returns the double value of the field.
 */
double GetDblField(FormPtr formPtr, UInt16 id);

/*
 * Convert a double to a string.
 * s = destination string
 * d = number to convert
 * p = # of digits to the right of the decimal.
 * l = the maximum length of s.
 */
void StrDToA(char *s, double d, int p, int l);

/*
 * Convert a string to a double.
 * s = source string pointer
 */
double strToDouble(char *str);

#endif    // PalmMath_h

