function RegImg() {
    this.cache = {};
    this.cacheTimeout = 600 * 1000;  // 10 Minutes
    this.imgWidth = 200; // 200px
    this.staticUrl = "/pictures";
    this.vrsUrl = null;
    this.picturesUrl = null;
    this.emptyUrl = "/img/empty.jpg";
    this.stantionUrl = "/img/stantion.jpg";

    var getVrsUrl = function(reg) {
        return this.vrsUrl + "/VirtualRadar/images/File-" + reg + "/Picture.png";
    }
    var getStaticUrl = function(reg) {
        return this.staticUrl + "/" + reg + ".jpg";
    }
    var getPicturesUrl = function(reg) {
        return this.picturesUrl  + reg + ".jpg";
    }
    var getRegUrl = function(reg) {
        if (this.vrsUrl != null) {
            return getVrsUrl(reg);
        } else if (this.picturesUrl != null) {
            return getPicturesUrl(reg);
        }
        return getStaticUrl(reg);
    }
    var makeImg = function(obj, url) {
        var d = $("<div></div>").addClass("airplane-photo");
        $("<img src='" + url + "'/>").width(this.imgWidth).appendTo(d);
        d.prependTo(obj);
    }
    this.setVrsUrl = function(url) {
        this.vrsUrl = url;
    }
    this.setPicturesUrl = function(url) {
        this.picturesUrl = url;
    }
    this.set = function(reg, obj) {
        if (reg == "") {
            makeImg(obj, this.stantionUrl);
            return;
        }
        var now = Date.now();
        var url = getRegUrl(reg);
        if (this.cache[reg] != undefined) {
            if (this.cache[reg] == 0) {
                makeImg(obj, url);
                return;
            }
            if (now - this.cache[reg] < this.cacheTimeout) {
                makeImg(obj, this.emptyUrl);
                return;
            }
        }
        $("<img src='" + url + "'/>")
            .load(this, function(event) {
                event.data.cache[reg] = 0;
                makeImg(obj, url);
            })
            .error(this, function(event) {
                event.data.cache[reg] = now;
                makeImg(obj, event.data.emptyUrl);
            });
    }
    return this;
}
