var okMsg = function(data) {
    alert("OK: " + data.message);
    updateServerList();
}

var failMsg = function(data) {

}

function LogView(objectId) {
    this.logNode = $(objectId);
    this.freqNode = $("#freqs")[0];
    this.lastTimestamp = 0;
    this.lastId = 0;
    this.msgCount = 0;
    this.maxMessages = 300;
    this.regimg = RegImg();

    var cleanLog = function() {
        var nodes = this.logNode.children();
        if (nodes != null) {
            for (var j = this.maxMessages; j < nodes.length; j++) {
                nodes[j].remove();
            }
        }
    }
    var getMsgText = function(msg) {
        var s = "RX ID: " + msg.id + " Freq: " + (parseInt(msg.freq) / 1000000).toFixed(3) + " MHz\r\n";
        s += "Mode: " + String.fromCharCode(parseInt(msg.mode)) + " (" + msg.mode + "), Label: " + msg.label;
        if (msg.label_descr != undefined) {
            s += " (" + msg.label_descr + ")";
        }
        s += "\r\nBlock ID: " + String.fromCharCode(parseInt(msg.blockid)) + " (" + msg.blockid + ")";
        if (msg.msgno != undefined && msg.msgno != "") {
            s += ", Msg No: " + msg.msgno + "\r\n";
        }
        s += "\r\nAircraft reg: <span class='hl-reg'>" + msg.addr + "</span>";
        if (msg.flightid != undefined && msg.flightid != "") {
            s += ", Flight ID: <span class='hl-reg'>" + msg.flightid + "</span>";
        }

        if (msg.vendor != undefined) {
            s += "\r\nVendor: " + msg.vendor + ", Type: " + msg.ftype + " (" + msg.stype;
            s += "), cn: " + msg.cn + ", Carrier: " + msg.carrier;
            if (msg.remark != "") {
                s += ", Remark: " + msg.remark;
            }
        } else if (msg.ftype != undefined) {
            s += "\r\nType: " + msg.ftype + ", cn: " + msg.cn + ", Carrier: " + msg.carrier;
        }
        if (msg.carrier_descr != undefined && msg.carrier_descr != "") {
            s += "\r\nAirline: " + msg.carrier_descr;
        }
        s += "\r\n";
        needCrlf = false;
        if (msg.Icao != undefined) {
            s += "ICAO: <span class='hl-reg'>" + msg.Icao + "</span>  ";
            needCrlf = true;
        }
        if (msg.Call != undefined) {
            s += "Callsign: <span class='hl-reg'>" + msg.Call + "</span>  ";
            needCrlf = true;
        }
        if (msg.Sqk != undefined) {
            s += "Squawk: <span class='hl-reg'>" + msg.Sqk + "</span>  ";
            needCrlf = true;
        }
        if (needCrlf) {
            s += "\r\n";
        }
        needCrlf = false;
        if (msg.Cou) {
            s += "Country: " + msg.Cou + "  ";
            needCrlf = true;
        }
        if (msg.Op) {
            s += "Operator: " + msg.Op + "  ";
            needCrlf = true;
        }
        if (msg.OpIcao) {
            s += "(" + msg.OpIcao + ")";
        }
        if (needCrlf) {
            s += "\r\n";
        }
        needCrlf = false;
        if (msg.Mdl) {
            s += "Model: " + msg.Mdl + "  ";
            needCrlf = true;
        }
        if (msg.Type) {
            s += "Type: " + msg.Type;
            needCrlf = true;
        }
        if (needCrlf) {
            s += "\r\n\r\n";
        }
        needCrlf = false;
        if (msg.From) {
            s += "<img class='route-picture' src='img/route.png'/>";
            s += "From: " + msg.From + "\r\n";
        }
        if (msg.To) {
            s += "To: " + msg.To + "\r\n\r\n";
        }
        if (msg.Lat) {
            s += "Lat: <span class='hl-reg'>" + msg.Lat + "</span>°  ";
            needCrlf = true;
        }
        if (msg.Long) {
            s += "Lon: <span class='hl-reg'>" + msg.Long + "</span>°  ";
            needCrlf = true;
        }
        if (msg.Trak) {
            s += "Track: <span class='hl-reg'>" + msg.Trak + "</span>°  ";
            needCrlf = true;
        }
        if (msg.Spd) {
            s += "Speed: <span class='hl-reg'>" + msg.Spd + "</span> kts  ";
            needCrlf = true;
        }
        if (msg.Vsi) {
            s += "VSpeed: <span class='hl-reg'>" + msg.Vsi + "</span> ft/m  ";
            needCrlf = true;
        }
        if (msg.Alt) {
            s += "FlightLevel: <span class='hl-reg'>" + "FL" + Math.round(msg.Alt / 100) + "</span>";
            needCrlf = true;
        }
        if (needCrlf) {
            s += "\r\n";
        }



        s += "\r\n\r\n<img src='/img/paperclip.png'/><span class='hl-text'>" + msg.text + "</span>";
        return s;
    }
    var addMsgDiv = function(msg) {
        var main = $("<div></div>").addClass("message").addClass("block");
        if (msgCount % 2 != 0) {
            main.addClass("gray");
        } 
        msgCount += 1;
        var m = $("<div></div>").addClass("block");
        $("<div>" + getMsgText(msg) + "</div>").addClass("txt").appendTo(m);
        if (this.regimg != null) {
            this.regimg.set(msg.addr, m);
        }
        m.appendTo(main);
        $("<div>[" + msg.time + "]</div>").addClass("to-right").appendTo(main);
        main.prependTo(this.logNode[0]);
        cleanLog();
    }
    var onUpdate = function(data) {
        for (var key in data.messages) {
            var value = data.messages[key];
            var timestamp = parseInt(value.timestamp);
            var id = parseInt(value.id);
            if (timestamp > this.lastTimestamp || (timestamp == this.lastTimestamp && id > this.lastId)) {
                addMsgDiv(value);
                this.lastTimestamp = timestamp;
                this.lastId = id;
            }
        }
    }
    this.update = function() {
        RpcCall("getMessages", {"id": this.lastId, "timestamp": this.lastTimestamp}, onUpdate, failMsg);
    }
    var onFreqUpdate = function(data) {
        var f = [];
        var j = 0;
        for (var key in data.freqs) {
            var value = data.freqs[key];
            f[j] = parseInt(value);
            j = j + 1;
        }
        f.sort();
        var txt = ""
        for (var j in f) {
            txt += (f[j] / 1000000).toFixed(3) + "  ";
        }
        this.freqNode.textContent = txt;
    }
    this.updateFreq = function() {
        RpcCall("getFreq", {}, onFreqUpdate, failMsg);
    }
    var onConfigUpdate = function(data) {
        if (data.vrsUrl != undefined && data.vrsUrl != "") {
            this.regimg.setVrsUrl(data.vrsUrl);
        }
        if (data.picturesUrl != undefined && data.picturesUrl != "") {
            this.regimg.setPicturesUrl(data.picturesUrl);
        }
    }
    this.updateConfig = function() {
        RpcCall("getConfig", {}, onConfigUpdate, failMsg);
    }
    return this;
}

$(document).ready(function() {
    $('#logPanel').height($(window).height() * 0.8);
    log = LogView("#log");
    log.updateConfig();
    log.updateFreq();
    window.setInterval(function() {
        log.update();
    }, 3000);
    window.setInterval(function() {
        log.updateFreq();
    }, 33000);
});
