
CLS : KEY OFF: COLOR 10, 0
PRINT "         Logiciel de chargement de programme pour PIC srie 16x84"
PRINT "                de Victor F1BIU, version 1.1  25/4/98"
PRINT : PRINT :

'la programmation du pic suit cette procdure:
'vrification du mot "84" en ligne FFFEh du fichier .obj, pour pic 16x84.
'le pic est reset une 1ere fois.
'criture du mot &HFF de configuration pour dsactiver le mode protection.
'le pic est reset une nouvelle fois.
'le mot d'itentification en ligne 4000h du fichier .obj est log dans le pic.
'le mot de configuration en ligne 400Eh du fichier .obj est log dans le pic.
'la mmoire programme est crite de la manire suivante:
'criture de la commande [criture-programme] suivie par 0+14 bits de data+0.
'commande [dbut-programmation] suivie d'une attente de 10 ms
'commande [incrmentation] d'adresse.
'boucle jusqu' la fin du buffer programme.
'reset du pic une nouvelle fois.
'criture des datas en mmoire eeprom datas.
'idem criture mmoire programme sauf mot de commande nomm [criture-eeprom].
'boucle de 64 jusqu' la fin du buffer eeprom.
'la programmation est finie.
'la broche MCLR est maintenue basse matriellement, pour reseter le pic.
'la broche MCLR est dsactive (haut), le pic peut excuter le programme cible
'tout en restant dans le programmateur.

'---------------------------------------------------------------------------





'----------------------Dclaration de variables-----------------------------
ECRITCONF = &H0:     'commande criture-mot-de-config
CHPM = &H2:          'commande criture-programme.
LECTDATAPROG = &H4:  'lecture datas de la mmoire programme, non utilis.
INCADR = &H6:        'commande d'incrmentation adresse
Debutprog = &H8:     'commande dbut-programmation
ECRITDATAMEM = &H3:  'commande criture-eeprom.
LECTDMEMD = &H5:     'lecture datas de la mmoire datas
EFFACMEMPROG = &H9:  'effacement mmoire programme, non utilis.
EFFMEMDATA = &HB:    'effacement mmoire datas, non utilis.
PP = &H378:          'adresse de sortie port parallle lpt1
REGDECDATA = &H0:    'registre  dcalage pour datas de 14bits.
REGDECCOMMAND = &H0: 'registre  dcalage pour commande de 6bits.
SORTIEVAR = &H0:     'Sortie variable, pour port parallle
DIM bufprog(1024) AS DOUBLE:
DIM bufdataeeprom(64)  AS INTEGER:
tailleprog = 0
REM fin de dclaration de variables
'---------------------------------------------------------------------------


'---------------------------------------------------------------------------
F$ = "": d$ = ""
OUT PP, &H4: 'PIC en mode reset
PRINT "1)-Coupez l'alimentation du programmateur, placez le pic dans le socle."
PRINT "2)-Alimentez le programmateur."
PRINT "3)-Activez le 13V par le switch 13v on/off. "
PRINT : PRINT
PRINT "Appuyer sur une touche pour continuer"
bou1: IF INKEY$ = "" THEN GOTO bou1
'---------------------------------------------------------------------------



'---------------------------------------------------------------------------
REM ouverture fichier obj ou hex
bou2:
INPUT "Entrez le nom du fichier .obj ou .hex"; F$
IF F$ = "" THEN GOTO bou2
OPEN F$ FOR INPUT AS #1
IF EOF(1) THEN END

'Vrification de la version PIC crite en ligne FFFEh du fichier .obj

WHILE NOT EOF(1)
INPUT #1, d$
IF MID$(d$, 4, 4) = "FFFE" THEN GOTO aff
WEND
CLOSE #1
GOTO erreur

aff:
CLOSE #1
a$ = MID$(d$, 10, 2)
IF a$ <> "84" THEN GOTO erreur
CLS
PRINT "          OK, votre fichier concerne bien un PIC xx84"
V = TIMER:  'pour implementer une tempo
bo: IF TIMER < V + 2 THEN GOTO bo 'tempo de 2 secondes
GOTO suite2

erreur:
CLS
PRINT "Votre fichier ne concerne pas un PIC 16x84 , vrifier votre fichier .obj";
END
'---------------------------------------------------------------------------




'----------------------- effacement du pic ---------------------------------
suite2:

'un reset du mot de configuration est ncessaire ici pour tout nettoyer,
'et le code de protection est dsactiv par la programmation du pic.
'la dsactivation du mot de protection efface l'ancien contenu du pic,
'vous ne pourrez donc pas pirater.
'
'la procdure d'effacement est la suivante:
'1- reset du pic.
'2- criture du mot de commande criture-mot-de-config, mot de 6bits.
'3- incrmentation de l'adresse 7 fois.
'4- criture du mot FFh  l'adresse du mot de configuration.
'5- criture du mot de commande 1 puis 7 (mots de 6bits)
'6- criture mot de commande dbut-programmation (mot de 6 bits)
'7- attente 10mS.
'8- criture du mot de commande 1 puis 7 (mots de 6bits)

effacement:
PRINT "Effacement de la mmoire: ";
OUT PP, &H0: OUT PP, &H4: OUT PP, &H0: 'le PIC est reset.
FOR te = 1 TO 10: NEXT te
REGDECCOMMAND = ECRITCONF: GOSUB ecrit6bits: 'criture commande configuration
REGDECDATA = VAL("&HFF")
GOSUB ECRIT14BITS

'Incrementer  0x2007
FOR n = 1 TO 7: REGDECCOMMAND = INCADR: GOSUB ecrit6bits: NEXT n:

REGDECCOMMAND = &H1: GOSUB ecrit6bits:
REGDECCOMMAND = &H7: GOSUB ecrit6bits
REGDECCOMMAND = Debutprog: GOSUB ecrit6bits:   'dbut de programmation
V = TIMER:  'pour implementer une tempo de 10 ms
bou3: IF TIMER < V + .02 THEN GOTO bou3
REGDECCOMMAND = &H1: GOSUB ecrit6bits
REGDECCOMMAND = &H7: GOSUB ecrit6bits
'----------------- fin d'effacement du pic ---------------------------------



'-------- saisie du contenu fichier .obj et mis en buffers temporaires -----
'init buffers
FOR n = 0 TO 1023: bufprog(n) = VAL("&H3FFF"): NEXT n
FOR n = 0 TO 63: bufdataeeprom(n) = VAL("&HFF"): NEXT n

OPEN F$ FOR INPUT AS #1
'Dcodage adresse du fichier .obj,  la position 4, taille 4 de chaque ligne.
d$ = ""
WHILE MID$(d$, 9, 1) <> "1"   'fin du fichier .obj ou .hex?
  INPUT #1, d$
  longueur = LEN(d$): 'longueur complte de la ligne
  adresse$ = MID$(d$, 4, 4): 'adresse des datas  crire
  adresse = VAL("&H" + adresse$) / 2:  'conversion adresse en dcimal
  IF (adresse >= 0 AND adresse < 1024) THEN GOSUB remplirbufprog
  IF MID$(d$, 4, 2) = "42" THEN GOSUB remplirbufeeprom
  IF MID$(d$, 4, 4) = "4000" THEN GOSUB identificateur
  IF MID$(d$, 4, 4) = "400E" THEN GOSUB ecritmotdeconfig
WEND:     'fin de la boucle while

'----------------- fin de saisie du contenu du fichier .obj ----------------





'------------------ criture en mmoire programme --------------------------
ecritdataprog:
' Programmation mmoire programme
PRINT
PRINT : PRINT "Ecriture en mmoire programme: "
OUT PP, &H0: OUT PP, &H4: OUT PP, &H0: 'le PIC est reset

'tailleprog a la taille rellement utilise par l'application, maxi=1024.
FOR n = 0 TO tailleprog - 1:
PRINT n; : PRINT ":";
'sortie data de commande mmoire programme
REGDECCOMMAND = CHPM: GOSUB ecrit6bits:
REGDECDATA = bufprog(n) 'saisie valeur dans le buffer programme
GOSUB ECRIT14BITS:  'Sortie mot de 14 bits vers port parallle

'criture commande dbut programmation
REGDECCOMMAND = Debutprog: GOSUB ecrit6bits:

V = TIMER:  'pour tempo de 10 ms.
bou5: IF TIMER < V + .02 THEN GOTO bou5:       'tempo 10mS

REGDECCOMMAND = INCADR: GOSUB ecrit6bits:   'incrmentation adresse       
NEXT n
' --------------- fin d'criture en mmoire programme ---------------------



'------------------ criture en mmoire eeprom ----------------------------
ecritdataeeprom:
PRINT
'criture des datas en eeprom

PRINT : PRINT "Ecriture des datas en eeprom: "
OUT PP, &H0: OUT PP, &H4: OUT PP, &H0: 'le PIC est reset

FOR n = 0 TO 63
PRINT n; : PRINT ":";

'Sortie du mot de contrle ecriture vers eeprom
REGDECCOMMAND = ECRITDATAMEM: GOSUB ecrit6bits:

REGDECDATA = bufdataeeprom(n) 'saisie valeur dans le buffer datas eeprom
GOSUB ECRIT14BITS:  'Sortie mot de 14 bits vers port parallle

'criture commande dbut programmation
REGDECCOMMAND = Debutprog: GOSUB ecrit6bits:

V = TIMER:  'tempo
bou7: IF TIMER < V + .02 THEN GOTO bou7  'tempo = 10mS

REGDECCOMMAND = INCADR: GOSUB ecrit6bits 'incrmentation adresse
NEXT n
' --------------- fin d'criture en mmoire eeprom ------------------------




'----------------------------------FIN--------------------------------------
FIN:
CLOSE #1
OUT PP, &H4: 'maintien de la broche reset MCLR  niveau bas
PRINT
PRINT "Appuyez sur une touche pour continuer"
bou11: IF INKEY$ = "" THEN GOTO bou11
CLS
LOCATE 11, 1
PRINT "Retirez le 13V du programmateur, par le switch 13v on/off "
PRINT "mais ne coupez pas le 5v, appuyez sur une touche pour reseter le pic."
bou8: IF INKEY$ = "" THEN GOTO bou8
OUT PP, 0
CLS
LOCATE 10, 1
PRINT "Ca y est, le pic est programm, si le programme test1 ou test2 est charg"
PRINT "une led cble en rb0 ou rb1 doit clignoter."
PRINT "Si le programme n'est pas un test, vous pouvez couper l'alimentation"
PRINT "et placer le pic dans la carte cible."
SYSTEM
END
'---------------------------------------------------------------------------




'--------------------------Sous routine ECRIT14BITS ------------------------
ECRIT14BITS:
FOR te = 1 TO 10: NEXT te
'Sous routine pour sortie sur port parallle d'un mot de 14 bits encadr
'd'un zro devant et derrire.
'Le mot est dcal 14 fois vers la droite, c'est le lsb qui va vers le port,
'et est valid sur front descendant de l'horloge.
PRINT HEX$(REGDECDATA); : PRINT " ";
OUT PP, &H2: OUT PP, &H0: 'Un zro en tte du mot de 14bits
FOR I = 1 TO 14
SORTIEVAR = (REGDECCOMMAND AND &H1)
OUT PP, SORTIEVAR: 'Sortie maintenant sur port parallle.
SORTIEVAR = (REGDECDATA AND &H1) OR &H2:
'sortie du bit lsb du data, horloge haute.
OUT PP, SORTIEVAR: 'Sortie maintenant sur port parallle.
FOR te = 1 TO 10: NEXT te
SORTIEVAR = SORTIEVAR AND &H1:  'sortie du lsb avec horloge basse.
OUT PP, SORTIEVAR: 'Sortie maintenant sur port parallle.
FOR te = 1 TO 10: NEXT te
REGDECDATA = INT(REGDECDATA / 2): 'dcalage  droite du data, un seul bit.
NEXT I
OUT PP, &H2: OUT PP, &H0: 'Un zro en queue de data.
RETURN
'-----------------------Fin de sous routine --------------------------------



'---------------------Sous routine ECRIT6BITS ------------------------------
ecrit6bits:
FOR te = 1 TO 10: NEXT te
'Sous routine pour sortie sur port parallle d'un mot de commande de 6 bits.
FOR I = 1 TO 6:  'les mots de commande sont de 6 bits.
SORTIEVAR = (REGDECCOMMAND AND &H1)
OUT PP, SORTIEVAR: 'Sortie maintenant sur port parallle.
SORTIEVAR = (REGDECCOMMAND AND &H1) OR &H2:
FOR te = 1 TO 10: NEXT te
'sortie du bit lsb du data, horloge haute.
OUT PP, SORTIEVAR: 'Sortie maintenant sur port parallle.                       
FOR te = 1 TO 10: NEXT te
SORTIEVAR = SORTIEVAR AND &H1:  'sortie du lsb avec horloge basse.
OUT PP, SORTIEVAR: 'Sortie maintenant sur port parallle.                        
FOR te = 1 TO 10: NEXT te

REGDECCOMMAND = INT(REGDECCOMMAND / 2): 'dcalage  droite du data, un seul bit

NEXT I
RETURN
'------------------------ Fin de sous routine ------------------------------



'------------------ Sous routine mot de configuration ----------------------
ecritmotdeconfig:
'Ecriture mot de configuration  l'adresse 2007h
mot$ = MID$(d$, 10 + 2, 2) + MID$(d$, 10, 2)
PRINT
PRINT
PRINT "Ecriture du mot de configuration: ";
OUT PP, &H0: OUT PP, &H4: OUT PP, &H0: 'Le PIC est reset

'envoi mot de contrle de configuration
REGDECCOMMAND = ECRITCONF: GOSUB ecrit6bits:

REGDECDATA = VAL("&H" + mot$): 'criture du mot de configuration
GOSUB ECRIT14BITS

'Incrementation jusqu' 0x2007
FOR n = 1 TO 7: REGDECCOMMAND = INCADR: GOSUB ecrit6bits: NEXT n:

REGDECCOMMAND = Debutprog: GOSUB ecrit6bits:  'Dbut de Programmation
V = TIMER: 'pour une tempo de 10ms
bou6: IF TIMER < V + .02 THEN GOTO bou6
RETURN
'------------------------ Fin de sous routine ------------------------------


'----------------------- Sous routine identificateur -----------------------
identificateur:
PRINT : PRINT
ida$ = MID$(d$, 10, 2)
ida = VAL("&H" + ida$): ida$ = CHR$(ida)
idb$ = MID$(d$, 14, 2)
idb = VAL("&H" + idb$): idb$ = CHR$(idb)
idc$ = MID$(d$, 18, 2)
idc = VAL("&H" + idc$): idc$ = CHR$(idc)
idd$ = MID$(d$, 22, 2)
idd = VAL("&H" + idd$): idd$ = CHR$(idd)
PRINT "Votre identificateur est: "; : PRINT ida$ + idb$ + idc$ + idd$
PRINT
PRINT "Ecriture du mot d'identification: ";

OUT PP, &H0: OUT PP, &H4: OUT PP, &H0: 'Le PIC est reset

'criture du mot d'identification de 4 caractres  l'adresse 2000h
FOR n = 10 TO longueur - 2 STEP 4
REGDECCOMMAND = ECRITCONF: GOSUB ecrit6bits:
mot$ = MID$(d$, n + 2, 2) + MID$(d$, n, 2)
REGDECDATA = VAL("&H" + mot$): 'Conversion en dcimal des valeurs hexa
GOSUB ECRIT14BITS
REGDECCOMMAND = Debutprog: GOSUB ecrit6bits:  'Dbut de Programmation
V = TIMER: 'pour une tempo de 10ms
bou10: IF TIMER < V + .02 THEN GOTO bou10
REGDECCOMMAND = INCADR: GOSUB ecrit6bits:
NEXT n
RETURN
'------------------------ Fin de sous routine ------------------------------



'---------------------sous routine remplissage buffer programme ------------
remplirbufprog:
FOR n = 10 TO longueur - 2 STEP 4
mot$ = MID$(d$, n + 2, 2) + MID$(d$, n, 2)
mot = VAL("&H" + mot$): 'Conversion en dcimal des valeurs hexa
bufprog(adresse) = mot
adresse = adresse + 1
tailleprog = adresse
NEXT n
RETURN
'------------------------ Fin de sous routine ------------------------------



'----------------------sous routine remplissage buffer datas en eeprom -----
remplirbufeeprom:
FOR n = 10 TO longueur - 2 STEP 4
mot$ = MID$(d$, n + 2, 2) + MID$(d$, n, 2)
mot = VAL("&H" + mot$): 'Conversion en dcimal des valeurs hexa
bufdataeeprom(adresse - VAL("&H2100")) = mot
adresse = adresse + 1
NEXT n
RETURN
'------------------------ Fin de sous routine ------------------------------



