;    
;	  500 . 	8-6
;	   	0.05 .
;	   	6250
;	 ,    256	25
;	
#include "P16F84.INC"	; Include header file
        LIST    p=16F84 ; PIC16F84 is the target processor
        __CONFIG _CP_OFF & _WDT_ON & _XT_OSC & _PWRTE_ON
;
;---   --------------------------------------------------
	CBLOCK	0X0C
	   DELOOP	;    
	   STEP 	; .   
	   CLEAR	;   
	   NUMCHAR	;    
	   CHAR		;     
	   PBIT		;   -    CHAR
	   PRTLVL	;      -		
	   CYKL		;      
			;  FM/CW
	ENDC
;---   '' -------------------------------------------------
	DAC0	EQU	0	;    
	DAC1	EQU	1
	PTT	EQU	2	; PA2  PTT
	SOUND	EQU	3	; PA3  FM 
;---   'STEP' -----------------------------------------------
	BLEVEL	EQU	0	;       
	BTEXT	EQU	1	;        
	BTLEVEL	EQU	2	;        
	BPAUSE	EQU	3	;       
	ENDSTEP	EQU	4	;      
	ALLBIT	EQU	5	; Set     
	FM	EQU	6	; Set if FM mode, else CW
	BBEEP	EQU	7	;    / 
;--- ,   -------------------------------------
	ORG	0H
	GOTO	START
;---   - " "  -------------
	ORG	4H		;    
				;
	BCF	INTCON,T0IF	;   
	CALL	MORZE
	MOVLW	0xFF-d'25'	; 0.05 .   500/4     /256
	MOVWF	TMR0
	RETFIE
;----------------------------------------------------------------------
; CQ DE EW1LN QTH LOC KO33RW    LEVEL 
; add offset to pc to generate a computed goto
TEXT:	ADDWF	PCL
        DT      0xEB,0xA1,0xDD,0x70,0x03,0xA8,0x40,0x08,
        DT      0x5D,0xC2,0xEE,0xEE,0x17,0x50,0xE8,0x01,
        DT      0xDD,0x70,0xE1,0x54,0x00,0xBA,0x87,0x77,
        DT      0x0E,0xBA,0x00,0x75,0xC3,0xBB,0x85,0x5D,
        DT      0xC2,0xAE,0xE1,0x74,0x2E,0xE0,0x00,0x00,
        DT      0x01,0x75,0x08,0x55,0xC2,0x17,0x50,0x00,
        DT      0xFF
TEXT1:	ADDWF	PCL	; '1'	
		DT	0xBB,0xBB,0x80,0xFF
TEXT2:	ADDWF	PCL	; '2'	
		DT	0xAE,0xEE,0x00,0xFF
TEXT3:	ADDWF	PCL	; '3'	
		DT	0xAB,0xB8,0x00,0xFF
TEXT4:	ADDWF	PCL	; '4'	
		DT	0xAA,0xE0,0x00,0xFF
;---     . -----------------------------
START	CLRF	STATUS
	BSF	STATUS,RP0	; PAGE1
	MOVLW	0H		;    
	MOVWF	TRISA
;
	BSF	OPTION_REG,PS0	; DIV 256  OSC/4 to TMR0	
	BSF	OPTION_REG,PS1	
	BSF	OPTION_REG,PS2
;
	BCF	OPTION_REG,T0CS	; Timer mode is selected by clearing the T0CS bit
	BCF	OPTION_REG,PSA	; Clearing bit PSA will assign the prescaler to the Timer0 Module
	BCF	STATUS,RP0	; PAGE0
;
	MOVLW	0xFF-d'25'	; 0.05 .   500/4     /256
	MOVWF	TMR0		;  . 128*256=32768
	BSF	INTCON,T0IE	;     
	BSF	INTCON,GIE	;  1 = Enables all un-masked interrupts
				;  0 = Disables all interrupts
;
	CLRF	NUMCHAR		;  
	CLRF	PORTA
	 BSF	PORTA,PTT
	CLRF	STEP
	 BSF	STEP,BLEVEL	;  0  - 1    
	 BSF	STEP,ALLBIT	;  5  -    
	 BSF	STEP,FM
	CLRF	PBIT		;    -    CHAR
	 BSF	PBIT,7		; 7  -    
	MOVLW	d'100'		;  100  - 5
	MOVWF	CLEAR
	MOVLW	d'16'		;  4X4   FM/CW
	MOVWF	CYKL
;
;---   ,      'BBEEP'  
;////////////////////////////////
LOOP	BTFSC	STEP,BBEEP	;   ?
	 CALL	BEEP		;   	
	BTFSS	STEP,FM		; FM mode ?
         CALL	CWMODE		; ,  PTT
	CLRWDT			;   
	GOTO	LOOP		; , ,  .
;////////////////////////////////
;---   ,       
BEEP	BTFSS	STEP,FM		;   FM - 
	 RETURN
	BSF 	PORTA,SOUND	; 1  PA2
	CALL	DELAY		; 78  
	BCF	PORTA,SOUND	; 0  PA2
	CALL	DELAY		; 78  
	RETURN			;      
;---    ---------------------------------------
DELAY	MOVLW	d'26'		; 78/3=26	   
	MOVWF	DELOOP		; 	 801 (0.001248ms) DELAY=156/2=78 
LOPDEL	CLRWDT			; 1
	DECFSZ	DELOOP,1	; 1		 , 
	 GOTO	LOPDEL		; 1
	RETURN
;---CW  / PTT--------------------------------------
CWMODE:	BTFSC	STEP,BPAUSE
	 RETURN			;  , PTT    
	BTFSS	STEP,BBEEP
	 BCF	PORTA,PTT
	BTFSC	STEP,BBEEP
	 BSF	PORTA,PTT
	RETURN
;--------------------------------------------------------------
;
MORZE	BTFSC	STEP,BLEVEL
	 CALL	SETLVL		;   
	BTFSC	STEP,BTEXT
	 CALL	SNDTXT		;    
	BTFSC	STEP,BTLEVEL
	 CALL	SNDLVL		;    
	BTFSC	STEP,BPAUSE
	 CALL	PAUSE		;    
	RETURN
;------      000   --------------
SETLVL: DECFSZ	CYKL		;   
	 GOTO	NXTLVL		; ,    
	BTFSS	STEP,FM		;   
	 GOTO	SET1
	BCF	STEP,FM
LSTCYK:	MOVLW	d'16'		;  4X4   FM/CW
	MOVWF	CYKL
	GOTO	NXTLVL
SET1:	BSF	STEP,FM
	GOTO	LSTCYK
;
NXTLVL:	MOVF	PORTA,W		;   
	ANDLW	3		;   
	SUBLW	3
	BTFSC	STATUS,Z
	 GOTO	POWER0		; ,  . 
	INCF	PORTA		;   
;
ENDLVL:	BCF	STEP,BLEVEL	;    
	BSF	STEP,BTEXT
	RETURN
;
POWER0: BCF	PORTA,DAC0
	BCF	PORTA,DAC1
	GOTO	ENDLVL
;------    -----------------------------
SNDTXT:	BTFSS	PBIT,7		;      ?
	 GOTO	SEND8		; , 
	MOVF	NUMCHAR,W	;      
	CALL	TEXT
	MOVWF	CHAR		;       CHAR
	INCF	NUMCHAR		;  
	SUBLW	0xFF		;     
	BTFSC	STATUS,Z	; ,    
	 GOTO 	SNDEND
	BTFSC	CHAR,7		;  
	BSF	STEP,BBEEP	;   
	BTFSS	CHAR,7		;   
	 BCF	STEP,BBEEP	;   
	RLF	CHAR
	BCF	STATUS,C	; ,   
	RRF	PBIT
	RETURN
;
SEND8:	BTFSC	CHAR,7		;  
	 BSF	STEP,BBEEP	;   
	BTFSS	CHAR,7		;   
	 BCF	STEP,BBEEP	;   
	RLF	CHAR
	BCF	STATUS,C	; ,   
	RRF	PBIT
	BTFSC	STATUS,C	;    (8)    ?
	 RRF	PBIT		; ,   -  7- -   
	RETURN
;--------------------------------
SNDEND:	CLRF	NUMCHAR
	BCF	STEP,BTEXT	;  
	BSF	STEP,BTLEVEL	;     next step
	RETURN
;-------   --------------------------------
SNDLVL:	BTFSS	PBIT,7		;      ?
	 GOTO	SEND8		; , 
	MOVF	PORTA,W
	ANDLW	3
	MOVWF	PRTLVL
	BTFSS	STATUS,Z
	 GOTO	NXT1
	MOVF	NUMCHAR,W	;      
	CALL	TEXT1
	GOTO	NEXTAL	
;
NXT1:	DECFSZ	PRTLVL
	 GOTO	NXT2
	MOVF	NUMCHAR,W	;      
	CALL	TEXT2
	GOTO	NEXTAL	
;
NXT2:	DECFSZ	PRTLVL
	 GOTO	NXT3
	MOVF	NUMCHAR,W	;      
	CALL	TEXT3
	GOTO	NEXTAL	
;
NXT3:	MOVF	NUMCHAR,W	;      
	CALL	TEXT4
;
NEXTAL:	MOVWF	CHAR		;       CHAR
	INCF	NUMCHAR		;  
	SUBLW	0xFF		;     
	BTFSC	STATUS,Z	; ,    
	 GOTO 	LVLEND
	BTFSC	CHAR,7		;  
	 BSF	STEP,BBEEP	;   
	BTFSS	CHAR,7		;   
	 BCF	STEP,BBEEP	;   
	RLF	CHAR
	BCF	STATUS,C	; ,   
	RRF	PBIT
	RETURN

LVLEND:	CLRF	NUMCHAR
	BCF	STEP,BTLEVEL	;  
	BSF	STEP,BPAUSE	;     next step
	RETURN
;-------    --------------------------------
PAUSE:	BSF	PORTA,PTT
	DECFSZ	CLEAR		;  -
	 RETURN			;     
;
	MOVLW	d'100'		;  100  - 5
	MOVWF	CLEAR
	BCF	STEP,BPAUSE	;   . 
	BSF	STEP,BLEVEL
	RETURN
;--------------------------------------------------------------
	END

