;    
;	  500 . 	8-6
;	   	0.05 .
;	   	6250
;	 ,    256	25
;	
#include "P16F84.INC"	; Include header file
        LIST    p=16F84 ; PIC16F84 is the target processor
        __CONFIG _CP_OFF & _WDT_ON & _XT_OSC & _PWRTE_ON
;
;---   --------------------------------------------------
	CBLOCK	0X0C
	   DELOOP	;    
	   STEP 	; .   
	   NUMCHAR	;    
	   CHAR		;     
	   PBIT		;   -    CHAR
	ENDC
;---   '' -------------------------------------------------
	PTT	EQU	2	; PA2  PTT
;---   'STEP' -----------------------------------------------
	ALLBIT	EQU	5	; Set     
	BBEEP	EQU	7	;    / 
;--- ,   -------------------------------------
	ORG	0H
	GOTO	START
;---   - " "  -------------
	ORG	4H		;    
				;
	BCF	INTCON,T0IF	;   
	CALL	SNDTXT
	MOVLW	0xFF-d'25'	; 0.05 .   500/4     /256
	MOVWF	TMR0
	RETFIE
;----------------------------------------------------------------------
; CQ DE EW1LN QTH LOC KO33RW    LEVEL 
; add offset to pc to generate a computed goto
TEXT:	ADDWF	PCL
        DT      0xEB,0xA1,0xDD,0x70,0x03,0xA8,0x40,0x08,
        DT      0x5D,0xC2,0xEE,0xEE,0x17,0x50,0xE8,0x01,
        DT      0xDD,0x70,0xE1,0x54,0x00,0xBA,0x87,0x77,
        DT      0x0E,0xBA,0x00,0x75,0xC3,0xBB,0x85,0x5D,
        DT      0xC2,0xAE,0xE1,0x74,0x2E,0xE0,0x00,0x00,
        DT      0x01,0x75,0x08,0x55,0xC2,0x17,0x50,0x00,
        DT      0xFF
;---     . -----------------------------
START	CLRF	STATUS
	BSF	STATUS,RP0	; PAGE1
	MOVLW	0H		;    
	MOVWF	TRISA
;
	BSF	OPTION_REG,PS0	; DIV 256  OSC/4 to TMR0	
	BSF	OPTION_REG,PS1	
	BSF	OPTION_REG,PS2
;
	BCF	OPTION_REG,T0CS	; Timer mode is selected by clearing the T0CS bit
	BCF	OPTION_REG,PSA	; Clearing bit PSA will assign the prescaler to the Timer0 Module
	BCF	STATUS,RP0	; PAGE0
;
	MOVLW	0xFF-d'25'	; 0.05 .   500/4     /256
	MOVWF	TMR0		;  . 128*256=32768
	BSF	INTCON,T0IE	;     
	BSF	INTCON,GIE	;  1 = Enables all un-masked interrupts
				;  0 = Disables all interrupts
;
	CLRF	NUMCHAR		;  
	CLRF	PORTA
	CLRF	STEP
	 BSF	STEP,ALLBIT	;  5  -    
	CLRF	PBIT		;    -    CHAR
	 BSF	PBIT,7		; 7  -    
;
;---   ,      'BBEEP'  
;////////////////////////////////
LOOP	CLRWDT			;   
	CALL	SWPTT
	GOTO	LOOP		; 
;////////////////////////////////
;
;---CW  / PTT--------------------------------------
SWPTT:	BTFSS	STEP,BBEEP	;  PTT CW
	 BCF	PORTA,PTT
	BTFSC	STEP,BBEEP
	 BSF	PORTA,PTT
	RETURN
;--------------------------------------------------------------
;
;------    -----------------------------
SNDTXT:	BTFSS	PBIT,7		;      ?
	 GOTO	SEND8		; , 
	MOVF	NUMCHAR,W	;      
	CALL	TEXT
	MOVWF	CHAR		;       CHAR
	INCF	NUMCHAR		;  
	SUBLW	0xFF		;     
	BTFSC	STATUS,Z	; ,    
	 GOTO 	SNDEND
	BTFSC	CHAR,7		;  
	BSF	STEP,BBEEP	;   
	BTFSS	CHAR,7		;   
	 BCF	STEP,BBEEP	;   
	RLF	CHAR
	BCF	STATUS,C	; ,   
	RRF	PBIT
	RETURN
;
SEND8:	BTFSC	CHAR,7		;  
	 BSF	STEP,BBEEP	;   
	BTFSS	CHAR,7		;   
	 BCF	STEP,BBEEP	;   
	RLF	CHAR
	BCF	STATUS,C	; ,   
	RRF	PBIT
	BTFSC	STATUS,C	;    (8)    ?
	 RRF	PBIT		; ,   -  7- -   
	RETURN
;--------------------------------
SNDEND:	CLRF	NUMCHAR
	RETURN
;--------------------------------------------------------------
	END

