;    
;	  500 . 	8-6
;	   	0.05 .
;	   	6250
;	 ,    256	25
;	
#include "p16f628a.inc"	; Include header file
	__CONFIG _CP_OFF & _WDT_ON & _BODEN_OFF & _PWRTE_ON & _XT_OSC & _MCLRE_OFF & _LVP_OFF
;
;---   --------------------------------------------------
	CBLOCK		0x20
	   DELOOP	;    
	   STEP 	; .   
	   CLEAR	;   
	   NUMCHAR	;    
	   CHAR		;     
	   PBIT		;   -    CHAR
	   CYKL		;      
			;  FM/CW
	ENDC
;---   '' -------------------------------------------------
	DAC0	EQU	0	;    
	DAC1	EQU	1
	PTT	EQU	2	; PA2  PTT
	SOUND	EQU	3	; PA3  FM 
;---   'STEP' -----------------------------------------------
	BTLEVEL	EQU	0	;       
	BTTEXT	EQU	1	;        
	BTPIP	EQU	2	;      
	BTPAUSE	EQU	3	;       
	ENDSTEP	EQU	4	;      
	ALLBIT	EQU	5	; Set     
	FM	EQU	6	; Set if FM mode, else CW
	BBEEP	EQU	7	;    / 
;--- ,   -------------------------------------
	ORG	0H
	GOTO	START
;---   - " "  -------------
	ORG	4H		;    
				;
	BCF	INTCON,T0IF	;   
	CALL	MORZE
	MOVLW	0xFF-d'25'	; 0.05 .   500/4     /256
	MOVWF	TMR0
	RETFIE
;----------------------------------------------------------------------
; CQ DE EW1LN QTH LOC KO33RW     ,
; add offset to pc to generate a computed goto
TEXT:	ADDWF	PCL
        DT      0xEB,0xA1,0xDD,0x70,0x03,0xA8,0x40,0x08,
        DT      0x5D,0xC2,0xEE,0xEE,0x17,0x50,0xE8,0x01,
        DT      0xDD,0x70,0xE1,0x54,0x00,0xBA,0x87,0x77,
        DT      0x0E,0xBA,0x00,0x75,0xC3,0xBB,0x85,0x5D,
        DT      0xC2,0xAE,0xE1,0x74,0x2E,0xE0,0x00,0x00,
        DT      0x00,0x00,0xFF
;---     . -----------------------------
START	CLRF	STATUS
;	
	CLRF PORTA	;Initialize PORTA by setting
			   	;output data latches
	MOVLW 7H		;Turn comparators off and
	MOVWF CMCON	;enable pins for I/O
					;functions
;
	BSF	STATUS,RP0	; PAGE1
	MOVLW	0H		;    
	MOVWF	TRISA
;
	BSF	OPTION_REG,PS0	; DIV 256  OSC/4 to TMR0	
	BSF	OPTION_REG,PS1	
	BSF	OPTION_REG,PS2
;
	BCF	OPTION_REG,T0CS	; Timer mode is selected by clearing the T0CS bit
	BCF	OPTION_REG,PSA	; Clearing bit PSA will assign the prescaler to the Timer0 Module
	BCF	STATUS,RP0	; PAGE0
;
	MOVLW	0xFF-d'25'	; 0.05 .   500/4     /256
	MOVWF	TMR0		;  . 128*256=32768
	BSF	INTCON,T0IE	;     
	BSF	INTCON,GIE	;  1 = Enables all un-masked interrupts
				;  0 = Disables all interrupts
;
	CLRF	NUMCHAR		;  
	CLRF	PORTA
	 BSF	PORTA,PTT
	CLRF	STEP
	 BSF	STEP,BTPIP	;  0  - 1    
	 BSF	STEP,ALLBIT	;  5  -    
	 BSF	STEP,FM
	CLRF	PBIT		;    -    CHAR
	 BSF	PBIT,7		; 7  -    
	MOVLW	.100		;  100  - 5
	MOVWF	CLEAR
	MOVLW	.4		;  4   FM/CW
	MOVWF	CYKL
;
;---   ,      'BBEEP'  
;////////////////////////////////
LOOP	BTFSC	STEP,BBEEP	;   ?
	 CALL	BEEP		;   	
	BTFSS	STEP,FM		; FM mode ?
         CALL	CWMODE		; ,  PTT
	CLRWDT			;   
	GOTO	LOOP		; , ,  .
;////////////////////////////////
;---   ,       
BEEP	BTFSS	STEP,FM		;   FM - 
	 RETURN
	BSF	PORTA,PTT	;  fm   !
	BSF 	PORTA,SOUND	; 1  PA2
	CALL	DELAY		; 78  
	BCF	PORTA,SOUND	; 0  PA2
	CALL	DELAY		; 78  
	RETURN			;      
;---    ---------------------------------------
DELAY	MOVLW	d'26'		; 78/3=26	   
	MOVWF	DELOOP		; 	 801 (0.001248ms) DELAY=156/2=78 
LOPDEL	CLRWDT			; 1
	DECFSZ	DELOOP,1	; 1		 , 
	 GOTO	LOPDEL		; 1
	RETURN
;---CW  / PTT--------------------------------------
CWMODE:	BTFSC	STEP,BTPAUSE
	 RETURN			;  , PTT    
	BTFSS	STEP,BBEEP	;  PTT CW
	 BCF	PORTA,PTT
	BTFSC	STEP,BBEEP
	 BSF	PORTA,PTT
	RETURN
;--------------------------------------------------------------
;**************************************************************
;       ,      
;**************************************************************
;--------------------------------------------------------------
MORZE	BTFSC	STEP,BTLEVEL
	 CALL	SETLVL		;   
	BTFSC	STEP,BTPIP
	 CALL	SETPIP		;   "PIP"
	BTFSC	STEP,BTPAUSE
	 CALL	PAUSE		;    
	BTFSC	STEP,BTTEXT
	 CALL	SNDTXT		;    
	RETURN
;------          . 
SETPIP	BTFSS	STEP,BBEEP	;   ?
	 GOTO	ONPIP		; , 
	BCF	STEP,BBEEP	; ,  
	BSF	STEP,BTPAUSE	;    
	BCF	STEP,BTPIP	;  .   
	RETURN
;	
ONPIP	BSF	STEP,BBEEP
	RETURN
;------      000   --------------
SETLVL: DECFSZ	CYKL		;    FM/CW
	 GOTO	NXTLVL		; ,    
	BTFSS	STEP,FM		;   
	 GOTO	SET1
	BCF	STEP,FM		; set mode CW
LSTCYK:	MOVLW	.4		;  4   FM/CW
	MOVWF	CYKL
	GOTO	NXTLVL
SET1:	BSF	STEP,FM		; set mode FM
	GOTO	LSTCYK
;
NXTLVL:	MOVF	PORTA,W		;   
	ANDLW	3		;   
	SUBLW	3
	BTFSC	STATUS,Z
	 GOTO	POWER0		; ,  . 
	INCF	PORTA		;   
;
	BCF	STEP,BTLEVEL	;    
	BSF	STEP,BTPIP	; "PIP"     
	RETURN
;
POWER0: BCF	PORTA,DAC0	;  . 
	BCF	PORTA,DAC1
;
ENDLVL:	BCF	STEP,BTLEVEL	;    
	BSF	STEP,BTTEXT
	RETURN
;------    -----------------------------
SNDTXT:	BTFSS	PBIT,7		;      ?
	 GOTO	SEND8		; , 
	MOVF	NUMCHAR,W	;      
	CALL	TEXT
	MOVWF	CHAR		;       CHAR
	INCF	NUMCHAR		;  
	SUBLW	0xFF		;     
	BTFSC	STATUS,Z	; ,    
	 GOTO 	SNDEND
	BTFSC	CHAR,7		;  
	BSF	STEP,BBEEP	;   
	BTFSS	CHAR,7		;   
	 BCF	STEP,BBEEP	;   
	RLF	CHAR
	BCF	STATUS,C	; ,   
	RRF	PBIT
	RETURN
;
SEND8:	BTFSC	CHAR,7		;  
	 BSF	STEP,BBEEP	;   
	BTFSS	CHAR,7		;   
	 BCF	STEP,BBEEP	;   
	RLF	CHAR
	BCF	STATUS,C	; ,   
	RRF	PBIT
	BTFSC	STATUS,C	;    (8)    ?
	 RRF	PBIT		; ,   -  7- -   
	RETURN
;--------------------------------
SNDEND:	CLRF	NUMCHAR
	BCF	STEP,BTTEXT	;  
	BSF	STEP,BTPIP	;     next step
	RETURN
;-------    --------------------------------
PAUSE:	BSF	PORTA,PTT
	DECFSZ	CLEAR		;  -
	 RETURN			;     
;
	MOVLW	d'100'		;  100  - 5
	MOVWF	CLEAR
	BCF	STEP,BTPAUSE	;   . 
	BSF	STEP,BTLEVEL
	RETURN
;--------------------------------------------------------------
	END

