;//////////////////////////////////////////////////////////////////////////
;///                                                                    ///
;///           Turbo-Pascal V24-Interrupt-Support      V2.00            ///
;///                                                                    ///
;///                 (c) Christian Philipps, Moers                      ///
;///                    June 1988 / West-Germany                        ///
;///                                                                    ///
;///                Turbo Pascal 4.0 or above required                  ///
;///                                                                    ///
;//////////////////////////////////////////////////////////////////////////

; This module is hereby donated to the public domain.

;
;                    Datensegment
;

DATA     SEGMENT BYTE PUBLIC

         ; Turbo-Pascal Variable
         EXTRN V24HP      : WORD
         EXTRN V24TP      : WORD
         EXTRN V24BuffEnd : WORD
         EXTRN V24Buff    : BYTE
         EXTRN ComBase    : WORD

DATA     ENDS

;
;                        Codesegment
;

CODE     SEGMENT BYTE PUBLIC

         ASSUME CS:CODE, DS:DATA

         PUBLIC V24Int

;

;CS-relative Daten

_Turbo_DS DW  DATA                              ; Turbo data segment
						; (inserted by linkage editor)

;
;                    Codebereich
;
;PROCEDURE V24Int; interrupt;
;  this routine is executed whenever a character arrives

V24Int   PROC  FAR                               ; Interrupt-Routine


V24Int   ENDP

	 push ds                                 ; save registers
         push ax
         push bx
         push dx
	 mov  ds,CS:_Turbo_DS                    ; set Turbo DS

	 mov  bx,V24TP                           ; ds:bx -> next free slot
	 mov  dx,ComBase                         ; dx = port base-address
         in   al,dx                              ; RBR -> al
	 mov  byte ptr [bx],al                   ; move byte into buffer
	 inc  bx                                 ; pointer to next slot
	 cmp  bx,V24BuffEnd                      ; past the end of the buffer?
	 jle  L1                                 ; no
	 mov  bx,OFFSET V24Buff                  ; yes, so wrap around

L1:      cmp  bx,V24HP                           ; TP=HP --> overflow!
	 jz   L2                                 ; yes, ignore character
	 mov  V24TP,bx                           ; no, save new tail pointer

L2:      mov  al,20H                             ; EOI -> 8259
         out  20H,al                             
	 pop  dx                                 ; restore registers
         pop  bx
         pop  ax
         pop  ds
         iret

CODE     ENDS

END
