;**********************************************************************
;     PIC16F628  ISD1420
;    - 4.
	#include  "p16f628.inc"       ; processor specific variable definitions
	__CONFIG _CP_OFF & _WDT_ON & _BODEN_OFF & _PWRTE_ON & _FOSC_INTOSCIO & _MCLRE_ON & _LVP_OFF
;
;---   --------------------------------------------------
	CBLOCK	0x20
				BITS
				BITS1
				COUNTER_beacon	;   
				TON				;   
;  -------------------------
				RECTIME
				TIME_MS20		;  20
				SEC
				MIN
		                DELAYCSQOFF
;   --------------
				NUMCHAR			;    
				CHAR			;     
				PBIT			;   -    CHAR
	ENDC
;
	CBLOCK	0x71
				w_temp				; variable used for context saving 
				status_temp			; variable used for context saving
	ENDC
;---------------------------------------------------------
LOBYTE		EQU		0xFF-0x42	; 50000	* 4 = 1000000 -  - 20: 0xC350-0x0C -   50000 
HIBYTE		EQU		0xFF-0xC3
HZ2400		EQU		.26		 	;   /16
HZ2000		EQU		.32		 	;   /16
HZ1500		EQU		.42
HZ1000		EQU		.62
HZ700		EQU		.89
HZ300		EQU		.208
TIMEBEACON	EQU		.15			;  
RECTimeOut	EQU		.20         ;   (19)
;-------- PORT B -----------------------------------------
#define	PTT		PORTB,0
#define	CSQ		PORTB,1
#define	enaBEACON	PORTB,2
#define	pinPWM		PORTB,3
#define	pinREC		PORTB,5
#define	recLEDin	PORTB,6
#define	pinPLAY		PORTB,7
;--------BITS-------------------------------------------------------------
#define TAKT		BITS,0		;   20 
#define	modeREC		BITS,1
#define	modePLAY	BITS,2
#define BEACONBIT	BITS,3
#define BEEPBIT		BITS,4
#define BBEEP		BITS,5		;   
#define ReadyPlay	BITS,6
#define BEEPOK		BITS,7
;-------------------------------------------------------------------------
		ORG     0x000             ; processor reset vector
		NOP
		GOTO    START             ; go to beginning of program
;	
		ORG     0x004             ; interrupt vector location
		movwf   w_temp            ; save off current W register contents
		movf	STATUS,w          ; move status register into W register
		movwf	status_temp       ; save off contents of STATUS register
; isr code can go here or be located as a call subroutine elsewhere
			BTFSC	PIR1,TMR1IF	
			 GOTO	TMR1_INT	
			GOTO	ENDINT
;-------------------------
TMR1_INT	
			CLRWDT
			BANKSEL PIR1
			BCF		PIR1,TMR1IF
			MOVLW	LOBYTE				;  
			MOVWF	TMR1L
			MOVLW	HIBYTE
			MOVWF	TMR1H
;
			MOVLW	0xFF 
			XORWF	BITS,W
			XORLW	B'11111110'		;   
			MOVWF	BITS
;
			BTFSC	BEACONBIT		;   
			 CALL	BEACONWORK		;    
;
			BTFSC	BEEPBIT			; /  
			 CALL	BEEPER
;
;
                        INCF    DELAYCSQOFF
			INCF	TIME_MS20,F		;  20    .
			MOVLW	.20
			SUBWF	TIME_MS20,W
			BTFSS	STATUS,Z
 			 GOTO	ENDINT
;-------------------------  --------------------------------------------- 
			CLRF	TIME_MS20
;
			INCF	RECTIME,F
			INCF	SEC,F			;  60    .
			MOVLW	.60
			SUBWF	SEC,W
			BTFSS	STATUS,Z
 			 GOTO	ENDINT
;-------------------------  --------------------------------------------- 
			CLRF	SEC
;
			INCF	COUNTER_beacon,F		;     
;
			INCF	MIN,F			;  60   
			MOVLW	.60
			SUBWF	MIN,W
			BTFSS	STATUS,Z
 			 GOTO	ENDINT


ENDINT	movf    status_temp,w     ; retrieve copy of STATUS register
		movwf	STATUS            ; restore pre-isr STATUS register contents
		swapf   w_temp,f
		swapf   w_temp,w          ; restore pre-isr W register contents
		retfie                    ; return from interrupt
;-------------------------------------------------------------------------
START			CLRWDT
			BANKSEL	TRISB
			MOVLW	B'01000110'			;  B 1,2,6 - 
			MOVWF	TRISB
;			BCF		OPTION_REG,NOT_RBPU	;   
;
			BANKSEL	T2CON
			CLRF	PORTB
			BSF		pinREC
			BSF		pinPLAY
;
			MOVLW	B'00000111'			;  TMR2   16
			MOVWF	T2CON
;  TMR1 
			MOVLW	LOBYTE				;  50000  20 
			MOVWF	TMR1L	
			MOVLW	HIBYTE
			MOVWF	TMR1H
;
			BANKSEL	PIE1
			BSF 	PIE1,TMR1IE			;   TMR1
;
			BANKSEL	T1CON
			BSF		T1CON,TMR1ON		; TMR1 -  
			BSF		INTCON,PEIE			;   
			BSF		INTCON,GIE
;*********************************************************
			BSF		pinPLAY
			BSF		pinREC
			CLRF	BITS
			CLRF	SEC
			CLRF	MIN
			CLRF	COUNTER_beacon
			CLRF	TIME_MS20
; -----   3   
STARTDELAY:		CLRWDT
			MOVLW	.3
			SUBWF	SEC,W
			BTFSS	STATUS,Z
 			 GOTO	STARTDELAY
;
LOOP:			CLRWDT
			 CALL	BEACONTEST			;    
;
			BTFSS	CSQ
			 CALL	TESTONREC
			BTFSC	CSQ
			 CALL	TESTOFFREC
;
			BTFSC	ReadyPlay
			 CALL	TestOnPLay
			BTFSS	RecLEdin
			 CALL	TestOffPLay
;
			BTFSC	ModeREC
			 CALL	RECTimeTest
;
			BTFSC	PTT					;   , ,  
			 CALL	OFF_PTT

			GOTO	LOOP
;*********************************************************
;---------------------------------------------------------
TestOnPLay:		BTFSS	CSQ					;    ?
			 RETURN
			BTFSC	ModePLay			;   ?
			 RETURN						; , 
			BTFSC	ModeREC				;  ?
			 RETURN						;  
			BTFSS	RecLEdin			;   ?
			 RETURN						;  
			BTFSS	PTT					;    ,
			 BSF	PTT					; 
			BCF	pinPLAY				;  
			NOP
			NOP
			CLRWDT
			NOP
			NOP
			BSF	pinPLAY
			BSF	ModePLay			;  
			 RETURN
;---------------------------------------------------------
TestOffPLay:		BTFSC	ModeREC				;  
			 RETURN						;  
			BTFSS	ModePLay			;  ?
			 RETURN
;			
			BSF	pinPLAY				;   
			BCF	ReadyPlay
			BCF	ModePLay
;
			BSF	BEEPBIT				;    
;			BTFSC	BEACONBIT
;			 RETURN						;   ,  
;			BCF		PTT
			 RETURN
;---------------------------------------------------------
TESTONREC:		BTFSC	modeREC				;   ?
			 RETURN						; , 
			BTFSC	ReadyPlay			;    ?
			 RETURN						; , 
;
			CLRF	DELAYCSQOFF
LOOPCSQ:                CLRWDT
                        MOVF	DELAYCSQOFF,w
                        SUBLW	.2
                        BTFSS	STATUS,Z
                         GOTO	LOOPCSQ
			BTFSC	CSQ					;    
			 RETURN
;
			BSF	modeREC				;   
			BCF	pinREC				;  
			CLRF	RECTIME				;   
			 RETURN
;--     --------------------------
TESTOFFREC:		BTFSS	modeREC				;   ?
			 RETURN						; , 
                        CLRF    DELAYCSQOFF
LOOPOFF:                CLRWDT          ;      
                        MOVF	DELAYCSQOFF,w
                        SUBLW	.5
                        BTFSS	STATUS,Z
                         GOTO	LOOPOFF
                        BTFSS	CSQ
                         RETURN         ;    -    
LOOPOFFNEXT:            CLRWDT          ;       
                        MOVF	DELAYCSQOFF,w
                        SUBLW	.7
                        BTFSS	STATUS,Z
                         GOTO	LOOPOFFNEXT
                        BTFSS	CSQ
                         RETURN         ;    -    
;---------------------------------------------------------
OFFREC:		        BCF	modeREC				;   
			BSF	pinREC				;  
			BSF	ReadyPlay			;   
			 RETURN
;---------------------------------------------------------
RECTimeTest:	MOVLW	RECTimeOut      ;  RECTIME => RECTimeOut 
                SUBWF	RECTIME,W
                BTFSS	STATUS,C
                 RETURN
                GOTO	OFFREC          ;  
;---------------------------------------------------------
OFF_PTT:		BTFSC	BEEPBIT				;    
			 RETURN
			BTFSC	MODEPLAY
			 RETURN
			BTFSC	BEACONBIT
			 RETURN
			BCF		PTT
			 RETURN
;---------------------------------------------------------
SOUND:			MOVLW	B'00001100'
			MOVWF	CCP1CON				;  PWM
			 RETURN
;---------------------------------------------------------
NOSOUND:		CLRF	CCP1CON
			BCF		PINPWM
			 RETURN
;---------------------------------------------------------
SETTONE:		MOVF	TON,W
			BANKSEL	PR2				;   
			MOVWF	PR2
			BCF		STATUS,C
			BANKSEL	TON
			RRF		TON,W
			MOVWF	CCPR1L			;   2
			 RETURN
;---------   -------------------------
BEACONTEST:		MOVF	COUNTER_beacon,W
			SUBLW	TIMEBEACON-1
			BTFSC	STATUS,C
			 RETURN
			BTFSC	ModeREC             ;   
			 RETURN
			BTFSC	enaBEACON	    ;   
			 RETURN
;
STARTBEACON: CLRF	PBIT				;    -    CHAR
			BSF		PBIT,7				; 7  -    
			CLRF	NUMCHAR				;  

			BSF		BEACONBIT			;   -  
			CLRF	COUNTER_beacon		;    
			BSF		PTT					;  
;
			MOVLW	HZ1500				;   
			MOVWF	TON
			GOTO	SETTONE
;---------------------------------------------------------
; [ CQ DE ECHO EW1LN K ]
; add offset to pc to generate a computed goto
;TEXT: ADDWF    PCL
;        DT      0x03,0xAE,0x87,0x75,0xC0,0x0E,0xA1,0x00
;        DT      0x21,0xD7,0x42,0xA8,0x77,0x70,0x02,0x17
;        DT      0x70,0xBB,0xBB,0x85,0xD4,0x3A,0x00,0x75
;        DT      0xC0,0x00,0xFF
;---------------------------------------------------------
; [CQ DE ECHO K ]
; add offset to pc to generate a computed goto
TEXT: ADDWF    PCL
        DT      0xEB,0xA1,0xDD,0x70,0x03,0xA8,0x40,0x08
        DT      0x75,0xD0,0xAA,0x1D,0xDC,0x00,0xEB,0x80
        DT      0x00,0xFF
;--   -------
SEL_TEXT:	MOVLW	HIGH TEXT	;  AN556E
			MOVWF	PCLATH
			MOVF	NUMCHAR,W	;      
			CALL	TEXT        ;   W
			RETURN
;------    -----------------------------
BEACONWORK:	BTFSS	PBIT,7		;      ?
			 GOTO	SEND8		; , 
;
			CALL	SEL_TEXT	;   ( )
;			
			MOVWF	CHAR		;       CHAR
			INCF	NUMCHAR,F	;  
			SUBLW	0xFF		;     
			BTFSC	STATUS,Z	; ,    
			 GOTO 	SNDEND
			BTFSC	CHAR,7		;  
			BSF		BBEEP		;   
			BTFSS	CHAR,7		;   
			 BCF	BBEEP		;   
			RLF		CHAR,F
			BCF		STATUS,C	; ,   
			RRF		PBIT,F
			GOTO	SETMORZE	; /  
;
SEND8:		BTFSC	CHAR,7		;  
	 		 BSF	BBEEP	;   
			BTFSS	CHAR,7		;   
			 BCF	BBEEP	;   
			RLF		CHAR,F
			BCF		STATUS,C	; ,   
			RRF		PBIT,F
			BTFSC	STATUS,C	;    (8)    ?
			 RRF	PBIT,F		; ,   -  7- -   
			GOTO	SETMORZE	; /  
;--------------------------------
SNDEND:		CLRF	NUMCHAR
			BTFSC	ModePLay	;   ,  
			 RETURN
			BCF		PTT
			BCF		BEACONBIT
			 RETURN
;---------------------------------------------------------
SETMORZE:	BTFSS	BBEEP			;     
			 GOTO	NOSOUND
			GOTO	SOUND
;---------------------------------------------------------
BEEPER:		BTFSS	TAKT			;   
			 GOTO	BEEPOFF
			MOVLW	HZ2000			;   2000 
			MOVWF	TON
			CALL	SETTONE
			GOTO	SOUND			;    
;
BEEPOFF:	MOVF	CCP1CON,W
			ANDLW	B'00001100'
			SUBLW	B'00001100'
			BTFSS	STATUS,Z		;   ?
			 RETURN
			BCF		BEEPBIT
			GOTO	NOSOUND			;   
;---------------------------------------------------------


            END
