/*------------------------------------------------------------------*/
/* File: C:\cbproj\rsNTP\WSJTX_Sync.h                               */
/*                                                                  */
/* Purpose: See *.c (implementation in a "C"-module)                */
/*------------------------------------------------------------------*/

#ifndef HWND
# include <windows.h> // header with all those funny data types and windows API functions
#endif


#ifndef CPROT /* for peaceful co-existence between C and C++ ... */
// Note on "extern": do not trust the lousy example from Borland !!
//   >extern "c" = wrong    (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

#define WSJTX_SYNC_DUMMY_SERVER_NAME "WSJT-X/FT8 'DT'"

#define WSJTX_SYNC_OPTION_NONE           0x0000
#define WSJTX_SYNC_OPTION_VERBOSE_OUTPUT 0x0001

extern char NtpClient_sz255LastErrorInfo[256]; // also used by WSJTX_Sync_UpdateClockOffset()
extern char WSJTX_Sync_sz511Title[512]; // complete name (aka "title") of WSJT-X's *main window*

CPROT HWND WSJTX_Sync_FindWSJTXMainWindowHandle(void);
CPROT HWND WSJTX_Sync_FindHandleOfDecoderOutputWindow( HWND hWndMainWindow,
     int iOptions, void (*pvInfoStringOuput)(char *cpInfo) );


CPROT BOOL WSJTX_Sync_UpdateClockOffset( // 'twin' of NtpClient_Update(), but without NTP ...
     int   iOptions,              // [in] NTP_SYNC_SHORT_INFO, NTP_SYNC_VERBOSE_INFO, ..
     void (pvInfoStringOuput(char *cpInfo)), // [in, optional] procedure to 'print info strings'
     long double *pClockOffset ); // [out] offset, in seconds, which must be added to the 'local' system time to correct it



/* EOF < C:\cbproj\rsNTP\WSJTX_Sync.h > */

