//---------------------------------------------------------------------------
// File: C:\cbproj\Remote_CW_Keyer\switches.h
// Date: 2023-12-14
// Author: Wolfgang Buescher (DL4YHF)
// Purpose: Project specific 'compilation switches'
//          for an experiment to key certain transceivers 'remotely'
//          Details about the "keying" itself in KeyerThread.c,
//          which glues the most important modules together,
//          (except for the user interface, which was't considered
//           "interesting" at the time of this writing).
//---------------------------------------------------------------------------

#define SWI_APP_EXE_NAME "Remote_CW_Keyer" // <- used for the "instance index detection"
                         // in Utilities.c, thus should be 'sufficiently unique';
                         // also (with the extension ".INI" appended) as the name
                         // of a simple configuration file

#define SWI_HARDCORE_DEBUGGING 1 // Compile for 'hardcore debugging' ? 0=no, 1=yes
#define SWI_CHECK_TIMESTAMPS 1   // Check timestamps plausibility ? 0=no, 1=yes
                                 // (especially timestamps from the AUDIO INPUT,
                                 //  which were error-prone and unreliable)

#define SWI_USE_DSOUND 1 // use "Direct Sound" / dsound_wrapper.c ?
                         // 1 = yes, 0 = no (use something else instead)

#define SWI_USE_WAVE_AUDIO  0 // use ancient "wave audio" API in windows ?
                         // 1 = yes, 0 = no (use something else instead)

#define SWI_USE_CRITICAL_SECTIONS_FOR_AUDIO_IO 0 // use Critical Sections around 'DirectSound' ?
                         // 1 = yes, 0 = no (work around CS with flags, etc)

#define SWI_USE_MIDI   0 // use the PC's MIDI-synthesizer to generate the sidetone ?
                         // 1 = yes, 0 = no (use something else instead)
   // (unacceptable latency with the "built-in MIDI synth emulator",
   //  so forget about MIDI. Also, any 'instrument' tried had a crazy
   //  attack-decay-sustain-release characteristic that could not be
   //  modified via MIDI command. So, also here: use something else instead)

#define SWI_AUDIO_INPUT_DUMMY 0 // replace "audio input" with a dummy signal,
                         // e.g. a full-swing sawtooth from DSW_ReadInput() ?
                         // 1 = yes, 0 = no (always return 'real' audio input signals)

#define SWI_SRCONV_SKIP_DONT_DECIMATE 0 // let SampleRateConv.c simply "skip samples"
                         // in the input instead of properly DECIMATING them ?
                         // 1 = yes (TEST, sounds ugly),  0 = no (normal compilation)

#define SWI_SRCONV_DUPLICATE_DONT_INTERPOLATE 0 // let SampleRateConv.c simply "duplicate samples"
                         // in the input instead of properly INTERPOLATE them, using low-pass filters ?
                         // 1 = yes (TEST, sounds ugly),  0 = no (normal compilation)

#define SWI_USE_HTTP_SERVER 1 // build an application with integrated HTTP server ? 0=no, 1=yes
                         // (at the moment, the HTTP server is ugly and not very
                         //  useful, thus it's NOT contained in the zipped archive)
#ifndef __clang__        // No "clang-enhanced compiler" ? Guess it's Borland..
# define SWI_USE_VORBIS_STREAM 1 // allow streaming audio via Ogg/Vorbis ? 0=no, 1=yes
                         // (requires the bulky "libvorbis" + "libogg",
                         //  which would be too much for a microcontrollers.
                         //  Adding VorbisStream.c to the BCB project caused an
                         //  explosion of the *.exe file size from 840 kByte
                         //  (without Ogg/Vorbis) to 2480 kByte WITH Ogg/Vorbis).
# define SWI_USE_VCL_STYLES 0  // assume the old (Borland-) VCL does NOT support 'Styles'
#else // "__CODEGEARC__" defined -> seem to use an "Embarcadero" C++Builder V12 ->
# define SWI_USE_VORBIS_STREAM 0 // exclude AUDIO STREAMING via Ogg/Vorbis,
      // because the flashy new IDE was unable to import a *.bpr (Borland Project),
      // and having to add dozens of "Ogg"- and "Vorbis" modules manually
      // was too much effort, for too little benefit !
# define SWI_USE_VCL_STYLES 1
#endif // using a "Codegear" / "Embarcadero" compiler (or trusty old Borland) ?

#define SWI_USE_HAMLIB_SERVER 1 // build an application with integrated "Hamlib Net rigctld"-compatible server ? 0=no, 1=yes

#define SWI_SUPPORT_YAESU_5_BYTE_CAT 1 // support the OLD, UGLY, "YAESU 5-BYTE-CAT" (KA7OEI:"FT817 Meow") ? 0=NO, 1=yes, maybe, half-hearted.

#define SWI_NUM_AUX_COM_PORTS 3 // number of 'Additional COM Ports' (formerly: 'Auxiliary COM Ports', thus the "AUX").
      // Not only used in AuxComPorts.h/*.c but also in CwKeyer.h, thus define it HERE.

#define SWI_RIGCTRL_ACT_AS_SERVER 1 // Act as server emulating e.g. an Icom- radio with CI-V on 'Additional COM Ports' ? 0=no, 1=yes

#define SWI_YHF_HELP_INCLUDED 1 // Support "Help via HTML browser" / YHF_Help.cpp ? 0=no, 1=yes                         

// Windows-specific stuff for the GUI. Not interesting for the brave-hearted
// who bites the bullet and re-writes the entire GUI for e.g. Qt / "cross-platform".
#define SWI_GUI_USE_NON_CLIENT_DRAW 0 /* use WM_NCCALCSIZE, WM_NCPAINT & Co ? 0=no, 1=yes */
   // (a window's "non-client area" usually consists of the outer frame / border,
   //  "title bar" with the caption, and usually a few 'system icons', at least 'close',
   //  the main menu. Without custom NON-CLIENT-AREA-drawing, it was impossible
   //  to give those elements a colour that matches e.g. our "dark scheme".)

#define SWI_GUI_USE_OWNER_DRAWN_MENU 0 /* 0 : let the VCL draw the menu, 1 : owner-drawn */


