// File: C:\cbproj\Remote_CW_Keyer\dsound_wrapper.h
// Purpose: Wrapper between non-MFC applications and "Direct Sound" .
// Based on dsound_wrapper.c,v 1.1.1.1 2002/01/22 00:52:45,
//                      "Simplified DirectSound interface",
//                       by Phil Burk & Robert Marsanyi .
//          [see credits and terms of use in the *.c file;
//           we don't want to DUPLICATE all the red tape here in the *.h file]
#ifndef __DSOUND_WRAPPER_H   // protect against multiple header inclusion ..
# define __DSOUND_WRAPPER_H

#ifndef  SWI_AUDIO_INPUT_DUMMY // if NOT defined in the project-specific SWITCHES.H ..
# define SWI_AUDIO_INPUT_DUMMY 0 // .. assume we don't need an "audio input dummy"
#endif

#ifndef _WAVEFORMATEX_
# include <windows.h> // maybe the "newer" dsound.h needs this for 'WAVEFORMATEX' ?
  // when trying to build with "C++Builder 12 Community Edition", this was
  // C:\program files (x86)\embarcadero\studio\23.0\include\windows\sdk\windows.h
  // As usual with this multi-milion-header-file garbage, the 'WAVEFORMATEX'
  // wasn't there (after #including windows.h); a full-text search found it in
  // C:\Program Files (x86)\Embarcadero\Studio\23.0\include\windows\sdk\mmeapi.h .
  // When compiling with the old, never-expiring BCB6 : "cannot open mmeapi.h".
# ifdef __CODEGEARC__ // guess we're not compiling with an old BORLAND compiler->
#  include <mmeapi.h> // "ApiSet Contract for api-ms-win-mm-mme-l1-1-0". OMG..
# endif // def __CODEGEARC__ ?
#endif // ndef _WAVEFORMATEX_ ?

#include <dsound.h>  // No problem when compiled with Borland C++Builder V6,
  // but when trying to build with "C++Builder 12 Community Edition", got
  // "unknown type name WAVEFORMATEX" somewhere inside
  // C:\program files (x86)\embarcadero\studio\23.0\include\windows\sdk\dsound.h

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

#define DSW_NUM_POSITIONS     (4)
#define DSW_NUM_EVENTS        (5)
#define DSW_TERMINATION_EVENT (DSW_NUM_POSITIONS)

typedef struct
{ char sz255DevName[256];
  GUID guid;
} T_DSW_EnumeratedDevice;

typedef struct
{
  DWORD  dwCapturePos;
  DWORD  dwReadPos;
  DWORD  dwTotalSamplesRead;
  double dblTimestamp_s;
  int    iDeltaT_ms;
  int    iTimestampJitter_ms;
} T_DSW_InputCaptureHistoryEntry;


typedef struct
{
    // Audio Output (Microsoft geek speak: "audio rendering" devices) :
    char sz255OutputDeviceName[256];
    LPDIRECTSOUND        pDirectSoundOut;
    LPDIRECTSOUNDBUFFER  pOutputBuffer;
    DWORD                dwWriteOffset; // last write position
    INT                  iOutputSize;
    DWORD                dwBytesPerFrame_out;
    BOOL                 fOutputOpened; // <- kludge added 2024-01-06 to reduce multithreading issues

    // helpers to detect OUTPUT-buffer-UNDERFLOWS (e.g. "output audio drop-outs");
    // later extended for *timestamped* in- and output :
    LARGE_INTEGER        i64CounterTicksPerOutputBuffer; // counter ticks it should take to play a full buffer
    LARGE_INTEGER        i64LastPlayTime; // snapshot of QueryPerformanceCounter() taken in DSW_QueryOutputSpace()
    UINT                 uLastPlayCursor; // snapshot of DirectSound's play cursor taken in DSW_QueryOutputSpace()
    double               dblOutputSamplingRate_Hz;
    double               dblLastOutputTime_s;
    int                  nOutputUnderflows;
    // use double which lets us can play for several thousand years with enough precision:
    double               dblSamplesWrittenToOutput;
    double               dblSamplesPlayedToOutput;

    // Audio Input (Microsoft geek speak: "audio capturing" devices) :
    char   sz255InputDeviceName[256];
    LPDIRECTSOUNDCAPTURE       pDirectSoundIn;
    LPDIRECTSOUNDCAPTUREBUFFER pInputBuffer;
    DWORD  dwInputBufferTailIndex;  //  (formerly called "uReadOffset" / "last read position", too ambiguous)
    DWORD  dwInputFifoSizeInBytes;  // ... BYTES, not SAMPLES ...
    DWORD  dwBytesPerFrame_in;      // a 'frame' seems to be an N-CHANNEL SAMPLE POINT (one point in time)
    BOOL   fInputOpened; // <- kludge added 2024-01-06 to reduce multithreading issues
    double dblInputSamplingRate_Hz;     // input sampling rate in Hertz. CONFIGURATION PARAMETER, not adjusted based on timestamps and sample counter
    double dblTimestampAtInputBufferTail_s;  // "timestamp, in seconds, of the sample point at dwInputBufferTailIndex"
    double dblInputSecondsPerSample; // increment added to dblTimestampAtInputBufferTail_s
            // for each input sample consumed by the application in DSW_ReadBlock() .
            // INITIAL setting is dblInputSecondsPerSample = 1 / dblInputSamplingRate_Hz,
            // but after a couple of seconds with the input active,
            //  dblInputSecondsPerSample will be gradually adjusted
            //  based on a INPUT SAMPLE COUNTER and the TIMESTAMP DIFFERENCE,
            //  using the following two struct members :
    double dblInputSRCalibTime_s;    // 'calibrates' (measures) the INPUT SAMPLING RATE based on DSW_ReadHighResTimestamp_s() [*]
    double dblInputSRCalibError_ppm; // error, in PARTS PER MILLION, between 'nominal' and 'calibrated' input sampling rate.
                                     // ( A cheap 'computer grade' crystal may have 50 ppm frequency error,
                                     //   which may result in f_sample = 48002.4 Hz instead of 48000 )
#   define DSW_INPUT_SR_CALIB_GATE_TIME_S 10 // approximate 'gate time' for counting input samples. Suffix "_S" means SECONDS.
           // Assuming an uncertainty of +/-10 ms in the timestamp readings
           // (caused by thread switching times, and the calling interval
           //  of DSW_QueryInputFilled()), to measure the sampling rate with
           //  dblInputSRCalibError_ppm around 100 (ppm), we need a gate time
           //  of 10 ms * 1e6/100 = 100 seconds, not 10 ! Thus, to make the
           //  readings of dblInputSRCalibTime_s and dblInputSRCalibError_ppm
           //  a bit more "accurate", use an averaging filter with this length:
#   define DSW_INPUT_SR_CALIB_AVERAGE_LENGTH 100 // see test results for different average-filter-lengths in dsound_wrapper.c !
    double dblInputSRCalib_AverageFilterForSecondsPerSample[DSW_INPUT_SR_CALIB_AVERAGE_LENGTH];
    int    iInputSRCalib_AverageFilterNumEntries;


    DWORD  dwInputSRCalibSampleCounter;
            // [*] Assuming that the crystal oscillator that feeds windows' "Performance Counter"
            //     is more accurate, than the oscillator providing the AUDIO SAMPLING CLOCK.
#   define DSW_INPUT_TIMESTAMPING_METHOD 1  /* 0=none, 1=based on counted samples and 'self-calibrated' sampling rate, 2=old stuff.. */

    DWORD  dwTotalSamplesReadFromInput; // <- summed up in DSW_ReadBlock(), used e.g. to synthesize 'test signals'
    double dblSamplesCapturedFromInput; // <- ... by DirectSound
    double dblSamplesReadFromInput;     // <- ... by the application, via DSW_ReadBlock()
    DWORD  dwPrevInputCapturePos, dwPrevInputReadPos; // <- added 2024 to find out
            // what the two outputs ("capture position" and "read position")
            // from IDirectSoundCaptureBuffer_GetCurrentPosition() *really* do,
            // and which range of buffer-byte-indices may actually be READ .
#   define DSW_CAPTURE_HISTORY_LENGTH 256
    T_DSW_InputCaptureHistoryEntry sCaptureHistory[DSW_CAPTURE_HISTORY_LENGTH];
    DWORD  dwCaptureHistoryIndex;
    double dblTimeAtLastCaptureHistoryEntry_s;

    // helpers to detect INPUT-buffer-OVERFLOWS (e.g. "lost samples on INPUT"):
    double dblInputWrapInterval_s;  // time, in seconds, to fill the circular input buffer COMPLETELY
    double dblLastInputTime_s; // high-res timestamp at last INPUT, only for overflow detection.
    int    nInputOverflows;


    // Added by WB: Plain old C-array of "enumerated devices";
    //              filled out in DSW_EnumerateDevices(),
    //              also used to open devices by their NAMES, not GUIDs :
# define DSW_MAX_ENUMERATED_DEVICES 20
    T_DSW_EnumeratedDevice m_sOutputDevices[DSW_MAX_ENUMERATED_DEVICES];
    int   m_nOutputDevices;
    T_DSW_EnumeratedDevice m_sInputDevices[DSW_MAX_ENUMERATED_DEVICES];
    int   m_nInputDevices;

    char sz255LastInputError[256], sz255LastOutputError[256];

    DWORD dwDebug[16];  // array holding e.g. function arguments passed to DSound API functions

} DSoundWrapper;

BOOL    DSW_Init( DSoundWrapper *dsw );
void    DSW_Term( DSoundWrapper *dsw );
double  DSW_ReadHighResTimestamp_s( void );  // high-res timestamp in SECONDS (that's the SI unit for time, basta)
BOOL    DSW_EnumerateDevices( DSoundWrapper *dsw ); // tries to enumerate all DirectSound capable audio in- and output devices

// Our API for audio OUTPUT ("rendering" - details and usage in *.c):
BOOL    DSW_OpenOutputDevice( DSoundWrapper *dsw, const char *sz255DevName );
BOOL    DSW_InitOutputBuffer( DSoundWrapper *dsw, unsigned long nFrameRate,
                              int nChannels, int bufSize );
BOOL    DSW_StartOutput( DSoundWrapper *dsw );
BOOL    DSW_StopOutput( DSoundWrapper *dsw );
DWORD   DSW_GetOutputStatus( DSoundWrapper *dsw );
BOOL    DSW_WriteBlock( DSoundWrapper *dsw, char *buf, long numBytes );
BOOL    DSW_ZeroEmptySpaceInOutputBuffer( DSoundWrapper *dsw );
BOOL    DSW_QueryOutputSpace( DSoundWrapper *dsw, long *bytesEmpty );
void    DSW_CloseOutput( DSoundWrapper *dsw );

// Our API for audio INPUT ("capturing" - details and usage in *.c):
BOOL    DSW_OpenInputDevice( DSoundWrapper *dsw, const char *sz255DevName );
BOOL    DSW_InitInputBuffer( DSoundWrapper *dsw, unsigned long nFrameRate,
                             int nChannels, int bufSize );
BOOL    DSW_StartInput( DSoundWrapper *dsw );
BOOL    DSW_StopInput( DSoundWrapper *dsw );
BOOL    DSW_IsInputOpened( DSoundWrapper *dsw );
BOOL    DSW_QueryInputFilled( DSoundWrapper *dsw, long *bytesFilled );
BOOL    DSW_ReadBlock( DSoundWrapper *dsw, char *buf, long numBytes, double *pdblTimestamp_s );
void    DSW_CloseInput( DSoundWrapper *dsw );

// Extra stuff for troubleshooting / development :
double  DSW_GetMeasuredInputSampleRate( DSoundWrapper *dsw );
double  DSW_GetInputSampleRateFromHistory( DSoundWrapper *dsw, int iHistoryIndex );
#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif  /* __DSOUND_WRAPPER_H */
