//---------------------------------------------------------------------------
// File: C:\cbproj\Remote_CW_Keyer\Utilities.h
//   (stuff collected from other projects, e.g. DL4YHF's Spectrum Lab)
//
// Most recent modifications:
//   2024-11-25: Replaced HUNDREDS of "char pointers" by "const char *"
//               because 'modern compilers' (e.g. "ISO C++11") are
//               very pedantic about char pointers, and refuse to
//               use STRING LITERALS as a "char *" !
//    After that, most of the non-VCL-modules could be compiled
//    with the old Borland C++Builder V6
//    and Embarcadero C++Builder V12 "Athens", "Community Edition".
//               Details about the migration process from BCB V6 to V12
//               in DL4YHF's C:\cbproj\YHF_Tools\StringLib.h .
//
//---------------------------------------------------------------------------

#ifndef  _YHF_UTILITIES_H
# define _YHF_UTILITIES_H      // prevent multiple inclusion


//---------------------------------------------------------------------------
// Data Types
//---------------------------------------------------------------------------

#ifndef DWORD  // only if windows.h / windef.h / what-the-heck hasn't been included yet ...

# ifdef __WIN32__  // to play with Microsoft's "RichText" edit control,
                   // we need to know what a "HWND" is, thus pull in windows.h:
#  include <windows.h>  // <- pulls in a megaton of stuff that we NEVER need..                   
# else // no windows (hip-hip-hooray, compiling for a Microcontroller, not Microsoft..)
typedef unsigned long       DWORD;
# endif // __WIN32__ ?
#endif // 'DWORD' (ancient data type, 32 bit unsigned integer) NOT defined ? 
#ifndef BOOL
typedef int                 BOOL;
#endif
#ifndef BYTE
typedef unsigned char       BYTE;
#endif
#ifndef WORD
typedef unsigned short      WORD;
#endif



//-------------- Old-fashioned global variables -----------------------------
//   (use with discretion; don't wrap each and everything into C++ classes)
// Initialized ONLY to prevent chaos if the application
// "forgets" to call UTL_Init() before any other function of this module.
extern int UTL_iDesktopXMin;    // typically something like ZERO
extern int UTL_iDesktopXMax;    // typically something like 1920
extern int UTL_iDesktopYMin;    // typically something like ZERO
extern int UTL_iDesktopYMax;    // typically something like 1080
extern int UTL_iWindowsVersion; // keep it simple: 0=95/98, 1=XP, 2="Vista" (uurgh..),
                                //  7=WIN7, 8=WIN8, 10=WIN10, .. ?
extern int UTL_iAppInstance;   // Application instance index. Possible values:
             // -1 = "Shame on you, haven't called UTL_Init() yet",
             //  0 = "I am the FIRST instance",
             //  1 = "I am the SECOND instance", etc ..
#  define UTL_MAX_APP_INSTANCES 40 // limits UTL_iAppInstance,
             //  and the number of MUTEXES used to count this, in UTL_Init() .

extern char UTL_sz255LastError[256]; // only for debugging .. contains the last error
             // in human readable form after e.g. complex functions like
             // UTL_EnumerateComPorts() experienced unexpected trouble
             // with OS function calls [for example, being unable to extract
             // a COM port's FRIENDLY NAME, which occasionally happened,
             // depending on the Windows version and who-knows-what-else].
extern BOOL UTL_fRunLogOpened; // TRUE when a 'run-log' shall be written
extern char UTL_sz255LogFile[256]; // name optional name of LOGFILE (""=don't TRY TO log)




//-------------- Functions  --------------------------------------------------

#ifndef CPROT  // For peaceful co-existence of "C" and "C++" ....
# ifdef __cplusplus
#   define CPROT extern "C" // the entire module is written in "C", but also callable from "C++"
# else
#   define CPROT
# endif  // ! "cplusplus"
#endif  // ndef CPROT

CPROT void UTL_Init(void);  // Initializes the module. Call 'as early as you can'.
CPROT void UTL_Exit(void);  // De-initializes the module. Call 'as late as you can'.
CPROT void UTL_LimitInteger( int *pI, int iMin, int iMax );
CPROT DWORD UTL_CRC32( DWORD crc/*~seed*/, const BYTE *data, int len );


CPROT double UTL_GetCurrentUnixDateAndTime(void);
CPROT double UTL_GetCurrentUnixDateAndTime_Fast(void); // similar as above, but FASTER (and not subject to time-syncing service) 
CPROT void UTL_FormatDateAndTime( const char *format, double dblUnixDateTime, char *dest);
CPROT void UTL_SplitUnixDateTimeToYMDhms( double dblUnixDateTime,
         int *piYear, int *piMonth, int *piDay,
         int *piHour, int *piMinute, double *pdblSecond );
CPROT int  UTL_GetDayOfWeekFromUnixDateTime(double dblUnixDateTime); // -> 0=Monday...6=Sunday


CPROT void UTL_LastWindowsErrorCodeToString( DWORD dwWindowsErrorCode, char *pszDest, int iMaxDestLen );
CPROT void UTL_OpenRunLogFile( const char *pszLogFileName );
CPROT BOOL UTL_WriteRunLogEntry( const char * pszFormatString, ... );

CPROT void UTL_ClipPointToDesktop( int *piX, int *piY); // Clips a pixel coordinate into the "total" desktop areavoid UTL_ClipXYWHToDesktop( int *piX, int *piY, int *piWidth, int *piHeight ); // Clips an entire window..

CPROT BOOL UTL_EnumerateComPorts(int *piEnumerator, char *pszComPortName, int iMaxLen);
CPROT int  UTL_ParseNumberFromComPortName(const char *pszComPortName);
CPROT int  UTL_CompareComPortNames( const char *pszComPortName1, const char *pszComPortName2);

CPROT BOOL UTL_GetPathAndNameOfExecutable( char *pszDest, int iMaxLen );
CPROT BOOL UTL_GetPathToMyDataFiles( char *pszDest, int iMaxLen );


//--------------------------------------------------------------------------
// Helpers to deal with old-fashioned INI-files (for 'small config files')
//--------------------------------------------------------------------------

CPROT const char *UTL_IntToStr(long i32);
CPROT long UTL_ReadIntFromIniFile(const char *pszIniFileName, const char *pszSection, const char *pszKeyName, long i32Default);
CPROT void UTL_WriteIntToIniFile(const char *pszIniFileName, const char *pszSection, const char *pszKeyName, long i32Value);
CPROT void UTL_ReadStringFromIniFile(const char *pszIniFileName, const char *pszSection, const char *pszKeyName,
                            const char *pszDefault,  char *pszResult, int iMaxLen );
CPROT void UTL_WriteStringToIniFile(const char *pszIniFileName, const char *pszSection, const char *pszKeyName, 
                            const char *pszValue );

//---------------------------------------------------------------------------
CPROT void ShowError( int iErrorClass, const char * pszFormat, ... );
  // ,---------------------------'
  // '--> ERROR_CLASS_FATAL, ERROR_CLASS_ERROR, ERROR_CLASS_WARNING, ERROR_CLASS_INFO .
  //
  // Not implemented in Utilities.c but "somewhere in the application", e.g. Keyer_GUI.cpp .
  // (because only "the application" knows where, and how, to output
  //  those messages in a relatively thread-safe way, ideally 'colourized')
# define ERROR_CLASS_FATAL      0x0020
# define ERROR_CLASS_ERROR      0x0010
# define ERROR_CLASS_WARNING    0x0008
# define ERROR_CLASS_RX_TRAFFIC 0x0004 /* received "network traffic"    */
# define ERROR_CLASS_TX_TRAFFIC 0x0002 /* transmitted "network traffic" */
# define ERROR_CLASS_INFO       0x0001 /* any kind of "info" (neither warning nor error nor network traffic) */
# define ERROR_CLASS_ALL        0x0000 /* "level" to show ANYTHING */
# define ERROR_CLASS_MASK       0x00FF
  // Since 2024-01, the upper bits in the first argument for ShowError()
  // specify whether to emit the message into the "debug run log" or not,
  // if ShowError() shall prefix the string with a timestamp, etc:
# define SHOW_ERROR_IN_RUN_LOG 0x8000 // -> Let ShowError() pass the message on to UTL_WriteRunLogEntry()
# define SHOW_ERROR_TIMESTAMP  0x4000 // -> Let ShowError() insert a TIMESTAMP (time of day?) before the message





#endif // ndef _YHF_UTILITIES_H ?

/* EOF <Utilities.h> */

