//---------------------------------------------------------------------------
// File:     C:\cbproj\Remote_CW_Keyer\Translator.h
// Purpose:  Translates individual strings
//           or an entire Borland VCL "form"
//           frome one language (english) into another language.
// Notes/Details: See implementation (Translator.cpp) !
//---------------------------------------------------------------------------

#define TRANSLATOR_LANGUAGE_DUTCH     31
#define TRANSLATOR_LANGUAGE_FRENCH    33
#define TRANSLATOR_LANGUAGE_SPANISH   34
#define TRANSLATOR_LANGUAGE_ITALIAN   39
#define TRANSLATOR_LANGUAGE_ENGLISH   44 // "Great Britain" (we "speak British", not US english, sorry fellas)
#define TRANSLATOR_LANGUAGE_DANISH    45
#define TRANSLATOR_LANGUAGE_SWEDISH   46
#define TRANSLATOR_LANGUAGE_NORWEGIAN 47
#define TRANSLATOR_LANGUAGE_POLISH    48
#define TRANSLATOR_LANGUAGE_GERMAN    49
#define TRANSLATOR_LANGUAGE_PORTUGUSE 351
#define TRANSLATOR_LANGUAGE_FINNISH   358
#define TRANSLATOR_LANGUAGE_CZECH     420
#define TRANSLATOR_LANGUAGE_SLOVAK    421


//---------------------------------------------------------------------------
//   Variables (global, say "yucc" if you feel better then ...)
//---------------------------------------------------------------------------

extern int  APPL_iLanguage;          // e.g. 01=US-Englisch, 49=deutsch, etc
extern int  APPL_iPrevLanguage;
extern int  APPL_iLanguageTestMode;  // 0=normal operation,
      //      1=highlight translated controls and list missing translations .
      //  Will be set in the main form via command line switch "\xlate" .
      //  If this flag is set, a list of all untranslated strings will be
      //  dumped into the main window's error log, along with the MODULE NAME.
      //  Missing strings can easily be fixed in TRANSLATIONS.C then . )
extern char APPL_sz255UntranslatedString[256];
extern int  APPL_iTranslationOk;     // additional result from APPL_TranslateString()

//---------------------------------------------------------------------------
const char *APPL_TranslateString( int iTranslateFrom,  // 0=UK, 1=DL, 2=FR, 3=?
              const char * pszString2Translate ); // Called via macro TS(x) = TranslateString .

#define TS(s) APPL_TranslateString(APPL_iPrevLanguage,s)
 // Translates a string from the "previous" language into the "current" one.
 // Used for a lot of visible windows components, which save their
 // "translated" strings.

#define TE(s) APPL_TranslateString(0,s)
 // Translates a string from ENGLISH into the "current" language.
 // Used for string literals built inside the "C"-code,
 // which is always written in english language.

void APPL_TranslateForm( TForm *pForm );
  // Translates a single 'Form' (window) of the application into the language
  //  which has been previously been set with APPL_SetLanguage()

void APPL_TranslateAllForms(void);
  // Translates all 'Forms' (windows) of the application into the language
  //  which has been previously been set with APPL_SetLanguage()

int APPL_GetNumEntriesInTranslationTable( const char **cppSrc );

int APPL_LoadTranslationsFromFile( char *pszPathAndFilename );
  // Tries to load e.g. Translations.c from the C sourcecode *AT RUNTIME* .
  // Returns the NUMBER OF LINES appended to TranslationTableFromFile[],
  // including the important NULL-pointers that mark the end of a group
  // of sub-strings (strings with different languages for the same english 'master').
  // When successful, char *TranslationTableFromFile[]
  // may be used instead of the hard-coded (linked) const char *TranslationTable[].

void APPL_UnloadTranslationsFromFile(void); // Call this on exit !
   // Frees all dynamically allocated strings in TranslationTableFromFile[] .


