//---------------------------------------------------------------------------
// File:     C:\cbproj\Remote_CW_Keyer\Translations.c
// Date:     2024-06-13 (ISO-8601, YYYY-MM-DD)
// Purpose:  Translations of strings used in the application
//           into a few western languages .
//
// Notes/Details:
//  * Unfortunately neither Borland's VCL = "Visual Component Library"
//    nor their IDE [Borland C++ Builder V6] supported UTF-8,
//    thus the encoding of THIS FILE must always remain "ANSI" !
//
//  * Volunteers for translations into other languages with western
//    character sets are welcome. Please coordinate who's currently
//    working on a translation (and thus "temporarily owns" this file)
//    on the user's group: https://groups.io/g/RemoteCWKeyer-Users .
//
//  * A modified copy of this file (Translations.c) can be tested
//    WITHOUT having to re-compile / rebuild the executable :
//    Simply copy your file (with a new language added in the array
//    TranslationTable[]) into THE DIRECTORY WITH THE EXECUTABLE FILE
//    (Remote_CW_Keyer.exe), and the application will LOAD IT AT RUN-TIME.
//    If all works as planned, you will get an info like the following
//    on the program's "Debug" tab:
//     > Loaded 611 lines of translations from C:\Remote_CW_Keyer\Translations.c
//    (assuming you unpacked the executable to C:\Remote_CW_Keyer\Remote_CW_Keyer.exe)
//    Select your new language in the main menu under 'Settings' .. 'Language'.
//    If an entry for the new language is missing in the sub-menu,
//       it can be added (in the C++ Builder 'form'), but THAT requires
//       rebuilding the executable.
//
//  * The use of tabulator characters in this file is
//    *STRICTLY FORBIDDEN* - use an appropriate text editor,
//    or tell your text editor NEVER to use tab characters .
//
//  * Some visual components in the main form (Keyer_Main.dfm)
//    are EXCLUDED from being translated, usually because the space
//    was too limited, and/or the "label" or "caption" are technical abbre-
//    viations. Such VCL components have their "Tag"-value set to 16,
//    which basically indicates "don't translate me" .
//
//  * A list of UNTRANSLATED STRINGS (from all controls in the GUI)
//    can be found in the 'Debug'-tab when running the program
//    with command line option \xlate ("translation test").
//    Actually, most of the lines in TranslationTable[] were generated
//    that way, instead of laboriously copying and pasting them here.
//
//  * The most time-consuming labour isn't the translation itself
//    but making the translated strings short enough to fit inside the
//    fields in the GUI (translated strings shouldn't be much longer
//    than the english original. Only for MENU ITEMS, the length doesn't
//    matter much, because the width of MENUS is automatically adjusted.
//
// Revision history:
//  2024-06-05 : Created, more or less just as a template for volunteers.
//               For a start, only english (the "master" language)
//               and german are actually implemented in TranslationTable[],
//               plus a few half-hearted machine-translated strings in other
//               western languages for testing.
//---------------------------------------------------------------------------

#include <stddef.h>        // NULL must be defined somewhere
#include "Translations.h"  // header file for THIS module


const char *TranslationTable[] =
{ // Format of the translation table:  3 or more lines per string entry..
  //  "<english original (master)>",   <<<< DO NOT MODIFY ! >>>>
  //    "<german translation>",
  //    "<other foreign languages with country-prefix>",
  //  ,--------------------------------|____________|
  //  '--> valid country prefixes are actually the ISO 3166-1 "alpha-2"
  //       two-letter codes, but in lower case, followed by a colon, e.g.:
  //    "fr:" France,      "es:" Spain,   "pt:" Portugal, "it:" Italy,
  //    "nl:" Netherlands, "dk:" Denmark, "no:" Norway,   "se:" Sweden, etc.
  // A NULL POINTER (NULL) marks the end of sub-strings with translations
  //    for a single 'master' string in english language.
  // TWO NULL POINTERS mark the end of the entire table.

  "I/O Config",    // in KeyerMainForm.PageControl1 (TABSHEET captions with very limited space)
    "I/O-Konfig.", // (this was the FIRST STRING translated by APPL_TranslateAllForms(), and used for testing)
    "fr:Config. I/O", // French translation  (placeholder)
    "it:Config. I/O", // Italian translation (placeholder)
    "nl:I/O Config",  // Dutch translation   (placeholder)
    NULL,          // NULL marks the end of the substrings (tranlations) for ONE TEXT

  "Keyer Settings",
    "Keyer-Einst.",
    "fr:Manipulateur", // paramtres du manipulateur ? (too long, got to find an abbreviation)
    "nl:Keyer-inst.",  // keyer-instellingen ?
    NULL,

  "Audio",        // KeyerMainForm.TS_Audio.Caption
    "Audio",
    "fr:L'Audio",
    "nl:Audio",
    NULL,

  "Network",      // KeyerMainForm.TS_Network.Caption
    "Netzwerk",
    "fr:Rseau",  // <- not really sure.. from Google Translate ... just a TEST
    "it:Rete",
    "nl:Netwerk",
    NULL,

  "Debug",   // KeyerMainForm.TS_Debug.Caption : Don't rename (referenced in various menu items)
    "Debug", // nicht umbenennen, denn in vielen Mens wird auf das "Debug-Tab" verwiesen !
    "fr:Dboguer",
    "it:Debug",
    "nl:Debug",
    NULL,

  "Memory",       // KeyerMainForm.TS_Memory.Caption
    "Speicher",
    "fr:Mmoire",
    "it:Memoria",
    "nl:Geheugen",
    NULL,

  "Test",         // KeyerMainForm.TS_Test.Caption
    "Test",
    "fr:Test",
    "it:Test",
    "nl:Test",
    NULL,


  "COM port for Morse key",
    "COM-Port fr Morsetaste",
	"nl:COM-Port naar morse sleutel",
    NULL,

  "COM port to 'key' the radio",
    "COM-Port fr den Transceiver",
	"nl:COM-Port naar Transceiver",
    NULL,

  "'Dot'- or straight key input",
    "Punkt-Kontakt oder Straight Key", // <- almost too long ..
	"nl:Kort of straight key input",
    NULL,

  "'Dash'- input contact",
    "'Strich'-Kontakt",
	"nl:Lang key input",
    NULL,

  "Positive supply voltage (key)",
    "Versorgungsspannung (Taste)",
	"nl:Positieve Voltage (sleutel)",
    NULL,

  "Radio CW keying signal",
    "CW-Tastausgang fr Sender",
	"nl:CW Sleutel Signaal ",
    NULL,

  "Radio PTT switching signal",
    "Sende/Empfangsumschaltung", // <- almost too long ..
	"nl:PTT Signaal",
    NULL,

  "Test input, e.g. for scope CH4",
    "Testeingang, z.B. fr Scope CH4",
	"nl:Test Input bv Scope CH4",
    NULL,

  "Rig Control / CI-V Address",
    "Rig-Steuerung / CI-V Adresse",
	"nl:Rig Control / CI-V Adres",
    NULL,

  "Baudrate",
    "Baudrate",
	"nl:Baudsnelheid",
    NULL,

  "Key Type",
    "Tastentyp",
	"nl:Sleutel Type",
    NULL,

  "Speed (WPM)",
    "Geschw.(WPM)",       // <- almost too long, thus no space
	"nl:Snelheid",
    NULL,

  "Sidetone on 'TXD'",
    "Mithrton an 'TXD'", // <- this is exactly as long as this label may get
	"nl:Sidetoon",
    NULL,


  "Test Input, e.g. for scope CH4",  // in KeyerMainForm.Label15
    "Testeingang, z.B. fr Kanal 4",
	"nl:Test Input bv Scope CH4",
    NULL,

  "Apply new settings and Start",    // in KeyerMainForm.Btn_ApplyAndStart
    "Einstellungen bernehmen und Starten",
	"nl:Instellingen Opslaan en Herstarten",
    NULL,

  "TX hang time / ms",               // in KeyerMainForm.Label28
    "TX-Nachlaufzeit / ms",
	"nl:TX-Nalooptijd / ms",
    NULL,

  "TX delay time / ms",              // in KeyerMainForm.Label29
    "TX-Verzgerung / ms",
	"nl:TX-Vertragingstijd",
    NULL,

  "Audio input device (optional)",   // in KeyerMainForm.Label17
    "Audio-Eingabegert (optional)",
    "fr:priphrique d'entre audio", // <- too long for the trailing "(optional)"
    "it:dispositivo di ingresso audio", // .. same here .. needs truncation
	"nl:Audio Ingang (optioneel)",
    NULL,

  "Audio output device (optional)",  // in KeyerMainForm.Label18
    "Audio-Ausgabegert (optional)",
    "fr:priphrique de sortie audio",
    "it:dispositivo di uscita audio",
	"nl:Audio Uitgang (optioneel)",
    NULL,

  "CW Sidetone on audio output device", // in KeyerMainForm.Label19
    "Mithrton per Audio-Ausgabegert",
	"nl:CW Sidetoon op Audio Uitgang",
    NULL,

  "CW Sidetone rise time (ramp time)", // in KeyerMainForm.Label14
    "Anstiegszeit vom Mithrton",
	"nl:CW Sidetoon Rise Time",
    NULL,

  "allow 'Network audio'",           // in KeyerMainForm.Chk_Audio_AllowNetwork
    "Netzwerk-Audio erlauben",
	"nl:Audio via Netwerk Toestaan",
    NULL,

  "Local host :",                    // in KeyerMainForm.Label20
    "Lokaler Host:",
    NULL,

  "Local IP Addr.:",                     // in KeyerMainForm.Lab_LocalIPHelp
    "Lokale IP-Adr.:",
	"nl:Lokaal IP Adres",
    NULL,

  "Listening port :",                // in KeyerMainForm.Lab_ServerListeningPort
    "Listening Port :",
	"nl:TCP Poort",
    NULL,

  "Network functionality",           // in KeyerMainForm.Lab_NetworkFunctionality
    "Netzwerk-Funktionalitt",
	"nl:Netwerk Functionaliteit",
    NULL,

  "Accepted Users and Permissions:", // in KeyerMainForm.Lab_AcceptedUsers
    "Akzepierte Benutzer und Rechte:",
	"nl:Gebruikers en Rechten",
    NULL,

  "Current Network Status",          // in KeyerMainForm.Lab_NetStatus
    "Aktueller Netzwerkstatus",
	"nl:Netwerk Status",
    NULL,

  "'On the key' now",                // in KeyerMainForm.Lab_Network_OnTheKey
    "Jetzt 'an der Taste'",
	"nl:Gebruiker aan het Seinen",
    NULL,

  "Admin PWD",                       // in KeyerMainForm.Lab_AdminPWD
    "Admin-Passwort",
	"nl:Admin Wachtwoord",
    NULL,

  "Off (neither server nor client)", // in KeyerMainForm.Rbtn_NetworkOff
    "Aus (weder Server noch Client)",
	"nl:Uit (geen server of client)",
    NULL,

  "Client (\"operator's desk\")",    // in KeyerMainForm.Rbtn_Client
    "Client (\"Operator mit Taste\")",
    NULL,

  "Server (\"remote radio site\")",    // in KeyerMainForm.Rbtn_Server
    "Server (\"fernbediente Station\")",
    NULL,

  "allow access via web browser",    // in KeyerMainForm.Chk_EnableHTTP
    "Zugriff per Web-Browser erlauben",
	"nl:Toegang Toestaan via Web Browser",
    NULL,

  "Morse Key Port :",                // in KeyerMainForm.Label3
    "Morsetasten-Port:",
	"nl:Sleutel Poort",
    NULL,

  "Radio Keying Port :",             // in KeyerMainForm.Label4
    "Transceiver-Port:",
	"nl:Tranceiver Poort",
    NULL,

  "inputs:",                         // in KeyerMainForm.Label5 + Label6
    "Eingnge:",
	"nl:Ingang",
    NULL,

  "*manually* control the above digital outputs (DTR, RTS)",  // in KeyerMainForm.Chk_ManualControl
    "*manuelle* Steuerung der obigen Ausgnge (DTR, RTS)",
	"nl:Manuele Controle van de DTR en RTS Uitgangen",
    NULL,

  "&Exit",                           // in KeyerMainForm.Exit1 ..
    "&Beenden",
	"nl:&Einde",
	
    NULL,

  "E&xit without saving",            // in KeyerMainForm.MI_ExitNoSave
    "B&eenden ohne Speichern",
	"nl:E&inde zonder op te slaan",
    NULL,

  "Restore &Defaults",               // in KeyerMainForm.MI_RestoreDefaultSettings
    "Zurck auf &Default-Werte",     // aka "Werkseinstellungen" (aber wo ist das "Werk" ?)
	"nl:Terug naar &Standaard Instellingen",
    NULL,

  "&Colour scheme",  // in KeyerMainForm.MI_ColourScheme
    "&Farbschema",
	"nl:&Kleuren Schema",
    NULL,

  "Connect &scope channel 4 to",      // in KeyerMainForm.MI_ConnectScopeCh4
    "&Scope-Kanal 4 verbinden mit",
	"nl:&Scope kanaal verbinden met",
    NULL,

  "PTT switching ouput",             // in KeyerMainForm.MI_Ch4_PTT
    "PTT-Schaltausgang",
	"nl:PTT Schakel Uitgang",
    NULL,

  "'Test' input",                    // in KeyerMainForm.MI_Ch4_TestInput
    "'Test'-Eingang",
	"nl:Test Ingang",
    NULL,

  "'Network Trouble' flag",          // in KeyerMainForm.MI_Ch4_NetworkTrouble
    "Netzwerk-Trouble Flag",
	"nl:Netwerk Probleem Label",
    NULL,

  "Remote keying FIFO usage",        // in KeyerMainForm.MI_Ch4_KeyingFifoUsage
    "Remote-Keying Pufferstand",
	"nl:Remote FIFO buffer gebruik",
    NULL,

  "Elbug keyer flags",               // in KeyerMainForm.MI_Ch4_ElbugKeyerFlags
    "Elbug-Keyer-Flags",             // oh come on, what a lousy translation..
	"nl:Elbug Sleutel Label",
    NULL,

  "Show &Audio Waveforms",            // in KeyerMainForm.ShowAudioWaveforms1
    "&Audio-Signale anzeigen",
	"nl:&Audio Waveforms Tonen",
    NULL,

  "Audio &Input (from soundcard)",    // in KeyerMainForm.MI_TScopeShowAudioIn
    "Audio-&Eingang (von Soundkarte)",
	"nl:Audio &Ingang van Geluidskaart",
    NULL,

  "Audio &Output (to soundcard)",     // in KeyerMainForm.MI_TScopeShowAudioOut
    "Audio-&Ausgang (zur Soundkarte)",
	"nl:Audio &Uitgang naar Geluidskaart",
    NULL,

  "More '&Keyer Settings'",           // in KeyerMainForm.MI_MoreKeyerSettings
    "Weitere &Keyer-Einstellungen",
	"nl:Meer &Sleutel Instellingen",
    NULL,

  "Watchdog against '&Stuck Paddle Input' ( 10 seconds )",  // in KeyerMainForm.MI_KeyInputWatchdog
    "&Schutz gegen 'klemmenden Paddle-Kontakt' (max 10 Sek.)",
	"nl:Bescherming tegen Constant Sleutel Contact (max 10 sec)",
    NULL,

  "&Debounce paddle inputs (via software)",  // in KeyerMainForm.MI_DebouncePaddleInputs
    "Pa&ddle-Kontakte per Software entprellen",
	"nl:Constant Sleutel Contact via Software opheffen",
    NULL,

  "Clear scope &overlays (markers)",         // in KeyerMainForm.MI_ClearScopeOverlays
    "Scope-&Overlays (Marker) entfernen",
	"nl:Scope &Overlays (markering) Verwijderen",
    NULL,

  "&Erase debug- and decoder output (text)", // in KeyerMainForm.MI_ClearDebugAndDecoderOutput
    "D&ebug- und Decoder-Ausgaben lschen (Text)",
	"nl:D&ebug en Decoder Tekst Verwijderen",
    NULL,

  "Show &Morse decoder output on the 'Debug' tab",  // in KeyerMainForm.MI_Settings_ShowMorseDecoderOutput
    "&Morse-Decoder-Ausgaben im Debug-Tab anzeigen",
    NULL,

  "&Report test results (on the 'Debug' tab)",  // in KeyerMainForm.MI_ReportTestResults
    "E&rgebnisse vom Programm-Test im Debug-Tab anzeigen",
    NULL,

  "S&how 'straight key decoder' history on the Debug tab",  // in KeyerMainForm.MI_ShowStraightKeyDecoderHistory
    "Interne Parameter vom 'Straig&ht Key-Decoder anzeigen",
    NULL,

  "&Pause output on the 'Debug' tab", // in KeyerMainForm.MI_PauseDebugOutput
    "Ausgaben auf dem Debug-Tab anhalten (&pausieren)",
    NULL,

  "&Network Server Options",         // in KeyerMainForm.MI_NetworkServerOptions
    "Optionen des &Netzwerk-Servers",
    NULL,

  "Enable &HTTP (access via web browser)",  // in KeyerMainForm.MI_Server_EnableHTTP
    "&HTTP-Server fr Zugriff per Web-Browser aktiv",
    NULL,

  "Restrict HTTP access to known &users (via Query String)",  // in KeyerMainForm.MI_Server_RestrictAccess
    "HTTP-Zugriff nur fr bekannte &User (per Query String)",
    NULL,

  "Add an audio &test tone  ( 1 kHz, -20 dB, to check for drop-outs)",  // in KeyerMainForm.MI_Server_AddTestTone
    "Audio-Test-&Ton (1 kHz, -20 dB) zum Ausgang addieren",
    NULL,

  "Network &Latency",                // in KeyerMainForm.MI_NetworkLatency
    "Netzwerk-&Latenz",
    NULL,

  "&Auto-Detect",                     // in KeyerMainForm.MI_NetworkLatency_AutoDetect
    "&Automatische Erkennung",
    NULL,

  "Auto-detect, currently measured: ", // Summary for MI_NetworkLatency->Caption, followed by the time in milliseconds
    "Automatische Erkennung, momentan: ", // combined result e.g. "Netzwerk-Latenz: Automatische Erkennung, momentan: 2 ms"
    NULL,

  "Network D&iagnostics and built-in tests",  // in KeyerMainForm.MI_NetworkDiagnostics
    "Netzwerk-D&iagnose und integrierte Tests",
    NULL,

  "Simulate a 'bad' connection (high latency with jitter)",  // in KeyerMainForm.MI_Network_SimulateBadConnection
    "'Schlechte' Verbindung emulieren (hohe Latenz mit Jitter)",
    NULL,

  "Show connect/disconnect log on the 'debug' tab",  // in KeyerMainForm.MI_Network_ShowConnectionLog
    "Verbindungs-Log (connect/disconnect) im Debug-Tab anzeigen",
    NULL,

  "Show network traffic on the 'debug' tab (caution:  a CPU hog!)",  // in KeyerMainForm.MI_Network_ShowNetworkTraffic
    "Netzwerk-Verkehr im Debug-Tab anzeigen (verursacht hohe CPU-Last!)",
    NULL,

  "Show &Network traffic on the 'debug' tab (caution:  a CPU hog!)", // in KeyerMainForm.MI_Debug_ShowNetworkTraffic
    "&Netzwerk-Verkehr im Debug-Tab anzeigen (verursacht hohe CPU-Last!)",
    NULL,

  "Open 'Server Pages' in a web browser",  // in KeyerMainForm.MI_Network_OpenServerPageInBrowser
    "HTTP-Server-Seiten im Web-Browser ffnen",
    NULL,

  "&Rig Control Options",   // in KeyerMainForm.MI_Settings_RigControlOptions
    "&Transceiver-Steuerungs-Optionen", // to translate or not translate, that's the question..
    NULL,

  "Show local RigControl traffic on the 'debug' tab",  // in KeyerMainForm.MI_Network_ShowRigControlTraffic
    "Lokalen Transceiver-Steuerungs-Verkehr im Debug-Tab anzeigen",
    NULL,

  "Reject CI-V 'echos' in the log",        // in KeyerMainForm.MI_RigCtrl_RejectEchosInLog
    "CI-V-Echos bei der Anzeige im Log ausblenden",
    NULL,

  "Reject frequency reports in the log",   // in KeyerMainForm.MI_RigCtrl_RejectFreqRprt
    "VFO-Frequenz-Meldungen bei der Anzeige im Log ausblenden",
    NULL,

  "Reject spectrum data in the log",       // in KeyerMainForm.MI_RigCtrl_RejectSpectrumInLog
    "Spektrum-Daten bei der Anzeige im Log ausblenden",
    NULL,

  "&TRX tab options (control and spectrum display)",  // in KeyerMainForm.MI_Settings_TRX_Options
    "Optionen fr &Transceiver-Steuerung und Spektrum-Anzeige",
    NULL,

  "Use 'shift' and 'control' key as crude paddle replacement",  // in KeyerMainForm.MI_KeyViaShiftAndControl
    "Umschalt- und STRG-Taste als primitiver Paddle-Ersatz", // .. this is ONE of the "Gadgets and Gimmicks"
    NULL,

  "&Index",                // in KeyerMainForm.MI_HelpIndex
    "&Inhalt",
    NULL,

  "I/&O Configuration",    // in KeyerMainForm.MI_Help_IOConfig (menu with sufficient space due to auto-sizing)
    "I/&O-Konfiguration",  // Hotkey 'I' already occupied so use 'O' instead
    NULL,

  "&Keyer Settings",       // in KeyerMainForm.MI_Help_KeyerSettings
    "&Keyer-Einstellungen",
    NULL,

  "&Audio Settings",       // in KeyerMainForm.MI_Help_AudioSettings
    "&Audio-Einstellungen",
    NULL,

  "&Network Settings",     // in KeyerMainForm.MI_Help_NetworkSettings
    "&Netzwerk-Einstellungen",
    NULL,

  "&Timing Scope Display", // in KeyerMainForm.MI_Help_TimingScope
    "&Timing-Scope Anzeige",
    NULL,

  "&Hardware / Circuit Diagrams",  // in KeyerMainForm.MI_Help_Hardware
    "&Hardware / Schaltplne",
    NULL,

  "'&Debug' tab / error messages / troubleshooting",  // in KeyerMainForm.MI_Help_DebugTab
    "&Debug-Tab / Fehlermeldungen / Troubleshooting",
    NULL,

  "Hotkey summary :",     // in KeyerMainForm.Hotkeysummary1 (a menu item, automatic width)
    "bersicht Tastenkrzel :",
    NULL,

  "ESCAPE : Pause immediately (\"panic button\")", // in KeyerMainForm.MI_Hotkey_Escape
    "ESCAPE : Sofort anhalten (\"Panik-Button\")",
    NULL,

  "F1 ... F6 : Start transmitting from memory",  // in KeyerMainForm.MI_Hotkeys_F1_to_F6
    "F1 ... F6 : Test aus Speicher senden",
    NULL,

  "F12 : Stop transmitting from memory",         // in KeyerMainForm.F12Stoptransmittingfrommemory1
    "F12 : Senden von Text aus Speicher abbrechen",
    NULL,

  "&About ...",                                  // in KeyerMainForm.MI_Help_About
    "&ber dieses Programm ...",
    NULL,

  "C&lear all lines in the error history (including decoder output)",  // in KeyerMainForm.MI_ClearErrorHistory
    "Alle Zeilen in der Fehler-Histories &lschen (inkl. Decoder-Ausgaben)",
    NULL,

  "&Copy selection as 'Rich Text' to the clipboard",  // in KeyerMainForm.MI_CopyHistoryToClipboard
    "Markierten Bereich als 'Rich Text' kopieren",
    NULL,

  "&Word Wrap (break long lines to avoid horz. scrolling)", // in KeyerMainForm.MI_Debug_WordWrap
    "&Automatischer Zeilenumbruch (vermeidet horizontales Scrollen)",
    NULL,

  "&Diagnostic Mode (verbose output on the 'Debug' tab)",  // in KeyerMainForm.MI_Network_DiagnosticMode ..
    "&Diagnose-Modus (erweiterte Anzeigen im Debug-Tab)",  // and KeyerMainForm.MI_Debug_VerboseDiagnostics
    NULL,

  "Show &Keying Bytestream (on the 'Debug' tab)",     // in KeyerMainForm.MI_Debug_ShowKeyingBytestream
    "Stream mit Morse-&Tastung anzeigen (im Debug-Tab)",
    NULL,

  "Show Received &Keying Bytestream",                 // in KeyerMainForm.MI_Network_ShowRcvdKeyingBytestream
    "Empfangenen Stream mit Morse-&Tastung anzeigen",
    NULL,

  "Show &Morse decoder output on the 'Debug' tab",    // in KeyerMainForm.MI_Debug_ShowMorseDecoderOutput
    "Ausgabe vom &Morse-Decoder im Debug-Tab anzeigen",
    NULL,

  "Show Network &Connection log on the 'debug' tab",  // in KeyerMainForm.MI_Debug_ShowNetworkConnectionLog
    "Netzwerk-&Verbindungs-Log im Debug-Tab anzeigen",
    NULL,

  "Show &Rig-Control traffic on the 'debug' tab (also a CPU hog!)",  // in KeyerMainForm.MI_Debug_ShowRigCtrlTraffic
    "&Rig-Control-Traffic im Debug-Tab anzeigen",
    NULL,

  "&Pause Display",              // in KeyerMainForm.MI_Debug_PauseDisplay
    "Display anhalten (&Pause)",
    NULL,

  "Show 'Dash' input (yellow)",  // in KeyerMainForm.PM_TScope_ShowDashInput
    "'Strich'-Signal anzeigen (gelb)",
    NULL,

  "Show 'Dot' input (green)",    // in KeyerMainForm.PM_TScope_ShowDotInput
    "'Punkt'-Signal anzeigen (grn)",
    NULL,

  "Show 'Keying' output (red)",  // in KeyerMainForm.PM_TScope_ShowKeyingOutput
    "CW-Tastsignal anzeigen (rot)",
    NULL,

  "Show 'PTT' output or 'Channel 4' (blue)",  // in KeyerMainForm.PM_TScope_ShowPttOutput
    "PTT-Ausgang oder 'Kanal 4' anzeigen (blau)",
    NULL,

  "Show Audio input (violet)",   // in KeyerMainForm.PM_TScope_ShowAudioIn
    "Audio-Eingangssignal anzeigen (violett)",
    NULL,

  "Show Audio ouput (orange)",   // in KeyerMainForm.PM_TScope_ShowAudioOut
    "Audio-Ausgangssignal anzeigen (orange)",
    NULL,

  "Clear scope &overlays (white 'drawn lines')",  // in KeyerMainForm.PM_TScope_ClearOverlays
    "Scope-&Overlays entfernen (weie 'gezeichnete Linien')",
    NULL,

  "&Free run (don't wait for trigger)",  // in KeyerMainForm.PM_TScope_FreeRun
    "&Freies Durchlaufen (ungetriggert)",
    NULL,

  "&Help (about the timing scope)",     // in KeyerMainForm.PM_TScope_Help
    "&Hilfe zum 'Timing Scope'",
    NULL,

  "TRX options (transceiver control and spectrum display)",  // in KeyerMainForm.MI_TRX_Display_Options
    "Transceiver-Optionen (Steuerung und Spektrum-Anzeige)",
    NULL,

  "Keep running even if this tab isn't open",  // in KeyerMainForm.MI_TRX_KeepRunning
    "Auch ohne Anzeige dieses Tabs weiter aktualisieren",
    NULL,

  "Set &VFO frequency to", // part of the menu item text in the spectrum popup, followed by " nnn.nnnn MHz"
    "Setze &VFO-Frequenz auf", // (beware of the syntax, which must match the trailing parameter)
    NULL,

  "Set a temporary marker for this frequency",  // in KeyerMainForm.PM_Spectrum_SetTempMarker
    "Temporren Marker auf diese Frequenz setzen",
    NULL,

  "Set a permanent marker for this frequency",  // in KeyerMainForm.PM_Spectrum_SetPermanentMarker
    "Dauerhaften Marker auf diese Frequenz setzen",
    NULL,

  "Define permanent frequency marker", // title for a DIALOG to enter the marker's name
    "Dauerhaften Marker definieren",
    NULL,

  "Spectrum &Reference Level", // menu item in KeyerMainForm.PM_Spectrum, followed by " : nn.n dB"
    "&Referenz-Level fr Spektrum", // (beware of the syntax, which must match the trailing parameter)
    NULL,


  "Set Spectrum Reference Level",     // title for a DIALOG to modify the 'spectrum reference level'
    "Referenz-Level fr Spektrum",
    NULL,

  "Valid range",   // used in info strings in input dialogs like "Set Spectrum Reference Level" : "Valid range: -20 .. 20 dB"
    "Gltiger Bereich",
    NULL,

  "Current value", // also used in info strings in input dialogs like "Set Spectrum Reference Level" : "Current value: 0.0 dB"
    "Aktueller Wert",
    NULL,

  // Frequently used strings from older applications ..
  "Delete",
    "Lschen",
    "fr:Couper",
    NULL,
  "Cut",
    "Ausschneiden",
    "fr:Couper",
    "nl:Snee",
    NULL,
  "Insert",
    "Einfgen",
    "fr:Insrer",
    "nl:Invoegen",
    NULL,
  "Insert..",
    "Einfgen..",
    "fr:Insrer..",
    "nl:Invoegen..",
    NULL,
  "&File",
    "&Datei",
    "fr:&Fichier",
    "it:&File",
    "nl:&Bestand",
    NULL,
  "New..",         // opens a menu with a selection WHAT shall be created new
    "Neu..",
    "fr:Noveau..",
    "it:Nuovo..",
    "nl:&Nieuw..",
    NULL,
  "New",           // creates a new 'something' without opening a menu
    "Neu",
    "fr:Noveau",
    "it:Nuovo",
    "nl:&Nieuw",
    NULL,
  "Open",
    "ffnen",
    "nl:&Open",
    NULL,
  "&Settings",
    "&Einstellungen",
    "fr:&Paramtres",
    "it:&Impostazioni",
    "nl:&Instellingen",
    NULL,
  "&Default (windows-controlled)",
    "&Default (Windows-gesteuert)",
    NULL,
  "D&ark",
    "D&unkel",
    NULL,

  "Copy",
    "Kopieren",
    "fr:Copier",
    NULL,
  "&Copy",
    "&Kopieren",
    "fr:&Copier",
    NULL,
  "Paste",
    "Einfgen",
    "fr:Coller",
    NULL,
  "&Paste",
    "&Einfgen",
    "fr:C&oller",
    NULL,

 "&Search",
    "&Suchen",
    NULL,
  "Properties",
    "Eigenschaften",
    "fr:Proprits",
    NULL,
  "More",
    "Mehr",
    "fr:plus",
    NULL,
  "More..",           // used in a dozen different places !
    "Mehr..",
    "fr:plus..",
    NULL,
  "More...",
    "Mehr...",
    "fr:plus...",
    NULL,
  "Help",
    "Hilfe",
    "fr:Aide",
    "it:Aiuto",
    "nl:Hulp",
    NULL,
  "&Help",
    "&Hilfe",
    "fr:&Aide",
    "it:&Aiuto",
    "nl:&Hulp",
    NULL,
  "Undo",
    "Rckgg.",
    "fr:Dfair",
    NULL,
  "Apply",
    "Anwenden",
    "fr:Appliquer",
    NULL,
  "Hello",
    "Hallo",
    "fr:Bonjour",
    NULL,
  "oops",       // this is an error message / caption which should never appear !
    "huch!",
    "fr:pardon",
    NULL,
  "Menu",
    "Men",
    "fr:Menu",
    NULL,
  "Width",
    "Breite",
    "fr:Largeur",
    NULL,
  " Width",    // space required because of lousy font rendering !
    "Breite",
    "fr:Largeur",
    NULL,
  "Height",
    "Hhe",
    "fr:Hauteur",
    NULL,
  "Style",
    "Stil",
    "fr:Style", // oui!
    NULL,
  "don't invert",
    "nicht invert.",
    NULL,
  "Lists",
    "Listen",
    NULL,
  "Tree",
    "Baum",
    "fr:Structure arborescente",
    NULL,
  "Invert",
    "Invers",
    "fr:Inversement",
    NULL,
  "Import",
    "Importieren",
    "fr:Importer",
    NULL,
  "Export",
    "Exportieren",
    "fr:Exporter",
    NULL,
  "Example",
    "Beispiel",
    NULL,
  "Stop",
    "Stoppen",
    "fr:S'arrter",
    NULL,
  "Update",
    "Aktualisieren",
    "fr:Actualiser",
    NULL,
  "Apply changes before closing ?",
    "nderungen vor dem Schlieen bernehmen ?",
    NULL,
  "Yes",
    "Ja",
    "fr:Oui",
    NULL,
  "No",
    "Nein",
    "fr:Non",
    NULL,
  "Cancel",
    "Abbrechen",
    "fr:Interrompre",
    NULL,
  "don't show this message again", // in C:\cbproj\UptWin1\MessageBoxWithCheckmark.cpp
    "diese Meldung nicht erneut anzeigen",
    NULL,
  "unknown",
    "unbekannt",
    NULL,
  "please wait",
    "bitte warten",
    NULL,
  "Language",
    "Sprache",
    "fr:Langue",
    NULL,
  "English",
    "Englisch",
    "fr:Anglais",
    NULL,
  "German",
    "Deutsch",
    "fr:Allemand",
    NULL,
  "French",
    "Franzsisch",
    "fr:Franaise",
    NULL,

  NULL, NULL   // end of table  marked by TWO 'NULL' pointers
}; // end TranslationTable[]

