//---------------------------------------------------------------------------
// File:     C:\cbproj\Remote_CW_Keyer\Translations.c
// Date:     2024-06-13 (ISO-8601, YYYY-MM-DD)
// Purpose:  Translations of strings used in the application
//           into a few western languages .
//
// Notes/Details:
//  * Unfortunately neither Borland's VCL = "Visual Component Library"
//    nor their IDE [Borland C++ Builder V6] supported UTF-8,
//    thus the encoding of THIS FILE must always remain "ANSI" !
//
//  * Volunteers for translations into other languages with western
//    character sets are welcome. Please coordinate who's currently
//    working on a translation (and thus "temporarily owns" this file)
//    on the user's group: https://groups.io/g/RemoteCWKeyer-Users .
//
//  * A modified copy of this file (Translations.c) can be tested
//    WITHOUT having to re-compile / rebuild the executable :
//    Simply copy your file (with a new language added in the array
//    TranslationTable[]) into THE DIRECTORY WITH THE EXECUTABLE FILE
//    (Remote_CW_Keyer.exe), and the application will LOAD IT AT RUN-TIME.
//    If all works as planned, you will get an info like the following
//    on the program's "Debug" tab:
//     > Loaded 611 lines of translations from C:\Remote_CW_Keyer\Translations.c
//    (assuming you unpacked the executable to C:\Remote_CW_Keyer\Remote_CW_Keyer.exe)
//    Select your new language in the main menu under 'Settings' .. 'Language'.
//    If an entry for the new language is missing in the sub-menu,
//       it can be added (in the C++ Builder 'form'), but THAT requires
//       rebuilding the executable.
//
//  * The use of tabulator characters in this file is
//    *STRICTLY FORBIDDEN* - use an appropriate text editor,
//    or tell your text editor NEVER to use tab characters .
//
//  * Some visual components in the main form (Keyer_Main.dfm)
//    are EXCLUDED from being translated, usually because the space
//    was too limited, and/or the "label" or "caption" are technical abbre-
//    viations. Such VCL components have their "Tag"-value set to 16,
//    which basically indicates "don't translate me" .
//
//  * A list of UNTRANSLATED STRINGS (from all controls in the GUI)
//    can be found in the 'Debug'-tab when running the program
//    with command line option \xlate ("translation test").
//    Actually, most of the lines in TranslationTable[] were generated
//    that way, instead of laboriously copying and pasting them here.
//
//  * The most time-consuming labour isn't the translation itself
//    but making the translated strings short enough to fit inside the
//    fields in the GUI (translated strings shouldn't be much longer
//    than the english original. Only for MENU ITEMS, the length doesn't
//    matter much, because the width of MENUS is automatically adjusted.
//
// Revision history:
//  2024-06-16 : Dutch translation by Dimitri, PD4DA .  Many thanks !
//
//  2024-06-05 : Created, more or less just as a template for volunteers.
//               For a start, only english (the "master" language)
//               and german are actually implemented in TranslationTable[],
//               plus a few half-hearted machine-translated strings in other
//               western languages for testing.
//---------------------------------------------------------------------------

#include <stddef.h>        // NULL must be defined somewhere
#include "Translations.h"  // header file for THIS module


const char *TranslationTable[] =
{ // Format of the translation table:  3 or more lines per string entry..
  //  "<english original (master)>",   <<<< DO NOT MODIFY ! >>>>
  //    "<german translation>",
  //    "<other foreign languages with country-prefix>",
  //  ,--------------------------------|____________|
  //  '--> valid country prefixes are actually the ISO 3166-1 "alpha-2"
  //       two-letter codes, but in lower case, followed by a colon, e.g.:
  //    "fr:" France,      "es:" Spain,   "pt:" Portugal, "it:" Italy,
  //    "nl:" Netherlands, "dk:" Denmark, "no:" Norway,   "se:" Sweden, etc.
  // A NULL POINTER (NULL) marks the end of sub-strings with translations
  //    for a single 'master' string in english language.
  // TWO NULL POINTERS mark the end of the entire table.

  "I/O Config",    // in KeyerMainForm.PageControl1 (TABSHEET captions with very limited space)
    "I/O Konfig.", // (this was the FIRST STRING translated by APPL_TranslateAllForms(), and used for testing)
    "fr:I/O Config.", // French translation  (placeholder)
    "it:I/O Config.", // Italian translation (placeholder)
    "nl:I/O Config",  // Dutch translation   (placeholder)
    NULL,         // NULL marks the end of the substrings (tranlations) for ONE TEXT

  "Keyer Settings",
    "Keyer-Einst.",
    "fr:Manipulateur", // paramtres du manipulateur ? (too long, got to find an abbreviation)
    "nl:Keyer-inst.",  // keyer-instellingen ?
    NULL,

  "Audio",        // KeyerMainForm.TS_Audio.Caption
    "Audio",
    "fr:L'Audio",
    "nl:Audio",
    NULL,

  "Network",      // KeyerMainForm.TS_Network.Caption
    "Netzwerk",
    "fr:Rseau",  // <- not really sure.. from Google Translate ... just a TEST
    "it:Rete",
    "nl:Netwerk",
    NULL,

  "Debug",   // KeyerMainForm.TS_Debug.Caption : Don't rename (referenced in various menu items)
    "Debug", // nicht umbenennen, denn in vielen Mens wird auf das "Debug-Tab" verwiesen !
    "fr:Dboguer",
    "it:Debug",
    "nl:Debug",
    NULL,

  "Memory",       // KeyerMainForm.TS_Memory.Caption
    "Speicher",
    "fr:Mmoire",
    "it:Memoria",
    "nl:Geheugen",
    NULL,

  "Test",         // KeyerMainForm.TS_Test.Caption
    "Test",
    "fr:Test",
    "it:Test",
    "nl:Test",
    NULL,

  "COM port for Morse key",
    "COM-Port fr Morsetaste",
    "nl:COM-Port naar morse sleutel",
    NULL,

  "Port to key/control the radio",
    "COM-Port fr den Transceiver",
    "nl:COM-Port naar Transceiver",
    NULL,

  "Additional COM Ports",  // in KeyerMainForm.TS_AuxSerialPort
    "Zustzliche COM-Ports",
    NULL,
  "Additional COM port #1",  // in KeyerMainForm.Lab_AuxComPort1
    "Zustzlicher COM-Port #1",
    NULL,
  "Additional COM port #2",  // in KeyerMainForm.Lab_AuxComPort2
    "Zustzlicher COM-Port #2",
    NULL,
  "Additional COM port #3",  // in KeyerMainForm.Lab_AuxComPort3
    "Zustzlicher COM-Port #3",
    NULL,
  "COM port details",  // in Form_AuxComPortDetails
    "COM-Port Details",
    NULL,
  "COM Port",  // in Form_AuxComPortDetails.Lab_Port
    "COM-Port",
    NULL,
  "Tunnel #",  // in Form_AuxComPortDetails.Label1
    "Tunnel #",
    NULL,
  "(programmable functions)",  // in Form_AuxComPortDetails.Lab_ProgrammableFunctions
    "(programmierbare Funktn.)",
    NULL,
  "Params",  // in Form_AuxComPortDetails.Lab_PortParams (not much space there !)
    "Param.",
    NULL,

  "Port used as",         // in KeyerMainForm.Lab_AuxPort1/2/3Usage
    "Port verwendet als", // there's not much space for this 'label' !
    NULL,
  "Signals on this port are used, but the port is currently invalid", // in FillComboWithSerialPorts()
    "Signale an diesem Port werden verwendet, der Port ist aber ungltig",
    NULL,
  "KEYER port, see manual for 'Simple Paddle Adapter'",
    "Keyer-Port, siehe 'Simple Paddle Adapter' im Handbuch",
    NULL,
  "Radio Keying / Radio Control Port (serial)",
    "Port fr die Transceiver-Tastung / Steuerung (seriell)",
    NULL,
  "Optional serial port for multiple purposes (purpose selected below)",
    "Optionaler serieller Port fr verschiedene Zwecke (unten definiert)",
    NULL,
  "Select COM port, or type e.g. COM123 if windows doen't enumerate it", // in AuxComPortDetails_Dialog.cpp
    "COM-Port whlen, oder direkt eingeben (z.B. COM123) wenn nicht aufgelistet",
    NULL,
  "Conflict: Other signals use the same pin on this port !",
    "Konflikt: Andere Signale verwenden den selben Pin an diesem Port !",
    NULL,
  "Please fix conflicts on the 'Config' tab (highlighted red)",
    "Bitte die rot markierten Konflikte unter 'I/O Konfig.' beheben.",
    NULL,
  "Conflicts on the 'Config' tab have been solved.",
    "Konflikte unter 'I/O Konfig.' wurden behoben.",
    NULL,

  "e.g. for the 'Simple Paddle Adapter' : CTS, inverted", // hint for the DOT INPUT selection combo
    "z.B. fr den 'Simple Paddle Adapter' : CTS, invertiert",
    NULL,
  "e.g. for the 'Simple Paddle Adapter' : DSR, inverted", // hint for the DASH INPUT selection combo
    "z.B. fr den 'Simple Paddle Adapter' : DSR, invertiert",
    NULL,
  "typically 'NONE' to use the program's own Semi-BK feature in CW",
    "In CW blicherweise 'NONE', um 'Semi-BK'-Betrieb zu machen",
    NULL,
  "Supply voltage for the 'Simple Paddle Adapter' : DTR",
    "Spannungsversorgung fr den 'Simple Paddle Adapter' : DTR",
    NULL,
  "Supply voltage for old CI-V interfaces : DTR or RTS",
    "Spannungsversorgung fr alte CI-V-Interfaces : DTR oder RTS",
    NULL,
  "for Icom radios, typically DTR",
    "fr Icom-Radios: blicherweise DTR",
    NULL,
  "for modern radios, NONE to use the built-in Semi-BK feature",
    "fr moderne Gerte: NONE, um die interne Semi-BK-Funktion zu verwenden",
    NULL,

  ".. about the AUDIO CW Decoder",  // in KeyerMainForm.Btn_MoreAudioCwDecoderOptions
    ".. ber den AUDIO-CW-Decoder",
    NULL,

  "&Pause display",  // in KeyerMainForm.PM_TScope_Paused
    "&Anzeige anhalten",
    NULL,

  "More Audio Spectrum / Audio DSP Settings...",  // in KeyerMainForm.PM_TScope_MoreAudioSpectrumSettings
    "Weitere Audio-Spektrum / Audio-DSP-Einstellungen...",
    NULL,

  "Spectrogram Colour &Palette",  // in KeyerMainForm.MI_SpectrogramColourPalette
    "&Farbpalette fr Spektrogramm",
    NULL,

  "&Sunrise",  // in KeyerMainForm.MI_WFColourPalette_Sunrise
    "&Sonnenaufgang",
    NULL,

  "&Linrad",  // in KeyerMainForm.MI_WFColourPalette_Linrad
    "&Linrad",
    NULL,

  "&Red",    // in KeyerMainForm.MI_WFColourPalette_Red
    "&Rot",
    NULL,

  "&Green",  // in KeyerMainForm.MI_WFColourPalette_Green
    "&Grn",
    NULL,

  "&Blue",   // in KeyerMainForm.MI_WFColourPalette_Blue
    "&Blau",
    NULL,

  "&Peak-Holding Audio Spectrum",  // in KeyerMainForm.MI_PeakHoldingAudioSpectrum
    "&Spitzenwert vom Spektrum halten",
    NULL,

  "'Dot'- or straight key input",
    "Punkt-Kontakt oder Straight Key", // <- almost too long ..
    "nl:Kort of straight key input",
    NULL,

  "'Dash'- input contact",
    "'Strich'-Kontakt",
    "nl:Lang key input",
    NULL,

  "Manual PTT switching input",  // in KeyerMainForm.Label_ManualPTTInput
    "Manueller PTT-Schalteingang",
    "nl:Handmatige PTT-schakelingang",
    NULL,

  "Key interface supply voltage",
    "Versorgungsspannung (Taste)",
    "nl:Positieve Voltage (sleutel)",
    NULL,

  "Radio interface supply voltage",
    "Versorgungsspannung (Radio)",
    "nl:Positieve Voltage (Radio)",
    NULL,


  "Output to key the radio in CW",
    "CW-Tastausgang fr Sender",
    "nl:CW Sleutel Signaal",
    NULL,

  "Output driving the PTT", // label for CB_RadioPTTControl on the "I/O" tab
    "Sende/Empfangsumschaltung", // <- almost too long ..
    "nl:PTT Signaal",
    NULL,

  "Test input, e.g. for scope CH4",
    "Testeingang, z.B. fr Scope CH4",
    "nl:Test Input bv Scope CH4",
    NULL,

  "Rig Control",     // in KeyerMainForm.TS_RemoteControl
    "Rig Control",
    "nl:Rig Control",
    NULL,

  "Method / Protocol",  // in KeyerMainForm.Lab_RemoteControlMethod ..
    "Methode / Protokoll",   // selects e.g. "None" / "CI-V via COM port" / "Hamlib / Rigctld protocol via TCP/IP"
    "nl:Methode / Protocol",
    NULL,

  "Rig Control / CI-V Address",
    "Rig-Steuerung / CI-V Adresse",
    "nl:Rig Control / CI-V Adres",
    NULL,

  "Baudrate",
    "Baudrate",
    "nl:Baudsnelheid",
    NULL,

  "Key Type",
    "Tastentyp",
    "nl:Sleutel Type",
    NULL,

  "Speed (WPM)",
    "Geschw.(WPM)",       // <- almost too long, thus no space
    "nl:Snelheid",
    NULL,

  "Sidetone on 'TXD'",
    "Mithrton an 'TXD'", // <- this is exactly as long as this label may get
     "nl:Sidetoon",
    NULL,

  "&CW Sidetone (with multiple options...)",  // <- in the 'Help' menu
    "CW-Mithrton (mit mehreren Optionen...)",
    NULL,

  "Test Input, e.g. for scope CH4",  // in KeyerMainForm.Label15
    "Testeingang, z.B. fr Kanal 4",
    "nl:Test Input bv Scope CH4",
    NULL,

  "Apply new settings and Start",    // in KeyerMainForm.Btn_ApplyAndStart
    "Einstellungen bernehmen und Starten",
    "nl:Instellingen Opslaan en Herstarten",
    NULL,

  "Click 'Apply and Start' when the configuration is finished !", // <- shown in the GUI's window title .. shall be similar as the APPLY/START-BUTTON'S caption !
    "Klick auf 'Einstellungen bernehmen und Starten' wenn fertig !",
    "nl: Klik 'Instellingen Opslaan en Herstarten' als ze klaar zijn",
    NULL,

  "TX hang time / ms",               // in KeyerMainForm.Label28
    "TX-Nachlaufzeit / ms",
    "nl:TX-Nalooptijd / ms",
    NULL,

  "TX delay time / ms",              // in KeyerMainForm.Label29
    "TX-Verzgerung / ms",
    "nl:TX-Vertragingstijd",
    NULL,

  "Audio input device (optional)",   // in KeyerMainForm.Label17
    "Audio-Eingabegert (optional)",
    "fr:priphrique d'entre audio", // <- too long for the trailing "(optional)"
    "it:dispositivo di ingresso audio", // .. same here .. needs truncation
    "nl:Audio Ingang (optioneel)",
    NULL,

  "Audio output device (optional)",  // in KeyerMainForm.Label18
    "Audio-Ausgabegert (optional)",
    "fr:priphrique de sortie audio",
    "it:dispositivo di uscita audio",
    "nl:Audio Uitgang (optioneel)",
    NULL,

  "CW Sidetone on audio output device", // in KeyerMainForm.Label19
    "Mithrton per Audio-Ausgabegert",
    "nl:CW Sidetoon op Audio Uitgang",
    NULL,

  "CW Sidetone rise time (ramp time)", // in KeyerMainForm.Label14
    "Anstiegszeit vom Mithrton",
    "nl:CW Sidetoon Rise Time",
    NULL,

  "allow 'Network audio'",           // in KeyerMainForm.Chk_Audio_AllowNetwork
    "Netzwerk-Audio erlauben",
    "nl:Audio via Netwerk Toestaan",
    NULL,

  "Local host :",                    // in KeyerMainForm.Label20
    "Lokaler Host:",
    "nl:Lokaal host:",
    NULL,

  "Local IP Addr.:",                     // in KeyerMainForm.Lab_LocalIPHelp
    "Lokale IP-Adr.:",
    "nl:Lokaal IP Adres",
    NULL,

  "Listening port :",                // in KeyerMainForm.Lab_ServerListeningPort
    "Listening Port :",
    "nl:TCP Poort",
    NULL,

  "Network functionality",           // in KeyerMainForm.Lab_NetworkFunctionality
    "Netzwerk-Funktionalitt",
    "nl:Netwerk Functionaliteit",
    NULL,

  "Accepted Users and Permissions:", // in KeyerMainForm.Lab_AcceptedUsers
    "Akzepierte Benutzer und Rechte:",
    "nl:Gebruikers en Rechten",
    NULL,

  "Current Network Status",          // in KeyerMainForm.Lab_NetStatus
    "Aktueller Netzwerkstatus",
    "nl:Netwerk Status",
    NULL,

  "'On the key' now",                // in KeyerMainForm.Lab_Network_OnTheKey
    "Jetzt 'an der Taste'",
    "nl:Gebruiker aan het Seinen",
    NULL,

  "Admin Password",                  // in KeyerMainForm.Lab_AdminPWD
    "Admin-Passwort",
    "nl:Admin Wachtwoord",
    NULL,

  "Off (neither server nor client)", // in KeyerMainForm.Rbtn_NetworkOff
    "Aus (weder Server noch Client)",
    "nl:Uit (geen server of client)",
    NULL,

  "Client (\"operator's desk\")",    // in KeyerMainForm.Rbtn_Client
    "Client (\"Operator mit Taste\")",
    NULL,

  "Server (\"remote radio site\")",    // in KeyerMainForm.Rbtn_Server
    "Server (\"fernbediente Station\")",
    NULL,

  "allow access via web browser",    // in KeyerMainForm.Chk_EnableHTTP
    "Zugriff per Web-Browser erlauben",
    "nl:Toegang Toestaan via Web Browser",
    NULL,

  "Morse Key Port :",                // in KeyerMainForm.Label3
    "Morsetasten-Port:",
    "nl:Sleutel Poort",
    NULL,

  "Radio Keying Port :",             // in KeyerMainForm.Label4
    "Transceiver-Port:",
    "nl:Tranceiver Poort",
    NULL,

  "inputs:",                         // in KeyerMainForm.Label5 + Label6
    "Eingnge:",
    "nl:Ingang",
    NULL,

  "*manually* control the above digital outputs (DTR, RTS)",  // in KeyerMainForm.Chk_ManualControl
    "*manuelle* Steuerung der obigen Ausgnge (DTR, RTS)",
    "nl:Manuele Controle van de DTR en RTS Uitgangen",
    NULL,

  "&Exit",                           // in KeyerMainForm.Exit1 ..
    "&Beenden",
    "nl:&Einde",
    NULL,

  "E&xit without saving",            // in KeyerMainForm.MI_ExitNoSave
    "B&eenden ohne Speichern",
    "nl:E&inde zonder op te slaan",
    NULL,

  "Restore &Defaults",               // in KeyerMainForm.MI_RestoreDefaultSettings
    "Zurck auf &Default-Werte",     // aka "Werkseinstellungen" (aber wo ist das "Werk" ?)
    "nl:Terug naar &Standaard Instellingen",
    NULL,
  "Restore defaults, recall presets, etc", // hint for a button on the 'Config' tab
    "Default-Werte, Grundeinstellungen abrufen, usw.",
    NULL,
  "&User Interface: Simple",   // 1st possible string in MI_Settings_UserInterface->Caption ...
    "&Benutzeroberflche: Einfach",
    NULL,
  "&User Interface: Complete", // 2nd possible string in MI_Settings_UserInterface->Caption ...
    "&Benutzeroberflche: Komplett",
    NULL,
  "&Simple, only the basic features",   // .. and these are SUBMENUS after MI_Settings_UserInterface->Caption (with hotkeys)
    "&Einfach, nur die Grundfunktionen",
    NULL,
  "&Complete, with all menus and controls", // 2nd possible string in MI_Settings_UserInterface->Caption ...
    "&Komplett, mit allen Mens und Steuerelementen",
    NULL,
  "&Automatic keyboard focus switch (see manual !)",
    "Automatische Fokus-Umschaltung (siehe Handbuch !)",
    NULL,
  "focus switch",    // substring for the summary under 'Settings'..'User Interface', in UpdateItemsInSettingsMenu()
    "Fokus-Umschaltung",
    NULL,
  "menu opened via ALT key", // substring for the summary under 'Settings'..'User Interface', in UpdateItemsInSettingsMenu()
    "Men nur per ALT-Taste",
    NULL,
  "menu always visible",     // substring for the summary under 'Settings'..'User Interface', in UpdateItemsInSettingsMenu()
    "Men immer sichtbar",
    NULL,


  "&Colour scheme",  // in KeyerMainForm.MI_ColourScheme
    "&Farbschema",
    "nl:&Kleuren Schema",
    NULL,

  "Connect &scope channel 4 to",      // in KeyerMainForm.MI_ConnectScopeCh4
    "&Scope-Kanal 4 verbinden mit",
    "nl:&Scope kanaal verbinden met",
    NULL,

  "PTT switching ouput",             // in KeyerMainForm.MI_Ch4_PTT
    "PTT-Schaltausgang",
    "nl:PTT Schakel Uitgang",
    NULL,

  "'Test' input",                    // in KeyerMainForm.MI_Ch4_TestInput
    "'Test'-Eingang",
    "nl:Test Ingang",
    NULL,

  "'Network Trouble' flag",          // in KeyerMainForm.MI_Ch4_NetworkTrouble
    "Netzwerk-Trouble Flag",
    "nl:Netwerk Probleem Label",
    NULL,

  "Remote keying FIFO usage",        // in KeyerMainForm.MI_Ch4_KeyingFifoUsage
    "Remote-Keying Pufferstand",
    "nl:Remote FIFO buffer gebruik",
    NULL,

  "Elbug keyer flags",               // in KeyerMainForm.MI_Ch4_ElbugKeyerFlags
    "Elbug-Keyer-Flags",             // oh come on, what a lousy translation..
    "nl:Elbug Sleutel Label",
    NULL,

  "&Enable Audio CW Decoder",
    "&Audio-CW-Decoder aktivieren",
    NULL,
  "&Signal source",   // used in the *.cpp code, followed by ": " and the source itself as text,
    "&Signalquelle",  // for example in PM_AudioCwDecoderOptions
    NULL,
  "Audio Input",      // input from the Remote CW Keyer's point of view, usually FROM the radio's "audio" or "mod" ouput, narrow-band filtered
    "Audio-Eingang",
    NULL,
  "Audio Output",     // output from the Remote CW Keyer's point of view, usually with the SIDETONE added
    "Audio-Ausgang",
    NULL,
  "Audio &Input", // <- that's the text for a menu item (MI_ACwDecoderSource_Input)
    "Audio-&Eingang",
    NULL,
  "Audio &Output (including sidetone)", // that's the text for a menu item (MI_ACwDecoderSource_Output) to emphasize the difference
    "Audio-&Ausgang (inkl. Mithrton)",
    NULL,
  "Audio for the CW &Decoder (filtered and rectified)",
    "Audio-Signal fr den CW-&Decoder (gleichgerichtet)",
    NULL,

  "Show &Audio Waveforms",            // in KeyerMainForm.ShowAudioWaveforms1
    "&Audio-Signale anzeigen",
    "nl:&Audio Waveforms Tonen",
    NULL,

  "Audio &Input (from soundcard)",    // in KeyerMainForm.MI_TScopeShowAudioIn
    "Audio-&Eingang (von Soundkarte)",
    "nl:Audio &Ingang van Geluidskaart",
    NULL,

  "Audio &Output (to soundcard)",     // in KeyerMainForm.MI_TScopeShowAudioOut
    "Audio-&Ausgang (zur Soundkarte)",
    "nl:Audio &Uitgang naar Geluidskaart",
    NULL,

  "More '&Keyer Settings'",           // in KeyerMainForm.MI_MoreKeyerSettings (part of 'dynamic content')
    "Weitere &Keyer-Einstellungen",
    "nl:Meer &Sleutel Instellingen",
    NULL,

  "Watchdog against '&Stuck Paddle Input' ( 10 seconds )",  // in KeyerMainForm.MI_KeyInputWatchdog
    "&Schutz gegen 'klemmenden Paddle-Kontakt' (max 10 Sek.)",
    "nl:Bescherming tegen Constant Sleutel Contact (max 10 sec)",
    NULL,

  "&Debounce paddle inputs (via software)",  // in KeyerMainForm.MI_DebouncePaddleInputs
    "Pa&ddle-Kontakte per Software entprellen",
    "nl:Constant Sleutel Contact via Software opheffen",
    NULL,

  "Clear scope &overlays (markers)",         // in KeyerMainForm.MI_ClearScopeOverlays
    "Scope-&Overlays (Marker) entfernen",
    "nl:Scope &Overlays (markering) Verwijderen",
    NULL,

  "&Erase debug- and decoder output (text)", // in KeyerMainForm.MI_ClearDebugAndDecoderOutput
    "D&ebug- und Decoder-Ausgaben lschen (Text)",
    "nl:D&ebug en Decoder Tekst Verwijderen",
    NULL,

  "Show &Morse decoder output on the 'Debug' tab",  // in KeyerMainForm.MI_Settings_ShowMorseDecoderOutput
    "&Morse-Decoder-Ausgaben im Debug-Tab anzeigen",
    "nl:&Morse Decoder Tekst in Debug Weergeven",
    NULL,

  "Show Test &Report (summary) on the 'Debug' tab",  // in KeyerMainForm.MI_ReportTestResults
    "E&rgebnisse vom Programm-Test im Debug-Tab anzeigen",
    "nl:Test &Resultaten in Debug Weergeven",
    NULL,

  "&More built-in tests (with output on the 'Debug' tab)", // MI_MoreBuiltInTests
    "&Weitere Tests (mit Ausgabe im Debug-Tab)",
    NULL,

  // Used in multiple menu items (MI_ListAndEditRigParams, MI_Debug_ListAndEditRigParams):
  "&List / Edit Rig Parameters and Settings on the 'Debug' tab",
    "'Rig'-Parameter und Einstellungen im Debug-Tab anzeigen / bearbeiten",
    "nl:'Rig Control' parameters weergeven en veranderen",
    NULL,

  "List User Defined &Bands on the 'Debug' tab",  // in KeyerMainForm.MI_ListUserDefinedBands
    "&Benutzerdefinierte Bnder im Debug-Tab auflisten",
    NULL,

  "List User Defined &Frequencies on the 'Debug' tab",
    "Benutzerdefinierte %Frequenzen im Debug-Tab auflisten",
    NULL,
  "&Enumerate Audio Devices",
    "&Audio-Gerte auflisten",
    NULL,
  "&Show GUI events on the 'Debug' tab",            // .. for debugging, on the DEBUG tab, MI_Test_ShowGuiEvents
    "&GUI-Ereignisse im Debug-Tab anzeigen",
    NULL,

  "S&how 'straight key decoder' history on the Debug tab",  // in KeyerMainForm.MI_ShowStraightKeyDecoderHistory
    "Interne Parameter vom 'Straig&ht Key-Decoder anzeigen",
    "nl:Straight Sleutel Parameters in Debug Weergeven",
    NULL,

  "&Pause output on the 'Debug' tab", // in KeyerMainForm.MI_PauseDebugOutput
    "Ausgaben auf dem Debug-Tab anhalten (&pausieren)",
    "nl:Weergave in Debug &Pauzeren",
    NULL,

  "&Network Server Options",         // in KeyerMainForm.MI_NetworkServerOptions
    "Optionen des &Netzwerk-Servers",
    "nl:&Netwerk Server Opties",
    NULL,

  "enable Hamlib Net Server",        // in KeyerMainForm.Chk_EnableBuiltInHamlibServer
    "Hamlib Net Server aktivieren",
    "nl:Hamlib Net Server inschakelen",
    NULL,

  "&Enable",   // in KeyerMainForm.MI_HLServer_Enable (submenu for the Hamlib server)
    "&Aktivieren",
    "nl:&Inschakelen",
    NULL,

  "enabled",  // part of a longer string assembled via code in Keyer_Main.cpp
    "aktiv",
    NULL,

  "disabled", // part of a longer string assembled via code in Keyer_Main.cpp
    "passiv",
    NULL,

  "Built-in &Hamlib 'Net' Server Options", // part of a string assembled in Keyer_Main.cpp
    "Optionen fr den integrierten &Hamlib 'Net' Server",
    "nl:&Hamlib 'Net' Server Opties",
    NULL,

  "Show &verbose diagnostic output", // in KeyerMainForm.MI_HLServer_VerboseOutput
    "&Erweiterte Diagnose-Ausgaben",
    "nl:&Uitgebreide diagnostische informatie",
    NULL,

  "Switch to the Control tab",       // in KeyerMainForm.MI_HLServer_OpenControlTab
    "Zu den Einstellungen umschalten",
    "nl:Ga naar het tabblad Controle",
    NULL,

  "&Main menu, status indicators, tabsheets",  // in KeyerMainForm.MI_Help_MainMenu
    "&Hauptmen, Status-Indikatoren, Registerkarten",
    NULL,

  "T&RX (Transceiver Control and Remote Spectrum display)",  // in KeyerMainForm.MI_Help_TransceiverControl
    "T&RX (Transceiver-Steuerung, Remote Spectrum-Anzeige)",
    "nl:T&RX (Transceiver Controle, Remote Spectrum weergave)",
    NULL,

  "Enable &HTTP (access via web browser)",  // in KeyerMainForm.MI_Server_EnableHTTP
    "&HTTP-Server fr Zugriff per Web-Browser aktiv",
    "nl:&HTTP Server Activeren",
    NULL,

  "Restrict HTTP access to known &users (via Query String)",  // in KeyerMainForm.MI_Server_RestrictAccess
    "HTTP-Zugriff nur fr bekannte &User (per Query String)",
    "nl:HTTP Toegang Beperken tot Gebr&uikers via Query String",
    NULL,

  "Add an audio &test tone  ( 1 kHz, -20 dB, to check for drop-outs)",  // in KeyerMainForm.MI_Server_AddTestTone
    "Audio-Test-&Ton (1 kHz, -20 dB) zum Ausgang addieren",
    "nl:Geluids&toon (1 khz) Toevoegen",
    NULL,

  "Network &Latency",                // in KeyerMainForm.MI_NetworkLatency
    "Netzwerk-&Latenz",
    "nl:Netwerk &Latentie",
    NULL,

  "&Auto-Detect",                     // in KeyerMainForm.MI_NetworkLatency_AutoDetect
    "&Automatische Erkennung",
    "nl:&Auto Detectie",
    NULL,

  "Auto-detect, currently measured: ", // Summary for MI_NetworkLatency->Caption, followed by the time in milliseconds
    "Automatische Erkennung, momentan: ", // combined result e.g. "Netzwerk-Latenz: Automatische Erkennung, momentan: 2 ms"
    "nl:Auto Detectie in ms:",
    NULL,

  "Network D&iagnostics and built-in tests",  // in KeyerMainForm.MI_NetworkDiagnostics
    "Netzwerk-D&iagnose und integrierte Tests",
    "nl:Netwerk D&iagnose en ingebouwde Tests",
    NULL,

  "Simulate a 'bad' connection (high latency with jitter)",  // in KeyerMainForm.MI_Network_SimulateBadConnection
    "'Schlechte' Verbindung emulieren (hohe Latenz mit Jitter)",
    "nl:Hoge Latentie (lag/jitter) verbinding Simuleren",
    NULL,

  "Show connect/disconnect log on the 'debug' tab",  // in KeyerMainForm.MI_Network_ShowConnectionLog
    "Verbindungs-Log (connect/disconnect) im Debug-Tab anzeigen",
    "nl:Verbindingsinformatie (connect/disconnect) in Debug Weergeven",
    NULL,

  "Show network traffic on the 'debug' tab (caution:  a CPU hog!)",  // in KeyerMainForm.MI_Network_ShowNetworkTraffic
    "Netzwerk-Verkehr im Debug-Tab anzeigen (verursacht hohe CPU-Last!)",
    "nl:Netwerk Verkeer in Debug Weergeven (!!Hoog CPU Gebruik!!)",
    NULL,

  "Show &Network traffic on the 'debug' tab (caution:  a CPU hog!)", // in KeyerMainForm.MI_Debug_ShowNetworkTraffic
    "&Netzwerk-Verkehr im Debug-Tab anzeigen (verursacht hohe CPU-Last!)",
    "nl:Netwerk Verkeer in Debug Weergeven (!!Hoog CPU Gebruik!!)",
    NULL,

  "Show &Hamlib Server traffic on the 'debug' tab",  // in KeyerMainForm.MI_HLServer_ShowTraffic
    "&Hamlib-Server-Verkehr im Debug-Tab anzeigen",
    "nl:&Hamlib Server Verkeer in Debug Weergeven",
    NULL,

  "Open 'Server Pages' in a web browser",  // in KeyerMainForm.MI_Network_OpenServerPageInBrowser
    "HTTP-Server-Seiten im Web-Browser ffnen",
    "nl:Open HTTP Server in Web Browser",
    NULL,


  "&Rig Control and Traffic Monitor Options",   // in KeyerMainForm.MI_Settings_RigControlOptions
    "Optionen fr &TRX-Steuerung und Traffic Monitor", // to translate or not translate, that's the question..
    "nl:Transceiver Aansturing Opties",
    NULL,

  "Show local RigControl traffic on the 'debug' tab",  // in KeyerMainForm.MI_Network_ShowRigControlTraffic
    "Lokalen Transceiver-Steuerungs-Verkehr im Debug-Tab anzeigen",
    "nl:Transceiver Aansturing Weergeven in Debug",
    NULL,

  "Reject CI-V 'echos'",        // in KeyerMainForm.MI_RigCtrl_RejectEchosInLog
    "CI-V-Echos bei der Anzeige ausblenden",
    "nl:CI-V Echo's blokkeren",
    NULL,

  "Reject frequent periodic commands",  // in KeyerMainForm.MI_RigCtrl_RejectPeriodicCmds
    "Hufige, periodisch bertragene Meldungen ausblenden",
    "nl:Periodiek Meldingen blokkeren",
    NULL,

  "Reject spectrum data",       // in KeyerMainForm.MI_RigCtrl_RejectSpectrumInLog
    "Spektrum-Daten bei der Anzeige ausblenden",
    "nl:Spectrum Data blokkeren",
    NULL,

  "Reject frequency (\"VFO\") reports",
    "VFO-Frequenz-Meldungen ausblenden",
    "nl:Frequentie Meldingen blokkeren",
    NULL,

  "Reject ANY KNOWN COMMAND in the traffic log",  // in KeyerMainForm.MI_RigCtrl_RejectAnyKnownCommandFromLog
    "Alle BEKANNTEN Befehle im log ausblenden",
    NULL,

  "Traffic Monitor &Extra Columns",  // in KeyerMainForm.MI_TrafficMon_ExtraColumns
    "&Zustzliche Spalten im Traffic Monitor",
    NULL,
  "&All",  // in KeyerMainForm.MI_TMColumns_All
    "&Alle",
    NULL,
  "&Timestamp",  // in KeyerMainForm.MI_TMColumns_Time
    "&Zeitstempel",
    NULL,
  "&RX / TX",  // in KeyerMainForm.MI_TMColumns_TX_RX
    "&RX / TX",
    NULL,
  "&Payload Length",  // in KeyerMainForm.MI_TMColumns_PayloadLength
    "&Payload-Lnge",
    NULL,
  "&Comments (from protocol decoders)",  // in KeyerMainForm.MI_TMColumns_Comment
    "&Kommentare (vom Paket-Decoder)",
    NULL,
  "Traffic Monitor &Timestamp Format",  // in KeyerMainForm.MI_TrafficMon_Timestamp
    "&Format des Zeitstempels",
    NULL,
  "hh:mm:ss.s (time in UTC)",  // in KeyerMainForm.MI_TMon_Timestamp_UTC
    "hh:mm:ss.s (Zeit in UTC)",
    NULL,
  "Milliseconds",  // in KeyerMainForm.MI_TMon_Timestamp_Milliseconds
    "Millisekunden",
    NULL,
  "Traffic Monitor Trigger &Options",  // in KeyerMainForm.MI_TrafficMon_TriggerOptions
    "Tigger-&Optionen fr den Traffic Monitor",
    NULL,
  "Pause on full FIFO",  // in KeyerMainForm.MI_TrafficMon_PauseOnFullFIFO
    "Pause bei vollem Puffer",
    NULL,
  "Pause on &Errors or unknown messages",  // in KeyerMainForm.MI_TrafficMonitor_PauseOnError
    "Pause bei &Fehlern oder unbekannten Befehlen",
    NULL,
  "Pause when &initialisation done",  // in KeyerMainForm.MI_TrafficMonitor_PauseOnInitDone
    "Pause beim Abschluss der &Initialisierung",
    NULL,
  "Show traffic from 'Additional COM Ports' with other purposes",  // in KeyerMainForm.MI_Debug_ShowAuxComTraffic
    "Meldungen von 'Zustzlichen COM-Ports' anzeigen",
    NULL,
  "Serial &Text Terminal mode (using an additional COM port) ",  // in KeyerMainForm.MI_Debug_SerialTextTerminal
    "&Text-Terminal-Mode (am zustzlichen COM-Port) ",
    NULL,
  "&Enable 'Hamlib' Server",  // in KeyerMainForm.MI_HLServer_Enable
    "'Hamlib-Server aktivieren (experimentell)",
    NULL,
  "Turn off when &closing",  // in KeyerMainForm.MI_Funcs_PowerOffWhenClosing
    "TRX beim Beenden abschalten",
    NULL,


  "&TRX tab options (control and spectrum display)",  // in KeyerMainForm.MI_Settings_TRX_Options
    "Optionen fr &Transceiver-Steuerung und Spektrum-Anzeige",
    "nl:Transceiver Aansturing en Spectrum Data Opties",
    NULL,

  "Use 'shift' and 'control' key as crude paddle replacement",  // in KeyerMainForm.MI_KeyViaShiftAndControl
    "Umschalt- und STRG-Taste als primitiver Paddle-Ersatz", // .. this is ONE of the "Gadgets and Gimmicks"
    "nl:Gebruik 'Shift en Ctrl' als Morse Paddle",
    NULL,

  "&Index",                // in KeyerMainForm.MI_HelpIndex
    "&Inhalt",
    "nl:&Inhoud",
    NULL,

  "I/&O Configuration, Rig Control, Hamlib Server",    // in KeyerMainForm.MI_Help_IOConfig (menu with sufficient space due to auto-sizing)
    "I/&O-Konfiguration, Rig Control, Hamlib Server",  // Hotkey 'I' already occupied so use 'O' instead
    "nl:I/&O Configuratie, Rig Control, Hamlib Server",
    NULL,

  "&Keyer Settings",       // in KeyerMainForm.MI_Help_KeyerSettings
    "&Keyer-Einstellungen",
    "nl:&Keyer Instellingen",
    NULL,

  "&Audio Settings",       // in KeyerMainForm.MI_Help_AudioSettings
    "&Audio-Einstellungen",
    "nl:&Audio Instellingen",
    NULL,

  "&Network Settings",     // in KeyerMainForm.MI_Help_NetworkSettings
    "&Netzwerk-Einstellungen",
    "nl:&Netwerk Instellinegn",
    NULL,

  "&Timing Scope Display", // in KeyerMainForm.MI_Help_TimingScope
    "&Timing-Scope Anzeige",
    "nl: &Timing Oscilloscoop",
    NULL,

  "&Hardware / Circuit Diagrams",  // in KeyerMainForm.MI_Help_Hardware
    "&Hardware / Schaltplne",
    "nl: &Hardware, schakelschema's",
    NULL,

  "'&Debug' tab / error messages / troubleshooting",  // in KeyerMainForm.MI_Help_DebugTab
    "&Debug-Tab / Fehlermeldungen / Troubleshooting",
    "nl:&Debug / Foutmeldingen / Probleem oplossen",
    NULL,

  "Hotkey summary :",     // in KeyerMainForm.Hotkeysummary1 (a menu item, automatic width)
    "bersicht Tastenkrzel :",
    "nl:Sneltoets Overzicht",
    NULL,

  "ESCAPE : Pause TX immediately (\"panic button\")", // in KeyerMainForm.MI_Hotkey_Escape
    "ESCAPE : Sendung sofort anhalten (\"Panik-Button\")",
    "nl:ESCAPE : Alles Stopzetten (Paniek Knop)",
    NULL,

  "F1 ... F6 : Start transmitting from memory",  // in KeyerMainForm.MI_Hotkeys_F1_to_F6
    "F1 ... F6 : Text aus Speicher senden",
    "nl:F1 tot F6 : Tekst Verzenden in Morse Code",
    NULL,

  "F12 : Stop transmitting from memory",         // in KeyerMainForm.F12Stoptransmittingfrommemory1
    "F12 : Senden von Text aus Speicher abbrechen",
    "nl:F12 : Tekst Verzending Stoppen",
    NULL,

  "&About ...",                                  // in KeyerMainForm.MI_Help_About
    "&ber dieses Programm ...",
    "nl:&Over",
    NULL,

  "C&lear the entire history (including decoder output)",  // in KeyerMainForm.MI_ClearErrorHistory
    "Komplette Fehler-Historie &lschen (inkl. Decoder-Ausgaben)",
    "nl:A&lle Informatie in Foutmelding Geschiedenis Verwijderen",
    NULL,

  "&Copy selection as 'Rich Text' to the clipboard",  // in KeyerMainForm.MI_CopyHistoryToClipboard
    "Markierten Bereich als 'Rich Text' kopieren",
    "nl:Selectie naar Clipboard Kopiren ",
    NULL,

  "&Word Wrap (break long lines to avoid horz. scrolling)", // in KeyerMainForm.MI_Debug_WordWrap
    "&Automatischer Zeilenumbruch (vermeidet horizontales Scrollen)",
    "nl:&Alle tekst in huidig venster laten passen (Word Wrap)",
    NULL,

  "&Diagnostic Mode (verbose output on the 'Debug' tab)",  // in KeyerMainForm.MI_Network_DiagnosticMode ..
    "&Diagnose-Modus (erweiterte Anzeigen im Debug-Tab)",  // and KeyerMainForm.MI_Debug_VerboseDiagnostics
    "nl:Uitgebreide &Diagnostische Modus in Debug",
    NULL,

  "Show &Keying Bytestream (on the 'Debug' tab)",     // in KeyerMainForm.MI_Debug_ShowKeyingBytestream
    "Stream mit Morse-&Tastung anzeigen (im Debug-Tab)",
    "nl:Morse Data in Debug Weergeven",
    NULL,

  "Show Received &Keying Bytestream",                 // in KeyerMainForm.MI_Network_ShowRcvdKeyingBytestream
    "Empfangenen Stream mit Morse-&Tastung anzeigen",
    "nl:&Ontvangen Morse Data in Debug Weergeven",
    NULL,

  "Show &Morse decoder output on the 'Debug' tab",    // in KeyerMainForm.MI_Debug_ShowMorseDecoderOutput
    "Ausgabe vom &Morse-Decoder im Debug-Tab anzeigen",
    "nl:&Morse Decoder Informatie in Debug Weergeven",
    NULL,

  "Show Network &Connection log on the 'debug' tab",  // in KeyerMainForm.MI_Debug_ShowNetworkConnectionLog
    "Netzwerk-&Verbindungs-Log im Debug-Tab anzeigen",
    "nl:Netwerk en Verbinding Informatie in Debug Weergeven",
    NULL,

  "Show &Rig-Control traffic on the 'debug' tab (also a CPU hog!)",  // in KeyerMainForm.MI_Debug_ShowRigCtrlTraffic
    "&Rig-Control-Traffic im Debug-Tab anzeigen",
    "nl:&Rig Control Data in Debug Weergeven (Hoog CPU!)",
    NULL,

  "&Pause Display",              // in KeyerMainForm.MI_Debug_PauseDisplay
    "Display anhalten (&Pause)",
    "nl:Weergave &Pauzeren",
    NULL,

  "Show 'Dash' input (yellow)",  // in KeyerMainForm.PM_TScope_ShowDashInput
    "'Strich'-Signal anzeigen (gelb)",
    "nl:Inkomende Morse 'Lang' Weergeven (geel)",
    NULL,

  "Show 'Dot' input (green)",    // in KeyerMainForm.PM_TScope_ShowDotInput
    "'Punkt'-Signal anzeigen (grn)",
    "nl:Inkomende Morse 'Kort' Weergeven (groen)",
    NULL,

  "Show 'Keying' output (red)",  // in KeyerMainForm.PM_TScope_ShowKeyingOutput
    "CW-Tastsignal anzeigen (rot)",
    "nl:Uitgaande CW Data Weergeven (rood)",
    NULL,

  "Show 'PTT' output or 'Channel 4' (blue)",  // in KeyerMainForm.PM_TScope_ShowPttOutput
    "PTT-Ausgang oder 'Kanal 4' anzeigen (blau)",
    "nl:Uitgaande PTT of Kanaal 4 Data weergeven (blauw)",
    NULL,

  "Show Audio input (violet)",   // in KeyerMainForm.PM_TScope_ShowAudioIn
    "Audio-Eingangssignal anzeigen (violett)",
    "nl:Inkomend Geluidssignaal Weergeven (paars)",
    NULL,

  "Show Audio ouput (orange)",   // in KeyerMainForm.PM_TScope_ShowAudioOut
    "Audio-Ausgangssignal anzeigen (orange)",
    "nl:Uitgaand Geluidssignaal Weergeven (oranje)",
    NULL,
  "Show Audio Spectrum and CW decoder output",
    "Audio-Spektrum und CW-Decoder-Daten anzeigen",
    NULL,

  "Clear scope &overlays (white 'drawn lines')",  // in KeyerMainForm.PM_TScope_ClearOverlays
    "Scope-&Overlays entfernen (weie 'gezeichnete Linien')",
    "nl:Scope &Overlays Verwijderen (witte lijnen)",
    NULL,

  "&Free run (don't wait for trigger)",  // in KeyerMainForm.PM_TScope_FreeRun
    "&Freies Durchlaufen (ungetriggert)",
    "nl:Vrije Loop (niet wachten op trigger)",
    NULL,

  "&Help (about the timing scope)", // in KeyerMainForm.PM_TScope_Help
    "&Hilfe zum 'Timing Scope'",
    "nl:&Help (Timing Scope)",
    NULL,

  "&Help (about the debug tab / error history)", // KeyerMainForm.PM_ErrorHistory_Help
    "&Hilfe zum 'Debug'-Tab / Fehler-Historie",
    "nl:&Help (Debug Tab)",
    NULL,

  "&Help (about the Audio CW Decoder)",  // in KeyerMainForm.HI_Help_AudioCWDecoder
    "&Hilfe (zum Audio-CW-Decoder)",
    NULL,

  "&Help (about RCW Keyer's I/O Configuration)",
    "&Hilfe zur 'I/O-Konfiguration'",
    NULL,

  "&Predefined I/O Configurations",
    "&Vordefinierte I/O-Konfigurationen",
    NULL,
  "Neither a Paddle Adapter nor a Radio Keying/Control port",
    "Kein Paddle-Adapter, und kein Port fr die TRX-Tastung/Steuerung vorhanden",
    NULL,

  "Decode CW from audio signal",  // in KeyerMainForm.Chk_Audio_DecodeCW
    "CW aus Audio-Signal decodieren",
    NULL,
  "Sidetone when keyed ON THE RIG", // in KeyerMainForm.Chk_Audio_SidetoneWhenKeyedOnTheRig
    "Mithrton bei Tastung AM RIG", // ... d.h. wenn der Sysop sein Radio selber nutzen will, hren ANDERE USER sein Sendesignal als Mithrton !
    NULL,
  "see manual, 'Audio Settings'",   // 'Hint' in KeyerMainForm.Chk_Audio_SidetoneWhenKeyedOnTheRig
    "siehe Handbuch, 'Audio Settings'",
    NULL,  
  "Hide the &main menu (use the 'window menu' or press ALT to bring it back)",  // in KeyerMainForm.MI_HideMenu
    "Hauptmen &verbergen (per 'Window Menu' wiederherstellbar)",
    NULL,
  "Disable Transmission ('SIM TX', only CW sidetone output)",  // in KeyerMainForm.MI_MoreKeyerSettings_DisableTx
    "Sendung unterdrcken ('SIM TX', nur CW Sidetone erzeugen)",
    NULL,
  "Disable TX", // short form, appended to the menu item's 'dynamic content', e.g. "More '&Keyer Settings' : Disable TX"
    "Sendung unterdrcken",
    NULL,
  "TRANSMIT DISABLED (RX only)", // <- for the 'special state indicator' in the GUI's window title
    "SENDUNG UNTERDRCKT (nur RX)",
    NULL,
  "Reject periodic messages in the traffic display",  // in KeyerMainForm.MI_Network_TrafficLog_RejectPeriodicMsgs
    "Periodisch auftretende Meldungen im 'Traffic Log' unterdrcken",
    NULL,
  "&Center display on this frequency",  // in KeyerMainForm.MI_CenterDisplayOnClickedFrequency
    "Anzeige auf diese Frequenz &zentrieren",
    NULL,
  "&Edit (numeric input)",  // in KeyerMainForm.MI_SpectrumRefLevel_Edit *and* 
    "&Bearbeiten (numerische Eingabe)",
    NULL,
  "&Bottom Panel mode",  // in KeyerMainForm.MI_TRX_Tab_BottomPanelMode
    "&Panel unterhalb der Frequenzskala",
    NULL,
  "&Bottom panel (below the frequency scale): Off", // in Keyer_Main.cpp : PM_SpectrumPopup() ...
    "Panel &unterhalb der Frequenzskala: Aus",
    NULL,
  "&Bottom panel: Show Multi-Function Meters",
    "&Unteres Panel: 'Instrumente' anzeigen",
    NULL,
  "&Bottom panel: Show Band- and Frequency Info",
    "&Unteres Panel: Band- und Frequenz-Info anzeigen",
    NULL,
  "&Bottom panel: Show 'chat box' for messages from the sysop, etc",
    "&Unteres Panel: 'Chatbox' fr Meldungen vom Sysop, usw.",
    NULL,
  "&Bottom panel: Automatic (show 'meters' or freq-info)",
    "&Unteres Panel: Automatisch (Instumente oder F-Info)",
    NULL,
  "&Bottom panel: mode=", // in Keyer_Main.cpp : PM_SpectrumPopup(), followed by the code for the "bottom panel mode"
    "&Unteres Panel: mode=",
    NULL,
  "No bottom panel (below the frequency scale)",  // in KeyerMainForm.MI_TRX_Tab_BPMode_OFF
    "Keine Anzeigepanel (unterhalb der Frequenzskala)",
    NULL,
  "Show 'meters' (Power, ALC, Voltage, Drain Current)",  // in KeyerMainForm.MI_TRX_Tab_BPMode_Meters
    "'Instrumente' anzeigen (Power, ALC, Spannung, Drainstrom)",
    NULL,
  "Show '&frequency info' (stations, beacons, etc)",    // in KeyerMainForm.MI_TRX_Tab_BPMode_FreqInfo
    "&Frequenz-Informationen (Sendernamen, Baken, usw.)",
    NULL,
  "Show '&chat box' for messages from sysop, etc", // in KeyerMainForm.MI_TRX_Tab_BPMode_ChatBox
    "Zeige '&Chatbox' fr Meldungen vom Sysop, usw.",
    NULL,
  "&Automatic (show meters during TX, etc)",  // in KeyerMainForm.MI_TRX_Tab_BPMode_Auto
    "&Automatisch (Instrumente beim Senden, Infos beim Empfang)",
    NULL,
  "More options for the 'TRX' tab",  // in KeyerMainForm.MI_More_TRX_Tab_Options
    "Weitere &Optionen fr die 'TRX'-Anzeige",
    NULL,

  "TRX options (transceiver control and spectrum display)",  // in KeyerMainForm.MI_TRX_Display_Options
    "Transceiver-Optionen (Steuerung und Spektrum-Anzeige)",
    "nl:TRX Opties (Transceiver en Spectrum Weergave)",
    NULL,

  "Show &time markers in the spectrogram",     // in KeyerMainForm.MI_TRX_Tab_ShowTimeMarkers
    "&Zeitmarken im Spektrogramm einblenden",
    NULL,
  "Show &audio spectrum from CW decoder when active", // in MI_TRX_Tab_ShowCWDecoderSpectrum
    "&Audio-Spektrum vom CW-Decoder einblenden (wenn aktiv)",
    NULL,
  "More options for the Audio CW &Decoder ...",  // in MI_TRX_Tab_AudioCWDecoderOptions
    "Weitere Optionen fr den Audio-CW-&Decoder ...",
    NULL,
  "Keep this tab updated even when not visible", // in KeyerMainForm.MI_TRX_KeepRunning
    "Auch ohne Anzeige dieses Tabs weiter aktualisieren",
    "nl:TRX Laten Doorlopen (zonder dat venster open is)",
    NULL,

  "Set &VFO frequency to", // part of the menu item text in the spectrum popup, followed by " nnn.nnnn MHz"
    "Setze &VFO-Frequenz auf", // (beware of the syntax, which must match the trailing parameter)
    "nl:Zet &VFO Freq naar",
    NULL,

  "Set a temporary marker for this frequency",  // in KeyerMainForm.PM_Spectrum_SetTempMarker
    "Temporren Marker auf diese Frequenz setzen",
    "nl:Tijdelijke Markering op deze Freq plaatsen",
    NULL,

  "Set a permanent marker for this frequency",  // in KeyerMainForm.PM_Spectrum_SetPermanentMarker
    "Dauerhaften Marker auf diese Frequenz setzen",
    "nl:Permanente Markering op deze Freq plaatsen",
    NULL,

  "Define permanent frequency marker", // title for a DIALOG to enter the marker's name
    "Dauerhaften Marker definieren",
    "nl:Permanente Freq Markering Defineren",
    NULL,

  "Band switch / band stacking registers",  // in KeyerMainForm.Btn_HelpBandSwitch
    "Bandumschaltung / Bandstapelregister", // diese wunderbare Bezeichnung stammt aus dem deutschen Handbuch zum IC-7300
    NULL,

  "Spectrum Display Settings (on the 'TRX' tab) ...", // in KeyerMainForm.MI_Settings_SpectrumDisplay
    "Spektrum-Anzeige (auf Registerkarte 'TRX') ...",
    NULL,

  "Spectrum &Reference Level", // menu item in KeyerMainForm.PM_Spectrum, followed by " : nn.n dB"
    "&Referenz-Level fr Spektrum", // (beware of the syntax, which must match the trailing parameter)
    "nl:Spectrum &Referentie level in dB",
    NULL,


  "Set Spectrum Reference Level",     // title for a DIALOG to modify the 'spectrum reference level'
    "Referenz-Level fr Spektrum",
    "nl:Benoem Spectrum Referentie",
    NULL,

  "Valid range",   // used in info strings in input dialogs like "Set Spectrum Reference Level" : "Valid range: -20 .. 20 dB"
    "Gltiger Bereich",
    "nl:Geldig Bereik",
    NULL,

  "Current value", // also used in info strings in input dialogs like "Set Spectrum Reference Level" : "Current value: 0.0 dB"
    "Aktueller Wert",
    "nl:Aktuele Waarde",
    NULL,

  // Frequently used strings from older applications ..
  "Delete",
    "Lschen",
    "fr:Couper",
    "nl:Verwijderen",
    NULL,
  "Cut",
    "Ausschneiden",
    "fr:Couper",
    "nl:Knippen",
    NULL,
  "Insert",
    "Einfgen",
    "fr:Insrer",
    "nl:Invoegen",
    NULL,
  "Insert..",
    "Einfgen..",
    "fr:Insrer..",
    "nl:Invoegen..",
    NULL,
  "&File",
    "&Datei",
    "fr:&Fichier",
    "it:&File",
    "nl:&Bestand",
    NULL,
  "New..",         // opens a menu with a selection WHAT shall be created new
    "Neu..",
    "fr:Noveau..",
    "it:Nuovo..",
    "nl:&Nieuw..",
    NULL,
  "New",           // creates a new 'something' without opening a menu
    "Neu",
    "fr:Noveau",
    "it:Nuovo",
    "nl:&Nieuw",
    NULL,
  "Open",
    "ffnen",
    "nl:&Open",
    NULL,
  "Import",
    "Importieren",
    "fr:Importer",
    "nl:Importeren",
    NULL,
  "Export",
    "Exportieren",
    "fr:Exporter",
    "nl:Exporteren",
    NULL,

  "Save settings as ...",    // in KeyerMainForm.MI_File_ExportSettingsAs
    "Einstellungen speichern unter ...",
    NULL,
  "Load settings from ...",  // in KeyerMainForm.MI_File_ImportSettingsFrom
    "Einstellungen laden aus ...",
    NULL,
  "Reload from recent file", // in KeyerMainForm.MI_File_ImportRecentFile
    "Letzte importierte Einstellungen",
    NULL,
  "Clear recent file history", // in KeyerMainForm.MI_ClearCecentFiles
    "Datei-Import-Historie lschen",
    NULL,
  "&Settings",
    "&Einstellungen",
    "fr:&Paramtres",
    "it:&Impostazioni",
    "nl:&Instellingen",
    NULL,

  "&Functions",  // in KeyerMainForm.MI_Functions
    "&Funktionen",
    "nl:&Functies",
    NULL,

  "&Transceiver",  // in KeyerMainForm.MI_Funcs_TRX
    "&Transceiver",
    "nl:&Transceiver",
    NULL,
  "Turn on (remotely)",  // in KeyerMainForm.MI_Funcs_TrxPowerOn
    "&Einschalten (remote)",
    "nl:&Zet de stroom aan",
    NULL,

  "Turn off (remotely)",  // in KeyerMainForm.MI_Funcs_TrxPowerOff
    "&Ausschalten (remote)",
    "nl:&Stroom uitzetten",
    NULL,

  "&Default (windows-controlled)",  // also just a menu item -> width not critical
    "&Default (Windows-gesteuert)",
    "nl:&Default (gecontrolleerd door windows)",
    NULL,
  "D&ark",
    "D&unkel",
    "nl:&Donker",
    NULL,

  "Copy",
    "Kopieren",
    "fr:Copier",
    "nl:Kopiren",
    NULL,
  "&Copy",
    "&Kopieren",
    "fr:&Copier",
    "nl:Kopiren",
    NULL,
  "Paste",
    "Einfgen",
    "fr:Coller",
    "nl:Plakken",
    NULL,
  "&Paste",
    "&Einfgen",
    "fr:C&oller",
    "nl:Plakken",
    NULL,

 "&Search",
    "&Suchen",
    "nl:Zoeken",
    NULL,
  "Properties",
    "Eigenschaften",
    "fr:Proprits",
    "nl:Eigenschappen",
    NULL,
  "More",
    "Mehr",
    "fr:plus",
     "nl:Meer",
    NULL,
  "More..",           // used in a dozen different places !
    "Mehr..",
    "fr:plus..",
    "nl:Meer..",
    NULL,
  "More...",          // 'even more' ? (used in other places)
    "Mehr...",
    "fr:plus...",
    "nl:Meer...",
    NULL,
  "Help",
    "Hilfe",
    "fr:Aide",
    "it:Aiuto",
    "nl:Hulp",
    NULL,
  "&Help",
    "&Hilfe",
    "fr:&Aide",
    "it:&Aiuto",
    "nl:&Hulp",
    NULL,
  "Undo",
    "Rckgg.",
    "fr:Dfair",
    "nl:Ongedaan maken",
    NULL,
  "Apply",
    "Anwenden",
    "fr:Appliquer",
    "nl:Toepassen",
    NULL,
  "Hello",
    "Hallo",
    "fr:Bonjour",
    "nl:Hallo",
    NULL,
  "oops",       // this is an error message / caption which should never appear !
    "huch!",
    "fr:pardon",
    "nl:OEPS!",
    NULL,
  "Menu",
    "Men",
    "fr:Menu",
    NULL,
  "Width",
    "Breite",
    "fr:Largeur",
    "nl:Breedte",
    NULL,
  " Width",    // space required because of lousy font rendering !
    "Breite",
    "fr:Largeur",
    "nl:Breedte",
    NULL,
  "Height",
    "Hhe",
    "fr:Hauteur",
    "nl:Hoogte",
    NULL,
  "Style",
    "Stil",
    "fr:Style", // oui!
    "nl:Stijl",
    NULL,
  "don't invert",
    "nicht invert.",
    "nl:Niet Inverteren",
    NULL,
  "Lists",
    "Listen",
    "nl:Lijst",
    NULL,
  "Tree",
    "Baum",
    "fr:Structure arborescente",
    "nl:Boom Structuur",
    NULL,
  "Invert",
    "Invers",
    "fr:Inversement",
    "nl:Inverteren",
    NULL,
  "Example",
    "Beispiel",
    "nl:Voorbeeld",
    NULL,
  "Stop",
    "Stoppen",
    "fr:S'arrter",
    NULL,
  "Update",
    "Aktualisieren",
    "fr:Actualiser",
    "nl:Updaten",
    NULL,
  "Apply changes before closing ?",
    "nderungen vor dem Schlieen bernehmen ?",
    "nl:Instellinegn Opslaan voor Sluiten",
    NULL,
  "Yes",
    "Ja",
    "fr:Oui",
    "nl:Ja",
    NULL,
  "No",
    "Nein",
    "fr:Non",
    "nl:Nee",
    NULL,
  "Cancel",
    "Abbrechen",
    "fr:Interrompre",
    "nl:Annuleren",
    NULL,
  "don't show this message again", // in C:\cbproj\UptWin1\MessageBoxWithCheckmark.cpp
    "diese Meldung nicht erneut anzeigen",
    "nl:Dit bericht niet laten zien",
    NULL,
  "unknown",
    "unbekannt",
    "nl:Onbekend",
    NULL,
  "please wait",
    "bitte warten",
    "nl:Even Wachten",
    NULL,
  "Language",
    "Sprache",
    "fr:Langue",
    "nl:Taal",
    NULL,
  "English",
    "Englisch",
    "fr:Anglais",
    "nl:Engels",
    NULL,
  "German",
    "Deutsch",
    "fr:Allemand",
    "nl:Duits",
    NULL,
  "French",
    "Franzsisch",
    "fr:Franaise",
    "nl:Frans",
    NULL,
  "&ITU Region (for TX frequency limits)",  // in KeyerMainForm.MI_ITU_Region
    "&ITU-Region (fr Frequenzbereiche beim Senden)",
    "nl:&ITU-Regio (voor frequentiebereiken bij het zenden)",
    NULL,


  NULL, NULL   // end of table  marked by TWO 'NULL' pointers
}; // end TranslationTable[]

