//---------------------------------------------------------------------------
// File: C:\cbproj\Remote_CW_Keyer\Timers.h
// Date: 2024-01-13
//       Provides high-resolution "timers" and "stopwatches" .
//       For Windows, based on the "QueryPerformance"-thingy .
//       Formerly a part of DL4YHF'S Spectrum Lab .
//       Modified / 'downsized' copies of this file may exist in:
//          * C:\cbproj\SpecLab\Timers.h
//          * C:\cbproj\Remote_CW_Keyer\Timers.h
//          * C:\cbproj\SoundUtl\Timers.h
//          * ... ?
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// No-No: #include <vcl.h>  // do NOT use Borland's VCL -
                            //  Timers.h is used in various NON-VCL DLLs !
#ifndef  _YHF_TIMERS_H
# define _YHF_TIMERS_H      // prevent multiple inclusion

#pragma hdrstop

typedef __int64 T_TIM_Stopwatch;  // type used by TIM_StartStopwatch / TIM_ReadStopwatch_xx
   // The application must not assume anything about the actual type;
   // the 'stopwatch' may be a STRUCT when compiling for an embedded system !


//-------------- Variables ---------------------------------------------------


//-------------- Functions  --------------------------------------------------

#ifndef CPROT  // For peaceful co-existence of "C" and "C++" ....
# ifdef __cplusplus
#   define CPROT extern "C"
# else
#   define CPROT
# endif  // ! "cplusplus"
#endif  // ndef CPROT


//---------------------------------------------------------------------------
CPROT void TIM_Init(void);
   /*  Initializes the module.
    */

//---------------------------------------------------------------------------
CPROT double TIM_ReadHighResTimer_s( void );
CPROT long   TIM_ReadHighResTimer_ms( void );
CPROT void   TIM_SyncHighResTimer_ms( long i32_ms );

//---------------------------------------------------------------------------
CPROT void TIM_StartStopwatch( T_TIM_Stopwatch *pStopwatch );
CPROT void TIM_StopStopwatch(  T_TIM_Stopwatch *pStopwatch );
CPROT double TIM_ReadStopwatch_s(T_TIM_Stopwatch *pStopwatch ); // -> result in seconds
CPROT long TIM_ReadStopwatch_us( T_TIM_Stopwatch *pStopwatch ); // -> result in microseconds (rounded)
CPROT long TIM_ReadStopwatch_ms( T_TIM_Stopwatch *pStopwatch ); // -> result in milliseconds (rounded)
CPROT void TIM_AdjustStopwatch_ms( T_TIM_Stopwatch *pStopwatch, int nMilliseconds );
CPROT long TIM_ReadAndRestartStopwatch_us( T_TIM_Stopwatch *pStopwatch );
    // Note: The english Wikipedia said about 'Microsecond' :
    //       The symbol is 's', sometimes simplified to 'us'
    //       when Unicode is not available. Thus (here): 'us', not 'usec'.



#endif // ndef  _YHF_TIMERS_H  ?


/* EOF <timers.h> */

