// File:  C:\cbproj\Remote_CW_Keyer\StraightKeyDecoder.h
// Date:  2024-05-09
// Author:  Wolfgang Buescher (DL4YHF)
// Purpose: Morse code decoder for a 'straight keying' signal.
//          First used in the author's "Remote CW Keyer" project
//          to check the CW keying signal on the SERVER SIDE
//          (which drives the radio with a "straight keying" signal,
//           not via separate "dash" and "dot" signals).
//          Details only in the implementation (*.c module).

#ifndef  STRAIGHT_KEY_DECODER_H_INCLUDED
# define STRAIGHT_KEY_DECODER_H_INCLUDED 1

//---------------------------------------------------------------------------
// Constants (besides those already defined in Elbug.h) ..
//---------------------------------------------------------------------------




//---------------------------------------------------------------------------
// Data Types (besides those already defined in Elbug.h) ..
//---------------------------------------------------------------------------

typedef enum // States for the 'straight Morse key' decoder state machine (simplified) ..
{
    DS_WAITING = 0,  // waiting for anything to happen (key was "up" so far)
    DS_RCV_DOT,      // currently receiving a dot (which MAY turn out a DASH later)
    DS_RCV_GAP,      // currently receiving a GAP WITHIN A CHARACTER (with may turn out a SPACE later)
    DS_RCV_SPACE     // finished receiving a CHARACTER but didn't emit a trailing SPACE yet
} T_StraightKeyDecoderState;

typedef struct t_StraightKeyDecoderHistoryEntry
{ int nMicrosecondsBeforeNewState;
  BOOL fKeyDown;
  T_StraightKeyDecoderState iState;
  WORD wShiftReg;
  WORD wEmittedCode; // 0 = none, ..
} T_StraightKeyDecoderHistoryEntry;

typedef struct t_StraightKeyDecoder // everthing we need for a single 'Decoder' instance:
{

  int iDotTime_ms;   // duration of a dot, measured in MILLISECONDS (!)
      // (use Elbug_WordsPerMinuteToDotTimeInMilliseconds() to convert,
      //  and initialize with the "configured" CW speed stored in
      //  Elbug.h : T_ElbugInstance.cfg.iDotTime_ms )

  T_StraightKeyDecoderState iState; // States for the 'straight Morse key' decoder state machine (simplified) :
      // DS_WAITING, DS_RCV_DOT, DS_RCV_GAP, DS_RCV_SPACE, ..(?)

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // "internal" stuff
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  long i32TimeAccu_us; // "accumulated time since last signal- or state change",
                       // in microseconds, to tell dashes from dots, etc .
  WORD wShiftReg;  // latch, or shift register, for the character currently being sent.
                   // Contains a CW_CHR_..-code, evaluated after a gap of TWO dot times.

  // Only for debugging (.."why didn't it decode the most recent characters ?" ) :
# define SKD_HISTORY_N_ENTRIES 256 // number of entries in the Straight Key Decoder's "history"
  T_StraightKeyDecoderHistoryEntry sHistory[SKD_HISTORY_N_ENTRIES];
  int  iHistoryHeadIndex, iHistoryTailIndex; // circular buffer indices into sHistory[]


} T_StraightKeyDecoder;


//---------------------------------------------------------------------------
// Function prototypes
//---------------------------------------------------------------------------
#ifndef CPROT   // for peaceful co-existence of C and C++ ...
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  // not "cplusplus" ?
#endif // ndef CPROT ?

CPROT void StraightKeyDecoder_Init( T_StraightKeyDecoder *pDecoder, int iDefaultDotTime_ms );


CPROT int StraightKeyDecoder( T_StraightKeyDecoder *pDecoder,
                              BOOL fKeyDown, long nMicrosecondsSinceLastCall);

CPROT char* StraightKeyDecoder_StateToString( T_StraightKeyDecoderState iState );


#endif // ndef STRAIGHT_KEY_DECODER_H_INCLUDED ?
