//---------------------------------------------------------------------------
// File  :  C:\cbproj\Remote_CW_Keyer\SampleRateConv.h
// Date  :  2023-12
// Author:  Wolfgang Buescher  (DL4YHF)
//
// Details and revision history : see implementation (*.c)
//---------------------------------------------------------------------------

#ifndef  _SampleRateConv_h
# define _SampleRateConv_h


// Length of all DECIMATING FIR filters, used for anti-aliasing, etc .
// Used as array length for Dec2FilterCoeffs[],  Dec3FilterCoeffs[],
//                          T_SOUND_DECIMATOR.queue[], etc.
#define DEC_FIR_LENGTH 25


typedef struct
{
 int    ratio;                 // decimation ratio of this stage
                               // (or upsampling ratio when used as interpolator)
 int    count;                 // counter for decimation/interpolation ratio
 float  queue[DEC_FIR_LENGTH];
 float *inptr;                 // pointer for circular queue(s)
 const float *coeffs;          // pointer to a table of FIR coefficients
} T_SRCONV_DECIMATOR; // <- originally just for DECIMATION, later also used for INTERPOLATION / upsampling



//---------------------------------------------------------------------------
void  SRConv_InitDecimator( T_SRCONV_DECIMATOR *pDecimator, int decimation_ratio );
int   SRConv_TwoStageDecimator( T_SRCONV_DECIMATOR *pTwoDecimators, float *pfltInput,
                                 int nSamplesIn, float *pfltOutput );
int   SRConv_TwoStageUpsampler( T_SRCONV_DECIMATOR *pTwoInterpolators, float *pfltInput,
                                 int nSamplesIn, float *pfltOutput );



#endif // ndef  _SampleRateConv_h ?



/* EOF <SampleRateConv.h> */


