//---------------------------------------------------------------------------
// File: C:\cbproj\Remote_CW_Keyer\Keyer_Main.h
// Date: 2023-11-11
// Author: Wolfgang Buescher (DL4YHF)
// Purpose: Main "form" (window) for an experiment to key certain Icom transceivers.
//          Details about the "keying" itself in KeyerThread.c .
//      THIS module is just the BORing graphic user interface,
//      written in a stoneage version of Borland's C++ Builder (BCB V6),
//      using their easy-to-use VCL (Visual Component Library).
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------

#ifndef Keyer_MainH
#define Keyer_MainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <ActnCtrls.hpp>
#include <ActnMan.hpp>
#include <ActnMenus.hpp>
#include <ToolWin.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
class TKeyerMainForm : public TForm
{
__published:	// Von der IDE verwaltete Komponenten
   TMainMenu *MainMenu1;
   TMenuItem *File1;
   TMenuItem *Exit1;
   TPageControl *PageControl1;
   TTabSheet *TS_Config;
   TTabSheet *TS_Debug;
   TTabSheet *TS_Test;
   TTabSheet *TS_KeyerSettings;
   TTabSheet *TS_Audio;
   TTabSheet *TS_TRX;
   TRichEdit *Ed_ErrorHistory;
   TMenuItem *MI_ExitNoSave;
   TTimer *Timer1;
   TMenuItem *Menu_Settings;
   TMenuItem *MI_RestoreDefaultSettings;
   TImage *Img_TimingScopeOnTestTab;
   TImage *Img_TimingScopeOnKeyerTab;
   TTabSheet *TS_Network;
   TTabSheet *TS_Memory;
   TMenuItem *MI_ConnectScopeCh4;
   TMenuItem *N1;
   TMenuItem *MI_Ch4_PTT;
   TMenuItem *MI_Ch4_TestInput;
   TButton *Btn_Mem1;
   TEdit *Ed_Mem1;
   TButton *Btn_Mem2;
   TEdit *Ed_Mem2;
   TButton *Btn_Mem3;
   TEdit *Ed_Mem3;
   TButton *Btn_Mem4;
   TEdit *Ed_Mem4;
   TButton *Btn_Mem5;
   TEdit *Ed_Mem5;
   TButton *Btn_Mem6;
   TEdit *Ed_Mem6;
   TMenuItem *MI_Hotkey_Escape;
   TMenuItem *MI_Hotkeys_F1_to_F6;
   TMenuItem *MI_ColourScheme;
   TMenuItem *MI_ColourScheme_Default;
   TMenuItem *MI_ColourScheme_Dark;
   TMenuItem *MI_ClearScopeOverlays;
   TMenuItem *MI_Help;
   TMenuItem *N2;
   TMenuItem *Hotkeysummary1;
   TMenuItem *MI_HelpIndex;
   TMenuItem *MI_Help_IOConfig;
   TMenuItem *MI_Help_KeyerSettings;
   TMenuItem *MI_Help_TimingScope;
   TMenuItem *MI_Help_Hardware;
   TComboBox *CB_AudioInputDevice;
   TLabel *Label17;
   TLabel *Label18;
   TComboBox *CB_AudioOutputDevice;
   TMenuItem *MI_ClearDebugAndDecoderOutput;
   TMenuItem *MI_Help_AudioSettings;
   TMenuItem *MI_Help_NetworkSettings;
   TLabel *Label19;
   TComboBox *CB_SidetoneOnAudioOut;
   TMenuItem *MI_ReportTestResults;
   TLabel *Label20;
   TLabel *Lab_LocalHost;
   TLabel *Lab_LocalIPHelp;
   TLabel *Lab_LocalIP;
   TLabel *Lab_ServerListeningPort;
   TEdit *Ed_ServerListeningPort;
   TLabel *Lab_NetworkFunctionality;
   TRadioButton *Rbtn_NetworkOff;
   TRadioButton *Rbtn_NetworkClient;
   TRadioButton *Rbtn_NetworkServer;
   TBevel *Bevel1;
   TLabel *Lab_RemoteURL;
   TEdit *Ed_ClientRemoteIP;
   TLabel *Lab_MyUserName;
   TEdit *Ed_ClientUserName;
   TLabel *Lab_AcceptedUsers;
   TEdit *Ed_ServerAcceptUsers;
   TLabel *Lab_NetStatus;
   TEdit *Ed_NetworkStatus;
   TBevel *Bevel2;
   TMenuItem *MI_NetworkDiagnostics;
   TMenuItem *MI_Network_DiagnosticMode;
   TPopupMenu *PM_ErrorHistory;
   TMenuItem *MI_ClearErrorHistory;
   TMenuItem *MI_Network_ShowRcvdKeyingBytestream;
   TMenuItem *N3;
   TMenuItem *MI_Debug_VerboseDiagnostics;
   TMenuItem *MI_Debug_ShowKeyingBytestream;
   TMenuItem *MI_Debug_PauseDisplay;
   TMenuItem *MI_PauseDebugOutput;
   TMenuItem *MI_CopyHistoryToClipboard;
   TMenuItem *MI_Help_DebugTab;
   TLabel *Lab_Network_OnTheKey;
   TEdit *Ed_OnTheKeyNow;
   TLabel *Lab_UserCallsign;
   TEdit *Ed_ClientCallsign;
   TMenuItem *MI_Debug_ShowMorseDecoderOutput;
   TMenuItem *MI_Settings_ShowMorseDecoderOutput;
   TLabel *Label14;
   TComboBox *CB_SidetoneRiseTime;
   TCheckBox *Chk_Audio_AllowNetwork;
   TScrollBar *SB_SidetoneGain_dB;
   TLabel *Label22;
   TScrollBar *SB_AudioInGain_dB;
   TScrollBar *SB_AudioOutGain_dB;
   TScrollBar *SB_NetworkTonesGain_dB;
   TLabel *Label23;
   TLabel *Label24;
   TLabel *Label25;
   TLabel *Label26;
   TBevel *Bevel_ZerodB;
   TLabel *Label27;
   TMenuItem *MI_ShowAudioWaveforms;
   TMenuItem *MI_TScopeShowAudioIn;
   TMenuItem *MI_TScopeShowAudioOut;
   TPopupMenu *PM_TimingScope;
   TMenuItem *PM_TScope_ShowDashInput;
   TMenuItem *PM_TScope_ShowDotInput;
   TMenuItem *PM_TScope_ShowKeyingOutput;
   TMenuItem *PM_TScope_ShowPttOutput;
   TMenuItem *PM_TScope_ShowAudioIn;
   TMenuItem *PM_TScope_ShowAudioOut;
   TMenuItem *PM_TScope_ClearOverlays;
   TMenuItem *PM_TScope_FreeRun;
   TPanel *TopPanelToFixTheAnchorBug;
   TLabel *Label3;
   TLabel *Label4;
   TLabel *Label5;
   TLabel *Label6;
   TCheckBox *Chk_MorseKeyDTR;
   TCheckBox *Chk_RadioKeyingDTR;
   TCheckBox *Chk_MorseKeyRTS;
   TCheckBox *Chk_RadioKeyingRTS;
   TStaticText *ST_MorseKeyDCD;
   TStaticText *ST_MorseKeyDSR;
   TStaticText *ST_MorseKeyCTS;
   TStaticText *ST_RadioKeyingDCD;
   TStaticText *ST_RadioKeyingDSR;
   TStaticText *ST_RadioKeyingCTS;
   TCheckBox *Chk_ManualControl;
   TStaticText *ST_MorseKeyRI;
   TStaticText *ST_RadioKeyingRI;
   TPanel *TopPanelToFixTheAnchorBug1;
   TLabel *Label12;
   TLabel *Label13;
   TLabel *Label16;
   TLabel *Label28;
   TLabel *Label29;
   TComboBox *CB_KeyType;
   TTrackBar *TrackBar_WPM;
   TEdit *Ed_WPM;
   TComboBox *CB_SidetoneOnTXD;
   TEdit *Ed_TxHangTime;
   TEdit *Ed_TxDelayTime;
   TMenuItem *MI_KeyViaShiftAndControl;
   TMenuItem *MI_Network_ShowConnectionLog;
   TMenuItem *N71;
   TMenuItem *MI_Help_About;
   TMenuItem *MI_Network_OpenServerPageInBrowser;
   TCheckBox *Chk_EnableHTTP;
   TLabel *Lab_AdminPWD;
   TEdit *Ed_ServerAdminPWD;
   TMenuItem *MI_NetworkServerOptions;
   TMenuItem *MI_Server_EnableHTTP;
   TMenuItem *MI_Server_RestrictAccess;
   TMenuItem *MI_Server_AddTestTone;
   TMenuItem *MI_Network_SimulateBadConnection;
   TMenuItem *MI_Ch4_NetworkTrouble;
   TMenuItem *MI_Network_ShowNetworkTraffic;
   TMenuItem *MI_Debug_ShowNetworkTraffic;
   TMenuItem *MI_Debug_WordWrap;
   TMenuItem *MI_Debug_ShowNetworkConnectionLog;
   TPanel *Pnl_TRX_Top;
   TEdit *Ed_VFO;
   TPanel *Pnl_TRX_Bottom;
   TComboBox *CB_OpMode;
   TMenuItem *MI_Debug_ShowRigCtrlTraffic;
   TMenuItem *MI_Network_ShowRigControlTraffic;
   TMenuItem *MI_Settings_RigControlOptions;
   TMenuItem *MI_RigCtrl_RejectEchosInLog;
   TMenuItem *MI_RigCtrl_RejectPeriodicCmds;
   TMenuItem *MI_RigCtrl_RejectSpectrumInLog;
   TPanel *Pnl_TRX_Center;
   TImage *Img_Spectrum;
   TImage *Img_Waterfall;
   TImage *Img_FreqScale;
   TMenuItem *MI_NetworkLatency;
   TMenuItem *MI_NetworkLatency_AutoDetect;
   TMenuItem *MI_NetworkLatency_100ms;
   TMenuItem *MI_NetworkLatency_250ms;
   TMenuItem *MI_NetworkLatency_500ms;
   TMenuItem *MI_NetworkLatency_1000ms;
   TMenuItem *MI_Ch4_KeyingFifoUsage;
   TButton *Btn_StopSendingFromMemory;
   TMenuItem *F12Stoptransmittingfrommemory1;
   TMenuItem *MI_ShowStraightKeyDecoderHistory;
   TMenuItem *MI_MoreKeyerSettings;
   TMenuItem *MI_KeyInputWatchdog;
   TMenuItem *MI_Settings_SpectrumDisplay;
   TMenuItem *MI_SeparatorBelowPauseDebugOutput;
   TMenuItem *MI_Ch4_ElbugKeyerFlags;
   TMenuItem *N6;
   TMenuItem *PM_TScope_Help;
   TButton *Btn_MoreKeyerSettings;
   TMenuItem *MI_DebouncePaddleInputs;
   TPopupMenu *PM_Spectrum;
   TMenuItem *MI_Spectrum_SetVFO;
   TMenuItem *MI_Spectrum_SetTempMarker;
   TMenuItem *MI_Spectrum_SetPermanentMarker;
   TMenuItem *MI_Language;
   TMenuItem *MI_Language_English;
   TMenuItem *MI_Language_German;
   TMenuItem *MI_Language_French;
   TMenuItem *MI_Language_Dutch;
   TMenuItem *MI_Language_Italian;
   TMenuItem *MI_Spectrum_RefLevel;
   TImage *Img_SMeter;
   TMenuItem *MI_Help_TransceiverControl;
   TMenuItem *MI_HamlibServerOptions;
   TMenuItem *MI_HLServer_ShowTraffic;
   TMenuItem *MI_HLServer_OpenControlTab;
   TMenuItem *MI_HLServer_Enable;
   TMenuItem *MI_HLServer_VerboseOutput;
   TMenuItem *MI_ListAndEditRigParams;
   TComboBox *CB_Band;
   TMenuItem *MI_ITU_Region;
   TMenuItem *MI_ITU_Region_1;
   TMenuItem *MI_ITU_Region_2;
   TMenuItem *MI_ITU_Region_3;
   TButton *Btn_HelpBandSwitch;
   TMenuItem *MI_RigCtrl_RejectFrequencyReports;   // <- selects "what to display" in the BOTTOM PANEL on the "TRX"-tab:
   TImage *Img_TRX_Bottom;
   TMenuItem *Menu_Functions;
   TMenuItem *MI_Funcs_TRX;
   TMenuItem *MI_Funcs_TrxPowerOn;
   TMenuItem *MI_Funcs_TrxPowerOff;
   TMenuItem *MI_Spectrum_Span;
   TMenuItem *MI_SpectrumSpan_2500;
   TMenuItem *MI_SpectrumSpan_5kHz;
   TMenuItem *MI_SpectrumSpan_10kHz;
   TMenuItem *MI_SpectrumSpan_25kHz;
   TMenuItem *MI_SpectrumSpan_50kHz;
   TMenuItem *MI_SpectrumSpan_100kHz;
   TMenuItem *MI_SpectrumSpan_500kHz;
   TMenuItem *MI_SpectrumSpan_250kHz;
   TMenuItem *MI_SeparatorBelowSpectrumDisplaySettings;
   TMenuItem *MI_Help_MainMenu;
   TMenuItem *MI_Settings_UserInterface;
   TMenuItem *MI_UI_Simple;
   TMenuItem *MI_UI_Complete;
   TMenuItem *MI_ListUserDefinedBands;
   TMenuItem *MI_ListUserDefinedFrequencies;
   TMenuItem *MI_SpectrumRefLevel_Edit;
   TMenuItem *MI_SpectrumRefLevel_m20;
   TMenuItem *MI_SpectrumRefLevel_m10;
   TMenuItem *MI_SpectrumRefLevel_0;
   TMenuItem *MI_SpectrumRefLevel_10;
   TMenuItem *MI_SpectrumRefLevel_20;
   TLabel *Lab_MyCall;
   TEdit *Ed_MyCall;
   TMenuItem *MI_More_TRX_Tab_Options;
   TMenuItem *MI_TRX_Tab_KeepRunning;
   TMenuItem *MI_CenterDisplayOnClickedFrequency;
   TMenuItem *MI_TRX_Tab_BottomPanelMode;
   TMenuItem *MI_TRX_Tab_BPMode_Meters;
   TMenuItem *MI_TRX_Tab_BPMode_FreqInfo;
   TMenuItem *MI_TRX_Tab_BPMode_OFF;
   TMenuItem *MI_TRX_Tab_ShowTimeMarkers;
   TMenuItem *MI_ChatBox_BPMode_Meters;
   TMenuItem *MI_ChatBox_BPMode_FreqInfo;
   TMenuItem *MI_ChatBox_BPMode_ChatBox;
   TMenuItem *MI_ChatBox_BPMode_Auto;
   TMenuItem *MI_ChatBox_BPMode_OFF;
   TPanel *Pnl_Top;
   TLabel *Lab_DateAndTime;
   TMenuItem *MI_HideMenu;
   TRichEdit *RichEdit_RxTxInfo;
   TPanel *Pnl_StatusIndicator;
   TMenuItem *MI_TRX_Tab_BPMode_Auto;
   TMenuItem *MI_Network_TrafficLog_RejectPeriodicMsgs;
   TMenuItem *MI_MoreKeyerSettings_DisableTx;
   TCheckBox *Chk_Audio_DecodeCW;
   TMenuItem *MI_TRX_Tab_ShowCWDecoderSpectrum;
   TButton *Btn_MoreAudioCwDecoderOptions;
   TPopupMenu *PM_AudioCwDecoderOptions;
   TMenuItem *MI_ACwDecoder_Enabled;
   TMenuItem *MI_TRX_Tab_AudioCWDecoderOptions;
   TMenuItem *MI_PeakHoldingAudioSpectrum;
   TMenuItem *PM_TScope_Paused;
   TMenuItem *MI_TScopeShowCwDecoderAudio;
   TMenuItem *PM_TScope_ShowAudioSpectrumAndCwDecoder;
   TMenuItem *MI_SpectrogramColourPalette;
   TMenuItem *MI_WFColourPalette_Sunrise;
   TMenuItem *MI_WFColourPalette_Linrad;
   TMenuItem *MI_WFColourPalette_Red;
   TMenuItem *MI_WFColourPalette_Green;
   TMenuItem *MI_WFColourPalette_Blue;
   TMenuItem *PM_TScope_Timebase;
   TMenuItem *MI_TimingScopeTB_2ms;
   TMenuItem *MI_TimingScopeTB_5ms;
   TMenuItem *MI_TimingScopeTB_10ms;
   TMenuItem *MI_TimingScopeTB_20ms;
   TMenuItem *PM_TScope_AudioSpectrumOptions;
   TMenuItem *PM_TScope_AudioSpectrumRefLevel;
   TMenuItem *PM_TScope_AudioSpectrumAmplitudeRange;
   TMenuItem *PM_TScope_MoreAudioSpectrumSettings;
   TMenuItem *MI_AudioSpectrumRefLevel_Edit;
   TMenuItem *MI_AudioSpectrumRefLevel_m20;
   TMenuItem *MI_AudioSpectrumRefLevel_m10;
   TMenuItem *MI_AudioSpectrumRefLevel_0;
   TMenuItem *MI_AudioSpectrumRefLevel_10;
   TMenuItem *MI_AudioSpectrumRefLevel_20;
   TMenuItem *MI_TScope_AudioSpectrumAmplRange_10;
   TMenuItem *MI_TScope_AudioSpectrumAmplRange_20;
   TMenuItem *MI_TScope_AudioSpectrumAmplRange_30;
   TMenuItem *MI_TScope_AudioSpectrumAmplRange_50;
   TMenuItem *MI_TScope_AudioSpectrumAmplRange_70;
   TMenuItem *MI_MoreBuiltInTests;
   TMenuItem *MI_Test_EnumerateAudioDevices;
   TMenuItem *N4;
   TMenuItem *MI_Debug_ListAndEditRigParams;
   TMenuItem *PM_ErrorHistory_Help;
   TMenuItem *N5;
   TMenuItem *HI_Help_AudioCWDecoder;
   TMenuItem *MI_Debug_ShowWinkeyerTraffic;
   TMenuItem *MI_Debug_SerialTextTerminal;
   TMenuItem *MI_Debug_ShowAuxComTraffic;
   TMenuItem *MI_Debug_LimitHistoryLength;
   TMenuItem *MI_Funcs_PowerOffWhenClosing;
   TMenuItem *MI_File_Separator1;
   TMenuItem *MI_File_ExportSettingsAs;
   TMenuItem *MI_File_ImportSettingsFrom;
   TOpenDialog *OpenDialog;
   TSaveDialog *SaveDialog;
   TMenuItem *MI_File_ImportRecentFile;
   TMenuItem *MI_RecentFile0;
   TMenuItem *MI_RecentFile1;
   TMenuItem *MI_RecentFile2;
   TMenuItem *MI_RecentFile3;
   TMenuItem *MI_ClearCecentFiles;
   TLabel *Lab_AuxCom1Signals;
   TLabel *Lab_AuxCom2Signals;
   TLabel *Lab_AuxCom3Signals;
   TMenuItem *MI_RigCtrl_RejectAnyKnownCommandFromLog;
   TMenuItem *MI_TrafficMon_ExtraColumns;
   TMenuItem *MI_TrafficMon_Timestamp;
   TMenuItem *MI_TMColumns_All;
   TMenuItem *MI_TMColumns_Time;
   TMenuItem *MI_TMColumns_TX_RX;
   TMenuItem *MI_TMColumns_PayloadLength;
   TMenuItem *MI_TMColumns_Comment;
   TMenuItem *MI_TMon_Timestamp_UTC;
   TMenuItem *MI_TMon_Timestamp_Milliseconds;
   TMenuItem *MI_TrafficMon_TriggerOptions;
   TMenuItem *MI_TrafficMon_PauseOnFullFIFO;
   TMenuItem *MI_TrafficMonitor_PauseOnError;
   TMenuItem *MI_TrafficMonitor_PauseOnInitDone;
   TMenuItem *MI_TRX_Tab_BPMode_ChatBox;
   TPopupMenu *PM_ChatBox;
   TMenuItem *MI_ChatBox_BottomPanelMode;
   TCheckBox *Chk_Audio_SidetoneWhenKeyedOnTheRig;
   TScrollBox *SCB_Config;
   TPageControl *PC_Config;
   TTabSheet *TS_IO;
   TLabel *Label1;
   TLabel *Label2;
   TLabel *Label7;
   TLabel *Label8;
   TLabel *Label9;
   TLabel *Label10;
   TLabel *Label11;
   TLabel *Label15;
   TLabel *Label_ManualPTTInput;
   TComboBox *CB_MorseKeyPort;
   TComboBox *CB_RadioKeyingPort;
   TComboBox *CB_DotKeyInput;
   TComboBox *CB_DashKeyInput;
   TComboBox *CB_InputKeySupply;
   TComboBox *CB_RadioCWKeying;
   TComboBox *CB_RadioPTTControl;
   TComboBox *CB_TestInput;
   TComboBox *CB_PTT_Input;
   TTabSheet *TS_RigControl;
   TLabel *Lab_RigCtrl_CIV_Addr;
   TLabel *Label31;
   TLabel *Lab_RemoteControlMethod;
   TLabel *Lab_RemoteRigControlServer;
   TLabel *Label21;
   TSpeedButton *Btn_Help_HamlibServer;
   TComboBox *CB_CIV_Address;
   TComboBox *CB_RadioCtrlBaudrate;
   TComboBox *CB_RemoteControlMethod;
   TEdit *Ed_RemoteRigctrlServerAddress;
   TEdit *Ed_BuiltInHamlibServerPort;
   TCheckBox *Chk_EnableBuiltInHamlibServer;
   TButton *Btn_MoreHLServerOptions;
   TTabSheet *TS_AuxPorts;
   TLabel *Lab_AuxComPort1;
   TLabel *Lab_AuxPort1Usage;
   TLabel *Lab_AuxComPort2;
   TLabel *Lab_AuxPort2Usage;
   TLabel *Lab_AuxComPort3;
   TLabel *Lab_AuxPort3Usage;
   TLabel *Label30;
   TLabel *Label32;
   TLabel *Label33;
   TLabel *Lab_AuxCom1Info;
   TLabel *Lab_AuxCom2Info;
   TLabel *Lab_AuxCom3Info;
   TComboBox *CB_AuxComPort1;
   TComboBox *CB_AuxComPort1Usage;
   TComboBox *CB_AuxComPort2;
   TComboBox *CB_AuxComPort2Usage;
   TComboBox *CB_AuxComPort3;
   TComboBox *CB_AuxComPort3Usage;
   TComboBox *CB_Aux1Baud;
   TComboBox *CB_Aux2Baud;
   TComboBox *CB_Aux3Baud;
   TButton *Btn_AuxCom1Details;
   TButton *Btn_AuxCom2Details;
   TButton *Btn_AuxCom3Details;
   TBitBtn *Btn_Help_AdditionalComPorts;
   TButton *Btn_ApplyAndStart;
   TButton *Btn_ConfigTabMenu;
   TPopupMenu *PM_IO_Config;
   TMenuItem *MI_HelpOnIOConfig;
   TMenuItem *MI_IO_Config_RecallPredefinedSettings;
   TMenuItem *MI_Predef_IO_Simple_Paddle_Adapter;
   TMenuItem *MI_Predef_IO_Simple_Paddle_Adapter_with_Keying_on_RTS;
   TMenuItem *MI_Predef_IO_Neither_Paddle_Adapter_nor_Radio_Keying_Port;
   TMenuItem *MI_Predef_IO_N1MM_Footswitch_Compatible;
   TLabel *Label34;
   TComboBox *CB_RadioInterfaceSupply;
   TMenuItem *MI_Help_CWSidetone;
   TMenuItem *MI_Test_ShowGuiEvents;
   TMenuItem *MI_AutoFocusSwitch;
   void __fastcall Exit1Click(TObject *Sender);
   void __fastcall FormCreate(TObject *Sender);
   void __fastcall MI_ExitNoSaveClick(TObject *Sender);
   void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
   void __fastcall Timer1Timer(TObject *Sender);
   void __fastcall ApplyManualTestSignals(TObject *Sender);
   void __fastcall MI_RestoreDefaultSettingsClick(TObject *Sender);
   void __fastcall ApplyKeyerSettings(TObject *Sender);
   void __fastcall TrackBar_WPMChange(TObject *Sender);
   void __fastcall Ed_WPMChange(TObject *Sender);
   void __fastcall Menu_SettingsClick(TObject *Sender);
   void __fastcall MI_Ch4_PTTClick(TObject *Sender);
   void __fastcall MI_Ch4_TestInputClick(TObject *Sender);
   void __fastcall Btn_Mem1Click(TObject *Sender);
   void __fastcall Btn_Mem2Click(TObject *Sender);
   void __fastcall Btn_Mem3Click(TObject *Sender);
   void __fastcall Btn_Mem4Click(TObject *Sender);
   void __fastcall Btn_Mem5Click(TObject *Sender);
   void __fastcall Btn_Mem6Click(TObject *Sender);
   void __fastcall Ed_MemChange(TObject *Sender);
   void __fastcall MI_Hotkey_EscapeClick(TObject *Sender);
   void __fastcall MI_ColourScheme_DefaultClick(TObject *Sender);
   void __fastcall MI_ColourScheme_DarkClick(TObject *Sender);
   void __fastcall FormResize(TObject *Sender);
   void __fastcall Img_TimingScopeOnTestTab_MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_TimingScopeOnTestTab_MouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
   void __fastcall Img_TimingScopeOnTestTab_MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_TimingScopeOnKeyerTab_MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_TimingScopeOnKeyerTab_MouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
   void __fastcall Img_TimingScopeOnKeyerTab_MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall MI_ClearScopeOverlaysClick(TObject *Sender);
   void __fastcall Hotkeysummary1Click(TObject *Sender);
   void __fastcall MI_HelpIndexClick(TObject *Sender);
   void __fastcall MI_Help_IOConfigClick(TObject *Sender);
   void __fastcall MI_Help_KeyerSettingsClick(TObject *Sender);
   void __fastcall MI_Help_TimingScopeClick(TObject *Sender);
   void __fastcall MI_Help_HardwareClick(TObject *Sender);
   void __fastcall MI_ClearDebugAndDecoderOutputClick(TObject *Sender);
   void __fastcall MI_Help_AudioSettingsClick(TObject *Sender);
   void __fastcall MI_Help_NetworkSettingsClick(TObject *Sender);
   void __fastcall MI_ReportTestResultsClick(TObject *Sender);
   void __fastcall ApplyNetworkSetup(TObject *Sender);
   void __fastcall MI_Network_DiagnosticModeClick(TObject *Sender);
   void __fastcall CB_SidetoneOnAudioOutChange(TObject *Sender);
   void __fastcall Lab_NetworkFunctionalityClick(TObject *Sender);
   void __fastcall Lab_NetStatusClick(TObject *Sender);
   void __fastcall Lab_AcceptedUsersClick(TObject *Sender);
   void __fastcall MI_ClearErrorHistoryClick(
          TObject *Sender);
   void __fastcall MI_Network_ShowRcvdKeyingBytestreamClick(
          TObject *Sender);
   void __fastcall MI_Debug_ShowKeyingBytestreamClick(TObject *Sender);
   void __fastcall MI_Debug_VerboseDiagnosticsClick(TObject *Sender);
   void __fastcall MI_Debug_PauseDisplayClick(TObject *Sender);
   void __fastcall PM_ErrorHistoryPopup(TObject *Sender);
   void __fastcall MI_PauseDebugOutputClick(TObject *Sender);
   void __fastcall MI_CopyHistoryToClipboardClick(TObject *Sender);
   void __fastcall MI_Help_DebugTabClick(TObject *Sender);
   void __fastcall MI_Debug_ShowMorseDecoderOutputClick(TObject *Sender);
   void __fastcall MI_Settings_ShowMorseDecoderOutputClick(
          TObject *Sender);
   void __fastcall Ed_ServerAcceptUsersDblClick(TObject *Sender);
   void __fastcall MyDrawMenuItem(TObject *Sender, TCanvas *ACanvas,
          TRect &ARect, bool Selected);
   void __fastcall Chk_Audio_AllowNetworkClick(TObject *Sender);
   void __fastcall ApplyVolumeAdjustments(TObject *Sender);
   void __fastcall MI_TScopeShowAudioInClick(TObject *Sender);
   void __fastcall MI_TScopeShowAudioOutClick(TObject *Sender);
   void __fastcall PM_TimingScopePopup(TObject *Sender);
   void __fastcall PM_TScope_ShowAudioInClick(TObject *Sender);
   void __fastcall PM_TScope_ShowAudioOutClick(TObject *Sender);
   void __fastcall PM_TScope_ClearOverlaysClick(TObject *Sender);
   void __fastcall PM_TScope_ShowDashInputClick(TObject *Sender);
   void __fastcall PM_TScope_ShowDotInputClick(TObject *Sender);
   void __fastcall PM_TScope_ShowKeyingOutputClick(TObject *Sender);
   void __fastcall PM_TScope_ShowPttOutputClick(TObject *Sender);
   void __fastcall PM_TScope_FreeRunClick(TObject *Sender);
   void __fastcall Btn_ApplyAndStartClick(TObject *Sender);
   void __fastcall MI_KeyViaShiftAndControlClick(TObject *Sender);
   void __fastcall MI_Network_ShowConnectionLogClick(TObject *Sender);
   void __fastcall MI_Help_AboutClick(TObject *Sender);
   void __fastcall MI_Network_OpenServerPageInBrowserClick(
          TObject *Sender);
   void __fastcall MI_Server_EnableHTTPClick(TObject *Sender);
   void __fastcall MI_Server_RestrictAccessClick(TObject *Sender);
   void __fastcall MI_Server_AddTestToneClick(TObject *Sender);
   void __fastcall MI_Network_SimulateBadConnectionClick(TObject *Sender);
   void __fastcall MI_Ch4_NetworkTroubleClick(TObject *Sender);
   void __fastcall MI_Network_ShowNetworkTrafficClick(TObject *Sender);
   void __fastcall MI_Debug_ShowNetworkTrafficClick(TObject *Sender);
   void __fastcall MI_Debug_ToggleWordWrap(TObject *Sender);
   void __fastcall MI_Debug_ShowNetworkConnectionLogClick(TObject *Sender);
   void __fastcall EditSuppressEnterKey(TObject *Sender, char &Key);
   void __fastcall Ed_VFOKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
   void __fastcall Ed_VFOChange(TObject *Sender);
   void __fastcall FormMouseWheel(TObject *Sender, TShiftState Shift,
          int WheelDelta, TPoint &MousePos, bool &Handled);
   void __fastcall CB_OpModeClick(TObject *Sender);
   void __fastcall MI_Debug_ShowRigCtrlTrafficClick(TObject *Sender);
   void __fastcall MI_Network_ShowRigControlTrafficClick(TObject *Sender);
   void __fastcall MI_RigCtrl_RejectEchosInLogClick(TObject *Sender);
   void __fastcall MI_RigCtrl_RejectPeriodicCmdsClick(TObject *Sender);
   void __fastcall MI_RigCtrl_RejectSpectrumInLogClick(TObject *Sender);
   void __fastcall Lab_LocalIPHelpClick(TObject *Sender);
   void __fastcall Lab_ServerListeningPortClick(TObject *Sender);
   void __fastcall Lab_RemoteURLClick(TObject *Sender);
   void __fastcall Lab_MyUserNameClick(TObject *Sender);
   void __fastcall Lab_UserCallsignClick(TObject *Sender);
   void __fastcall MI_TRX_KeepRunningClick(TObject *Sender);
   void __fastcall MI_Settings_TRX_OptionsClick(TObject *Sender);
   void __fastcall MI_NetworkLatency_AutoDetectClick(TObject *Sender);
   void __fastcall MI_NetworkLatency_100msClick(TObject *Sender);
   void __fastcall MI_NetworkLatency_250msClick(TObject *Sender);
   void __fastcall MI_NetworkLatency_500msClick(TObject *Sender);
   void __fastcall MI_NetworkLatency_1000msClick(TObject *Sender);
   void __fastcall MI_Ch4_KeyingFifoUsageClick(TObject *Sender);
   void __fastcall Btn_StopSendingFromMemoryClick(TObject *Sender);
   void __fastcall MI_ShowStraightKeyDecoderHistoryClick(TObject *Sender);
   void __fastcall MI_KeyInputWatchdogClick(TObject *Sender);
   void __fastcall Img_SpectrumMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_SpectrumMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
   void __fastcall Img_SpectrumMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall MI_Ch4_ElbugKeyerFlagsClick(TObject *Sender);
   void __fastcall PM_TScope_HelpClick(TObject *Sender);
   void __fastcall Btn_MoreKeyerSettingsClick(TObject *Sender);
   void __fastcall MI_DebouncePaddleInputsClick(TObject *Sender);
   void __fastcall PM_SpectrumPopup(TObject *Sender);
   void __fastcall MI_Spectrum_SetVFOClick(TObject *Sender);
   void __fastcall MI_Spectrum_SetPermanentMarkerClick(TObject *Sender);
   void __fastcall MI_Language_EnglishClick(TObject *Sender);
   void __fastcall MI_Language_GermanClick(TObject *Sender);
   void __fastcall MI_Language_FrenchClick(TObject *Sender);
   void __fastcall MI_Language_DutchClick(TObject *Sender);
   void __fastcall MI_Language_ItalianClick(TObject *Sender);
   void __fastcall CB_RemoteControlMethodClick(TObject *Sender);
   void __fastcall MI_Help_TransceiverControlClick(TObject *Sender);
   void __fastcall Btn_Help_HamlibServerClick(TObject *Sender);
   void __fastcall Btn_MoreHLServerOptionsClick(TObject *Sender);
   void __fastcall MI_HLServer_OpenControlTabClick(TObject *Sender);
   void __fastcall MI_HLServer_EnableClick(TObject *Sender);
   void __fastcall MI_HLServer_ShowTrafficClick(TObject *Sender);
   void __fastcall MI_HLServer_VerboseOutputClick(TObject *Sender);
   void __fastcall MI_ListAndEditRigParamsClick(TObject *Sender);
   void __fastcall CB_BandClick(TObject *Sender);
   void __fastcall MI_ITU_Region_1Click(TObject *Sender);
   void __fastcall MI_ITU_Region_2Click(TObject *Sender);
   void __fastcall MI_ITU_Region_3Click(TObject *Sender);
   void __fastcall Btn_HelpBandSwitchClick(TObject *Sender);
   void __fastcall PageControl1Change(TObject *Sender);
   void __fastcall MI_RigCtrl_RejectFrequencyReportsClick(TObject *Sender);
   void __fastcall MI_Funcs_TrxPowerOffClick(TObject *Sender);
   void __fastcall MI_Funcs_TrxPowerOnClick(TObject *Sender);
   void __fastcall MI_WFall_SetVFOClick(TObject *Sender);
   void __fastcall Img_WaterfallMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_WaterfallMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_WaterfallMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
   void __fastcall MI_SpectrumSpan_500kHzClick(TObject *Sender);
   void __fastcall MI_SpectrumSpan_2500Click(TObject *Sender);
   void __fastcall MI_SpectrumSpan_5kHzClick(TObject *Sender);
   void __fastcall MI_SpectrumSpan_10kHzClick(TObject *Sender);
   void __fastcall MI_SpectrumSpan_25kHzClick(TObject *Sender);
   void __fastcall MI_SpectrumSpan_50kHzClick(TObject *Sender);
   void __fastcall MI_SpectrumSpan_100kHzClick(TObject *Sender);
   void __fastcall MI_SpectrumSpan_250kHzClick(TObject *Sender);
   void __fastcall MI_Settings_SpectrumDisplayClick(TObject *Sender);
   void __fastcall MI_Help_MainMenuClick(TObject *Sender);
   void __fastcall MI_UI_SimpleClick(TObject *Sender);
   void __fastcall MI_UI_CompleteClick(TObject *Sender);
   void __fastcall MI_HelpClick(TObject *Sender);
   void __fastcall MI_ListUserDefinedBandsClick(TObject *Sender);
   void __fastcall MI_ListUserDefinedFrequenciesClick(TObject *Sender);
   void __fastcall MI_SpectrumRefLevel_EditClick(TObject *Sender);
   void __fastcall MI_SpectrumRefLevel_m20Click(TObject *Sender);
   void __fastcall MI_SpectrumRefLevel_m10Click(TObject *Sender);
   void __fastcall MI_SpectrumRefLevel_0Click(TObject *Sender);
   void __fastcall MI_SpectrumRefLevel_10Click(TObject *Sender);
   void __fastcall MI_SpectrumRefLevel_20Click(TObject *Sender);
   void __fastcall MI_TRX_Tab_KeepRunningClick(TObject *Sender);
   void __fastcall MI_CenterDisplayOnClickedFrequencyClick(
          TObject *Sender);
   void __fastcall Img_FreqScaleMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_FreqScaleMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
   void __fastcall Img_FreqScaleMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_TRX_BottomMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Img_TRX_BottomMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
   void __fastcall Img_TRX_BottomMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall MI_TRX_Tab_BPMode_MetersClick(TObject *Sender);
   void __fastcall MI_TRX_Tab_BPMode_FreqInfoClick(TObject *Sender);
   void __fastcall MI_TRX_Tab_BPMode_OFFClick(TObject *Sender);
   void __fastcall MI_TRX_Tab_ShowTimeMarkersClick(TObject *Sender);
   void __fastcall MI_HideMenuClick(TObject *Sender);
   void __fastcall Pnl_StatusIndicatorClick(TObject *Sender);
   void __fastcall MI_TRX_Tab_BPMode_AutoClick(TObject *Sender);
   void __fastcall RichEdit_RxTxInfoKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
   void __fastcall RichEdit_RxTxInfoKeyPress(TObject *Sender, char &Key);
   void __fastcall MI_Network_TrafficLog_RejectPeriodicMsgsClick(
          TObject *Sender);
   void __fastcall MI_MoreKeyerSettings_DisableTxClick(TObject *Sender);
   void __fastcall Chk_Audio_DecodeCWClick(TObject *Sender);
   void __fastcall MI_TRX_Tab_ShowCWDecoderSpectrumClick(TObject *Sender);
   void __fastcall Btn_MoreAudioCwDecoderOptionsClick(TObject *Sender);
   void __fastcall PM_AudioCwDecoderOptionsPopup(TObject *Sender);
   void __fastcall MI_ACwDecoder_EnabledClick(TObject *Sender);
   void __fastcall MI_TRX_Tab_AudioCWDecoderOptionsClick(TObject *Sender);
   void __fastcall MI_PeakHoldingAudioSpectrumClick(TObject *Sender);
   void __fastcall PM_TScope_PausedClick(TObject *Sender);
   void __fastcall MI_TScopeShowCwDecoderAudioClick(TObject *Sender);
   void __fastcall PM_TScope_ShowAudioSpectrumAndCwDecoderClick(TObject *Sender);
   void __fastcall MI_WFColourPalette_SunriseClick(TObject *Sender);
   void __fastcall MI_WFColourPalette_LinradClick(TObject *Sender);
   void __fastcall MI_WFColourPalette_RedClick(TObject *Sender);
   void __fastcall MI_WFColourPalette_GreenClick(TObject *Sender);
   void __fastcall MI_WFColourPalette_BlueClick(TObject *Sender);
   void __fastcall MI_TimingScopeTB_2msClick(TObject *Sender);
   void __fastcall MI_TimingScopeTB_5msClick(TObject *Sender);
   void __fastcall MI_TimingScopeTB_10msClick(TObject *Sender);
   void __fastcall MI_TimingScopeTB_20msClick(TObject *Sender);
   void __fastcall PM_TScope_MoreAudioSpectrumSettingsClick(
          TObject *Sender);
   void __fastcall MI_AudioSpectrumRefLevel_EditClick(TObject *Sender);
   void __fastcall MI_AudioSpectrumRefLevel_m20Click(TObject *Sender);
   void __fastcall MI_AudioSpectrumRefLevel_m10Click(TObject *Sender);
   void __fastcall MI_AudioSpectrumRefLevel_0Click(TObject *Sender);
   void __fastcall MI_AudioSpectrumRefLevel_10Click(TObject *Sender);
   void __fastcall MI_AudioSpectrumRefLevel_20Click(TObject *Sender);
   void __fastcall MI_TScope_AudioSpectrumAmplRange_10Click(
          TObject *Sender);
   void __fastcall MI_TScope_AudioSpectrumAmplRange_20Click(
          TObject *Sender);
   void __fastcall MI_TScope_AudioSpectrumAmplRange_30Click(
          TObject *Sender);
   void __fastcall MI_TScope_AudioSpectrumAmplRange_50Click(
          TObject *Sender);
   void __fastcall MI_TScope_AudioSpectrumAmplRange_70Click(
          TObject *Sender);
   void __fastcall MI_Test_EnumerateAudioDevicesClick(TObject *Sender);
   void __fastcall Ed_ErrorHistoryKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
   void __fastcall Ed_ErrorHistoryKeyPress(TObject *Sender, char &Key);
   void __fastcall MI_Debug_ListAndEditRigParamsClick(TObject *Sender);
   void __fastcall PM_ErrorHistory_HelpClick(TObject *Sender);
   void __fastcall HI_Help_AudioCWDecoderClick(TObject *Sender);
   void __fastcall MI_Debug_ShowWinkeyerTrafficClick(TObject *Sender);
   void __fastcall Btn_AuxCom1DetailsClick(TObject *Sender);
   void __fastcall Btn_AuxCom2DetailsClick(TObject *Sender);
   void __fastcall Btn_AuxCom3DetailsClick(TObject *Sender);
   void __fastcall MI_Debug_SerialTextTerminalClick(TObject *Sender);
   void __fastcall OnChangeOfAnyRigControlParam(TObject *Sender);
   void __fastcall MI_Debug_ShowAuxComTrafficClick(TObject *Sender);
   void __fastcall MI_Debug_LimitHistoryLengthClick(TObject *Sender);
   void __fastcall MI_Funcs_PowerOffWhenClosingClick(TObject *Sender);
   void __fastcall Menu_FunctionsClick(TObject *Sender);
   void __fastcall MI_File_ImportSettingsFromClick(TObject *Sender);
   void __fastcall MI_File_ExportSettingsAsClick(TObject *Sender);
   void __fastcall File1Click(TObject *Sender);
   void __fastcall MI_ClearCecentFilesClick(TObject *Sender);
   void __fastcall MI_RecentFile0Click(TObject *Sender);
   void __fastcall MI_RecentFile1Click(TObject *Sender);
   void __fastcall MI_RecentFile2Click(TObject *Sender);
   void __fastcall MI_RecentFile3Click(TObject *Sender);
   void __fastcall Btn_Help_AdditionalComPortsClick(TObject *Sender);
   void __fastcall Ed_VFOMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Ed_VFOMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
   void __fastcall Ed_VFODblClick(TObject *Sender);
   void __fastcall Ed_VFOMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
   void __fastcall MI_RigCtrl_RejectAnyKnownCommandFromLogClick(
          TObject *Sender);
   void __fastcall MI_TMColumns_AllClick(TObject *Sender);
   void __fastcall MI_TMColumns_TimeClick(TObject *Sender);
   void __fastcall MI_TMColumns_TX_RXClick(TObject *Sender);
   void __fastcall MI_TMColumns_PayloadLengthClick(TObject *Sender);
   void __fastcall MI_TMColumns_CommentClick(TObject *Sender);
   void __fastcall MI_TMon_Timestamp_UTCClick(TObject *Sender);
   void __fastcall MI_TMon_Timestamp_MillisecondsClick(TObject *Sender);
   void __fastcall MI_TrafficMon_PauseOnFullFIFOClick(TObject *Sender);
   void __fastcall MI_TrafficMonitor_PauseOnErrorClick(TObject *Sender);
   void __fastcall MI_TrafficMonitor_PauseOnInitDoneClick(TObject *Sender);
   void __fastcall MI_TRX_Tab_BPMode_ChatBoxClick(TObject *Sender);
   void __fastcall PM_ChatBoxPopup(TObject *Sender);
   void __fastcall Chk_Audio_SidetoneWhenKeyedOnTheRigClick(TObject *Sender);
   void __fastcall MI_HelpOnIOConfigClick(TObject *Sender);
   void __fastcall Btn_ConfigTabMenuClick(TObject *Sender);
   void __fastcall MI_Predef_IO_Simple_Paddle_AdapterClick(
          TObject *Sender);
   void __fastcall MI_Predef_IO_Simple_Paddle_Adapter_with_Keying_on_RTSClick(
          TObject *Sender);
   void __fastcall MI_Predef_IO_Neither_Paddle_Adapter_nor_Radio_Keying_PortClick(
          TObject *Sender);
   void __fastcall MI_Predef_IO_N1MM_Footswitch_CompatibleClick(
          TObject *Sender);
   void __fastcall MI_Help_CWSidetoneClick(TObject *Sender);
   void __fastcall Ed_VFOEnter(TObject *Sender);
   void __fastcall CB_OpModeEnter(TObject *Sender);
   void __fastcall CB_BandEnter(TObject *Sender);
   void __fastcall Btn_ApplyAndStartEnter(TObject *Sender);
   void __fastcall TrackBar_WPMEnter(TObject *Sender);
   void __fastcall Ed_WPMEnter(TObject *Sender);
   void __fastcall SB_AudioInGain_dBEnter(TObject *Sender);
   void __fastcall SB_AudioOutGain_dBEnter(TObject *Sender);
   void __fastcall SB_SidetoneGain_dBEnter(TObject *Sender);
   void __fastcall SB_NetworkTonesGain_dBEnter(TObject *Sender);
   void __fastcall Rbtn_NetworkOffEnter(TObject *Sender);
   void __fastcall Rbtn_NetworkClientEnter(TObject *Sender);
   void __fastcall Rbtn_NetworkServerEnter(TObject *Sender);
   void __fastcall Ed_NetworkStatusEnter(TObject *Sender);
   void __fastcall Ed_OnTheKeyNowEnter(TObject *Sender);
   void __fastcall Ed_ErrorHistoryEnter(TObject *Sender);
   void __fastcall Ed_Mem1Enter(TObject *Sender);
   void __fastcall Ed_Mem2Enter(TObject *Sender);
   void __fastcall Ed_Mem3Enter(TObject *Sender);
   void __fastcall Ed_Mem4Enter(TObject *Sender);
   void __fastcall Ed_Mem5Enter(TObject *Sender);
   void __fastcall Ed_Mem6Enter(TObject *Sender);
   void __fastcall Ed_MyCallEnter(TObject *Sender);
   void __fastcall MI_Test_ShowGuiEventsClick(TObject *Sender);
   void __fastcall MI_AutoFocusSwitchClick(TObject *Sender);
private:	// Anwender-Deklarationen
public:  // Anwender-Deklarationen
   __fastcall TKeyerMainForm(TComponent* Owner);
   void __fastcall AppMessage(tagMSG &Msg, bool &Handled);
   void __fastcall MyWindowProc(Messages::TMessage &Message);


   // BOOL OnNonClientPaint( HWND hWnd, HRGN hRegion );
   void OnNonClientPaint( HRGN hUpdateRegion );
   void SetNewLanguage( int iNewLanguage );
   void UpdateWindowCaption(void);
   void HideOrShowMainMenu(BOOL fHideMenu);
   void ConfigureAuxComDetails(int iAuxComIndex );

   
   void UpdateTrxDisplay(void);
   void UpdateMultiFunctionMeters(void); // [out] Img_TRX_Bottom (part of the "TRX" tab)
   void UpdateFrequencyInfo(void);   // [out] Img_TRX_Bottom (same bitmap, but different content)
   void CreateChatboxOnTrxTab(void);
   void UpdateChatboxOnTrxTab(void); // Updates a small text box primarily intended for messages from the SYSOP to other users

   void UpdateAllControlsFromConfig(void); // called shortly after LoadSettings() ..
   int  UpdateSettingsTab(void);
   void RecallPrefinedSetting(int iSetting); // [in] PREDEF_SETTING_SIMPLE_PADDLE_ADAPTER, etc

   void UpdateRigControlMethodDependingFields(void);
   void UpdateWPMIndicatorFromCwKeyerConfig(void);

   int  UpdateAuxComPortSettings(void);
   void ApplyAuxComPortSettings(void);

   void ApplySettingsTab(void);
   void ApplyNewVFOFreq(void); // Ed_VFO -> MyCwNet.RigControl.dblVfoFrequency
   void StopAndRestart(void);
   void StartVFOEditTimer(int nMilliseconds);
   void AddAudioInputDevice( AnsiString sItemText );
   void AddAudioOutputDevice( AnsiString sItemText );
   void UpdateAudioDeviceCombos(void);
   void UpdateTestDisplay(void);
   void UpdateItemsInFileMenu(void);
   void ImportRecentFile( int iZeroBasedIndex );
   void UpdateItemsInSettingsMenu(void);
   void UpdateItemsInFunctionsMenu(void);
   BOOL DumpRigCtrlTrafficToDebugTab(int iWantedCharsPerLine); // TrafficLog[] -> Ed_ErrorHistory (Rich Text control)
   void UpdateStatusIndicator(void);
   void UpdateNetworkSetup(void);
   void UpdateClientServerLabels(void);
   void AdaptImageSizesOnTRXTab(void);
   void StartKeyerAndShowInfo(void);
   void StartPlaying( int iKeyerMemoryIndex ); // [in] KEYER_MEMORY_INDEX_1..6
   void PauseTransmissionAndClearTxBuffers(void);
   TEdit* GetEditorForMemoryIndex( int iKeyerMemoryIndex ); // [in] KEYER_MEMORY_INDEX_1..6
   int  IdentifyClientCoord( int iClientX, int iClientY,
         float *pfltXrel,  // optional output: relative 'X' coord, 0...1 within the area
         float *pfltYrel); // optional output: relative 'X' coord, 0...1 within the area
#   define SCREEN_AREA_NOT_DEFINED      0
#   define SCREEN_AREA_SPECTRUM_GRAPH   1
#   define SCREEN_AREA_FREQUENCY_SCALE  2
#   define SCREEN_AREA_SPECTROGRAM      3
   void __fastcall RichEd_Chatbox_KeyDown(TObject *Sender, WORD &Key, TShiftState Shift);
   void __fastcall RichEd_Chatbox_KeyPress(TObject *Sender, char &Key);

   void SwitchMainTab(int iNewTab); // [in] one of the KEYER_GUI_MAIN_TAB_.. constants
   BOOL  m_fInitialising, m_fRestartKeyerThread, m_fAdaptImageSizesOnTRXTab;
   BOOL  m_fDontSaveOnExit;
   DWORD m_dwHashForSettings;  // hash value calculated for 'anything that needs to be saved' between two sessions.
         // Note: m_dwHashForSettings is not updated when EXPORTING settings
         //       as a file. Its purpose is to SAVE ON EXIT when modified.
   int   m_iFunctionalityInCaption; // state of MyCwNet.cfg.iFunctionality displayed in the forms 'Caption' (window title)
   BOOL  m_fMustApplyInfoInCaption; // state of KeyerGUI_fMustApplyConfigAndStart displayed in the forms 'Caption'
   BOOL  m_fTxDisbledInfoInCaption; // state of CwKeyer_Config.fDisableTx || MyCwNet.fDisableTx displayed in the forms 'Caption'

   AnsiString m_sLastExportedOrImportedFile;
   int  m_iMainMenuCountdownTimer;    // countdown timer for TEMPORARILY "un-hiding" the main menu
   int  m_iDecoderFifoTail, m_iAudioCwDecoderFifoTail;
   char m_sz80LastMarkerText[84];
   int  m_iTransmittingClient;    // copy of T_CwNet.iTransmittingClient for the "On the key now"-display
   BOOL m_fDebugOutputPaused;
   int  m_iMorseFIFOTailIndex2;   // only for debugging / CWNET_DIAG_FLAGS_SHOW_KEYING_BYTESTREAM
   int  m_iDisplayedRigControlOpMode;
   int    m_iSelectedBandComboRow;
   DWORD  m_dwDisplayedAvailableBands;
   double m_dblDisplayedSMeterLevel_dB;
   double m_dblDisplayedSWRMeterValue;
   int  m_iDisplayedPowerMeterLevel_pcnt;
   int  m_iDisplayedALCMeterLevel_pcnt;
   int  m_iDisplayedCompMeterLevel_dB;
   int  m_iDisplayedSupplyVoltage_mV;
   int  m_iDisplayedDrainCurrent_mA;
   int  m_iDisplayediPATemperature_degC;

   int  m_iRigControlTrafficTailIndex, m_iPrevMsgTypeInTrafficLog;
   int  m_iLastScopeDisplayHeadIndex; // keeps track of 'new' spectra ("waveform data") in RigControl.c
   int  m_iMouseButtonAsGuiKeyFlags;
   int  m_Ed_VFO_iSelStartBeforeDoubleClick;

   TRichEdit *RichEd_ChatboxOnTrxTab; // DYNAMICALLY CREATED, thus not a part of the FORM ! NULL when not created / not used.
};
//---------------------------------------------------------------------------
extern PACKAGE TKeyerMainForm *KeyerMainForm;
//---------------------------------------------------------------------------
#endif
