//---------------------------------------------------------------------------
// File: C:\cbproj\Remote_CW_Keyer\Keyer_GUI_no_VCL.h
// Date: 2024-11-29
// Author: Wolfgang Buescher (DL4YHF)
// Purpose and revision history: See implementation, Keyer_GUI.cpp .
//     THIS PART (formerly in Keyer_GUI.h) does NOT depend on Borland's VCL.
//     Actually, this header has no dependencies on any other header at all,
//     because it only uses standard C types.
//     Thus, it may be #included from modules written in plain C,
//     unlike Keyer_GUI.h (which, like it or not, is doomed to use VCL.H
//     because the Remote CW Keyer GUI consists of a megaton of VCL objects.
//---------------------------------------------------------------------------

#ifndef _KEYER_GUI_NO_VCL_H_

#ifndef AUX_COM_PORTS_H
# include "AuxComPorts.h"
#endif

extern BOOL APPL_fLaunchKeyerOnStart;
extern BOOL APPL_fPausedDuringSleep;
extern BOOL APPL_fSaveSettingsOnExit;

extern char g_sz255CommandLine[256];
extern char g_sz255PathToDataFiles[256];
#define GUI_RECENT_FILES_HISTORY_LENGTH 4
extern char g_sz255RecentFiles[GUI_RECENT_FILES_HISTORY_LENGTH][256];

extern int KeyerGUI_iStatusIndicatorUsage; // one of the following (some bitwise combineable):
#       define STATUS_INDICATOR_OFF    0  // Keyer Thread not started yet
#       define STATUS_INDICATOR_IDLE   1  // not transmitting yet
#       define STATUS_INDICATOR_ON_AIR 2  // "on air" (PTT active, or at least "sending Morse")
#       define STATUS_INDICATOR_SOMEONE_ELSE_ON_AIR 4 // "someone else connected to the rig is currently on air"
#       define STATUS_INDICATOR_ON_AIR_SIM 8 // "would be on air" (e.g. because the MANUAL PTT INPUT is activated) but disabled e.g. via CwKeyer_Config.fDisableTx
#       define STATUS_INDICATOR_TX_MEM  16  // sending CW from one of the "TX memories", or directly from the 'type-ahead input field'
#       define STATUS_INDICATOR_CW_TEST 32 // "generating" CW but not TRANSMITTING (with manual PTT control, but PTT currently off)
#       define STATUS_INDICATOR_PAUSED  64 // operator pressed the "panic" button (ESCAPE)


extern int KeyerGUI_iStatusIndicatorMemIdx; // also for the 'Status Indicator'; one of the following constants:
#       define KEYER_MEMORY_INDEX_1         1  // "sending from Memory #1 (the one activated by function key F1)"
#       define KEYER_MEMORY_INDEX_2         2  // "sending from Memory #2 (the one activated by function key F2)"
#       define KEYER_MEMORY_INDEX_3         3  // "sending from Memory #3 (the one activated by function key F3)"
#       define KEYER_MEMORY_INDEX_4         4  // "sending from Memory #4 (the one activated by function key F4)"
#       define KEYER_MEMORY_INDEX_5         5  // "sending from Memory #5 (the one activated by function key F5)"
#       define KEYER_MEMORY_INDEX_6         6  // "sending from Memory #6 (the one activated by function key F6)"
#       define KEYER_MEMORY_INDEX_MAX KEYER_MEMORY_INDEX_6
#       define KEYER_MEMORY_INDEX_TX_EDITOR     -1 // "sending directly from RichEdit_RxTxInfo"
#       define KEYER_MEMORY_INDEX_WINKEYER_EMU  -2 // "sending CW from the Winkeyer-EMULATOR" (possibly fooling an external application like N1MM Logger)
#       define KEYER_MEMORY_INDEX_WINKEYER_HOST -3 // "sending CW from the Winkeyer-HOST" (and an EXTERNAL Winkeyer-chip on an 'Additional COM Port'
#       define KEYER_MEMORY_INDEX_NONE      0  // "neither sending from TX memory 1..6 nor 'direct text input' nor from the Winkeyer-EMULATOR nor from the WINKEYER-HOST...

extern int KeyerGUI_iRxTxInfoUsage; // <- applies to e.g. RichEdit_RxTxInfo, with the following values:
#       define KEYER_GUI_RXTXINFO_OFF        0 // the edit field on status panel shows nothing, and the user isn't typing into it
#       define KEYER_GUI_RXTXINFO_PROG_INFO  1 // the edit field on status panel shows 'low priority info' about the program
#       define KEYER_GUI_RXTXINFO_TYPING_TXD 2 // the user operator is typing 'transmittable text' into the edit field on status panel
#       define KEYER_GUI_RXTXINFO_TYPING_CMD 3 // the user operator is typing a COMMAND into the edit field on status panel
#       define KEYER_GUI_RXTXINFO_RXDATA     4 // the edit field on status panel shows RECEIVED TEXT (e.g from the Audio-CW-Decoder)
#       define KEYER_GUI_RXTXINFO_SENT_DATA  5 // a part of the edit field shows TRANSMITTED TEXT (the rest, usually text TO BE SENT)
#       define KEYER_GUI_RXTXINFO_CMD_RESPONSE 6 // response after executing a command (appended to text with KEYER_GUI_RXTXINFO_TYPING_CMD)
#       define KEYER_GUI_RXTXINFO_ERROR_MSG  7 // something entered by the operator resulted with an ERROR

// Bitwise combineable "conflict indicators", detected for example in UpdateSettingsTab() :
extern int KeyerGUI_iConflictsFromSettingsTab;
#       define KEYER_GUI_CONFLICT_MORSE_KEY_PORT         (1<<0)
#       define KEYER_GUI_CONFLICT_RADIO_CONTROL_PORT     (1<<1)
#       define KEYER_GUI_CONFLICT_DOT_INPUT              (1<<2)
#       define KEYER_GUI_CONFLICT_DASH_INPUT             (1<<3)
#       define KEYER_GUI_CONFLICT_PTT_INPUT              (1<<4)
#       define KEYER_GUI_CONFLICT_TEST_INPUT             (1<<5)
#       define KEYER_GUI_CONFLICT_KEY_INTERFACE_SUPPLY   (1<<6)
#       define KEYER_GUI_CONFLICT_RADIO_INTERFACE_SUPPLY (1<<7)
#       define KEYER_GUI_CONFLICT_RADIO_CW_KEYING_OUTPUT (1<<8)
#       define KEYER_GUI_CONFLICT_RADIO_PTT_OUTPUT       (1<<9)
#       define KEYER_GUI_CONFLICT_RIG_CONTROL            (1<<10)
#       define KEYER_GUI_CONFLICT_AUX_COM_PORT_1         (1<<11)
#       define KEYER_GUI_CONFLICT_AUX_COM_PORT_2         (1<<12)
#       define KEYER_GUI_CONFLICT_AUX_COM_PORT_3         (1<<13)


extern long KeyerGUI_i32CountdownForRxTxInfo_ms; // "countdown timer", in milliseconds, for e.g. RichEdit_RxTxInfo (the "multi-purpose" edit- and display field on the 'status panel')
extern int  KeyerGUI_iTxEditorCharIndex_CwGenerator; // index of the next character to move from the type-ahead buffer into the CW Generator
extern int  KeyerGUI_iTxEditorCharIndex_StartOfMsg;  // index of the FIRST character to send from the type-ahead input field

extern BOOL KeyerGUI_fUpdateWPMIndicator; // May be set by ANY THREAD after modifying CwKeyer_Elbug.cfg.iDotTime_ms .
            // Requests a call of UpdateWPMIndicatorFromCwKeyerConfig() from where it's safe to call the VCL :o)
extern BOOL KeyerGUI_fMustApplyConfigAndStart; // flag that lets the "Apply new settings and start"-button on any of the CONFIG tabs *blink*
extern DWORD KeyerGUI_dwTimerTicks_50ms;  // <- Incremented every 50 milliseonds. Individual bits are used as e.g. 'blink flag' anywhere in the GUI

extern int  KeyerGUI_iFocusSwitchCountdownTimer_ms; // countdown timer, in milliseconds, for 'automatic switching of the keyboard focus' back to the VFO FIELD
extern BOOL KeyerGUI_fMaySwitchToVfoEditField;   // flag to allow switching BACK to the VFO edit field (within the 'TRX' tab only)
extern int  KeyerGUI_iCurrentlyFocusedItem;      // used in combination with m_iFocusSwitchCountdownTimer. Contains one of the following:
#       define KEYER_GUI_ITEM_NONE                   0 // using simple INTEGERS instead of Borland's "TControl" for portability...
#       define KEYER_GUI_ITEM_MAIN_MENU_FILE         1
#       define KEYER_GUI_ITEM_MAIN_MENU_SETTINGS     2
#       define KEYER_GUI_ITEM_MAIN_MENU_FUNCTIONS    3
#       define KEYER_GUI_ITEM_MAIN_MENU_HELP         4
#       define KEYER_GUI_ITEM_BTN_APPLY_AND_START   10 // "Apply and Start"-button on the "Config" tab
#       define KEYER_GUI_ITEM_SCR_KEYER_SPEED       11 // "scroller" / "trackbar" / whatever for the KEYER SPEED IN WPM
#       define KEYER_GUI_ITEM_EDIT_KEYER_SPEED      12 // EDIT FIELD (numeric input) for the KEYER SPEED IN WPM
#       define KEYER_GUI_ITEM_SCR_AUDIO_IN_VOLUME   20 // "scrollbar" for the audio INPUT volume
#       define KEYER_GUI_ITEM_SCR_AUDIO_OUT_VOLUME  21 // "scrollbar" for the audio OUTUT volume
#       define KEYER_GUI_ITEM_SCR_SIDETONE_VOLUME   22 // "scrollbar" for the SIDETONE volume (signal added to the audio output)
#       define KEYER_GUI_ITEM_SCR_NETWORK_IN_VOLUME 23 // "scrollbar" for the NETWORK AUDIO volume (signal added to the audio output)
#       define KEYER_GUI_ITEM_RBTN_NETWORK_OFF      30 // "radio buttons"(!) for 'Network functionality' ..
#       define KEYER_GUI_ITEM_RBTN_NETWORK_CLIENT   31
#       define KEYER_GUI_ITEM_RBTN_NETWORK_SERVER   32
#       define KEYER_GUI_ITEM_EDIT_NETWORK_STATUS   33 // edit field(!) usually displaying the "Current Network Status"
#       define KEYER_GUI_ITEM_EDIT_NETWORK_ON_KEY   34 // edit field(!) usually displaying "On the key now" on the NETWORK tab
#       define KEYER_GUI_ITEM_EDIT_ERROR_HISTORY    40 // Rich Text editor on the 'Debug' tab, for all sorts of stuff
#       define KEYER_GUI_ITEM_EDIT_KEYER_MEMORY_1   51 // edit field for 'Keyer Memory #1'
#       define KEYER_GUI_ITEM_EDIT_KEYER_MEMORY_2   52 // edit field for 'Keyer Memory #2'
#       define KEYER_GUI_ITEM_EDIT_KEYER_MEMORY_3   53 // edit field for 'Keyer Memory #3'
#       define KEYER_GUI_ITEM_EDIT_KEYER_MEMORY_4   54 // edit field for 'Keyer Memory #4'
#       define KEYER_GUI_ITEM_EDIT_KEYER_MEMORY_5   55 // edit field for 'Keyer Memory #5'
#       define KEYER_GUI_ITEM_EDIT_KEYER_MEMORY_6   56 // edit field for 'Keyer Memory #6'
#       define KEYER_GUI_ITEM_EDIT_KEYER_MEMORY_LAST KEYER_GUI_ITEM_EDIT_KEYER_MEMORY_6
#       define KEYER_GUI_ITEM_EDIT_MYCALL           59 // edit field for '<mycall>' (also on the 'Memory' tab)
#       define KEYER_GUI_ITEM_EDIT_MAIN_VFO         60 // edit field for the main VFO frequency, on the "TRX" tab
#       define KEYER_GUI_ITEM_COMBO_MAIN_OP_MODE    61 // combo box(?) for the 'opmode' (CW, CWN, USB, LSB), on the "TRX" tab
#       define KEYER_GUI_ITEM_COMBO_BAND_SWITCH     62 // combo box(?) to switch to a different BAND or BAND STACKING REGISTER
        // Some keyboard-focus-switching actions were implemented without VCL/Qt/whatever-dependencies.
        // See Remote_CW_Keyer\Keyer_GUI.cpp : Keyer_GUI_OnSetFocus( iNewFocusedItem = one of the constants defined above ).

extern int KeyerGUI_iCurrentMainTab; // contains one of the KEYER_GUI_MAIN_TAB_.. constants defined below, set via SwitchMainTab()
#   define KEYER_GUI_MAIN_TAB_UNKNOWN        0 // <- only a dummy for KeyerGUI_iCurrentMainTab
#   define KEYER_GUI_MAIN_TAB_CONFIG         1
#   define KEYER_GUI_MAIN_TAB_KEYER_SETTINGS 2
#   define KEYER_GUI_MAIN_TAB_AUDIO          3
#   define KEYER_GUI_MAIN_TAB_NETWORK        4
#   define KEYER_GUI_MAIN_TAB_DEBUG          5
#   define KEYER_GUI_MAIN_TAB_MEMORY         6
#   define KEYER_GUI_MAIN_TAB_TEST           7 // "Test" tab with the 'CW timing' scope
#   define KEYER_GUI_MAIN_TAB_TRX            8
extern BOOL KeyerGUI_fAutomaticTabSwitching;   // normally FALSE = "tabs switched by the USER";  TRUE to allow e.g. switching from KEYER_GUI_MAIN_TAB_DEBUG to KEYER_GUI_MAIN_TAB_TRX when the 'rig initialisation' is finished.
extern BOOL KeyerGUI_fAutomaticFocusSwitching; // normally TRUE = "allow automatic switching of the input focus" (e.g. back to the VFO edit field)

extern BOOL KeyerGUI_fSerialTerminalActive; // TRUE: Send characters typed into the RichEdit on the DEBUG tab via serial port to 'Additional COM Ports' configured as TEXT TERMINAL,
                                            // FALSE: Don't SEND but only DISPLAY RECEIVED text.

void  KeyerGUI_ParseAuxComParams( const char *psz40AuxComParams, T_AuxComPortInstance *pAuxComPort );
BOOL  KeyerGUI_ParseSerialFormat( const char *pszSrc, int  *piNumDatabits, int *piParity, int *piNumStopbits );
void  KeyerGUI_SerialFormatToString(int  iNumDatabits, int iParity, int iNumStopbits, char *psz7Dest );
const char* KeyerGUI_PortNumberToString( int iPortNumber );
void  KeyerGUI_OnSetFocus( int iNewFocusedItem );
BOOL  KeyerGUI_SwitchFocus( int iNewFocusedItem );
void  KeyerGUI_SetDefaultTextCaretPosInVFOInputField( void );
void  KeyerGUI_On50msTimer( void ); // VCL-independent part of 'periodic updates' of the GUI


#endif // ndef _KEYER_GUI_NO_VCL_H_ ?

/* EOF < Remote_CW_Keyer/Keyer_GUI_no_VCL.h > */

